/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal.ui;

import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.wizards.TeamPlaceSelectionPage;
import com.ibm.team.internal.filesystem.ui.wizards.sharing.TeamAreaSelection;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMappingArea;
import com.ibm.team.scm.client.importz.internal.ui.Author2ContributorMappingPage;
import com.ibm.team.scm.client.importz.internal.ui.ConfigureImportProcessingPage;
import com.ibm.team.scm.client.importz.internal.ui.ImportConfiguration;
import com.ibm.team.scm.client.importz.internal.ui.ImportLoggingHelper;
import com.ibm.team.scm.client.importz.internal.ui.ImportOperation;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractImportWizard
extends Wizard
implements IImportWizard {
    private static final String TEAM_PLACE_SELECTION_PAGE_TITLE = SCMImportMessages.AbstractImportWizard_0;
    private static final String TEAM_PLACE_SELECTION_PAGE_DESCRIPTION = SCMImportMessages.AbstractImportWizard_1;
    static final String DEFAULT_FILENAME = new File(System.getProperty("user.home"), "archive.tar").getAbsolutePath();
    private TeamPlaceSelectionPage teamPlaceSelectionPage;
    private ConfigureImportProcessingPage configureImportProcessingPage;
    private Author2ContributorMappingPage contributorMappingPage;
    private ImportConfiguration configuration;
    private UIContext context;

    public void addPages() {
        this.configuration = this.createConfiguration();
        this.initializeConfiguration();
        this.addPagesAtBeginning();
        this.teamPlaceSelectionPage = this.createTargetComponentSelectionPage();
        this.addPage((IWizardPage)this.teamPlaceSelectionPage);
        this.configureImportProcessingPage = this.createConfigureImportProcessingPage();
        this.addPage((IWizardPage)this.configureImportProcessingPage);
        this.contributorMappingPage = this.createContributorMappingPage();
        this.addPage((IWizardPage)this.contributorMappingPage);
        this.addPagesAtEnd();
    }

    protected ConfigureImportProcessingPage createConfigureImportProcessingPage() {
        ConfigureImportProcessingPage page = new ConfigureImportProcessingPage("CustomizeImportProcessingPage", SCMImportMessages.AbstractImportFromOtherWizard_3, this.getBanner(), this.getConfiguration());
        page.setDescription(SCMImportMessages.AbstractImportFromOtherWizard_7);
        return page;
    }

    private Author2ContributorMappingPage createContributorMappingPage() {
        Author2ContributorMappingPage page = new Author2ContributorMappingPage("ContributorMappingPage", this.getBanner(), this.configuration, false, false);
        return page;
    }

    private TeamPlaceSelectionPage createTargetComponentSelectionPage() {
        TeamPlaceSelectionPage page = new TeamPlaceSelectionPage("TeamPlaceSelectionPage", TEAM_PLACE_SELECTION_PAGE_TITLE, this.getBanner(), false, "com.ibm.team.scm.client.importz.teamPlaceSelectionPage");
        page.setDescription(TEAM_PLACE_SELECTION_PAGE_DESCRIPTION);
        return page;
    }

    protected abstract void addPagesAtBeginning();

    protected void addPagesAtEnd() {
    }

    protected ImportConfiguration createConfiguration() {
        ImportConfiguration importConfiguration = new ImportConfiguration(this.getSourceRepositoryKind(), false);
        importConfiguration.setProperty("com.ibm.team.scm.client.importz.internal.ui.reconcileWithExisting", Boolean.TRUE);
        return importConfiguration;
    }

    protected abstract String getSourceRepositoryKind();

    protected void initializeConfiguration() {
        this.configuration.setArchiveFilename(this.getDefaultFilename());
    }

    protected String getDefaultFilename() {
        return DEFAULT_FILENAME;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.getNextPage(page, true);
    }

    public IWizardPage getNextPage(IWizardPage page, boolean aboutToShow) {
        ITeamRepository repo = this.teamPlaceSelectionPage.getRepository();
        if (repo != null && aboutToShow) {
            this.configuration.setRepository(repo);
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.teamPlaceSelectionPage.isPageComplete() && this.configureImportProcessingPage.isPageComplete();
    }

    protected boolean aboutToFinish() {
        this.configureImportProcessingPage.storeValues();
        IStatus status = this.configuration.validateState();
        if (status.getSeverity() == 4) {
            ImportLoggingHelper.displayError(SCMImportMessages.AbstractImportFromOtherWizard_4, status.getMessage());
            return false;
        }
        if (status.getSeverity() == 2 && !MessageDialog.openQuestion((Shell)this.getShell(), (String)SCMImportMessages.AbstractImportFromOtherWizard_5, (String)NLS.bind((String)SCMImportMessages.AbstractImportFromOtherWizard_6, (Object)status.getMessage()))) {
            return false;
        }
        if (this.configuration.isImportIntoWorkspace()) {
            ITeamRepository repository = this.teamPlaceSelectionPage.getRepository();
            if (!this.confirmImportForNonAdminUser(this.getShell(), repository)) {
                return false;
            }
            if (!Author2ContributorMappingArea.promptForSuspectMappings(this.getShell(), repository.loggedInContributor(), this.contributorMappingPage.getAuthorMappings(), this.configuration.getSourceRepositoryKind())) {
                return false;
            }
            this.configuration.setRepository(repository);
            if (this.teamPlaceSelectionPage.creatingNewWorkspace()) {
                this.configuration.setWorkspaceName(this.teamPlaceSelectionPage.getWorkspaceName());
            } else {
                final TeamAreaSelection teamSelection = this.teamPlaceSelectionPage.getTeamSelection();
                try {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                WorkspaceComponentWrapper wrapper = teamSelection.getComponent(AbstractImportWizard.this.configuration.getRepository(), monitor);
                                if (wrapper != null) {
                                    AbstractImportWizard.this.configuration.setTargetComponent(wrapper.getWorkspaceConnection(), wrapper.getComponent());
                                }
                            }
                            catch (TeamRepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    ImportLoggingHelper.displayError(SCMImportMessages.AbstractImportWizard_2, e.getTargetException());
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            this.configuration.setAuthorMappings(this.contributorMappingPage.getAuthorMappings());
        }
        return true;
    }

    private boolean confirmImportForNonAdminUser(Shell shell, ITeamRepository repository) {
        boolean isAdmin;
        Object property = this.getConfiguration().getProperty("PromptForAuthrMappings");
        if (!(property != null && property != "none" || (isAdmin = this.hasAdminPrivileges(repository)))) {
            return MessageDialog.openConfirm((Shell)shell, (String)SCMImportMessages.AbstractImportWizard_3, (String)NLS.bind((String)SCMImportMessages.AbstractImportWizard_4, (Object)repository.loggedInContributor().getUserId()));
        }
        return true;
    }

    private boolean hasAdminPrivileges(final ITeamRepository repository) {
        try {
            final boolean[] isAdmin = new boolean[1];
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    isAdmin[0] = Author2ContributorMappingArea.hasJazzAdminPermissions(repository);
                }
            });
            return isAdmin[0];
        }
        catch (InvocationTargetException e) {
            ImportLoggingHelper.displayError(SCMImportMessages.AbstractImportWizard_2, e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    protected abstract ImageDescriptor getBanner();

    public ImportConfiguration getConfiguration() {
        return this.configuration;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.context = UIContext.createShellContext((Shell)workbench.getActiveWorkbenchWindow().getShell());
    }

    public UIContext getContext() {
        return this.context;
    }

    public void setContext(UIContext context) {
        this.context = context;
    }

    public final boolean performFinish() {
        if (!this.aboutToFinish()) {
            return false;
        }
        ImportOperation op = this.createImportOperation();
        this.getContext().getUserOperationRunner().enqueue(op.getName(), (Operation)op);
        return true;
    }

    protected abstract ImportOperation createImportOperation();
}

