/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.ide.ui.internal.logical.IChangeSetFilter;
import com.ibm.team.filesystem.ide.ui.internal.logical.PartialFileSystemView;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.IChangeSetArchiveCreator;
import com.ibm.team.scm.client.importz.internal.ChangeSetArchiveImporter;
import com.ibm.team.scm.client.importz.internal.IImportAcceptHelper;
import com.ibm.team.scm.client.importz.internal.IImportDeliverHelper;
import com.ibm.team.scm.client.importz.internal.IImporter;
import com.ibm.team.scm.client.importz.internal.ISyncFileReader;
import com.ibm.team.scm.client.importz.internal.ISyncImportParticipant;
import com.ibm.team.scm.client.importz.internal.ISyncMigrationFactory;
import com.ibm.team.scm.client.importz.internal.ImportArchiveOperation;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.spi.ImportData;
import com.ibm.team.scm.common.IChangeHistoryEntry;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class SyncOperation {
    private Object lock;
    private List outgoing;
    private List incoming;
    private IWorkspaceConnection userWorkspace;
    private IComponent component;
    private ISyncMigrationFactory factory;
    private IWorkspaceConnection importWorkspace;
    private ISyncImportParticipant importParticipant;

    public SyncOperation(IWorkspaceConnection workspace, IWorkspaceConnection importWorkspace, IComponent component, ISyncMigrationFactory factory) {
        if (workspace == null || component == null || factory == null) {
            throw new NullPointerException();
        }
        this.userWorkspace = workspace;
        this.importWorkspace = importWorkspace;
        this.component = component;
        this.factory = factory;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getIncoming() {
        Object object = this.lock;
        synchronized (object) {
            return this.incoming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOutgoing() {
        Object object = this.lock;
        synchronized (object) {
            return this.outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh(IProgressMonitor pm) throws CoreException, InterruptedException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (String)(String.valueOf(SCMImportMessages.SyncOperation_0) + this.factory.getName()), (int)100);
        if (this.importParticipant.needsReinit((IProgressMonitor)progress.newChild(1))) {
            this.init((IProgressMonitor)progress.newChild(99));
        } else {
            File archiveFile = DebugUtils.createTempFile("importArchive");
            ImportData data = new ImportData();
            data.setArchiveFile(archiveFile);
            boolean closeArchive = false;
            try {
                IChangeSetArchiveCreator scmImproter = this.factory.createChangeSetArchiveCreator();
                ((IImporter)((Object)scmImproter)).createChangeSetArchive(this.importParticipant, archiveFile.getAbsolutePath(), (IProgressMonitor)progress.newChild(80));
                closeArchive = data.openArchive((IProgressMonitor)progress);
                ChangeSetArchiveImporter importer = new ChangeSetArchiveImporter(this.factory, data);
                importer.addImportParticipant(this.importParticipant);
                importer.importChangeSetArchive(this.importWorkspace, this.component, false, (IProgressMonitor)progress.newChild(8));
                this.computeOutgoingChangeSets((IProgressMonitor)progress.newChild(1));
                List<IChangeSetHandle> incoming = this.importParticipant.getIncomingChangeSets();
                Object object = this.lock;
                synchronized (object) {
                    this.incoming = incoming;
                }
            }
            finally {
                if (closeArchive) {
                    data.closeArchive();
                }
                DebugUtils.deleteTempFile(archiveFile);
            }
            if (this.importParticipant.needsReinit((IProgressMonitor)progress.newChild(1))) {
                this.init((IProgressMonitor)progress.newChild(9));
            }
        }
        pm.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(IProgressMonitor pm) throws CoreException, InterruptedException, TeamRepositoryException, IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (String)(String.valueOf(SCMImportMessages.SyncOperation_2) + this.factory.getName()), (int)100);
        File archiveFile = DebugUtils.createTempFile("importArchive");
        ImportData data = new ImportData();
        data.setArchiveFile(archiveFile);
        boolean closeArchive = false;
        try {
            ISyncFileReader syncReader = this.factory.createSyncFileReader();
            syncReader.read(this.userWorkspace, this.component, (IProgressMonitor)progress.newChild(3));
            IChangeSetHandle initial = ImportArchiveOperation.getInitialCS(this.component, this.userWorkspace.teamRepository(), (IProgressMonitor)progress.newChild(2));
            IChangeSetArchiveCreator scmImproter = this.factory.createChangeSetArchiveCreator();
            ((IImporter)((Object)scmImproter)).createChangeSetArchive(syncReader, archiveFile.getAbsolutePath(), (IProgressMonitor)progress.newChild(40));
            this.importParticipant = this.factory.createImportParticipant(syncReader);
            PartialFileSystemView view = new PartialFileSystemView(this.userWorkspace, this.component);
            ImportArchiveOperation.ImportChangeSetFilter importFilter = new ImportArchiveOperation.ImportChangeSetFilter(this.factory.createChangeSetFilter(this.importParticipant), initial);
            SyncChangeSetFilterWrapper filter = new SyncChangeSetFilterWrapper(importFilter);
            view.discardChangeSets((IChangeSetFilter)filter, (IProgressMonitor)progress.newChild(5));
            this.importWorkspace = view.createView(this.factory.getName(), this.importWorkspace, (IProgressMonitor)progress.newChild(5));
            closeArchive = data.openArchive((IProgressMonitor)progress);
            ChangeSetArchiveImporter importer = new ChangeSetArchiveImporter(this.factory, data);
            importer.addImportParticipant(this.importParticipant);
            importer.importChangeSetArchive(this.importWorkspace, this.component, false, (IProgressMonitor)progress.newChild(45));
            List outgoing = filter.getDiscardedChangeSets();
            List<IChangeSetHandle> incoming = this.importParticipant.getIncomingChangeSets();
            Object object = this.lock;
            synchronized (object) {
                this.outgoing = outgoing;
                this.incoming = incoming;
            }
        }
        finally {
            if (closeArchive) {
                data.closeArchive();
            }
            DebugUtils.deleteTempFile(archiveFile);
        }
        pm.done();
    }

    public IWorkspaceConnection getFrom() {
        return this.userWorkspace;
    }

    public IWorkspaceConnection getTo() {
        return this.importWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deliver(List changeSetHandles, IProgressMonitor monitor) throws IOException, CoreException, TeamRepositoryException {
        this.checkOutgoing(changeSetHandles);
        this.getDeliverHelper().deliver(changeSetHandles, monitor);
        Object object = this.lock;
        synchronized (object) {
            this.outgoing = this.removeChangeSets(this.outgoing, changeSetHandles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void markDelivered(List changeSetHandles, IProgressMonitor monitor) throws FileSystemClientException, IOException, TeamRepositoryException {
        this.checkOutgoing(changeSetHandles);
        this.getDeliverHelper().markDelivered(changeSetHandles, monitor);
        Object object = this.lock;
        synchronized (object) {
            this.outgoing = this.removeChangeSets(this.outgoing, changeSetHandles);
        }
    }

    private void checkOutgoing(List changeSets) {
        HashSet<UUID> outgoingChangeSetIds = new HashSet<UUID>();
        Iterator i = this.getOutgoing().iterator();
        while (i.hasNext()) {
            outgoingChangeSetIds.add(((IChangeSetHandle)i.next()).getItemId());
        }
        i = changeSets.iterator();
        while (i.hasNext()) {
            if (outgoingChangeSetIds.contains(((IChangeSetHandle)i.next()).getItemId())) continue;
            throw new IllegalArgumentException(SCMImportMessages.SyncOperation_4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postAccept(List acceptedChangeSetHandles, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.getAcceptHelper().postAccept(acceptedChangeSetHandles, (IProgressMonitor)progress.newChild(99));
        Object object = this.lock;
        synchronized (object) {
            this.incoming = this.removeChangeSets(this.incoming, acceptedChangeSetHandles);
        }
        this.computeOutgoingChangeSets((IProgressMonitor)progress.newChild(1));
        monitor.done();
    }

    private List removeChangeSets(List current, List toRemove) {
        HashSet<UUID> removed = new HashSet<UUID>((int)((double)toRemove.size() / 0.75));
        for (IChangeSetHandle cs : toRemove) {
            removed.add(cs.getItemId());
        }
        ArrayList<IChangeSetHandle> newList = new ArrayList<IChangeSetHandle>(Math.max(current.size() - toRemove.size(), 0));
        for (IChangeSetHandle cs : current) {
            if (removed.contains(cs.getItemId())) continue;
            newList.add(cs);
        }
        return newList;
    }

    public boolean allowsDeliver() {
        return this.getDeliverHelper().allowsDeliver();
    }

    protected IImportAcceptHelper getAcceptHelper() {
        return this.factory.createAcceptHelper(this.importParticipant);
    }

    protected IImportDeliverHelper getDeliverHelper() {
        return this.factory.createDeliverHelper(this.importParticipant, this.importWorkspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeOutgoingChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        SyncChangeSetFilterWrapper filter = new SyncChangeSetFilterWrapper(this.factory.createChangeSetFilter(this.importParticipant));
        ITeamRepository repo = this.userWorkspace.teamRepository();
        int ticksRemaining = 1000;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ticksRemaining);
        IChangeHistory history = this.userWorkspace.changeHistory((IComponentHandle)this.component);
        while (!filter.allDiscarded() && history != null) {
            int ticks = ticksRemaining / 2;
            ticksRemaining -= ticks;
            SubMonitor subProgress = progress.newChild(ticks);
            List recentHist = history.recent((IProgressMonitor)subProgress.newChild(30));
            List recent = new ArrayList<IChangeSetHandle>(recentHist.size());
            for (IChangeHistoryEntry historyEntry : recentHist) {
                recent.add(((IChangeHistoryEntryChange)historyEntry).changeSet());
            }
            if (!recent.isEmpty()) {
                recent = repo.itemManager().fetchCompleteItems(recent, 0, (IProgressMonitor)subProgress.newChild(60));
            }
            Iterator i = recent.listIterator(recent.size());
            while (i.hasPrevious()) {
                IChangeSet cs = (IChangeSet)i.previous();
                filter.excludeChangeSet(cs);
            }
            history = history.previousHistory((IProgressMonitor)subProgress.newChild(recent.isEmpty() ? 70 : 10));
            subProgress.done();
        }
        List outgoing = filter.getDiscardedChangeSets();
        Object object = this.lock;
        synchronized (object) {
            this.outgoing = outgoing;
        }
        monitor.done();
    }

    protected static class SyncChangeSetFilterWrapper
    implements IChangeSetFilter {
        protected IChangeSetFilter filter;
        protected List discardedChangeSets;

        public SyncChangeSetFilterWrapper(IChangeSetFilter filter) {
            this.filter = filter;
            this.discardedChangeSets = new LinkedList();
        }

        public boolean allDiscarded() {
            return this.filter.allDiscarded();
        }

        public boolean excludeChangeSet(IChangeSet changeSet) {
            if (this.filter.excludeChangeSet(changeSet)) {
                this.discardedChangeSets.add(0, changeSet);
                return true;
            }
            return false;
        }

        public List getDiscardedChangeSets() {
            return this.discardedChangeSets;
        }
    }
}

