/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.importz.internal.IImportDeliverHelper;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.SyncImportParticipant;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImportDeliverHelper
implements IImportDeliverHelper {
    private SyncImportParticipant participant;
    private IWorkspaceConnection workspace;
    private Collection<IVersionableHandle> finalStates;
    private Map<UUID, IVersionable> initialStates;

    public ImportDeliverHelper(SyncImportParticipant participant, IWorkspaceConnection workspace) {
        this.participant = participant;
        this.workspace = workspace;
    }

    @Override
    public void deliver(List<? extends IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws IOException, CoreException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = this.participant.getWorkspace();
        List changeSets = workspace.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, (IProgressMonitor)progress.newChild(5));
        this.checkAndInitDeliver(changeSets, (IProgressMonitor)progress.newChild(20));
        this.closeActiveChangeSets(changeSets, (IProgressMonitor)progress.newChild(5));
        try {
            this.commitToRemoteSCM(changeSets, (IProgressMonitor)progress.newChild(55));
            this.markDelivered(changeSets, (IProgressMonitor)progress.newChild(10));
        }
        catch (Exception e) {
            StatusUtil.log((Object)"com.ibm.team.scm.client.importz", (Throwable)e);
            try {
                File f = File.createTempFile("sync", ".txt");
                this.writeSyncInfo(f);
                throw new CoreException(StatusUtil.newStatus((Object)"com.ibm.team.scm.client.importz", (String)(String.valueOf(SCMImportMessages.ImportDeliverHelper_2) + f.getAbsolutePath())));
            }
            catch (IOException ex) {
                throw new CoreException(StatusUtil.newStatus((Object)"com.ibm.team.scm.client.importz", (String)SCMImportMessages.ImportDeliverHelper_3, (Throwable)ex));
            }
        }
        this.deliverChangeSets(changeSets, (IProgressMonitor)progress.newChild(5));
        monitor.done();
    }

    @Override
    public void markDelivered(List<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.participant.deliveredChangeSets(changeSets);
        this.writeSyncInfo(monitor);
    }

    protected abstract void writeSyncInfo(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void writeSyncInfo(File var1) throws IOException;

    protected void closeActiveChangeSets(List<IChangeSet> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IChangeSet> toClose = new ArrayList<IChangeSet>();
        for (IChangeSet cs : changeSets) {
            if (!cs.isActive()) continue;
            toClose.add(cs);
        }
        if (!toClose.isEmpty()) {
            this.participant.getWorkspace().closeChangeSets(toClose, monitor);
        } else {
            monitor.beginTask("", 1);
            monitor.done();
        }
    }

    protected void checkAndInitDeliver(List<IChangeSet> changeSets, IProgressMonitor monitor) throws IOException, CoreException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        this.checkPredecessorStates(changeSets, (IProgressMonitor)progress.newChild(1));
        ArrayList<IVersionableHandle> affectedItems = new ArrayList<IVersionableHandle>(this.getAffectedItems(changeSets));
        List<IVersionable> affectedItemStates = this.getAffectedItemStates(affectedItems, (IProgressMonitor)progress.newChild(1));
        this.initialStates = this.getInitialStates(affectedItems, affectedItemStates);
        this.finalStates = this.getFinalStates(changeSets, affectedItems, affectedItemStates, (IProgressMonitor)progress.newChild(1));
        TeamRepositoryException e = this.checkMissingParents(affectedItems, new RepoItemFetcher(), (IProgressMonitor)progress.newChild(1));
        if (e != null) {
            throw e;
        }
        monitor.done();
    }

    protected void checkPredecessorStates(List<IChangeSet> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Map<String, IVersionableHandle> unresolvedStates = this.getUnresolvedPredecessorStates(changeSets);
        Iterator<String> i = unresolvedStates.keySet().iterator();
        while (i.hasNext()) {
            if (!this.getStateRevisionMap().containsKey(i.next())) continue;
            i.remove();
        }
        if (!unresolvedStates.isEmpty() && !this.directoriesSignificant()) {
            this.ensureAllDirChanges(unresolvedStates.values());
            this.findDirChangesInHistory(unresolvedStates.keySet(), (IProgressMonitor)progress.newChild(1));
        }
        if (!unresolvedStates.isEmpty()) {
            throw new TeamRepositoryException((Object)this.participant.getWorkspace().teamRepository(), SCMImportMessages.ImportDeliverHelper_5);
        }
        monitor.done();
    }

    protected void ensureAllDirChanges(Collection<IVersionableHandle> unresolvedItems) throws TeamRepositoryException {
        for (IVersionableHandle item : unresolvedItems) {
            if (item instanceof IFolderHandle) continue;
            throw new TeamRepositoryException((Object)this.participant.getWorkspace().teamRepository(), SCMImportMessages.ImportDeliverHelper_6);
        }
    }

    protected void findDirChangesInHistory(Set<String> unresolvedStates, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)unresolvedStates.size());
        IWorkspaceConnection workspace = this.participant.getWorkspace();
        IComponent component = this.participant.getComponent();
        ITeamRepository repo = workspace.teamRepository();
        IChangeHistory history = workspace.changeHistory((IComponentHandle)component);
        while (history != null && !unresolvedStates.isEmpty()) {
            List recentHist = history.recent((IProgressMonitor)progress.newChild(0));
            List<IChangeSetHandle> recent = new ArrayList(recentHist.size());
            for (IChangeHistoryEntryChange historyEntry : recentHist) {
                IChangeSetHandle cs = historyEntry.changeSet();
                if (!this.participant.getCommittedChangeSets().contains(cs.getItemId().getUuidValue())) continue;
                recent.add(cs);
            }
            if (!recent.isEmpty()) {
                recent = repo.itemManager().fetchCompleteItems(recent, 0, (IProgressMonitor)progress.newChild(0));
                ListIterator i = recent.listIterator(recent.size());
                while (i.hasPrevious()) {
                    IChangeSet cs = (IChangeSet)i.previous();
                    for (IChange change : cs.changes()) {
                        if (change.afterState() != null && unresolvedStates.remove(change.afterState().getStateId().getUuidValue())) {
                            progress.worked(1);
                        }
                        if (change.beforeState() != null && unresolvedStates.remove(change.beforeState().getStateId().getUuidValue())) {
                            progress.worked(1);
                        }
                        for (IVersionableHandle v : change.mergeStates()) {
                            if (v == null || !unresolvedStates.remove(v.getStateId().getUuidValue())) continue;
                            progress.worked(1);
                        }
                    }
                }
            }
            history = history.previousHistory((IProgressMonitor)progress.newChild(0));
        }
        monitor.done();
    }

    protected Map<UUID, IVersionable> getInitialStates() {
        return this.initialStates;
    }

    protected Collection<IVersionableHandle> getFinalStates() {
        return this.finalStates;
    }

    protected Map<UUID, IVersionable> getInitialStates(List<IVersionableHandle> items, List<IVersionable> itemStates) throws TeamRepositoryException {
        HashMap<UUID, IVersionable> itemsMap = new HashMap<UUID, IVersionable>();
        Iterator<IVersionable> i = itemStates.iterator();
        for (IVersionableHandle h : items) {
            itemsMap.put(h.getItemId(), i.next());
        }
        return itemsMap;
    }

    protected Collection<IVersionableHandle> getFinalStates(List<IChangeSet> changeSets, List<IVersionableHandle> affectedItems, List<IVersionable> affectedItemStates, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<IVersionableHandle, IVersionable> affectedItemsMap = new HashMap<IVersionableHandle, IVersionable>();
        Iterator<IVersionable> i = affectedItemStates.iterator();
        for (IVersionableHandle item : affectedItems) {
            affectedItemsMap.put(item, i.next());
        }
        Collection<Map<UUID, IVersionableHandle>> finalStates = this.getFinalStates(changeSets, affectedItemsMap);
        ArrayList<IVersionableHandle> finalStatesList = new ArrayList<IVersionableHandle>(finalStates.size());
        ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>();
        for (Map<UUID, IVersionableHandle> states : finalStates) {
            if (states.size() != 1) {
                throw new TeamRepositoryException((Object)this.participant.getWorkspace().teamRepository(), SCMImportMessages.ImportDeliverHelper_7);
            }
            IVersionableHandle item = states.values().iterator().next();
            if (item.hasStateId()) {
                if (item instanceof IVersionable) {
                    finalStatesList.add((IVersionableHandle)((IVersionable)item));
                    continue;
                }
                IVersionable v = this.initialStates.get(item.getItemId());
                if (!item.sameStateId((IItemHandle)v)) {
                    toFetch.add(item);
                    continue;
                }
                finalStatesList.add((IVersionableHandle)v);
                continue;
            }
            finalStatesList.add(item);
        }
        if (!toFetch.isEmpty()) {
            finalStatesList.addAll(SCMPlatform.getWorkspaceManager((ITeamRepository)this.workspace.teamRepository()).versionableManager().fetchCompleteStates(toFetch, monitor));
        } else {
            monitor.beginTask("", 1);
            monitor.done();
        }
        return finalStatesList;
    }

    protected List<IVersionable> getAffectedItemStates(List<IVersionableHandle> affectedItems, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.workspace.configuration((IComponentHandle)this.participant.getComponent()).fetchCompleteItems(affectedItems, monitor);
    }

    protected Map<String, IVersionableHandle> getUnresolvedPredecessorStates(List<IChangeSet> changeSets) {
        HashSet<UUID> knownPredecessors = new HashSet<UUID>();
        HashMap<String, IVersionableHandle> unresolvedPredecessors = new HashMap<String, IVersionableHandle>();
        for (IChangeSet cs : changeSets) {
            for (IChange change : cs.changes()) {
                if (change.beforeState() != null && !knownPredecessors.contains(change.beforeState().getStateId())) {
                    unresolvedPredecessors.put(change.beforeState().getStateId().getUuidValue(), change.beforeState());
                }
                for (IVersionableHandle item : change.mergeStates()) {
                    if (item == null || knownPredecessors.contains(item.getStateId())) continue;
                    unresolvedPredecessors.put(item.getStateId().getUuidValue(), item);
                }
                if (change.afterState() == null) continue;
                knownPredecessors.add(change.afterState().getStateId());
            }
        }
        return unresolvedPredecessors;
    }

    protected Collection<IVersionableHandle> getAffectedItems(Collection<IChangeSet> changeSets) {
        HashMap<UUID, IVersionableHandle> affectedItems = new HashMap<UUID, IVersionableHandle>();
        for (IChangeSet cs : changeSets) {
            for (IChange change : cs.changes()) {
                affectedItems.put(change.item().getItemId(), change.item());
            }
        }
        return affectedItems.values();
    }

    protected Collection<Map<UUID, IVersionableHandle>> getFinalStates(List<IChangeSet> changeSets, Map<IVersionableHandle, IVersionable> latestItemStates) {
        HashMap latestStates = new HashMap();
        for (Map.Entry<IVersionableHandle, IVersionable> entry : latestItemStates.entrySet()) {
            HashMap<UUID, Object> itemStates = new HashMap<UUID, Object>();
            IVersionableHandle item = entry.getKey();
            if (entry.getValue() != null) {
                IVersionable latestState = entry.getValue();
                itemStates.put(latestState.getStateId(), latestState);
            } else {
                itemStates.put(null, item);
            }
            latestStates.put(item.getItemId(), itemStates);
        }
        for (IChangeSet cs : changeSets) {
            for (IChange change : cs.changes()) {
                Map itemStates = (Map)latestStates.get(change.item().getItemId());
                if (itemStates == null) {
                    throw new IllegalStateException(String.valueOf(SCMImportMessages.ImportDeliverHelper_9) + change.item());
                }
                if (change.beforeState() != null) {
                    itemStates.remove(change.beforeState().getStateId());
                } else {
                    itemStates.remove(null);
                }
                for (IVersionableHandle item : change.mergeStates()) {
                    if (item != null) {
                        itemStates.remove(item.getStateId());
                        continue;
                    }
                    itemStates.remove(null);
                }
                if (change.afterState() != null) {
                    itemStates.put(change.afterState().getStateId(), change.afterState());
                    continue;
                }
                itemStates.put(null, change.item());
            }
        }
        return latestStates.values();
    }

    protected TeamRepositoryException checkMissingParents(Collection<IVersionableHandle> affectedItems, IItemFetcher fetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<UUID, IVersionable> closure = this.buildParentClosure(affectedItems, fetcher, (IProgressMonitor)progress.newChild(50));
        ArrayList<IFolderHandle> toFetch = new ArrayList<IFolderHandle>();
        for (IVersionableHandle h : affectedItems) {
            IVersionable v = closure.get(h.getItemId());
            if (v != null) {
                if (v.getParent() == null) continue;
                IFolder parent = (IFolder)closure.get(v.getParent().getItemId());
                if (parent == null) {
                    TeamRepositoryException e = new TeamRepositoryException((Object)this.workspace.teamRepository(), SCMImportMessages.ImportDeliverHelper_10);
                    e.fillInStackTrace();
                    return e;
                }
                toFetch.add((IFolderHandle)parent);
                HashSet<UUID> seenItems = new HashSet<UUID>();
                do {
                    if (!seenItems.add(v.getItemId())) {
                        TeamRepositoryException e = new TeamRepositoryException((Object)this.workspace.teamRepository(), SCMImportMessages.ImportDeliverHelper_11);
                        e.fillInStackTrace();
                        return e;
                    }
                    if ((v = closure.get(v.getParent().getItemId())) != null) continue;
                    TeamRepositoryException e = new TeamRepositoryException((Object)this.workspace.teamRepository(), SCMImportMessages.ImportDeliverHelper_12);
                    e.fillInStackTrace();
                    return e;
                } while (v.getParent() != null);
                continue;
            }
            if (!(h instanceof IFolderHandle)) continue;
            toFetch.add((IFolderHandle)h);
        }
        if (toFetch.isEmpty()) {
            monitor.done();
            return null;
        }
        List<Map<String, IVersionableHandle>> fetched = fetcher.fetchChildren(toFetch, (IProgressMonitor)progress.newChild(50));
        Iterator i = toFetch.iterator();
        HashMap<UUID, Map<String, IVersionableHandle>> childMap = new HashMap<UUID, Map<String, IVersionableHandle>>((int)((double)fetched.size() / 0.75));
        for (Map<String, IVersionableHandle> entries : fetched) {
            childMap.put(((IFolderHandle)i.next()).getItemId(), entries);
        }
        for (IVersionableHandle h : affectedItems) {
            IVersionable v = closure.get(h.getItemId());
            if (v != null) {
                if (v.sameItemId((IItemHandle)((Map)childMap.get(v.getParent().getItemId())).get(v.getName()))) continue;
                TeamRepositoryException e = new TeamRepositoryException((Object)this.workspace.teamRepository(), SCMImportMessages.ImportDeliverHelper_13);
                e.fillInStackTrace();
                return e;
            }
            if (((Map)childMap.get(h.getItemId())).isEmpty()) continue;
            TeamRepositoryException e = new TeamRepositoryException((Object)this.workspace.teamRepository(), SCMImportMessages.ImportDeliverHelper_14);
            e.fillInStackTrace();
            return e;
        }
        return null;
    }

    protected Map<UUID, IVersionable> buildParentClosure(Collection<IVersionableHandle> items, IItemFetcher fetcher, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<UUID, IVersionable> result = new HashMap<UUID, IVersionable>((int)((double)items.size() / 0.375));
        ArrayList<Object> toFetch = new ArrayList<IVersionableHandle>(items);
        while (!toFetch.isEmpty()) {
            HashSet<UUID> ids = new HashSet<UUID>((int)((double)toFetch.size() / 0.75));
            for (IVersionableHandle h : toFetch) {
                ids.add(h.getItemId());
            }
            List<IVersionable> fetched = fetcher.fetch(toFetch, (IProgressMonitor)progress.newChild(50));
            Iterator i = toFetch.iterator();
            ArrayList<IFolderHandle> next = new ArrayList<IFolderHandle>(toFetch.size());
            for (IVersionable v : fetched) {
                if (v == null) {
                    result.put(((IVersionableHandle)i.next()).getItemId(), null);
                    continue;
                }
                result.put(v.getItemId(), v);
                i.next();
                if (v.getParent() == null || result.containsKey(v.getParent().getItemId()) || ids.contains(v.getParent().getItemId())) continue;
                next.add(v.getParent());
            }
            toFetch = next;
        }
        return result;
    }

    @Override
    public boolean allowsDeliver() {
        return true;
    }

    protected abstract boolean directoriesSignificant();

    protected abstract void commitToRemoteSCM(List<IChangeSet> var1, IProgressMonitor var2) throws CoreException, IOException, TeamRepositoryException;

    protected Map<String, String> getStateRevisionMap() {
        return this.participant.getBaseStateRevisionMap();
    }

    protected SyncImportParticipant getParticipant() {
        return this.participant;
    }

    protected IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    protected void deliverChangeSets(List<IChangeSet> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.commitFinalStates(monitor);
    }

    protected void commitFinalStates(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<Object> configOps = new ArrayList<Object>(this.finalStates.size());
        for (IVersionableHandle item : this.finalStates) {
            if (item.hasStateId()) {
                if (item.sameStateId((IItemHandle)((IVersionableHandle)this.initialStates.get(item.getItemId())))) continue;
                configOps.add(this.workspace.configurationOpFactory().revert(item));
                continue;
            }
            if (this.initialStates.get(item.getItemId()) == null) continue;
            configOps.add(this.workspace.configurationOpFactory().delete(item));
        }
        IChangeSetHandle cs = this.workspace.createChangeSet((IComponentHandle)this.participant.getComponent(), (IProgressMonitor)progress.newChild(20));
        boolean success = false;
        try {
            this.workspace.commit(cs, configOps, (IProgressMonitor)progress.newChild(70));
            this.workspace.closeChangeSets(Collections.singleton(cs), (IProgressMonitor)progress.newChild(10));
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                try {
                    this.workspace.discardChangeSets(false, Collections.singleton(cs), (IProgressMonitor)progress.newChild(0));
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            throw throwable;
        }
        if (!success) {
            try {
                this.workspace.discardChangeSets(false, Collections.singleton(cs), (IProgressMonitor)progress.newChild(0));
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        monitor.done();
    }

    protected String getComment(IChangeSet cs) {
        String comment = cs.getComment();
        return comment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface IItemFetcher {
        public List<IVersionable> fetch(List<IVersionableHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

        public List<Map<String, IVersionableHandle>> fetchChildren(List<IFolderHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepoItemFetcher
    implements IItemFetcher {
        private Map<UUID, IVersionableHandle> stateMap;
        private Map<UUID, List<IVersionable>> parentMap;

        public RepoItemFetcher() {
            this.stateMap = new HashMap<UUID, IVersionableHandle>((int)((double)ImportDeliverHelper.this.finalStates.size() / 0.75));
            this.parentMap = new HashMap<UUID, List<IVersionable>>();
            for (IVersionableHandle item : ImportDeliverHelper.this.finalStates) {
                this.stateMap.put(item.getItemId(), item);
                if (!item.hasStateId() || item.sameItemId((IItemHandle)ImportDeliverHelper.this.participant.getComponent().getRootFolder())) continue;
                IVersionable v = (IVersionable)item;
                List<IVersionable> children = this.parentMap.get(v.getParent().getItemId());
                if (children == null) {
                    children = new ArrayList<IVersionable>();
                    this.parentMap.put(v.getParent().getItemId(), children);
                }
                children.add(v);
            }
        }

        @Override
        public List<Map<String, IVersionableHandle>> fetchChildren(List<IFolderHandle> items, IProgressMonitor monitor) throws TeamRepositoryException {
            HashMap resultMap = new HashMap();
            ArrayList<Map<String, IVersionableHandle>> result = new ArrayList<Map<String, IVersionableHandle>>(items.size());
            for (IFolderHandle h : items) {
                HashMap<String, IVersionable> children = new HashMap<String, IVersionable>();
                resultMap.put(h.getItemId(), children);
                result.add(children);
                List<IVersionable> knownChildren = this.parentMap.get(h.getItemId());
                if (knownChildren == null) continue;
                for (IVersionable child : knownChildren) {
                    children.put(child.getName(), child);
                }
            }
            List fetched = ImportDeliverHelper.this.workspace.configuration((IComponentHandle)ImportDeliverHelper.this.participant.getComponent()).childEntries(items, monitor);
            Iterator<IFolderHandle> i = items.iterator();
            for (Map entries : fetched) {
                IFolderHandle parent = i.next();
                if (entries == null) continue;
                for (Map.Entry child : entries.entrySet()) {
                    IVersionableHandle cv = (IVersionableHandle)child.getValue();
                    if (this.stateMap.containsKey(cv.getItemId())) continue;
                    ((Map)resultMap.get(parent.getItemId())).put((String)child.getKey(), cv);
                }
            }
            return result;
        }

        @Override
        public List<IVersionable> fetch(List<IVersionableHandle> items, IProgressMonitor monitor) throws TeamRepositoryException {
            HashMap<UUID, IVersionable> fetched = new HashMap<UUID, IVersionable>((int)((double)items.size() / 0.75));
            ArrayList<IVersionableHandle> toFetch = new ArrayList<IVersionableHandle>(items.size());
            for (IVersionableHandle h : items) {
                IVersionableHandle item = this.stateMap.get(h.getItemId());
                if (item != null) {
                    if (!item.hasStateId()) continue;
                    fetched.put(item.getItemId(), (IVersionable)item);
                    continue;
                }
                toFetch.add(h);
            }
            if (!toFetch.isEmpty()) {
                List fetchedList = ImportDeliverHelper.this.workspace.configuration((IComponentHandle)ImportDeliverHelper.this.participant.getComponent()).fetchCompleteItems(toFetch, monitor);
                for (IVersionable v : fetchedList) {
                    if (v == null) continue;
                    fetched.put(v.getItemId(), v);
                }
            }
            ArrayList<IVersionable> result = new ArrayList<IVersionable>(items.size());
            for (IVersionableHandle h : items) {
                result.add((IVersionable)fetched.get(h.getItemId()));
            }
            return result;
        }
    }
}

