/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.ide.ui.internal.logical.IChangeSetFilter;
import com.ibm.team.filesystem.ide.ui.internal.logical.PartialFileSystemView;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.importz.IChangeSetArchiveImporter;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.IImportParticipant;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.AbstractImportOperation;
import com.ibm.team.scm.client.importz.internal.ChangeSetArchiveImporter;
import com.ibm.team.scm.client.importz.internal.IChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.IImportAcceptHelper;
import com.ibm.team.scm.client.importz.internal.ISyncImportParticipant;
import com.ibm.team.scm.client.importz.internal.ISyncMigrationFactory;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.spi.ImportParticipant;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ImportArchiveOperation
extends AbstractImportOperation
implements IChangeSetArchiveImporter {
    private IWorkspaceConnection userWorkspace;
    private IComponent component;
    private IMigrationFactory factory;
    private boolean allowSync;
    private IChangeArchiveStatistics stats;

    public ImportArchiveOperation(IImportData importData, IWorkspaceConnection workspace, IComponent component, IMigrationFactory factory, boolean allowSync) {
        super(factory, importData);
        Assert.isNotNull((Object)workspace);
        Assert.isNotNull((Object)component);
        this.userWorkspace = workspace;
        this.component = component;
        this.factory = factory;
        this.allowSync = allowSync;
    }

    public void run(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        boolean closeArchive = false;
        try {
            closeArchive = this.getImportData().openArchive(monitor);
            this.doImport(this.getImportData(), monitor);
        }
        finally {
            if (closeArchive) {
                this.getImportData().closeArchive();
            }
        }
    }

    private void doImport(IImportData importData, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IWorkspaceConnection importWorkspace;
        String message = NLS.bind((String)SCMImportMessages.ImportArchiveOperation_0, (Object)this.factory.getName());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)message, (int)100);
        progress.setTaskName(message);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IChangeSetHandle initial = null;
        ImportChangeSetFilter filter = null;
        if (this.allowSync) {
            initial = ImportArchiveOperation.getInitialCS(this.component, this.userWorkspace.teamRepository(), (IProgressMonitor)progress.newChild(2));
            filter = new ImportChangeSetFilter(((ISyncMigrationFactory)this.factory).getChangeSetFilter(importData), initial);
            PartialFileSystemView view = new PartialFileSystemView(this.userWorkspace, this.component);
            view.discardChangeSets((IChangeSetFilter)filter, (IProgressMonitor)progress.newChild(4));
            String importWorkspaceName = this.allowSync ? this.factory.getName() : NLS.bind((String)SCMImportMessages.ImportArchiveOperation_1, (Object)this.userWorkspace.getName(), (Object)this.factory.getName());
            importWorkspace = view.createView(importWorkspaceName, null, (IProgressMonitor)progress.newChild(4));
        } else {
            importWorkspace = this.userWorkspace;
        }
        ChangeSetArchiveImporter importer = new ChangeSetArchiveImporter(this.factory, importData);
        IImportParticipant importParticipant = this.factory.createImportParticipant(this.userWorkspace, this.component, importData);
        if (this.allowSync && importParticipant == null) {
            ImportParticipant p = new ImportParticipant();
            p.setPostImportBaselineName(importData.getPostImportBaselineName());
            importParticipant = p;
        }
        if (importParticipant != null) {
            importer.addImportParticipant(importParticipant);
        }
        importer.importChangeSetArchive(importWorkspace, this.component, false, (IProgressMonitor)progress.newChild(80));
        this.stats = importer.getStats();
        if (this.allowSync && importParticipant instanceof ISyncImportParticipant && this.factory instanceof ISyncMigrationFactory) {
            IImportAcceptHelper acceptHelper = ((ISyncMigrationFactory)this.factory).createAcceptHelper((ISyncImportParticipant)importParticipant);
            List<IChangeSetHandle> incomingChangeSets = ((ISyncImportParticipant)importParticipant).getIncomingChangeSets();
            IChangeHistorySyncReport report = this.userWorkspace.compareTo((IFlowNodeConnection)importWorkspace, WorkspaceComparisonFlags.CHANGE_SET_COMPARISON_ONLY, Collections.EMPTY_LIST, (IProgressMonitor)progress.newChild(3));
            WorkspaceUpdateDilemmaHandler dilemmaHandler = new WorkspaceUpdateDilemmaHandler(){

                public int componentsToBeAddedOrRemoved(Collection<ConfigurationDescriptor> added, Collection<ConfigurationDescriptor> removed) {
                    return 3;
                }

                public int disconnectedComponents(Collection<ConfigurationDescriptor> configurations) {
                    return 0;
                }

                public int staleData(IWorkspaceConnection workspaceConnection, IWorkspaceConnection sourceWorkspaceConnection) {
                    return 0;
                }
            };
            ModelUtil.accept((IWorkspaceConnection)this.userWorkspace, (IWorkspaceConnection)importWorkspace, (IChangeHistorySyncReport)report, incomingChangeSets, (WorkspaceUpdateDilemmaHandler)dilemmaHandler, (IProgressMonitor)progress.newChild(1));
            acceptHelper.postAccept(incomingChangeSets, (IProgressMonitor)progress.newChild(3));
            if (filter.getUserFilter() == null) {
                ((ISyncMigrationFactory)this.factory).createDeliverHelper((ISyncImportParticipant)importParticipant, importWorkspace).markDelivered(Collections.singletonList(initial), (IProgressMonitor)progress.newChild(2));
            }
        }
        monitor.done();
    }

    static IChangeSetHandle getInitialCS(IComponent component, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IBaselineHandle initial = component.getInitialBaseline();
        IBaselineConnection bc = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection(initial, (IProgressMonitor)sm.newChild(50));
        IChangeHistory hist = bc.changeHistory();
        List recent = hist.recent((IProgressMonitor)sm.newChild(50));
        if (recent.size() != 1) {
            throw new IllegalStateException(SCMImportMessages.ImportArchiveOperation_2);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.done();
        return ((IChangeHistoryEntryChange)recent.get(0)).changeSet();
    }

    public IChangeArchiveStatistics getStats() {
        return this.stats;
    }

    public void performImport(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.run(monitor);
    }

    static class ImportChangeSetFilter
    implements IChangeSetFilter {
        private IChangeSetFilter userFilter;
        private IChangeSetHandle firstChangeSet;

        public ImportChangeSetFilter(IChangeSetFilter userFilter, IChangeSetHandle firstChangeSet) {
            this.userFilter = userFilter;
            this.firstChangeSet = firstChangeSet;
        }

        public boolean excludeChangeSet(IChangeSet changeSet) {
            if (this.firstChangeSet.sameItemId((IItemHandle)changeSet)) {
                return false;
            }
            return this.userFilter == null || this.userFilter.excludeChangeSet(changeSet);
        }

        public boolean allDiscarded() {
            return this.userFilter != null && this.userFilter.allDiscarded();
        }

        public IChangeSetFilter getUserFilter() {
            return this.userFilter;
        }
    }
}

