/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.spi.DerivedImportChangeSet;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedChangeSetComparator
implements Comparator<IImportChangeSet> {
    @Override
    public int compare(IImportChangeSet o1, IImportChangeSet o2) {
        return this.compareChangeSets((DerivedImportChangeSet)o1, (DerivedImportChangeSet)o2);
    }

    protected int compareChangeSets(DerivedImportChangeSet cs1, DerivedImportChangeSet cs2) {
        int cmp = cs1.getEarliestDate().compareTo(cs2.getEarliestDate());
        if (cmp != 0) {
            return cmp;
        }
        int finalResult = 0;
        HashMap<String, String> changeMap = new HashMap<String, String>();
        for (IImportChange change : cs1.getChanges()) {
            changeMap.put(this.getPath(change), change.getRevision());
        }
        for (IImportChange change2 : cs2.getChanges()) {
            String revision1 = (String)changeMap.get(this.getPath(change2));
            if (revision1 == null) continue;
            String revision2 = change2.getRevision();
            int result = this.compareChangeRevisions(revision1, revision2);
            finalResult += result;
        }
        return finalResult;
    }

    protected String getPath(IImportChange change) {
        if (change.getAfterPath() != null) {
            return change.getAfterPath();
        }
        return change.getBeforePath();
    }

    protected int compareChangeRevisions(String revision1, String revision2) {
        return revision1.compareTo(revision2);
    }
}

