/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.scm.client.importz.IChangeSetFileReader;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.spi.DerivedImportChangeSet;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ChangeSetBuffer {
    private int offset;
    private List<DerivedImportChangeSet> changeSets = new LinkedList<DerivedImportChangeSet>();
    private final IChangeSetFileReader reader;
    private boolean doneReading;

    public ChangeSetBuffer(IChangeSetFileReader reader) {
        this.reader = reader;
    }

    public void resetOffset() {
        this.offset = 0;
    }

    public DerivedImportChangeSet removeFirst() {
        return this.changeSets.remove(0);
    }

    public DerivedImportChangeSet getFirst() {
        return this.changeSets.get(0);
    }

    public void add(DerivedImportChangeSet changeSet) {
        this.changeSets.add(changeSet);
    }

    public boolean isEmpty() {
        return this.changeSets.isEmpty();
    }

    public void primeBuffer() throws IOException {
        IImportChangeSet next;
        if (this.changeSets.isEmpty() && (next = this.readNext()) != null) {
            this.changeSets.add((DerivedImportChangeSet)next);
        }
    }

    private IImportChangeSet readNext() throws IOException {
        if (this.doneReading) {
            return null;
        }
        IImportChangeSet next = this.reader.next(null);
        this.doneReading = next == null;
        return next;
    }

    public boolean walkBuffer(DerivedImportChangeSet changeSet) throws IOException {
        boolean modified;
        boolean globalModified = false;
        block0: do {
            modified = false;
            this.fillBuffer(changeSet);
            ListIterator<DerivedImportChangeSet> i = this.changeSets.listIterator(this.offset);
            while (i.hasNext()) {
                DerivedImportChangeSet nextChangeSet = (DerivedImportChangeSet)i.next();
                if (changeSet == nextChangeSet) {
                    ++this.offset;
                    continue;
                }
                if (nextChangeSet.getEarliestDate().getTime() - changeSet.getLatestDate().getTime() > 60000L) break block0;
                if (changeSet.sameAs(nextChangeSet)) {
                    changeSet.combine(nextChangeSet);
                    i.remove();
                    modified = true;
                    globalModified = true;
                    continue;
                }
                ++this.offset;
            }
        } while (modified);
        return globalModified;
    }

    public void fillBuffer(DerivedImportChangeSet changeSet) throws IOException {
        IImportChangeSet next;
        while ((next = this.readNext()) != null) {
            this.changeSets.add((DerivedImportChangeSet)next);
            if (((DerivedImportChangeSet)next).getEarliestDate().getTime() - changeSet.getLatestDate().getTime() >= 60000L) continue;
            return;
        }
    }
}

