/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ServiceMethodInvocationError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.importz.IChangeSetFileReader;
import com.ibm.team.scm.client.importz.IChangeSetFileWriter;
import com.ibm.team.scm.client.importz.IFileProperties;
import com.ibm.team.scm.client.importz.IImportChange;
import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.IImportParticipant;
import com.ibm.team.scm.client.importz.IMigrationFactory;
import com.ibm.team.scm.client.importz.internal.ChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.IChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.ImportException;
import com.ibm.team.scm.client.importz.internal.PreFlightChangeArchiveStatistics;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.utils.DebugUtils;
import com.ibm.team.scm.client.importz.internal.utils.FileTree;
import com.ibm.team.scm.client.importz.internal.utils.FileTreeWithEmptyFolderTracking;
import com.ibm.team.scm.client.importz.internal.utils.IFileTree;
import com.ibm.team.scm.client.importz.spi.ImportChange;
import com.ibm.team.scm.client.importz.spi.ImportChangeSet;
import com.ibm.team.scm.client.interop.IImportChangeSetResult;
import com.ibm.team.scm.client.interop.IWorkspaceConnectionInteropAdapter;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSetArchiveImporter {
    private static final String ENCODING_PREFERENCES_FILE = "org.eclipse.core.resources.prefs";
    private static final String SETTINGS_FOLDER_NAME = ".settings";
    private static final String ENCODING_PROPERTY_PREFIX = "encoding/";
    private static final String PROJECT_ENCODING_PROPERTY = "<project>";
    public static final int TIMING_INTERVAL = 100;
    private ITeamRepository repository;
    private IWorkspaceConnection workspace;
    private IComponent component;
    private boolean preflight;
    private boolean directoriesSignificant;
    private IFileTree fileTree;
    private final IImportData importData;
    private final IMigrationFactory factory;
    private ListenerList importParticipants = new ListenerList();
    private IChangeArchiveStatistics stats;
    private Map<String, Map<String, String>> projectEncodings = new HashMap<String, Map<String, String>>();
    private Set<String> reconciledProjects = new HashSet<String>();

    public ChangeSetArchiveImporter(IMigrationFactory factory, IImportData importData) {
        Assert.isNotNull((Object)importData);
        Assert.isNotNull((Object)factory);
        this.factory = factory;
        this.importData = importData;
    }

    public void importChangeSetArchive(IWorkspaceConnection workspace, IComponent component, boolean preflight, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkAndInitArgs(workspace, component, this.factory, preflight);
        this.stats = workspace == null ? new PreFlightChangeArchiveStatistics() : new ChangeArchiveStatistics(workspace);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.ChangeSetArchiveImporter_0, (int)1000);
        this.fileTree = new FileTree(workspace, component);
        SubMonitor subProgress = progress.newChild(990);
        subProgress.beginTask(SCMImportMessages.ChangeSetArchiveImporter_1, this.importData.getArchiveSize() - 1);
        IChangeSetFileReader reader = null;
        try {
            try {
                IImportChangeSet importChangeSet;
                reader = this.factory.createChangeSetFileReader(this.importData);
                this.directoriesSignificant = reader.getDirectoriesSignificant();
                if (!this.directoriesSignificant) {
                    this.fileTree = new FileTreeWithEmptyFolderTracking(this.fileTree);
                }
                while ((importChangeSet = this.readChangeSet(reader, (IProgressMonitor)progress)) != null) {
                    this.notifyPrecommit(importChangeSet, subProgress.newChild(1));
                    subProgress.subTask(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_2, (Object)this.getCommentForDisplay(importChangeSet)));
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (!preflight) {
                        try {
                            List<IImportChange> changes = importChangeSet.getChanges();
                            this.updateEncodings(changes, subProgress.newChild(1));
                            this.commitChanges(importChangeSet, changes, (IProgressMonitor)subProgress.newChild(changes.size()));
                            this.stats.endCommit(importChangeSet);
                        }
                        catch (ImportException e) {
                            this.debug(importChangeSet);
                            throw e;
                        }
                        catch (TeamRepositoryException tre) {
                            this.debug(importChangeSet);
                            String comment = this.getCommentForDisplay(importChangeSet);
                            String errorMessage = NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_4, (Object)comment);
                            throw new TeamRepositoryException((Object)this.repository, errorMessage, (Throwable)tre);
                        }
                        catch (ServiceMethodInvocationError smie) {
                            this.debug(importChangeSet);
                            String comment = this.getCommentForDisplay(importChangeSet);
                            String errorMessage = NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_6, (Object)comment);
                            throw new RuntimeException(errorMessage, smie);
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            this.debug(importChangeSet);
                            String comment = this.getCommentForDisplay(importChangeSet);
                            String errorMessage = NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_40, (Object)comment);
                            throw new TeamRepositoryException((Object)this.repository, errorMessage, (Throwable)e);
                        }
                    }
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                this.notifyImportComplete(subProgress.newChild(1));
            }
            catch (IOException e) {
                throw new TeamRepositoryException(SCMImportMessages.ChangeSetArchiveImporter_8, (Throwable)e);
            }
        }
        finally {
            if (this.stats != null) {
                this.stats.close();
            }
            if (reader != null) {
                reader.close();
            }
            monitor.done();
        }
    }

    private void updateEncodings(List<IImportChange> changes, SubMonitor monitor) {
        monitor.setWorkRemaining(changes.size());
        for (IImportChange change : changes) {
            if (!this.isEncodingPropertiesFileChange(change)) continue;
            this.updateEncodings(change, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private void updateEncodings(IImportChange change, IProgressMonitor monitor) {
        String name;
        String path = change.getAfterPath();
        if (path == null) {
            path = change.getBeforePath();
        }
        if ((name = PathUtils.getBaseName((String)path)).equals(ENCODING_PREFERENCES_FILE)) {
            String projectPath = PathUtils.getParentFolderPath((String)PathUtils.getParentFolderPath((String)path));
            if (change.getKind() == 32) {
                this.clearEncodings(projectPath);
            } else if (change.getKind() == 16 || (change.getFlags() & 0x100) > 0) {
                try {
                    Properties properties = new Properties();
                    InputStream contents = change.getContents(this.importData, monitor);
                    if (contents != null) {
                        try {
                            properties.load(contents);
                        }
                        catch (Throwable throwable) {
                            try {
                                contents.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.updateEncodings(projectPath, properties);
                }
                catch (IOException e) {
                    StatusUtil.log((Object)this, (String)NLS.bind((String)"An error occurred reading properties file {0}", (Object)path), (Throwable)e);
                }
            }
        } else if (name.equals(SETTINGS_FOLDER_NAME)) {
            if (change.getKind() == 32) {
                String projectPath = PathUtils.getParentFolderPath((String)path);
                this.clearEncodings(projectPath);
            }
        } else {
            Map<String, String> properties;
            String projectPath = PathUtils.normalizePath((String)path, (boolean)false, (boolean)false);
            if (change.getKind() == 32) {
                this.clearEncodings(projectPath);
            } else if (change.getKind() == 64 && (change.getFlags() & 0x200) > 0 && (properties = this.projectEncodings.get(projectPath)) != null) {
                this.projectEncodings.remove(projectPath);
                this.projectEncodings.put(PathUtils.normalizePath((String)change.getAfterPath(), (boolean)false, (boolean)false), properties);
            }
        }
    }

    private void updateEncodings(String projectPath, Properties properties) {
        this.clearEncodings(projectPath);
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            if (!key.startsWith(ENCODING_PROPERTY_PREFIX)) continue;
            String path = key.substring(ENCODING_PROPERTY_PREFIX.length());
            if (path.equals(PROJECT_ENCODING_PROPERTY)) {
                this.setEncoding(projectPath, "", (String)entry.getValue());
                continue;
            }
            this.setEncoding(projectPath, path, (String)entry.getValue());
        }
    }

    private String getEncoding(String path) {
        String normalizePath = PathUtils.normalizePath((String)path, (boolean)false, (boolean)false);
        for (String projectPath : this.projectEncodings.keySet()) {
            if (!PathUtils.isParentFolder((String)projectPath, (String)normalizePath)) continue;
            String relativePath = PathUtils.getRelativePath((String)projectPath, (String)normalizePath);
            Map<String, String> encodings = this.projectEncodings.get(projectPath);
            String match = null;
            for (String projectRelativePath : encodings.keySet()) {
                if (projectRelativePath.equals(relativePath)) {
                    match = projectRelativePath;
                    break;
                }
                if (!PathUtils.isParentFolder((String)projectRelativePath, (String)relativePath) || match != null && projectRelativePath.length() <= match.length()) continue;
                match = projectRelativePath;
            }
            if (match == null) continue;
            String encoding = encodings.get(match);
            if (encoding != null && Charset.isSupported(encoding)) {
                return encoding;
            }
            return null;
        }
        return null;
    }

    private void setEncoding(String projectPath, String subpath, String encoding) {
        String normalizePath = PathUtils.normalizePath((String)projectPath, (boolean)false, (boolean)false);
        Map<String, String> encodings = this.projectEncodings.get(normalizePath);
        if (encodings == null) {
            encodings = new HashMap<String, String>();
            this.projectEncodings.put(normalizePath, encodings);
        }
        encodings.put(PathUtils.normalizePath((String)subpath, (boolean)false, (boolean)false), encoding);
    }

    private void clearEncodings(String projectPath) {
        String normalizePath = PathUtils.normalizePath((String)projectPath, (boolean)false, (boolean)false);
        this.projectEncodings.remove(normalizePath);
    }

    private boolean isEncodingPropertiesFileChange(IImportChange change) {
        String name;
        String path = change.getAfterPath();
        if (path == null) {
            path = change.getBeforePath();
        }
        if ((name = PathUtils.getBaseName((String)path)).equals(ENCODING_PREFERENCES_FILE)) {
            String settingsFolder;
            String parentPath = PathUtils.getParentFolderPath((String)path);
            return !parentPath.equals("/") && (settingsFolder = PathUtils.getBaseName((String)parentPath)).equals(SETTINGS_FOLDER_NAME);
        }
        if (name.equals(SETTINGS_FOLDER_NAME)) {
            return true;
        }
        String normalizePath = PathUtils.normalizePath((String)path, (boolean)false, (boolean)false);
        return this.projectEncodings.get(normalizePath) != null;
    }

    private String getCommentForDisplay(IImportChangeSet importChangeSet) {
        String comment = importChangeSet.asCommentMessage(true, true);
        if (comment.length() > 128) {
            comment = String.valueOf(comment.substring(0, 125)) + "...";
        }
        return comment;
    }

    private IImportChangeSet readChangeSet(IChangeSetFileReader reader, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            long start = System.currentTimeMillis();
            IImportChangeSet changeSet = reader.next(monitor);
            if (changeSet != null) {
                this.stats.startCommit(changeSet, System.currentTimeMillis() - start, this.preflight);
            }
            return changeSet;
        }
        catch (IOException e) {
            throw new TeamRepositoryException(SCMImportMessages.ChangeSetArchiveImporter_9, (Throwable)e);
        }
    }

    private void debug(IImportChangeSet changeSet) {
        if (!DebugUtils.DEBUG_IMPORT) {
            return;
        }
        IChangeSetFileWriter writer = this.factory.createChangeSetFileWriter((IChangeSetFileReader)null);
        try {
            System.out.println("Dumping Change set for import failure");
            writer.startWrite(System.out);
            writer.writeElement(changeSet);
            writer.closeWrite();
            System.out.println("Change set dump finished");
        }
        catch (IOException iOException) {}
    }

    private void checkAndInitArgs(IWorkspaceConnection workspace, IComponent component, IMigrationFactory factory, boolean preflight) throws TeamRepositoryException {
        Assert.isNotNull((Object)factory);
        this.preflight = preflight;
        if (!preflight) {
            Assert.isNotNull((Object)workspace);
            Assert.isNotNull((Object)component);
            this.component = component;
            this.workspace = workspace;
            this.repository = workspace.teamRepository();
        }
    }

    private void commitChanges(IImportChangeSet importChangeSet, List<IImportChange> changes, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            progress.subTask(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_11, (Object)this.getCommentForDisplay(importChangeSet)));
            this.fileTree.prepareForChanges(changes, this.importData.isImportOverExisting(), this.directoriesSignificant, (IProgressMonitor)progress.newChild(10));
            CommitRecord record = this.collectChanges(importChangeSet, changes, (IProgressMonitor)progress.newChild(45));
            this.commitChangesFromMap(importChangeSet, changes, record, (IProgressMonitor)progress.newChild(45));
        }
        finally {
            monitor.done();
        }
    }

    private CommitRecord collectChanges(IImportChangeSet importChangeSet, List<IImportChange> changes, IProgressMonitor monitor) throws TeamRepositoryException {
        long startTime = System.currentTimeMillis();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.size());
            CommitRecord record = new CommitRecord();
            Date date = importChangeSet.getDate();
            for (IImportChange change : changes) {
                this.collectChange(change, date, record, (IProgressMonitor)progress.newChild(1));
            }
            if (this.importData.isImportOverExisting()) {
                this.deleteUnreconciledItems(record, "");
                Set<String> projects = record.getReconciledProjects();
                if (projects != null) {
                    this.reconciledProjects.addAll(projects);
                }
            }
            this.deleteEmptyFoldersIfRequired(record);
            CommitRecord commitRecord = record;
            return commitRecord;
        }
        finally {
            this.stats.changesCollected(System.currentTimeMillis() - startTime);
            monitor.done();
        }
    }

    private void deleteUnreconciledItems(CommitRecord record, String revision) throws TeamRepositoryException {
        Set<String> paths = record.getPathsToReconcile();
        if (paths != null) {
            for (String path : paths) {
                IVersionable item = this.fileTree.getItem(path);
                if (item == null) continue;
                this.deleteVersionable(path, record);
                record.recordLeafChange(new ImportChange(32, revision, path, null, null, null), item);
            }
        }
    }

    private void collectChange(IImportChange change, Date date, CommitRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        IVersionable item;
        if (change.getKind() == 32) {
            String path = change.getBeforePath();
            monitor.subTask(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_33, (Object)path));
            item = this.deleteVersionable(path, record);
        } else if (change.getKind() == 16) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (this.importData.isImportOverExisting() && !this.isProjectForPathReconciled(change.getAfterPath())) {
                if (this.reconcileAdditionWithExisting(change, date, record, (IProgressMonitor)progress.newChild(50))) {
                    record.addReconciledProject(PathUtils.getFirstSegment((String)change.getAfterPath()));
                    return;
                }
            } else {
                progress.setWorkRemaining(50);
            }
            item = this.performCreate(change, date, record, (IProgressMonitor)progress.newChild(50));
        } else if (change.getKind() == 64) {
            IVersionableHandle targetItemHandle;
            String afterPath = change.getAfterPath();
            if (this.importData.isImportOverExisting() && (change.getFlags() & 0x200) != 0 && !this.isProjectForPathReconciled(afterPath) && (targetItemHandle = this.fileTree.getItemHandle(afterPath)) != null) {
                IVersionable targetItem = this.fileTree.getItem(afterPath);
                this.deleteVersionable(afterPath, record);
                record.recordLeafChange(new ImportChange(32, change.getRevision(), afterPath, null, null, null), targetItem);
                record.addReconciledProject(PathUtils.getFirstSegment((String)change.getAfterPath()));
            }
            item = this.performModification(change, date, record, monitor);
        } else {
            throw new IllegalArgumentException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_16, (Object)change.getItemType()));
        }
        record.recordLeafChange(change, item);
    }

    private boolean isProjectForPathReconciled(String path) {
        if (this.reconciledProjects == null || this.reconciledProjects.isEmpty()) {
            return false;
        }
        return this.reconciledProjects.contains(PathUtils.getFirstSegment((String)path));
    }

    private boolean reconcileAdditionWithExisting(IImportChange change, Date date, CommitRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        this.ensureParentsReconciled(change.getAfterPath(), record);
        String afterPath = change.getAfterPath();
        IVersionableHandle targetItemHandle = this.fileTree.getItemHandle(afterPath);
        if (targetItemHandle != null) {
            record.pathReconciled(afterPath);
            IVersionable targetItem = this.fileTree.getItem(afterPath);
            if (change.getItemType() != this.getItemType(targetItem)) {
                this.deleteVersionable(afterPath, record);
                record.recordLeafChange(new ImportChange(32, change.getRevision(), afterPath, null, null, null), targetItem);
                return false;
            }
            if (change.getItemType() == 1) {
                IFileItem fileItem = (IFileItem)targetItem;
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (this.contentDiffers(fileItem, change, progress.newChild(50))) {
                    IImportChange modChange = change.asModificationForReconciliation();
                    this.performModification(modChange, date, record, (IProgressMonitor)progress.newChild(50));
                    record.recordLeafChange(modChange, targetItem);
                }
            } else if (change.getItemType() == 2) {
                Collection<String> names = this.fileTree.getChildNames(afterPath);
                record.addPathsRequiringReconciliation(afterPath, names);
            }
            return true;
        }
        return false;
    }

    private void ensureParentsReconciled(String childPath, CommitRecord record) {
        if (this.directoriesSignificant) {
            return;
        }
        String parentPath = PathUtils.getParentFolderPath((String)childPath);
        if (PathUtils.isEmptyPath((String)parentPath)) {
            return;
        }
        if (!record.isFolderReconciled(parentPath)) {
            this.ensureParentsReconciled(parentPath, record);
            IVersionableHandle targetItemHandle = this.fileTree.getItemHandle(parentPath);
            if (targetItemHandle != null) {
                Collection<String> names = this.fileTree.getChildNames(parentPath);
                record.addPathsRequiringReconciliation(parentPath, names);
            }
            record.folderReconciled(parentPath);
            record.addReconciledProject(PathUtils.getFirstSegment((String)parentPath));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contentDiffers(IFileItem fileItem, IImportChange change, SubMonitor progress) throws TeamRepositoryException {
        boolean bl;
        IFileContent content = fileItem.getContent();
        IFileProperties properties = change.getFileProperties();
        if (properties.isExecutable() != fileItem.isExecutable() || !properties.getContentType().equals(fileItem.getContentType()) || !properties.getLineDelimiter().equals((Object)content.getLineDelimiter()) || properties.isText()) {
            if (!this.isCharacterEncodingEqual(change, content, progress)) return true;
        }
        InputStream newContents = null;
        InputStream oldContents = null;
        try {
            progress.setWorkRemaining(10);
            newContents = change.getContents(this.importData, (IProgressMonitor)progress.newChild(1));
            Object contentState = !fileItem.isWorkingCopy() ? fileItem : (IFileItemHandle)content.getOriginalContainingState();
            oldContents = this.retrieveContent(progress.newChild(9), (IFileItemHandle)contentState, content);
            bl = !this.streamsEqual(oldContents, newContents);
        }
        catch (IOException e) {
            try {
                throw new TeamRepositoryException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (newContents != null) {
                            newContents.close();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (oldContents == null) throw throwable;
                            oldContents.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            throw throwable;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    try {
                        if (oldContents == null) throw throwable2;
                        oldContents.close();
                        throw throwable2;
                    }
                    catch (IOException iOException) {}
                    throw throwable2;
                }
                try {
                    if (oldContents == null) throw throwable;
                    oldContents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            try {
                if (newContents != null) {
                    newContents.close();
                }
            }
            catch (IOException iOException) {
                try {
                    if (oldContents == null) return bl;
                    oldContents.close();
                    return bl;
                }
                catch (IOException iOException3) {
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (oldContents == null) throw throwable;
                oldContents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (oldContents == null) return bl;
            oldContents.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
    }

    private boolean isCharacterEncodingEqual(IImportChange change, IFileContent content, SubMonitor progress) {
        String encoding = content.getCharacterEncoding();
        String newEncoding = this.getEncoding(change, null, (IProgressMonitor)progress);
        if (encoding == null) {
            return newEncoding == null;
        }
        if (newEncoding == null) {
            return false;
        }
        return encoding.equals(newEncoding);
    }

    private InputStream retrieveContent(SubMonitor progress, IFileItemHandle item, IFileContent content) throws TeamRepositoryException {
        if (content.getLineDelimiter().equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
            return FileSystemCore.getContentManager((ITeamRepository)this.repository).retrieveContentStream(item, content, content.getCharacterEncoding(), FileLineDelimiter.LINE_DELIMITER_LF, (IProgressMonitor)progress);
        }
        return FileSystemCore.getContentManager((ITeamRepository)this.repository).retrieveContentStream(item, content, (IProgressMonitor)progress);
    }

    private boolean streamsEqual(InputStream expected, InputStream actual) throws IOException {
        BufferedInputStream b1 = new BufferedInputStream(expected);
        BufferedInputStream b2 = new BufferedInputStream(actual);
        int r1 = b1.read();
        int r2 = b2.read();
        int count = 0;
        while (r1 == r2 && r1 != -1 && r2 != -1) {
            r1 = b1.read();
            r2 = b2.read();
            ++count;
        }
        return r1 == -1 || r2 == -1;
    }

    private int getItemType(IVersionable targetItem) {
        if (targetItem instanceof IFolder) {
            return 2;
        }
        if (targetItem instanceof IFileItem) {
            return 1;
        }
        return 0;
    }

    private IVersionable performCreate(IImportChange change, Date date, CommitRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        if (change.getItemType() == 1) {
            return this.createFile(change, date, record, monitor);
        }
        if (change.getItemType() == 2) {
            return this.createFolder(change.getAfterPath(), record);
        }
        throw new IllegalArgumentException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_3, (Object)change.getBeforePath()));
    }

    private void commitChangesFromMap(IImportChangeSet importChangeSet, List<IImportChange> changes, CommitRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        progress.subTask(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_38, (Object)this.getCommentForDisplay(importChangeSet)));
        long startTime = System.currentTimeMillis();
        IChangeSetHandle changeSet = null;
        IUpdateReport report = null;
        if (record.hasItemChanges()) {
            boolean committed = false;
            try {
                IContributorHandle contributor = this.getContributor(this.workspace.teamRepository(), importChangeSet.getAuthor(), progress.newChild(1));
                String comment = ImportChangeSet.truncateComment(importChangeSet.asCommentMessage(contributor == null, false));
                IWorkspaceConnectionInteropAdapter op = (IWorkspaceConnectionInteropAdapter)this.workspace.getAdapter(IWorkspaceConnectionInteropAdapter.class);
                if (op == null) {
                    changeSet = this.createActiveChangeSet(comment, this.workspace, this.component, (IProgressMonitor)progress.newChild(1));
                    report = this.commit(record, changeSet, (IProgressMonitor)progress.newChild(1));
                    this.closeChangeSet(this.workspace, changeSet, contributor, importChangeSet.getDate(), progress.newChild(1));
                    committed = true;
                } else {
                    if (contributor == null) {
                        contributor = this.workspace.teamRepository().loggedInContributor();
                    }
                    IImportChangeSetResult result = op.importChangeSet((IComponentHandle)this.component, comment, record.asConfigOps(), importChangeSet.getDate().getTime(), contributor, (IProgressMonitor)progress.newChild(3));
                    changeSet = result.getChangeSet();
                    report = result.getUpdateReport();
                    committed = true;
                }
            }
            finally {
                if (!committed && changeSet != null) {
                    this.workspace.discardChangeSets(false, Collections.singletonList(changeSet), (IProgressMonitor)progress.newChild(0));
                }
            }
        }
        this.stats.changesCommited(System.currentTimeMillis() - startTime);
        this.notifyPostCommit(importChangeSet, report, changeSet, changes, record, (IProgressMonitor)progress.newChild(1));
        monitor.done();
    }

    private IContributorHandle getContributor(ITeamRepository teamRepository, String author, SubMonitor monitor) throws TeamRepositoryException {
        if (this.importData == null) {
            return null;
        }
        return this.importData.getContributor(teamRepository, author, (IProgressMonitor)monitor);
    }

    private void closeChangeSet(IWorkspaceConnection connection, IChangeSetHandle changeSet, IContributorHandle contributor, Date creationDate, SubMonitor monitor) throws TeamRepositoryException {
        this.stats.startPhase("Close Change Set");
        if (contributor == null) {
            contributor = connection.teamRepository().loggedInContributor();
        }
        connection.closeChangeSets(Collections.singletonList(changeSet), (IProgressMonitor)monitor);
        this.stats.endPhase("Close Change Set");
    }

    private IUpdateReport commit(CommitRecord record, IChangeSetHandle changeset, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            IUpdateReport report;
            this.stats.startPhase("Commit Change Set");
            ArrayList<IWorkspaceConnection.IConfigurationOp> configOps = record.asConfigOps();
            IUpdateReport iUpdateReport = report = this.workspace.commit(changeset, configOps, monitor);
            return iUpdateReport;
        }
        finally {
            this.stats.endPhase("Commit Change Set");
        }
    }

    private void notifyPrecommit(final IImportChangeSet importChangeSet, SubMonitor monitor) {
        if (this.importParticipants != null && !this.importParticipants.isEmpty()) {
            Object[] participants = this.importParticipants.getListeners();
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.ChangeSetArchiveImporter_17, (int)participants.length);
            int i = 0;
            while (i < participants.length) {
                final IImportParticipant participant = (IImportParticipant)participants[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        participant.changeSetRead(ChangeSetArchiveImporter.this.workspace, (IComponentHandle)ChangeSetArchiveImporter.this.component, importChangeSet, (IProgressMonitor)progress.newChild(1));
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++i;
            }
        }
    }

    private void notifyImportComplete(SubMonitor monitor) {
        if (this.importParticipants != null && !this.importParticipants.isEmpty()) {
            Object[] participants = this.importParticipants.getListeners();
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.ChangeSetArchiveImporter_18, (int)participants.length);
            int i = 0;
            while (i < participants.length) {
                final IImportParticipant participant = (IImportParticipant)participants[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        participant.postImport(ChangeSetArchiveImporter.this.workspace, ChangeSetArchiveImporter.this.component, (IProgressMonitor)progress.newChild(1));
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++i;
            }
        }
    }

    private void notifyPostCommit(final IImportChangeSet importChangeSet, final IUpdateReport report, final IChangeSetHandle committedChangeSet, List<IImportChange> changesCollection, CommitRecord record, IProgressMonitor monitor) {
        if (this.importParticipants != null && !this.importParticipants.isEmpty()) {
            final List<IVersionable> fsItemsList = record.getAllChangedItems();
            final List<IImportChange> changesList = record.getChanges();
            final List<IVersionable> changeLeafsList = record.getLeafsItemChanges();
            Object[] participants = this.importParticipants.getListeners();
            final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.ChangeSetArchiveImporter_20, (int)participants.length);
            int i = 0;
            while (i < participants.length) {
                final IImportParticipant participant = (IImportParticipant)participants[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        IImportChange[] changes = new IImportChange[changesList.size()];
                        changesList.toArray(changes);
                        IVersionable[] fsItems = new IVersionable[fsItemsList.size()];
                        fsItemsList.toArray(fsItems);
                        IVersionableHandle[] changeLeafs = new IVersionableHandle[changeLeafsList.size()];
                        changeLeafsList.toArray(changeLeafs);
                        participant.postCommit(ChangeSetArchiveImporter.this.workspace, (IComponentHandle)ChangeSetArchiveImporter.this.component, importChangeSet, committedChangeSet, report, fsItems, changes, changeLeafs, (IProgressMonitor)progress.newChild(1));
                    }

                    public void handleException(Throwable exception) {
                        exception.printStackTrace();
                    }
                });
                ++i;
            }
        }
    }

    private IFolder createFolder(String path, CommitRecord record) throws TeamRepositoryException {
        this.ensureParentExists(path, record);
        IFolder folder = this.fileTree.createFolder(path);
        record.updateItemsMapsForSave((IVersionable)folder);
        return folder;
    }

    private IFileItem createFile(IImportChange change, Date timestamp, CommitRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String path = change.getAfterPath();
        progress.subTask(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_26, (Object)path));
        this.ensureParentExists(path, record);
        IFileItem fileItem = this.fileTree.createFile(path);
        this.setContents(fileItem, change, timestamp, -1, null, (IProgressMonitor)progress.newChild(100));
        record.updateItemsMapsForSave((IVersionable)fileItem);
        return fileItem;
    }

    private void ensureParentExists(String path, CommitRecord record) throws TeamRepositoryException {
        String parentPath = PathUtils.getParentFolderPath((String)path);
        IVersionableHandle versionableHandle = this.fileTree.getItemHandle(parentPath);
        if (versionableHandle == null) {
            if (this.directoriesSignificant) {
                throw new IllegalStateException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_5, (Object)parentPath));
            }
            this.ensureParentExists(parentPath, record);
            this.createFolder(parentPath, record);
        }
    }

    private void setContents(IFileItem fileItem, final IImportChange change, Date timestamp, int retry, String encodingOverride, IProgressMonitor monitor) throws TeamRepositoryException {
        if (retry == -1) {
            retry = 1;
        }
        AbstractVersionedContentManagerInputStreamProvider contents = null;
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            final String encoding = this.getEncoding(change, encodingOverride, (IProgressMonitor)progress.newChild(1));
            final IFileProperties properties = change.getFileProperties();
            final int tryNum = retry;
            contents = new AbstractVersionedContentManagerInputStreamProvider(){

                public void dispose() throws IOException, TeamRepositoryException {
                }

                public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
                    InputStream in = change.getContents(ChangeSetArchiveImporter.this.importData, (IProgressMonitor)progress.newChild(1));
                    if (tryNum == 0 && properties.getLineDelimiter() != FileLineDelimiter.LINE_DELIMITER_NONE) {
                        in = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)in, (String)encoding, (FileLineDelimiter)properties.getLineDelimiter()));
                    }
                    return in;
                }

                public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
                    return in;
                }
            };
            this.setContents(fileItem, contents, properties.getLineDelimiter(), properties.getContentType(), encoding, properties.isExecutable(), timestamp, (IProgressMonitor)progress.newChild(50));
        }
        catch (TeamRepositoryException e) {
            if (retry > 0 || encodingOverride == null) {
                String path = change.getAfterPath();
                String revision = change.getRevision();
                String encoding = "ISO-8859-1";
                String message = encodingOverride == null ? NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_39, (Object[])new Object[]{revision, path, encoding}) : NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_27, (Object)revision, (Object)path);
                StatusUtil.log((Object)this, (String)message, (Throwable)e);
                this.setContents(fileItem, change, timestamp, encodingOverride == null ? retry : retry - 1, encoding, (IProgressMonitor)progress.newChild(40));
            }
            String path = change.getAfterPath();
            String revision = change.getRevision();
            String message = NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_28, (Object)revision, (Object)path);
            StatusUtil.log((Object)this, (String)message, (Throwable)e);
            throw new ImportException(message, e);
        }
    }

    private String getEncoding(IImportChange change, String encodingOverride, IProgressMonitor monitor) {
        IFileProperties properties = change.getFileProperties();
        String encoding = properties.getEncoding();
        if (encodingOverride != null) {
            encoding = encodingOverride;
        } else if (encoding == null && properties.isText()) {
            encoding = this.getCharset(change, monitor);
        }
        return encoding;
    }

    /*
     * Unable to fully structure code
     */
    private String getCharset(IImportChange change, IProgressMonitor monitor) {
        block18: {
            block16: {
                block17: {
                    contents = null;
                    contentTypeManager = Platform.getContentTypeManager();
                    contents = change.getContents(this.importData, monitor);
                    desc = contentTypeManager.getDescriptionFor(contents, PathUtils.getBaseName((String)change.getAfterPath()), new QualifiedName[]{IContentDescription.CHARSET});
                    if (desc == null || (charset = desc.getCharset()) == null) break block16;
                    var8_7 = charset;
                    if (contents == null) break block17;
                    try {
                        contents.close();
                    }
                    catch (IOException v0) {}
                }
                return var8_7;
                catch (IOException v1) {
                    try {
                        ** if (contents == null) goto lbl-1000
                    }
                    catch (Throwable var7_8) {
                        if (contents != null) {
                            try {
                                contents.close();
                            }
                            catch (IOException v3) {}
                        }
                        throw var7_8;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            contents.close();
                        }
                        catch (IOException v2) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block18;
                    }
                }
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException v4) {}
            }
        }
        if ((eclipseEncoding = this.getEncoding(change.getAfterPath())) != null) {
            return eclipseEncoding;
        }
        return this.importData.getWorkspaceEncoding();
    }

    private void setContents(IFileItem fileItem, AbstractVersionedContentManagerInputStreamProvider contents, FileLineDelimiter lineDelimeter, String contentType, String encoding, boolean executable, Date timestamp, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileContent content = FileSystemCore.getContentManager((ITeamRepository)this.repository).storeContent(encoding, lineDelimeter, contents, fileItem.getContent() == null ? null : fileItem.getContent().getHash(), monitor);
        fileItem.setContentType(contentType);
        fileItem.setContent(content);
        fileItem.setFileTimestamp(timestamp);
        fileItem.setExecutable(executable);
    }

    private IVersionable performModification(IImportChange change, Date timestamp, CommitRecord record, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            IVersionable item;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
            String message = (change.getFlags() & 0x200) == 0 ? NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_30, (Object)change.getAfterPath()) : NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_31, (Object)change.getBeforePath());
            progress.subTask(message);
            String afterPath = change.getAfterPath();
            if ((change.getFlags() & 0x200) > 0) {
                String beforePath = change.getBeforePath();
                item = this.fileTree.move(beforePath, afterPath);
            } else {
                item = this.fileTree.getItem(afterPath);
            }
            if (item instanceof IFileItem && (change.getFlags() & 0x100) > 0) {
                IFileItem fileItem = (IFileItem)item;
                progress.subTask(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_32, (Object)change.getBeforePath()));
                this.setContents(fileItem, change, timestamp, -1, null, (IProgressMonitor)progress.newChild(19));
            } else if (item instanceof IFileItem && this.isExecuteBitChange((IFileItem)item, change.getFileProperties())) {
                ((IFileItem)item).setExecutable(change.getFileProperties().isExecutable());
                ((IFileItem)item).setFileTimestamp(timestamp);
            }
            record.updateItemsMapsForSave(item);
            IVersionable iVersionable = item;
            return iVersionable;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isExecuteBitChange(IFileItem item, IFileProperties fileProperties) {
        return item.isExecutable() ^ fileProperties.isExecutable();
    }

    private IVersionable deleteVersionable(String path, CommitRecord record) throws TeamRepositoryException {
        IVersionable item;
        boolean childrenKnown = this.fileTree.areChilrenKnown(path);
        if (childrenKnown) {
            this.deleteChildren(path, record);
        }
        if ((item = this.fileTree.remove(path)) == null) {
            throw new TeamRepositoryException(NLS.bind((String)SCMImportMessages.ChangeSetArchiveImporter_34, (Object)path));
        }
        record.updateItemsMapForDelete(item, !childrenKnown);
        return item;
    }

    private void deleteChildren(String path, CommitRecord record) throws TeamRepositoryException {
        String[] childNames;
        String[] stringArray = childNames = this.fileTree.getChildNames(path).toArray(new String[0]);
        int n = childNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childName = stringArray[n2];
            this.deleteVersionable(PathUtils.appendPath((String)path, (String)childName), record);
            ++n2;
        }
    }

    private void deleteEmptyFoldersIfRequired(CommitRecord record) throws TeamRepositoryException {
        if (!this.directoriesSignificant && this.fileTree instanceof FileTreeWithEmptyFolderTracking) {
            Set<String> emptyFolders;
            FileTreeWithEmptyFolderTracking vt = (FileTreeWithEmptyFolderTracking)this.fileTree;
            while (!(emptyFolders = vt.getEmptyFolders()).isEmpty()) {
                for (String path : emptyFolders) {
                    IVersionable item = this.fileTree.remove(path);
                    record.updateItemsMapForDelete(item, false);
                }
            }
        }
    }

    private IChangeSetHandle createActiveChangeSet(String comment, IWorkspaceConnection workspace, IComponent component, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.ChangeSetArchiveImporter_37, (int)2);
        IChangeSetHandle changeSet = null;
        try {
            this.stats.startPhase("Create Change Set");
            changeSet = workspace.createChangeSet((IComponentHandle)component, (IProgressMonitor)progress.newChild(1));
            this.addCommentsTaskToChangeSet(comment, changeSet, workspace, (IProgressMonitor)progress.newChild(1));
            IChangeSetHandle iChangeSetHandle = changeSet;
            return iChangeSetHandle;
        }
        catch (TeamRepositoryException e) {
            try {
                if (changeSet != null) {
                    workspace.discardChangeSets(false, Collections.singletonList(changeSet), (IProgressMonitor)progress.newChild(0));
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            throw e;
        }
        finally {
            this.stats.endPhase("Create Change Set");
            monitor.done();
        }
    }

    private void addCommentsTaskToChangeSet(String comment, IChangeSetHandle changeSet, IWorkspaceConnection workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        SCMPlatform.getWorkspaceManager((ITeamRepository)workspace.teamRepository()).setComment(changeSet, comment, (IProgressMonitor)progress.newChild(100));
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportParticipant(IImportParticipant participant) {
        ListenerList listenerList = this.importParticipants;
        synchronized (listenerList) {
            this.importParticipants.add((Object)participant);
        }
    }

    public IChangeArchiveStatistics getStats() {
        return this.stats;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommitRecord {
        private Map<UUID, ItemsMapEntry> itemsMap = new HashMap<UUID, ItemsMapEntry>();
        private List<IImportChange> changes = new ArrayList<IImportChange>();
        private List<IVersionable> changedItems = new ArrayList<IVersionable>();
        private Set<String> pathsToReconcile;
        private Set<String> reconciledProjects;
        private Set<String> reconciledFolders;

        private CommitRecord() {
        }

        public ArrayList<IWorkspaceConnection.IConfigurationOp> asConfigOps() {
            ArrayList<IWorkspaceConnection.IConfigurationOp> configOps = new ArrayList<IWorkspaceConnection.IConfigurationOp>(this.itemsMap.size());
            for (ItemsMapEntry entry : this.itemsMap.values()) {
                configOps.add(entry.configOp);
            }
            return configOps;
        }

        public void updateItemsMapsForSave(IVersionable newVersionable) {
            IWorkspaceConnection.ISaveOp op = ChangeSetArchiveImporter.this.workspace.configurationOpFactory().save(newVersionable);
            this.updateItemsMap(newVersionable, (IWorkspaceConnection.IConfigurationOp)op);
        }

        public void updateItemsMapForDelete(IVersionable itemToDelete, boolean deleteSubtreeForFolder) {
            IWorkspaceConnection.IDeleteOp op;
            if (itemToDelete instanceof IFolder && deleteSubtreeForFolder) {
                IFolder folder = (IFolder)itemToDelete;
                op = ChangeSetArchiveImporter.this.workspace.configurationOpFactory().deleteSubtree((IFolderHandle)folder);
            } else {
                op = ChangeSetArchiveImporter.this.workspace.configurationOpFactory().delete((IVersionableHandle)itemToDelete);
            }
            this.updateItemsMap(itemToDelete, (IWorkspaceConnection.IConfigurationOp)op);
        }

        private void updateItemsMap(IVersionable item, IWorkspaceConnection.IConfigurationOp op) {
            ItemsMapEntry entry = new ItemsMapEntry(op, item);
            this.itemsMap.put(item.getItemId(), entry);
        }

        public boolean hasItemChanges() {
            return !this.itemsMap.isEmpty();
        }

        public void recordLeafChange(IImportChange change, IVersionable item) {
            this.changes.add(change);
            this.changedItems.add(item);
        }

        public List<IVersionable> getAllChangedItems() {
            ArrayList<IVersionable> fsItemsList = new ArrayList<IVersionable>(this.itemsMap.size());
            for (ItemsMapEntry entry : this.itemsMap.values()) {
                fsItemsList.add(entry.versionable);
            }
            return fsItemsList;
        }

        public List<IImportChange> getChanges() {
            return this.changes;
        }

        public List<IVersionable> getLeafsItemChanges() {
            return this.changedItems;
        }

        public void addPathsRequiringReconciliation(String parentPath, Collection<String> names) {
            if (this.pathsToReconcile == null) {
                this.pathsToReconcile = new HashSet<String>();
            }
            if (!ChangeSetArchiveImporter.this.directoriesSignificant) {
                if (this.reconciledFolders == null) {
                    this.reconciledFolders = new HashSet<String>();
                }
                this.reconciledFolders.add(PathUtils.normalizePath((String)parentPath, (boolean)false, (boolean)false));
            }
            for (String name : names) {
                this.pathsToReconcile.add(PathUtils.normalizePath((String)PathUtils.appendPath((String)parentPath, (String)name), (boolean)false, (boolean)false));
            }
        }

        public void pathReconciled(String path) {
            if (this.pathsToReconcile != null) {
                this.pathsToReconcile.remove(PathUtils.normalizePath((String)path, (boolean)false, (boolean)false));
            }
        }

        public Set<String> getPathsToReconcile() {
            return this.pathsToReconcile;
        }

        public void addReconciledProject(String projectName) {
            if (this.reconciledProjects == null) {
                this.reconciledProjects = new HashSet<String>();
            }
            this.reconciledProjects.add(projectName);
        }

        public Set<String> getReconciledProjects() {
            return this.reconciledProjects;
        }

        public boolean isFolderReconciled(String folderPath) {
            if (this.reconciledFolders == null) {
                return false;
            }
            String normalizedPath = PathUtils.normalizePath((String)folderPath, (boolean)false, (boolean)false);
            return this.reconciledFolders.contains(normalizedPath);
        }

        public void folderReconciled(String parentPath) {
            this.pathReconciled(parentPath);
            if (!ChangeSetArchiveImporter.this.directoriesSignificant) {
                if (this.reconciledFolders == null) {
                    this.reconciledFolders = new HashSet<String>();
                }
                this.reconciledFolders.add(PathUtils.normalizePath((String)parentPath, (boolean)false, (boolean)false));
            }
        }
    }

    private static class ItemsMapEntry {
        private final IWorkspaceConnection.IConfigurationOp configOp;
        private final IVersionable versionable;

        private ItemsMapEntry(IWorkspaceConnection.IConfigurationOp configOp, IVersionable versionable) {
            this.configOp = configOp;
            this.versionable = versionable;
        }
    }
}

