/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.importz.internal.ISyncFileReader;
import com.ibm.team.scm.client.importz.internal.SCMImportMessages;
import com.ibm.team.scm.client.importz.internal.SyncFileNotFoundException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractSyncFileReader
implements ISyncFileReader {
    protected Set committedChangeSets;
    protected Map stateRevisionMap;
    protected IFileItemHandle syncFile;
    protected IWorkspaceConnection workspace;
    protected IComponent component;

    public void read(IWorkspaceConnection workspace, IComponent component, IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        this.workspace = workspace;
        this.component = component;
        BufferedReader reader = this.getReader(monitor);
        try {
            this.readHeader(reader);
            this.readCommittedChangeSets(reader);
            this.readStateMap(reader);
            this.readBody(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            monitor.done();
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        monitor.done();
    }

    private BufferedReader getReader(IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        BufferedReader bufferedReader;
        block7: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.AbstractSyncFileReader_0, (int)100);
            monitor.beginTask(SCMImportMessages.AbstractSyncFileReader_1, 100);
            IFileItem fi = this.getAndSetStateFile((IProgressMonitor)progress.newChild(10));
            IFileContent content = fi.getContent();
            InputStream in = FileSystemCore.getContentManager((ITeamRepository)this.workspace.teamRepository()).retrieveContentStream((IFileItemHandle)fi, content, (IProgressMonitor)progress.newChild(90));
            boolean success = false;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                success = true;
                bufferedReader = reader;
                if (success) break block7;
            }
            catch (Throwable throwable) {
                if (!success) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return bufferedReader;
    }

    protected IFileItem getAndSetStateFile(IProgressMonitor monitor) throws IOException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SCMImportMessages.AbstractSyncFileReader_2, (int)2);
        try {
            IFolderHandle root = this.component.getRootFolder();
            IVersionableHandle handle = this.workspace.configuration((IComponentHandle)this.component).resolvePath(root, ".CVS/.Sync_State".split("/"), (IProgressMonitor)progress.newChild(1));
            if (handle instanceof IFileItemHandle) {
                IFileItem fi = (IFileItem)this.workspace.configuration((IComponentHandle)this.component).fetchCompleteItem(handle, (IProgressMonitor)progress.newChild(1));
                this.syncFile = (IFileItemHandle)fi.getStateHandle();
                IFileItem iFileItem = fi;
                return iFileItem;
            }
        }
        finally {
            monitor.done();
        }
        throw new SyncFileNotFoundException(NLS.bind((String)SCMImportMessages.AbstractSyncFileReader_3, (Object)this.workspace.getName(), (Object)this.component.getName()));
    }

    protected void readCommittedChangeSets(BufferedReader reader) throws IOException {
        int numChangeSets = Integer.parseInt(reader.readLine());
        this.committedChangeSets = new HashSet(numChangeSets);
        int i = 0;
        while (i < numChangeSets) {
            this.committedChangeSets.add(reader.readLine());
            ++i;
        }
    }

    public Set getCommittedChangeSets() {
        return this.committedChangeSets;
    }

    protected void readStateMap(BufferedReader reader) throws IOException {
        this.stateRevisionMap = new CachedDiskBackedHashMap();
        int numStates = Integer.parseInt(reader.readLine());
        int i = 0;
        while (i < numStates) {
            String state = reader.readLine();
            String revision = reader.readLine();
            this.stateRevisionMap.put(state, revision);
            ++i;
        }
    }

    public Map getStateRevisionMap() {
        return this.stateRevisionMap;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    public IComponent getComponent() {
        return this.component;
    }

    protected abstract void readHeader(BufferedReader var1) throws IOException;

    protected abstract void readBody(BufferedReader var1) throws IOException;

    public IFileItemHandle getSyncFile() {
        return this.syncFile;
    }
}

