/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.importz.internal;

import com.ibm.team.scm.client.importz.IImportChangeSet;
import com.ibm.team.scm.client.importz.internal.IChangeArchiveStatistics;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractChangeArchiveStatistics
implements IChangeArchiveStatistics {
    private Set<String> contributors = new HashSet<String>();
    private int largestChangeSet = 0;
    protected Date firstDate = null;
    protected Date lastDate = null;

    private void addContributor(String contributor) {
        this.contributors.add(contributor);
    }

    public int getContributorsCount() {
        return this.contributors.size();
    }

    protected void recordChangeSetSize(int size) {
        if (size > this.largestChangeSet) {
            this.largestChangeSet = size;
        }
    }

    public int getLargestChangeSetSize() {
        return this.largestChangeSet;
    }

    protected void recordDate(Date date) {
        if (this.firstDate == null) {
            this.firstDate = date;
        }
        this.lastDate = date;
    }

    protected long timeSpan() {
        if (this.lastDate == null || this.firstDate == null) {
            return 0L;
        }
        return this.lastDate.getTime() - this.firstDate.getTime();
    }

    public void startCommit(IImportChangeSet importChangeSet, long time, boolean preflight) {
        this.addContributor(importChangeSet.getAuthor());
        this.recordDate(importChangeSet.getDate());
        this.recordChangeSetSize(importChangeSet.getChanges().size());
    }
}

