/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.json;

import com.ibm.team.repository.common.json.IJSONSerializable;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.json.internal.Parser;
import com.ibm.team.repository.common.json.internal.Serializer;
import com.ibm.team.repository.common.json.internal.SerializerVerbose;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class JSONArray
extends ArrayList
implements IJSONSerializable {
    private static final long serialVersionUID = 9076798781015779954L;

    public JSONArray() {
    }

    public JSONArray(int initialCapacity) {
        super(initialCapacity);
    }

    public void add(int index, Object element) {
        this.checkElement(element);
        super.add(index, element);
    }

    public boolean add(Object element) {
        this.checkElement(element);
        return super.add(element);
    }

    public boolean addAll(Collection collection) {
        this.checkElements(collection);
        return super.addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        this.checkElements(collection);
        return super.addAll(index, collection);
    }

    public Object set(int index, Object element) {
        this.checkElement(element);
        return super.set(index, element);
    }

    private void checkElement(Object element) {
        if (!JSONObject.isValidObject(element)) {
            throw new IllegalArgumentException("invalid type of element");
        }
    }

    private void checkElements(Collection collection) {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            if (JSONObject.isValidObject(iter.next())) continue;
            throw new IllegalArgumentException("invalid type of element");
        }
    }

    public void serialize(Writer writer) throws IOException {
        this.serialize(writer, false);
    }

    public void serialize(Writer writer, boolean verbose) throws IOException {
        writer = new BufferedWriter(writer);
        Serializer serializer = verbose ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeArray(this).flush();
    }

    public static JSONArray parse(Reader reader) throws IOException {
        Object obj = new Parser(reader = new BufferedReader(reader)).parse();
        if (!(obj instanceof JSONArray)) {
            String msg = MessageFormat.format("The type \"{0}\" was encountered, rather than the expected type \"JSONArray\"", obj.getClass());
            throw new IOException(msg);
        }
        return (JSONArray)obj;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringWriter writer = new StringWriter();
        try {
            this.serialize(writer, verbose);
        }
        catch (IOException e) {
            return MessageFormat.format("Error serializing JSON object: {0}", e.getMessage());
        }
        return writer.toString();
    }
}

