/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.reports.apt.ide.ui.internal.actions;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.reports.apt.ide.ui.internal.nls.Messages;
import com.ibm.team.reports.client.IReportManager;
import com.ibm.team.reports.common.IReportDescriptor;
import com.ibm.team.reports.common.IReportDescriptorHandle;
import com.ibm.team.reports.ide.ui.internal.nodes.ReportNode;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SetAPTChartAction
implements IObjectActionDelegate {
    private List<IReportDescriptor> reports = new LinkedList<IReportDescriptor>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.reports.isEmpty()) {
            return;
        }
        Job job = new Job(Messages.getString("SetAPTChartAction.0")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.getString("SetAPTChartAction.0"), 600 * SetAPTChartAction.this.reports.size());
                    for (IReportDescriptor report : SetAPTChartAction.this.reports) {
                        ITeamRepository repository = (ITeamRepository)report.getOrigin();
                        IProjectAreaHandle projectAreaHandle = report.getProjectArea();
                        if (projectAreaHandle == null) continue;
                        IReportManager reportManager = (IReportManager)repository.getClientLibrary(IReportManager.class);
                        reportManager.setDefaultReportDescriptor(projectAreaHandle, (IReportDescriptorHandle)report, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    Status status = new Status(4, "com.ibm.team.reports.apt.ide.ui", Messages.getString("SetAPTChartAction.2"), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.reports.clear();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof ReportNode) {
                    this.reports.add(((ReportNode)obj).getDescriptor());
                }
                ++n2;
            }
        }
    }
}

