/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.reports.apt.ide.ui.internal;

import com.ibm.team.apt.ide.core.IResolvedIterationPlanRecord;
import com.ibm.team.apt.ide.ui.editor.IIterationPlanEditor;
import com.ibm.team.apt.ide.ui.editor.IterationPlanEditorPage;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.reports.apt.ide.ui.internal.nls.Messages;
import com.ibm.team.reports.client.IReportManager;
import com.ibm.team.reports.common.IReportDescriptor;
import com.ibm.team.reports.common.IReportDescriptorHandle;
import com.ibm.team.reports.ide.ui.internal.dialogs.ReportSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.TeamContent;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.progress.UIJob;

public class BurnDownChartPage
extends IterationPlanEditorPage {
    private IResolvedIterationPlanRecord resolvedIterationPlan;
    private Label infoLabel;
    private Label textLabel;
    private Label imageLabel;
    private Image image;
    private Button selectButton;
    private ResourceManager resourceManager;
    private IReportDescriptor reportDescriptor;

    public BurnDownChartPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        if (this.resolvedIterationPlan == null) {
            return;
        }
        this.createControls(managedForm.getForm().getBody());
        this.feedContent();
    }

    public void setInput(IResolvedIterationPlanRecord input) {
        this.resolvedIterationPlan = input;
        if (this.getManagedForm() != null) {
            if (this.imageLabel == null) {
                this.createControls(this.getManagedForm().getForm().getBody());
            }
            this.feedContent();
        }
    }

    private void createControls(final Composite parent) {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        FontDescriptor defaultFont = JFaceResources.getFontRegistry().getDescriptor("org.eclipse.jface.defaultfont");
        Font font = (Font)this.resourceManager.get((DeviceResourceDescriptor)defaultFont.setHeight(16));
        Color color = this.resourceManager.createColor(new RGB(102, 102, 102));
        this.textLabel = new Label(parent, 0);
        this.textLabel.setLayoutData((Object)new GridData());
        this.textLabel.setFont(font);
        this.textLabel.setForeground(color);
        this.textLabel.setBackground(parent.getDisplay().getSystemColor(1));
        this.imageLabel = new Label(parent, 0);
        this.imageLabel.setForeground(color);
        this.imageLabel.setBackground(parent.getDisplay().getSystemColor(1));
        this.textLabel.setLayoutData((Object)new GridData());
        this.imageLabel.setBackground(parent.getDisplay().getSystemColor(1));
        Font errorFont = (Font)this.resourceManager.get((DeviceResourceDescriptor)defaultFont);
        this.infoLabel = new Label(parent, 0);
        this.infoLabel.setFont(errorFont);
        this.infoLabel.setForeground(color);
        this.infoLabel.setBackground(parent.getDisplay().getSystemColor(1));
        this.infoLabel.setLayoutData((Object)new GridData());
        this.infoLabel.setVisible(false);
        this.selectButton = new Button(parent, 8);
        this.selectButton.setText(Messages.getString("BurnDownChartPage.2"));
        this.selectButton.setLayoutData((Object)new GridData());
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Job job = new Job(Messages.getString("BurnDownChartPage.3")){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ITeamRepository repository = BurnDownChartPage.this.resolvedIterationPlan.getTeamRepository();
                            IReportManager reportManager = (IReportManager)repository.getClientLibrary(IReportManager.class);
                            List<String> parameters = Arrays.asList("ProjectAreaName", "TeamAreaName", "Interval");
                            final List descriptors = reportManager.fetchReportDescriptors(null, (IProjectAreaHandle)BurnDownChartPage.this.resolvedIterationPlan.getProjectArea(), null, parameters, 17, monitor);
                            UIJob uiJob = new UIJob(Messages.getString("BurnDownChartPage.1")){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    ReportSelectionDialog dialog = new ReportSelectionDialog(parent.getShell());
                                    dialog.setElements(descriptors.toArray());
                                    dialog.setTitle(Messages.getString("BurnDownChartPage.4"));
                                    dialog.setMessage(Messages.getString("BurnDownChartPage.5"));
                                    int result = dialog.open();
                                    if (result == 1) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    Object[] val = dialog.getResult();
                                    if (val.length != 1) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    BurnDownChartPage.this.reportDescriptor = (IReportDescriptor)val[0];
                                    BurnDownChartPage.this.feedContent();
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.setUser(false);
                            uiJob.schedule();
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (Exception e) {
                            Status status = new Status(4, "com.ibm.team.reports.apt.ide.ui", e.getMessage(), (Throwable)e);
                            return status;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                job.setUser(false);
                job.schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        parent.layout(true);
    }

    private void setInfoMessage(String message) {
        if (message == null) {
            GridData data = (GridData)this.infoLabel.getLayoutData();
            data.heightHint = 1;
            this.infoLabel.setVisible(false);
            data = (GridData)this.imageLabel.getLayoutData();
            data.heightHint = -1;
            this.imageLabel.setVisible(true);
            data = (GridData)this.textLabel.getLayoutData();
            data.heightHint = -1;
            this.textLabel.setVisible(true);
            this.infoLabel.getParent().layout(true);
            this.selectButton.setVisible(true);
        } else {
            GridData data = (GridData)this.infoLabel.getLayoutData();
            data.heightHint = -1;
            this.infoLabel.setVisible(true);
            this.infoLabel.setText(message);
            data = (GridData)this.imageLabel.getLayoutData();
            data.heightHint = 1;
            this.imageLabel.setVisible(false);
            data = (GridData)this.textLabel.getLayoutData();
            data.heightHint = 1;
            this.textLabel.setVisible(false);
            this.infoLabel.getParent().layout(true);
            this.selectButton.setVisible(false);
        }
    }

    private void feedContent() {
        final ITeamRepository repository = this.resolvedIterationPlan.getTeamRepository();
        this.getIterationPlanEditor().setBusy((IFormPage)this, true);
        this.setInfoMessage(Messages.getString("BurnDownChartPage.6"));
        Job job = new Job(Messages.getString("BurnDownChartPage.1")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IReportDescriptor report;
                    monitor.beginTask("", 700);
                    List processAreas = BurnDownChartPage.this.resolvedIterationPlan.getMemberAreas();
                    IProjectArea projectAreaHandle = BurnDownChartPage.this.resolvedIterationPlan.getProjectArea();
                    IProjectArea projectArea = (IProjectArea)repository.itemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    ITeamAreaHierarchy teamAreaHierarchy = projectArea.getTeamAreaHierarchy();
                    ArrayList<String> teamAreaPaths = new ArrayList<String>();
                    Iterator it = processAreas.iterator();
                    while (it.hasNext()) {
                        StringBuilder teamAreaPathBuilder = new StringBuilder();
                        IProcessArea currentProcessArea = (IProcessArea)it.next();
                        while (true) {
                            ITeamAreaHandle parent;
                            String name = currentProcessArea.getName();
                            int i = name.length() - 1;
                            while (i >= 0) {
                                teamAreaPathBuilder.append(name.charAt(i));
                                --i;
                            }
                            teamAreaPathBuilder.append('/');
                            if (currentProcessArea.getProjectArea().getItemId().equals((Object)currentProcessArea.getItemId()) || (parent = teamAreaHierarchy.getParent((ITeamAreaHandle)((ITeamArea)currentProcessArea))) == null) break;
                            currentProcessArea = (ITeamArea)repository.itemManager().fetchCompleteItem((IItemHandle)parent, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        }
                        teamAreaPaths.add(teamAreaPathBuilder.reverse().toString());
                    }
                    String charsetName = Charset.defaultCharset().name();
                    String teamAreaParam = "";
                    Iterator pathIt = teamAreaPaths.iterator();
                    while (pathIt.hasNext()) {
                        teamAreaParam = String.valueOf(teamAreaParam) + URLEncoder.encode("'" + (String)pathIt.next() + "'", charsetName);
                        if (!pathIt.hasNext()) continue;
                        teamAreaParam = String.valueOf(teamAreaParam) + ",";
                    }
                    String intervalParam = "";
                    Iterator iterationIt = BurnDownChartPage.this.resolvedIterationPlan.getIterations().iterator();
                    while (iterationIt.hasNext()) {
                        intervalParam = String.valueOf(intervalParam) + URLEncoder.encode("'" + ((IIteration)iterationIt.next()).getName() + "'", charsetName);
                        if (!iterationIt.hasNext()) continue;
                        intervalParam = String.valueOf(intervalParam) + ",";
                    }
                    IReportManager reportManager = (IReportManager)repository.getClientLibrary(IReportManager.class);
                    IReportDescriptor iReportDescriptor = report = BurnDownChartPage.this.reportDescriptor == null ? BurnDownChartPage.this.getReportDescriptor(repository, reportManager, projectArea, monitor) : BurnDownChartPage.this.reportDescriptor;
                    if (report == null) {
                        UIJob uiJob = new UIJob(Messages.getString("BurnDownChartPage.1")){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                BurnDownChartPage.this.setInfoMessage(Messages.getString("BurnDownChartPage.18"));
                                return Status.OK_STATUS;
                            }
                        };
                        uiJob.setUser(false);
                        uiJob.schedule();
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    final String text = report.getName();
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("ProjectAreaName", "{Current Project Area}");
                    parameters.put("TeamAreaName", teamAreaParam);
                    parameters.put("Interval", intervalParam);
                    ImageData[] imageDatas = new ImageData[]{};
                    final boolean[] canceled = new boolean[1];
                    try {
                        TeamContent content = reportManager.getReportImage((IReportDescriptorHandle)report, "chart", parameters, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        imageDatas = new ImageLoader().load(content.getInputStream());
                        if (imageDatas.length != 1) {
                            throw new Exception(Messages.getString("BurnDownChartPage.12"));
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        canceled[0] = true;
                    }
                    catch (Exception exception) {}
                    final ImageData imageData = imageDatas.length == 0 ? null : imageDatas[0];
                    UIJob uiJob = new UIJob(Messages.getString("BurnDownChartPage.1")){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (BurnDownChartPage.this.textLabel.isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            BurnDownChartPage.this.setInfoMessage(null);
                            BurnDownChartPage.this.textLabel.setText(text);
                            if (BurnDownChartPage.this.imageLabel.isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            if (canceled[0]) {
                                BurnDownChartPage.this.setInfoMessage(Messages.getString("BurnDownChartPage.17"));
                                BurnDownChartPage.this.getIterationPlanEditor().setBusy((IFormPage)BurnDownChartPage.this, false);
                                return Status.OK_STATUS;
                            }
                            if (imageData == null) {
                                BurnDownChartPage.this.setInfoMessage(Messages.getString("BurnDownChartPage.14"));
                                BurnDownChartPage.this.getIterationPlanEditor().setBusy((IFormPage)BurnDownChartPage.this, false);
                                return Status.OK_STATUS;
                            }
                            BurnDownChartPage.this.image = new Image((Device)BurnDownChartPage.this.imageLabel.getDisplay(), imageData);
                            BurnDownChartPage.this.imageLabel.setImage(BurnDownChartPage.this.image);
                            BurnDownChartPage.this.imageLabel.getParent().layout(true);
                            BurnDownChartPage.this.getIterationPlanEditor().setBusy((IFormPage)BurnDownChartPage.this, false);
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.setUser(false);
                    uiJob.schedule();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    UIJob uiJob = new UIJob(Messages.getString("BurnDownChartPage.15")){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            BurnDownChartPage.this.imageLabel.setText(BurnDownChartPage.this.getErrorText());
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.setUser(false);
                    uiJob.schedule();
                    Status status = new Status(4, "com.ibm.team.reports.apt.ide.ui", e.getMessage(), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(false);
        job.schedule();
    }

    public void dispose() {
        super.dispose();
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    private String getErrorText() {
        return Messages.getString("BurnDownChartPage.16");
    }

    private IIterationPlanEditor getIterationPlanEditor() {
        return (IIterationPlanEditor)this.getEditor();
    }

    private IReportDescriptor getReportDescriptor(ITeamRepository repository, IReportManager reportManager, IProjectArea projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IReportDescriptor report = null;
        IReportDescriptorHandle reportHandle = reportManager.getDefaultReportDescriptor((IProjectAreaHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        if (reportHandle != null) {
            report = (IReportDescriptor)repository.itemManager().fetchCompleteItem((IItemHandle)reportHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        } else if (reportManager.doesReportDescriptorExist((IProjectAreaHandle)projectArea, "apt.WorkItems", (IProgressMonitor)new SubProgressMonitor(monitor, 100))) {
            report = reportManager.getReportDescriptor("apt.WorkItems", (IProjectAreaHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        } else if (reportManager.doesReportDescriptorExist((IProjectAreaHandle)projectArea, "workitems.OpenWorkItemsByType", (IProgressMonitor)new SubProgressMonitor(monitor, 100))) {
            report = reportManager.getReportDescriptor("workitems.OpenWorkItemsByType", (IProjectAreaHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        return report;
    }
}

