/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.icu.util.Calendar;
import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.Scale;
import com.ibm.team.jface.timeline.TimelineUtils;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;

public abstract class TimelineContentProvider
implements ITimelineContentProvider {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long WEEK = 604800000L;
    private static final long MONTH = 2678400000L;
    private static final long YEAR = 31536000000L;
    private static final int DETAIL_YEAR = 0;
    private static final int DETAIL_MONTH = 1;
    private static final int DETAIL_WEEK = 2;
    private static final int DETAIL_DAY = 3;
    private Calendar fCal = Calendar.getInstance();
    private Scale fYearPrimaryScaleCache;
    private Scale fMonthPrimaryScaleCache;
    private Scale fWeekPrimaryScaleCache;
    private Scale fDayPrimaryScaleCache;
    private Scale fMonthSecondaryScaleCache;
    private Scale fWeekSecondaryScaleCache;
    private Scale fYearSecondaryScaleCache;
    private Scale fDaySecondaryScaleCache;

    protected TimelineContentProvider() {
        Calendar today = Calendar.getInstance();
        Calendar thisYear = Calendar.getInstance();
        thisYear.set(1, today.get(1));
        thisYear.setTimeInMillis(TimelineUtils.trimToYear(thisYear.getTimeInMillis()));
        Calendar nextYear = Calendar.getInstance();
        nextYear.setTime(thisYear.getTime());
        nextYear.set(1, today.get(1) + 1);
        Range range = new Range(thisYear.getTimeInMillis(), nextYear.getTimeInMillis());
        this.fYearPrimaryScaleCache = this.createScale(range, 0);
        this.fMonthPrimaryScaleCache = this.createScale(range, 1);
        this.fWeekPrimaryScaleCache = this.createScale(range, 2);
        this.fDayPrimaryScaleCache = this.createScale(range, 3);
        this.fMonthSecondaryScaleCache = this.createScale(range, 1);
        this.fWeekSecondaryScaleCache = this.createScale(range, 2);
        this.fYearSecondaryScaleCache = this.createScale(range, 0);
        this.fDaySecondaryScaleCache = this.createScale(range, 3);
    }

    public Range getDefaultRange() {
        Calendar from = Calendar.getInstance();
        from.add(3, -2);
        from.setTimeInMillis(TimelineUtils.trimToWeek(from.getTimeInMillis()));
        Calendar to = Calendar.getInstance();
        to.add(3, 1);
        to.setTimeInMillis(TimelineUtils.trimToWeek(to.getTimeInMillis()));
        return new Range(from.getTimeInMillis(), to.getTimeInMillis());
    }

    public Scale getScale(Range range, boolean primary) {
        if (primary) {
            return this.getPrimaryScale(range);
        }
        return this.getSecondaryScale(range);
    }

    private Scale getPrimaryScale(Range range) {
        if (range.exceeds(63072000000L)) {
            Range cachedRange = this.fYearPrimaryScaleCache.getRange();
            if (cachedRange.contains(range)) {
                return this.fYearPrimaryScaleCache;
            }
            return this.createScale(range, 0);
        }
        if (range.exceeds(5356800000L)) {
            Range cachedRange = this.fMonthPrimaryScaleCache.getRange();
            if (cachedRange.contains(range)) {
                return this.fMonthPrimaryScaleCache;
            }
            return this.createScale(range, 1);
        }
        if (range.exceeds(2419200000L)) {
            Range cachedRange = this.fWeekPrimaryScaleCache.getRange();
            if (cachedRange.contains(range)) {
                return this.fWeekPrimaryScaleCache;
            }
            return this.createScale(range, 2);
        }
        Range cachedRange = this.fDayPrimaryScaleCache.getRange();
        if (cachedRange.contains(range)) {
            return this.fDayPrimaryScaleCache;
        }
        return this.createScale(range, 3);
    }

    private Scale getSecondaryScale(Range range) {
        if (range.exceeds(63072000000L)) {
            return null;
        }
        if (range.exceeds(5356800000L)) {
            Range cachedRange = this.fYearSecondaryScaleCache.getRange();
            if (cachedRange.contains(range)) {
                return this.fYearSecondaryScaleCache;
            }
            return this.createScale(range, 0);
        }
        if (range.exceeds(2678400000L)) {
            Range cachedRange = this.fMonthSecondaryScaleCache.getRange();
            if (cachedRange.contains(range)) {
                return this.fMonthSecondaryScaleCache;
            }
            return this.createScale(range, 1);
        }
        if (range.exceeds(604800000L)) {
            Range cachedRange = this.fWeekSecondaryScaleCache.getRange();
            if (cachedRange.contains(range)) {
                return this.fWeekSecondaryScaleCache;
            }
            return this.createScale(range, 2);
        }
        Range cachedRange = this.fDaySecondaryScaleCache.getRange();
        if (cachedRange.contains(range)) {
            return this.fDaySecondaryScaleCache;
        }
        return this.createScale(range, 3);
    }

    private Scale createScale(Range range, int detail) {
        switch (detail) {
            case 0: {
                return this.createYearScale(range);
            }
            case 1: {
                return this.createMonthScale(range);
            }
            case 2: {
                return this.createWeekScale(range);
            }
        }
        return this.createDayScale(range);
    }

    private Scale createYearScale(Range range) {
        ArrayList<Date> dates = new ArrayList<Date>();
        this.fCal.setTimeInMillis(range.getStart());
        int yearFrom = this.fCal.get(1) - 20;
        this.fCal.setTimeInMillis(range.getEnd());
        int yearTo = this.fCal.get(1) + 20;
        int years = yearTo - yearFrom;
        int i = 0;
        while (i < years) {
            this.fCal.set(1, yearFrom + i);
            this.fCal.setTimeInMillis(TimelineUtils.trimToYear(this.fCal.getTimeInMillis()));
            dates.add(new Date(this.fCal.getTimeInMillis()));
            ++i;
        }
        Calendar fromYearCal = Calendar.getInstance();
        fromYearCal.set(1, yearFrom);
        fromYearCal.setTimeInMillis(TimelineUtils.trimToYear(fromYearCal.getTimeInMillis()));
        Calendar toYearCal = Calendar.getInstance();
        toYearCal.set(1, yearTo);
        toYearCal.setTimeInMillis(TimelineUtils.trimToYear(toYearCal.getTimeInMillis()));
        Range yearsRange = new Range(fromYearCal.getTimeInMillis(), toYearCal.getTimeInMillis());
        return new Scale(yearsRange, dates.toArray(new Date[dates.size()]));
    }

    private Scale createMonthScale(Range range) {
        ArrayList<Date> dates = new ArrayList<Date>();
        this.fCal.setTimeInMillis(range.getStart());
        int yearFrom = this.fCal.get(1) - 10;
        this.fCal.setTimeInMillis(range.getEnd());
        int yearTo = this.fCal.get(1) + 10;
        Calendar fromYearCal = Calendar.getInstance();
        fromYearCal.set(1, yearFrom);
        fromYearCal.setTimeInMillis(TimelineUtils.trimToYear(fromYearCal.getTimeInMillis()));
        Calendar toYearCal = Calendar.getInstance();
        toYearCal.set(1, yearTo);
        toYearCal.setTimeInMillis(TimelineUtils.trimToYear(toYearCal.getTimeInMillis()));
        int year = yearFrom;
        while (year <= yearTo) {
            int month = 0;
            while (month < 12) {
                this.fCal.set(year, month, 1);
                dates.add(new Date(TimelineUtils.trimToDay(this.fCal.getTimeInMillis())));
                ++month;
            }
            ++year;
        }
        Range monthsRange = new Range(fromYearCal.getTimeInMillis(), toYearCal.getTimeInMillis());
        return new Scale(monthsRange, dates.toArray(new Date[dates.size()]));
    }

    private Scale createWeekScale(Range range) {
        ArrayList<Date> dates = new ArrayList<Date>();
        this.fCal.setTimeInMillis(range.getStart());
        int yearFrom = this.fCal.get(1) - 1;
        this.fCal.setTimeInMillis(range.getEnd());
        int yearTo = this.fCal.get(1) + 1;
        Calendar fromYearCal = Calendar.getInstance();
        fromYearCal.set(1, yearFrom);
        fromYearCal.setTimeInMillis(TimelineUtils.trimToYear(fromYearCal.getTimeInMillis()));
        Calendar toYearCal = Calendar.getInstance();
        toYearCal.set(1, yearTo);
        toYearCal.setTimeInMillis(TimelineUtils.trimToYear(toYearCal.getTimeInMillis()));
        int year = yearFrom;
        while (year <= yearTo) {
            this.fCal.set(year, 0, 1, 0, 0, 0);
            this.fCal.set(14, 0);
            int maxWeeks = this.fCal.getActualMaximum(3);
            int week = 0;
            while (week <= maxWeeks) {
                this.fCal.add(3, 1);
                this.fCal.setTimeInMillis(TimelineUtils.trimToWeek(this.fCal.getTimeInMillis()));
                if (this.fCal.get(1) == year) {
                    dates.add(this.fCal.getTime());
                }
                ++week;
            }
            ++year;
        }
        Range weeksRange = new Range(fromYearCal.getTimeInMillis(), toYearCal.getTimeInMillis());
        return new Scale(weeksRange, dates.toArray(new Date[dates.size()]));
    }

    private Scale createDayScale(Range range) {
        ArrayList<Date> dates = new ArrayList<Date>();
        this.fCal.setTimeInMillis(range.getStart());
        int yearFrom = this.fCal.get(1) - 1;
        this.fCal.setTimeInMillis(range.getEnd());
        int yearTo = this.fCal.get(1) + 1;
        Calendar fromYearCal = Calendar.getInstance();
        fromYearCal.set(yearFrom, 0, 1, 0, 0, 0);
        fromYearCal.set(14, 0);
        Calendar toYearCal = Calendar.getInstance();
        toYearCal.set(yearTo, 0, 1, 0, 0, 0);
        toYearCal.set(14, 0);
        int year = yearFrom;
        while (year <= yearTo) {
            this.fCal.set(year, 0, 1);
            int maxDays = this.fCal.getActualMaximum(6);
            int day = 0;
            while (day < maxDays) {
                this.fCal.add(6, 1);
                dates.add(new Date(TimelineUtils.trimToDay(this.fCal.getTimeInMillis())));
                ++day;
            }
            ++year;
        }
        Range daysRange = new Range(fromYearCal.getTimeInMillis(), toYearCal.getTimeInMillis());
        return new Scale(daysRange, dates.toArray(new Date[dates.size()]));
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

