/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.icu.util.Calendar;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.timeline.Messages;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.Scale;
import com.ibm.team.jface.timeline.TimelineColors;
import com.ibm.team.jface.timeline.TimelineSelectionEvent;
import com.ibm.team.jface.timeline.TimelineSelectionListener;
import com.ibm.team.jface.timeline.TimelineUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Timeline
extends Canvas {
    private static final int GAP = 0;
    private static final int BAR_GAP = 5;
    private static final int BAR_MARGIN_TOP = 5;
    private static final int DEFAULT_SCALE_AREA_HEIGHT = 12;
    private static final int TICK_HEIGHT = 4;
    private static final int SELECTOR_MIN_WIDTH = 10;
    private static final int SCALE_TEXT_GAP = 6;
    private static final int SELECTOR_RESIZE_AREA = 3;
    private static final int PRIMARY_SCALE_TEXT_MARGIN_TOP = 2;
    private static final int SELECTOR_OVERLAP = 2;
    private Scale fPrimaryScale;
    private Scale fSecondScale;
    private Range fVisibleRange;
    private int[] fValues;
    private int fPrimaryScaleHeight = 12;
    private int fSecondaryScaleHeight = 12;
    private Rectangle fSelectorRect;
    private Range fCachedSelectedRange;
    private boolean fBlockSelection;
    private boolean fMouseDownOverSelectorContent;
    private boolean fMouseDownOverSelectorLeftBorder;
    private boolean fMouseDownOverSelectorRightBorder;
    private Range fMouseDownRange;
    private boolean fHasFocus;
    private List<TimelineSelectionListener> fSelectionListeners = new ArrayList<TimelineSelectionListener>();
    private TimelineColors fColors = TimelineColors.createInstance((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this));

    public Timeline(Composite parent, int style) {
        super(parent, style | 0x40000);
        new DoubleBufferPainter(this){

            public void doPaint(PaintEvent event) {
                Timeline.this.onPaint(event);
            }
        };
        int[] listener = new int[]{5, 3, 4, 8, 7, 11, 31, 15, 16};
        int i = 0;
        while (i < listener.length) {
            this.addListener(listener[i], new Listener(){

                public void handleEvent(Event event) {
                    Timeline.this.onEvent(event);
                }
            });
            ++i;
        }
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Timeline.this.onGetName(e);
            }
        });
    }

    private void onFocus(boolean gained) {
        this.fHasFocus = gained;
        this.redraw();
    }

    private void onGetName(AccessibleEvent e) {
        Point cursorLocation = this.getDisplay().getCursorLocation();
        cursorLocation = this.toControl(cursorLocation);
        Range range = this.getRange(cursorLocation.x);
        e.result = range == null ? Messages.Timeline_EVENT_LOG_TIMELINE : range.toString();
    }

    public void setValues(Range range, Scale primaryScale, Scale secondaryScale, int[] values) {
        this.fVisibleRange = range;
        this.fPrimaryScale = primaryScale;
        this.fSecondScale = secondaryScale;
        this.fValues = values;
        if (this.fCachedSelectedRange == null) {
            this.fCachedSelectedRange = new Range(range);
        }
        this.updateScaleHeight();
        this.redraw();
        this.update();
    }

    private void updateScaleHeight() {
        Font f;
        Range tickRange;
        int i;
        int maxHeight;
        Font defaultFont = this.getDisplay().getSystemFont();
        if (this.fPrimaryScale != null) {
            maxHeight = defaultFont.getFontData()[0].getHeight();
            i = 0;
            while (i < this.fPrimaryScale.getTickCount()) {
                tickRange = this.fPrimaryScale.getRange(i);
                if (this.fVisibleRange.overlaps(tickRange) && (f = this.fPrimaryScale.getFont(i)) != null) {
                    maxHeight = Math.max(maxHeight, f.getFontData()[0].getHeight());
                }
                this.fPrimaryScaleHeight = maxHeight + 6;
                ++i;
            }
        }
        if (this.fSecondScale != null) {
            maxHeight = defaultFont.getFontData()[0].getHeight();
            i = 0;
            while (i < this.fSecondScale.getTickCount()) {
                tickRange = this.fSecondScale.getRange(i);
                if (this.fVisibleRange.overlaps(tickRange) && (f = this.fSecondScale.getFont(i)) != null) {
                    maxHeight = Math.max(maxHeight, f.getFontData()[0].getHeight());
                }
                this.fSecondaryScaleHeight = maxHeight + 6;
                ++i;
            }
        }
    }

    public void addTimelineSelectionListener(TimelineSelectionListener listener) {
        if (!this.fSelectionListeners.contains(listener)) {
            this.fSelectionListeners.add(listener);
        }
    }

    public void removeTimelineSelectionListener(TimelineSelectionListener listener) {
        this.fSelectionListeners.remove(listener);
    }

    public Range getSelection() {
        if (this.fCachedSelectedRange == null) {
            return null;
        }
        return new Range(this.fCachedSelectedRange);
    }

    public Point getLocation(long value) {
        Rectangle area = this.getBarArea();
        double difToStart = value - this.fVisibleRange.getStart();
        int xPos = (int)(difToStart * (double)area.width / (double)this.fVisibleRange.getDif());
        return new Point(xPos, area.y);
    }

    public Rectangle getBounds(Range range) {
        Rectangle selectorArea = this.getBarArea();
        int xPos = this.getLocation((long)range.getStart()).x;
        int width = 0;
        if (this.fVisibleRange.getDif() > 0L) {
            width = (int)(range.getDif() * (long)selectorArea.width / this.fVisibleRange.getDif());
        }
        selectorArea.y -= 2;
        selectorArea.height += 4;
        return new Rectangle(xPos, selectorArea.y, width, selectorArea.height);
    }

    public void setSelection(Range range) {
        if (range != null && this.fVisibleRange.overlaps(range)) {
            Range oldSelection = this.fCachedSelectedRange;
            this.fCachedSelectedRange = new Range(range);
            this.fSelectorRect = this.getBounds(range);
            ++this.fSelectorRect.width;
            --this.fSelectorRect.height;
            this.redraw();
            this.update();
            this.notifySelectedRangeChanged(oldSelection, range);
        }
    }

    public void selectAll() {
        this.setSelection(this.fVisibleRange);
    }

    public Range getRange(int x) {
        Range r = null;
        Rectangle barArea = this.getBarArea();
        long start = this.fVisibleRange.getStart();
        double dif = this.fVisibleRange.getDif();
        long dateAtXPos = start + (long)((double)x * dif / (double)barArea.width);
        int i = 0;
        while (i < this.fPrimaryScale.getTickCount()) {
            r = this.fPrimaryScale.getRange(i);
            if (r.contains(dateAtXPos)) break;
            ++i;
        }
        if (r.getStart() < this.fVisibleRange.getStart()) {
            r.setStart(this.fVisibleRange.getStart());
        } else if (r.getEnd() > this.fVisibleRange.getEnd()) {
            r.setEnd(this.fVisibleRange.getEnd());
        }
        return r;
    }

    void notifySelectedRangeChanged(Range oldRange, Range newRange) {
        if (oldRange != null && oldRange.equals(newRange)) {
            return;
        }
        TimelineSelectionEvent event = new TimelineSelectionEvent(this.fCachedSelectedRange, newRange);
        for (TimelineSelectionListener listener : this.fSelectionListeners) {
            listener.selectedRangeChanged(event);
        }
    }

    protected void onEvent(Event e) {
        switch (e.type) {
            case 5: {
                this.onMouseMove(e);
                break;
            }
            case 3: {
                this.onMouseDown(e);
                break;
            }
            case 4: {
                this.onMouseUp(e);
                break;
            }
            case 8: {
                this.onMouseDoubleClick(e);
                break;
            }
            case 7: {
                this.onMouseExit();
                break;
            }
            case 11: {
                this.onResize();
                break;
            }
            case 15: {
                this.onFocus(true);
                break;
            }
            case 16: {
                this.onFocus(false);
                break;
            }
            case 31: {
                e.doit = true;
            }
        }
    }

    private void onResize() {
        if (this.fSelectorRect == null) {
            this.fSelectorRect = this.getBarArea();
        }
        if (this.fCachedSelectedRange != null) {
            this.setSelection(this.fCachedSelectedRange);
        }
    }

    private void onMouseExit() {
        this.fMouseDownOverSelectorContent = false;
        this.fMouseDownOverSelectorLeftBorder = false;
        this.fMouseDownOverSelectorRightBorder = false;
        this.fBlockSelection = false;
        this.fMouseDownRange = null;
    }

    private void onMouseDown(Event e) {
        Point p = new Point(e.x, e.y);
        if (e.button != 1) {
            return;
        }
        this.fMouseDownRange = this.getRange(e.x);
        if (this.fSelectorRect.contains(p)) {
            if (this.fSelectorRect.x <= e.x && e.x < this.fSelectorRect.x + 3) {
                this.fMouseDownOverSelectorLeftBorder = true;
            } else if (this.fSelectorRect.x + this.fSelectorRect.width - 3 < e.x && e.x <= this.fSelectorRect.x + this.fSelectorRect.width) {
                this.fMouseDownOverSelectorRightBorder = true;
            } else {
                this.fMouseDownOverSelectorContent = true;
            }
        } else {
            boolean expandSelection;
            boolean bl = expandSelection = (e.stateMask & SWT.MOD1) != 0 || (e.stateMask & SWT.MOD2) != 0;
            if (expandSelection) {
                Range currentRange = this.getSelection();
                this.fBlockSelection = true;
                if (this.fMouseDownRange.getStart() > currentRange.getStart()) {
                    Range newRange = new Range(currentRange.getStart(), this.fMouseDownRange.getEnd());
                    this.setSelection(newRange);
                } else {
                    Range newRange = new Range(this.fMouseDownRange.getStart(), currentRange.getEnd());
                    this.setSelection(newRange);
                }
            } else {
                this.fBlockSelection = true;
                this.setSelection(this.fMouseDownRange);
            }
        }
    }

    private void onMouseUp(Event e) {
        if (!this.fBlockSelection && e.button == 1) {
            this.setSelection(this.getRange(e.x));
        }
        this.fMouseDownOverSelectorContent = false;
        this.fMouseDownOverSelectorLeftBorder = false;
        this.fMouseDownOverSelectorRightBorder = false;
        this.fBlockSelection = false;
        this.fMouseDownRange = null;
    }

    private void onMouseDoubleClick(Event e) {
        Point p = new Point(e.x, e.y);
        if (this.fSelectorRect.contains(p)) {
            this.fBlockSelection = true;
            if (this.getSelection().getDif() < this.fVisibleRange.getDif()) {
                this.setSelection(this.fVisibleRange);
            }
        }
    }

    private void onMouseMove(Event e) {
        Point p = new Point(e.x, e.y);
        if (!(this.fMouseDownOverSelectorContent || this.fMouseDownOverSelectorLeftBorder || this.fMouseDownOverSelectorRightBorder)) {
            if (this.fSelectorRect != null && this.fSelectorRect.contains(p)) {
                if (this.fSelectorRect.x <= e.x && e.x < this.fSelectorRect.x + 3) {
                    this.setCursor(this.getDisplay().getSystemCursor(9));
                } else if (this.fSelectorRect.x + this.fSelectorRect.width - 3 < e.x && e.x <= this.fSelectorRect.x + this.fSelectorRect.width) {
                    this.setCursor(this.getDisplay().getSystemCursor(9));
                } else {
                    this.setCursor(this.getDisplay().getSystemCursor(21));
                }
            } else {
                this.setCursor(this.getDisplay().getSystemCursor(21));
            }
        }
        Range currentSelection = this.getSelection();
        Range mouseOverRange = this.getRange(e.x);
        if (this.fMouseDownOverSelectorContent) {
            this.fBlockSelection = true;
            long startDif = mouseOverRange.getStart() - this.fMouseDownRange.getStart();
            long endDif = mouseOverRange.getEnd() - this.fMouseDownRange.getEnd();
            currentSelection.setStart(currentSelection.getStart() + startDif);
            currentSelection.setEnd(currentSelection.getEnd() + endDif);
            if (this.fVisibleRange.contains(currentSelection)) {
                this.setSelection(currentSelection);
                this.fMouseDownRange = new Range(mouseOverRange);
            }
        } else if (this.fMouseDownOverSelectorLeftBorder) {
            this.fBlockSelection = true;
            Range newRange = new Range(mouseOverRange.getStart(), currentSelection.getEnd());
            if (newRange.getDif() > 0L) {
                this.setSelection(newRange);
            }
        } else if (this.fMouseDownOverSelectorRightBorder) {
            this.fBlockSelection = true;
            Range newRange = new Range(currentSelection.getStart(), mouseOverRange.getEnd());
            if (newRange.getDif() > 0L) {
                this.setSelection(newRange);
            }
        }
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        boolean initialized = this.fVisibleRange != null && this.fValues != null && this.fPrimaryScale != null;
        Rectangle clArea = this.getClientArea();
        --clArea.width;
        --clArea.height;
        gc.setBackground(this.getDisplay().getSystemColor(25));
        gc.fillRectangle(clArea);
        Rectangle barArea = this.getBarArea();
        Rectangle topScaleArea = new Rectangle(clArea.x + 0, clArea.y, clArea.width - 0, clArea.y + this.fSecondaryScaleHeight);
        Rectangle bottomScaleArea = new Rectangle(clArea.x + 0, clArea.y + clArea.height - this.fPrimaryScaleHeight, clArea.width - 0, clArea.y + clArea.height);
        if (initialized) {
            this.drawBars(gc, barArea);
        }
        this.drawBackground(gc, clArea);
        if (initialized) {
            this.drawScale(this.fPrimaryScale, gc, barArea, bottomScaleArea);
        }
        Rectangle[] topScaleTextBounds = new Rectangle[]{};
        if (initialized && this.fSecondScale != null) {
            topScaleTextBounds = this.drawScale(this.fSecondScale, gc, barArea, topScaleArea);
        }
        if (initialized) {
            this.drawTodayIndicator(gc, barArea, topScaleArea, topScaleTextBounds);
        }
        if (initialized) {
            this.drawSelector(gc, barArea);
        }
    }

    private void drawBackground(GC gc, Rectangle clArea) {
        gc.setForeground(this.fColors.getColor(TimelineColors.BORDER));
        gc.drawRectangle(clArea.x, clArea.y + this.fSecondaryScaleHeight, clArea.width, clArea.height - this.fPrimaryScaleHeight - this.fSecondaryScaleHeight);
    }

    private Rectangle[] drawScale(Scale scale, GC gc, Rectangle barArea, Rectangle scaleArea) {
        ArrayList<Rectangle> topScaleTextBounds = new ArrayList<Rectangle>();
        int i = 0;
        while (i < scale.getTickCount()) {
            Range tickRange = scale.getRange(i);
            long tickDateFrom = tickRange.getStart();
            if (this.fVisibleRange.overlaps(tickRange)) {
                Point textLocation;
                int xPos = this.getLocation((long)tickDateFrom).x;
                if (xPos > scaleArea.x && scale == this.fPrimaryScale) {
                    gc.setForeground(this.fColors.getColor(TimelineColors.SEPARATOR));
                    gc.drawLine(xPos, barArea.y + 1, xPos, barArea.y + barArea.height - 1);
                } else if (xPos > scaleArea.x && scale == this.fSecondScale) {
                    gc.setForeground(this.fColors.getColor(TimelineColors.BORDER));
                    gc.drawLine(xPos, barArea.y + 1, xPos, barArea.y + barArea.height - 1);
                }
                if (xPos >= scaleArea.x && scale == this.fPrimaryScale) {
                    gc.setForeground(this.fColors.getColor(TimelineColors.BORDER));
                    gc.drawLine(xPos, scaleArea.y, xPos, scaleArea.y + 4);
                } else if (xPos >= scaleArea.x && scale == this.fSecondScale) {
                    gc.setForeground(this.fColors.getColor(TimelineColors.BORDER));
                    gc.drawLine(xPos, scaleArea.y, xPos, scaleArea.y + scaleArea.height);
                }
                Font oldFont = gc.getFont();
                int align = scale.getTextAlign(i);
                String tickText = scale.getText(i);
                Font font = scale.getFont(i);
                Point tickTextSize = gc.textExtent(tickText);
                if (font != null) {
                    gc.setFont(font);
                }
                Rectangle tickBounds = this.getBounds(tickRange);
                while (tickBounds.width < tickTextSize.x && tickText.length() > 0) {
                    tickText = tickText.substring(0, tickText.length() - 1);
                    tickTextSize = gc.textExtent(tickText);
                }
                if (align == 0) {
                    textLocation = new Point(xPos + 6, scaleArea.y);
                } else if (align == 1) {
                    textLocation = new Point(tickBounds.x + tickBounds.width - tickTextSize.x, scaleArea.y);
                } else {
                    int xPosCenter = tickBounds.x + tickBounds.width / 2 - tickTextSize.x / 2 + 2;
                    textLocation = new Point(xPosCenter, scaleArea.y);
                }
                if (textLocation.x >= scaleArea.x && textLocation.x + tickTextSize.x < scaleArea.x + scaleArea.width) {
                    Rectangle tBounds = new Rectangle(textLocation.x, 0, tickTextSize.x, tickTextSize.y);
                    tBounds.y = textLocation.y + (scale == this.fPrimaryScale ? 2 : 0);
                    topScaleTextBounds.add(tBounds);
                    gc.setForeground(this.fColors.getColor(TimelineColors.SCALE_TEXT_FG));
                    gc.drawString(tickText, tBounds.x, tBounds.y, true);
                }
                gc.setFont(oldFont);
            }
            ++i;
        }
        return topScaleTextBounds.toArray(new Rectangle[topScaleTextBounds.size()]);
    }

    private void drawSelector(GC gc, Rectangle barArea) {
        if (this.fSelectorRect.x < 0) {
            this.fSelectorRect.x = 0;
        }
        if (this.fSelectorRect.x + this.fSelectorRect.width >= barArea.width) {
            this.fSelectorRect.width = barArea.width - this.fSelectorRect.x - 1;
        }
        if (this.fSelectorRect.width < 10) {
            this.fSelectorRect.width = 10;
        }
        Rectangle rect = new Rectangle(this.fSelectorRect.x, this.fSelectorRect.y, this.fSelectorRect.width, this.fSelectorRect.height);
        gc.setForeground(this.fColors.getColor(TimelineColors.SELECTOR_OUTER_INNER_BORDER));
        gc.drawRectangle(rect);
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        gc.setForeground(this.fColors.getColor(TimelineColors.SELECTOR_MIDDLE_BORDER));
        gc.drawRectangle(rect);
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        gc.setForeground(this.fColors.getColor(TimelineColors.SELECTOR_OUTER_INNER_BORDER));
        gc.drawRectangle(rect);
        if (this.fHasFocus) {
            gc.setForeground(this.getDisplay().getSystemColor(2));
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private void drawTodayIndicator(GC gc, Rectangle barArea, Rectangle topScaleArea, Rectangle[] topScaleTextBounds) {
        long todayFrom = TimelineUtils.trimToDay(System.currentTimeMillis());
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTimeInMillis(todayFrom);
        tomorrow.add(6, 1);
        Range dayRange = new Range(todayFrom, tomorrow.getTimeInMillis());
        if (dayRange.overlaps(this.fVisibleRange)) {
            if (todayFrom < this.fVisibleRange.getStart()) {
                dayRange.setStart(this.fVisibleRange.getStart());
            }
            Rectangle bounds = this.getBounds(dayRange);
            int xPos = bounds.x;
            int width = bounds.width;
            if (xPos < barArea.x) {
                xPos = barArea.x;
            }
            if (xPos + width > barArea.width) {
                width = barArea.x + barArea.width - xPos;
            }
            if (width < 3) {
                width = 3;
            }
            int oldAlpha = gc.getAlpha();
            gc.setBackground(this.fColors.getColor(TimelineColors.TODAY_INDICATOR));
            gc.setAlpha(60);
            Rectangle todayBox = new Rectangle(xPos + 1, barArea.y + 1, width, barArea.height - 1);
            gc.fillRectangle(todayBox);
            gc.setAlpha(oldAlpha);
            int xPosCenter = todayBox.x + todayBox.width / 2;
            Rectangle r = topScaleArea;
            Rectangle todayArrowBounds = new Rectangle(xPosCenter - 4, r.y + r.height - 12, 8, r.y + r.height - 3);
            int i = 0;
            while (i < topScaleTextBounds.length) {
                Rectangle rectangle = topScaleTextBounds[i];
                if (rectangle.intersects(todayArrowBounds)) {
                    return;
                }
                ++i;
            }
            if (todayArrowBounds.x + todayArrowBounds.width < barArea.x + barArea.width) {
                gc.setForeground(this.fColors.getColor(TimelineColors.TODAY_INDICATOR));
                gc.setAntialias(1);
                gc.drawLine(xPosCenter - 2, r.y + r.height - 8, xPosCenter + 2, r.y + r.height - 8);
                gc.drawLine(xPosCenter - 1, r.y + r.height - 9, xPosCenter + 1, r.y + r.height - 9);
                gc.drawLine(xPosCenter - 1, r.y + r.height - 10, xPosCenter + 1, r.y + r.height - 10);
                gc.drawPoint(xPosCenter, r.y + r.height - 11);
                gc.drawPoint(xPosCenter, r.y + r.height - 12);
                gc.setAntialias(0);
                gc.drawLine(xPosCenter - 4, r.y + r.height - 7, xPosCenter + 4, r.y + r.height - 7);
                gc.drawLine(xPosCenter - 3, r.y + r.height - 6, xPosCenter + 3, r.y + r.height - 6);
                gc.drawLine(xPosCenter - 2, r.y + r.height - 5, xPosCenter + 2, r.y + r.height - 5);
                gc.drawLine(xPosCenter - 1, r.y + r.height - 4, xPosCenter + 1, r.y + r.height - 4);
                gc.drawPoint(xPosCenter, r.y + r.height - 3);
            }
        }
    }

    private void drawBars(GC gc, Rectangle barArea) {
        int maxBarHeight = barArea.height - 5;
        int maxValue = this.getMax(this.fValues);
        int i = 0;
        int valIndex = 0;
        while (i < this.fPrimaryScale.getTickCount() - 1) {
            long tickDateTo;
            long tickDateFrom = this.fPrimaryScale.getTick(i);
            Range tickRange = new Range(tickDateFrom, tickDateTo = this.fPrimaryScale.getTick(i + 1));
            if (this.fVisibleRange.overlaps(tickRange) && this.fValues.length > valIndex) {
                Color bgColor;
                int value = this.fValues[valIndex];
                ++valIndex;
                float barHeight = (float)value * (float)maxBarHeight / (float)maxValue;
                Rectangle bounds = this.getBounds(tickRange);
                int barWidth = bounds.width;
                int barXPos = bounds.x;
                int yBarStartPos = barArea.y + barArea.height - (int)barHeight;
                Rectangle barBounds = new Rectangle(barXPos + 5 + 1, yBarStartPos, barWidth - 10 - 2, barArea.y + barArea.height - yBarStartPos - 1);
                if (barBounds.height < 2) {
                    barBounds.y = barArea.y + barArea.height - 3;
                    barBounds.height = 2;
                }
                if ((bgColor = this.fPrimaryScale.getBarBackground(i)) == null) {
                    bgColor = this.getDisplay().getSystemColor(25);
                }
                Color oldBg = gc.getBackground();
                gc.setBackground(bgColor);
                Rectangle barBackground = new Rectangle(barXPos + 1, barArea.y, barWidth, barArea.height);
                gc.fillRectangle(barBackground);
                gc.setBackground(oldBg);
                if (value != 0) {
                    Color fG = this.fPrimaryScale.getBarForeground(i);
                    Rectangle gradientRect = new Rectangle(barBounds.x + 2, barBounds.y + 2, barBounds.width - 3, barBounds.height - 1);
                    gc.setForeground(fG != null ? fG : this.fColors.getColor(TimelineColors.BAR_GRADIENT_BEGIN));
                    gc.setBackground(fG != null ? fG : this.fColors.getColor(TimelineColors.BAR_GRADIENT_END));
                    gc.fillGradientRectangle(gradientRect.x, gradientRect.y, gradientRect.width, gradientRect.height, true);
                    Color border = this.fPrimaryScale.getBarBorder(i);
                    gc.setForeground(border != null ? border : this.fColors.getColor(TimelineColors.BAR_BORDER));
                    gc.drawLine(barBounds.x, barBounds.y, barBounds.x, barBounds.y + barBounds.height);
                    gc.drawLine(barBounds.x, barBounds.y, barBounds.x + barBounds.width, barBounds.y);
                    gc.drawLine(barBounds.x + barBounds.width, barBounds.y, barBounds.x + barBounds.width, barBounds.y + barBounds.height);
                    if (gradientRect.height > 2) {
                        gc.setForeground(this.getDisplay().getSystemColor(1));
                        gc.drawLine(barBounds.x + 1, barBounds.y + 1, barBounds.x + 1, barBounds.y + barBounds.height - 1);
                        gc.drawLine(barBounds.x + 1, barBounds.y + 1, barBounds.x + barBounds.width - 1, barBounds.y + 1);
                        gc.drawLine(barBounds.x + barBounds.width - 1, barBounds.y + 1, barBounds.x + barBounds.width - 1, barBounds.y + barBounds.height - 1);
                    } else {
                        gc.setForeground(this.getDisplay().getSystemColor(1));
                        gc.drawLine(barBounds.x + 1, barBounds.y + 1, barBounds.x + barBounds.width - 1, barBounds.y + 1);
                    }
                }
            }
            ++i;
        }
    }

    private int getMax(int[] values) {
        int maxValue = -1;
        int i = 0;
        while (i < values.length) {
            if (values[i] > maxValue) {
                maxValue = this.fValues[i];
            }
            ++i;
        }
        return maxValue;
    }

    private Rectangle getBarArea() {
        Rectangle clArea = this.getClientArea();
        return new Rectangle(clArea.x + 0, clArea.y + this.fSecondaryScaleHeight, clArea.width - 0, clArea.y + clArea.height - this.fPrimaryScaleHeight - this.fSecondaryScaleHeight);
    }
}

