/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.labelProviders;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class BaseLabelProvider
implements ILabelProvider,
IViewerLabelProvider {
    private ListenerList listenerList = new ListenerList(1);
    private ResourceManager resources = null;
    private Display display = Display.getCurrent();

    public BaseLabelProvider() {
        if (this.display == null) {
            throw new IllegalStateException("This object must be constructed in the display thread");
        }
    }

    protected Display getDisplay() {
        return this.display;
    }

    protected final ResourceManager getResources() {
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resources;
    }

    protected final Image getImage(ImageDescriptor descriptor) {
        Object o = this.getResources().find((DeviceResourceDescriptor)descriptor);
        if (o instanceof Image) {
            return (Image)o;
        }
        return this.getResources().createImageWithDefault(descriptor);
    }

    protected final Font getFont(FontDescriptor descriptor) {
        return (Font)this.getResources().get((DeviceResourceDescriptor)descriptor);
    }

    public abstract void updateLabel(ViewerLabel var1, Object var2);

    public final void addListener(ILabelProviderListener listener) {
        this.assertOnUIThread();
        if (this.listenerList.isEmpty()) {
            this.firstListenerAdded();
        }
        this.listenerList.add((Object)listener);
    }

    private void assertOnUIThread() {
        if (Display.getCurrent() != this.getDisplay()) {
            Assert.isTrue((boolean)false, (String)"Must be called on UI thread");
        }
    }

    protected final boolean hasListeners() {
        return !this.listenerList.isEmpty();
    }

    protected final void fireChangeEvent(Object[] elements) {
        if (elements == null) {
            this.fireAllElementsChangedEvent();
        } else {
            LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this, elements);
            this.fireLabelProviderChangedEvent(e);
        }
    }

    protected final void fireAllElementsChangedEvent() {
        if (Display.getCurrent() == this.display) {
            LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this);
            this.fireLabelProviderChangedEvent(e);
        } else {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)BaseLabelProvider.this);
                    BaseLabelProvider.this.fireLabelProviderChangedEvent(e);
                }
            });
        }
    }

    protected final void fireChangeEvent(final Collection elementsThatChanged) {
        if (elementsThatChanged.isEmpty()) {
            return;
        }
        if (Display.getCurrent() == this.display) {
            LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this, elementsThatChanged.toArray());
            this.fireLabelProviderChangedEvent(e);
        } else {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)BaseLabelProvider.this, elementsThatChanged.toArray());
                    BaseLabelProvider.this.fireLabelProviderChangedEvent(e);
                }
            });
        }
    }

    protected void firstListenerAdded() {
    }

    public void dispose() {
        this.assertOnUIThread();
        boolean hadListeners = !this.listenerList.isEmpty();
        this.listenerList.clear();
        if (hadListeners) {
            this.lastListenerRemoved();
        }
        if (this.resources != null) {
            this.resources.dispose();
        }
    }

    public final boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public final void removeListener(ILabelProviderListener listener) {
        this.assertOnUIThread();
        if (this.listenerList.isEmpty()) {
            return;
        }
        this.listenerList.remove((Object)listener);
        if (this.listenerList.isEmpty()) {
            this.lastListenerRemoved();
        }
    }

    protected void lastListenerRemoved() {
    }

    public final Image getImage(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        return label.getImage();
    }

    public final String getText(Object element) {
        ViewerLabel label = new ViewerLabel(null, null);
        this.updateLabel(label, element);
        return label.getText();
    }

    protected final void fireLabelProviderChangedEvent(LabelProviderChangedEvent e) {
        Object[] listeners = this.listenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            l.labelProviderChanged(e);
            ++i;
        }
    }
}

