/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.itemview.AbstractMarkupItemViewPage;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import com.ibm.team.jface.itemview.Messages;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MarkupTitlePart {
    private static final String TOGGLE_EXPAND_ACTION_ID = "com.ibm.team.jface.itemview.ToggleExpandAction";
    MarkupItemViewInput fInput;
    private Form fTitleForm;
    private IStructuredSelection fSelection;
    private SharedHeaderFormEditor fEditor;
    private ResourceManager fResources;

    public void init(SharedHeaderFormEditor editor) {
        this.fTitleForm = editor.getHeaderForm().getForm().getForm();
        this.fEditor = editor;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.updateTitle();
        this.createContextMenu(this.fTitleForm);
        this.addDragSupport(this.fTitleForm);
        this.createActionArea(this.fTitleForm);
    }

    private void addDragSupport(Form proxy) {
        DragSourceAdapter dragSourcelistener = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                if (MarkupTitlePart.this.fSelection != null) {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)MarkupTitlePart.this.fSelection);
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getTransfer().getSelection();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        };
        proxy.addTitleDragSupport(4, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)dragSourcelistener);
    }

    public void setInput(MarkupItemViewInput input) {
        this.fInput = input;
        Object input2 = this.fInput.getInput();
        this.fSelection = input2 instanceof Object[] ? new StructuredSelection((Object[])input2) : new StructuredSelection(input2);
        this.updateTitle();
    }

    private void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups(manager);
                manager.add((IAction)new Action(Messages.MarkupTitlePart_RELOAD_ALL_FEEDS){

                    public void run() {
                        MarkupTitlePart.this.onRefresh();
                    }
                });
            }
        });
        if (menuMgr instanceof MenuManager) {
            this.fEditor.getSite().registerContextMenu(this.fEditor.getSite().getId(), (MenuManager)menuMgr, new ISelectionProvider(){

                public ISelection getSelection() {
                    return MarkupTitlePart.this.fSelection;
                }

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
        }
    }

    private void createActionArea(Form titleForm) {
        final IToolBarManager toolBarManager = titleForm.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)new Action(Messages.MarkupTitlePart_MARK_ALL_AS_READ){

            public void run() {
                MarkupTitlePart.this.onMarkAllRead();
            }

            public ImageDescriptor getImageDescriptor() {
                return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.jface", (String)"icons/elcl16/markl_read.gif");
            }
        });
        toolBarManager.add((IAction)new Action(""){
            private boolean fExpandAll;
            {
                super($anonymous0);
                this.fExpandAll = true;
            }

            public void run() {
                MarkupTitlePart.this.onToggleExpand();
                this.fExpandAll = !this.fExpandAll;
                toolBarManager.find(MarkupTitlePart.TOGGLE_EXPAND_ACTION_ID).update();
            }

            public ImageDescriptor getImageDescriptor() {
                return this.fExpandAll ? ImagePool.EXPAND_ALL : ImagePool.COLLAPSE_ALL;
            }

            public String getText() {
                return this.fExpandAll ? Messages.MarkupTitlePart_EXPAND_ALL : Messages.MarkupTitlePart_COLLAPSE_ALL;
            }

            public String getId() {
                return MarkupTitlePart.TOGGLE_EXPAND_ACTION_ID;
            }
        });
        Action toggleSideBarAction = new Action(Messages.MarkupTitlePart_SHOW_SIDEBAR, 2){

            public void run() {
                MarkupTitlePart.this.onToggleSideBar(this.isChecked());
            }

            public ImageDescriptor getImageDescriptor() {
                return ImagePool.TOGGLE_SIDEBAR;
            }
        };
        toggleSideBarAction.setChecked(!this.isSideBarHidden());
        toolBarManager.add((IAction)toggleSideBarAction);
        Action refreshAction = new Action(Messages.MarkupTitlePart_RELOAD_ALL_FEEDS){

            public void run() {
                MarkupTitlePart.this.onRefresh();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImagePool.REFRESH;
            }
        };
        toolBarManager.add((IAction)refreshAction);
        this.fEditor.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)refreshAction);
        titleForm.updateToolBar();
    }

    private boolean isSideBarHidden() {
        String settings;
        IDialogSettings section = JFacePlugin.getDefault().getDialogSettings().getSection("com.ibm.team.workitem.query.editor.page.details");
        if (section != null && (settings = section.get("MarkupItemViewSettings")) != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
                return Boolean.valueOf(memento.getString("fSideBarHidden"));
            }
            catch (WorkbenchException workbenchException) {
                return false;
            }
        }
        return false;
    }

    private void onToggleExpand() {
        AbstractMarkupItemViewPage page = this.getMarkupItemViewPage();
        if (page != null) {
            page.toggleExpandAll();
        }
    }

    private void onToggleSideBar(boolean show) {
        AbstractMarkupItemViewPage page = this.getMarkupItemViewPage();
        if (page != null) {
            page.toggleSideBar(show);
        }
    }

    private AbstractMarkupItemViewPage getMarkupItemViewPage() {
        MarkupItemView markupView;
        IFormPage activePage;
        if (this.fEditor instanceof MarkupItemView && (activePage = (markupView = (MarkupItemView)this.fEditor).getActivePageInstance()) != null && activePage instanceof AbstractMarkupItemViewPage) {
            AbstractMarkupItemViewPage page = (AbstractMarkupItemViewPage)activePage;
            return page;
        }
        return null;
    }

    private void onRefresh() {
        Object input;
        if (this.fEditor instanceof MarkupItemView) {
            ((MarkupItemView)this.fEditor).refreshEditor();
        }
        if ((input = this.fInput.getInput()) instanceof Channel[]) {
            Channel[] feeds;
            Channel[] channelArray = feeds = (Channel[])input;
            int n = feeds.length;
            int n2 = 0;
            while (n2 < n) {
                Channel feed = channelArray[n2];
                feed.setExplicitRefresh(true);
                FeedManager.getDefault().loadNews(feed);
                ++n2;
            }
        }
    }

    private void onMarkAllRead() {
        Object input = this.fInput.getInput();
        if (input instanceof Channel[]) {
            Channel[] feeds = (Channel[])input;
            ArrayList<NewsItem> newsToMarkRead = new ArrayList<NewsItem>();
            Channel[] channelArray = feeds;
            int n = feeds.length;
            int n2 = 0;
            while (n2 < n) {
                Channel feed = channelArray[n2];
                newsToMarkRead.addAll(Arrays.asList(feed.getItems()));
                ++n2;
            }
            if (!newsToMarkRead.isEmpty()) {
                FeedManager.getDefault().setRead(newsToMarkRead.toArray(new NewsItem[newsToMarkRead.size()]), true);
            }
        }
    }

    private void updateTitle() {
        if (this.fInput != null && this.fTitleForm != null && !this.fTitleForm.isDisposed()) {
            this.fTitleForm.setText(this.fInput.getName());
            this.fTitleForm.setImage(JazzResources.getImage(this.fResources, this.fInput.getImageDescriptor(), null));
        }
    }

    public void dispose() {
        if (this.fResources != null) {
            this.fResources.dispose();
        }
    }
}

