/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.foundation.rcp.core.ILinkProvider;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.itemview.AbstractMarkupItemViewPage;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import com.ibm.team.jface.itemview.MarkupTitlePart;
import com.ibm.team.ui.editor.TeamFormEditor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class MarkupItemView
extends TeamFormEditor {
    public static final String EDITOR_ID = "com.ibm.team.jface.MarkupItemView";
    private MarkupTitlePart fTitlePart;
    private ResourceManager fResources;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        if (!(input instanceof MarkupItemViewInput)) {
            throw new PartInitException("input of type MarkupItemViewInput expected");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.fTitlePart = new MarkupTitlePart();
        this.fTitlePart.init(this);
        this.fTitlePart.setInput((MarkupItemViewInput)this.getEditorInput());
        Form form = this.getForm(headerForm);
        if (form != null) {
            form.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    MarkupItemView.this.refreshEditor();
                }
            });
        }
    }

    void refreshEditor() {
        IFormPage activePage;
        boolean updatesAvailable = this.showMessage(null, 0);
        if (updatesAvailable && (activePage = this.getActivePageInstance()) != null && activePage instanceof AbstractMarkupItemViewPage) {
            AbstractMarkupItemViewPage markupPage = (AbstractMarkupItemViewPage)activePage;
            markupPage.performRefresh(false);
        }
    }

    public boolean showMessage(String msg, int type) {
        boolean messageVisible = false;
        Form form = this.getForm(this.getHeaderForm());
        if (form != null) {
            String oldMessage = form.getMessage();
            messageVisible = oldMessage != null && oldMessage.length() > 0;
            form.setMessage(msg, type);
        }
        this.updateTitleImage(msg != null && msg.length() > 0);
        return messageVisible;
    }

    void updateTitleImage(boolean indicateUpdate) {
        Object inputImage;
        IEditorInput fInput = this.getEditorInput();
        if (fInput != null && (inputImage = fInput.getImageDescriptor()) != null) {
            if (indicateUpdate) {
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = ImagePool.NEWINFO_OVRL;
                inputImage = new OverlayIcon((ImageDescriptor)inputImage, imageDescriptorArray, 131200);
            }
            this.setTitleImage(JazzResources.getImage(this.fResources, inputImage, null));
            this.firePropertyChange(1);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public static IDateProvider getDateProvider(Object element) {
        IAdaptable adapter;
        if (element instanceof IDateProvider) {
            return (IDateProvider)element;
        }
        if (element instanceof IAdaptable && (adapter = (IAdaptable)element).getAdapter(IDateProvider.class) != null) {
            return (IDateProvider)adapter.getAdapter(IDateProvider.class);
        }
        return null;
    }

    public static ILinkProvider getLinkProvider(Object element) {
        IAdaptable adapter;
        if (element instanceof ILinkProvider) {
            return (ILinkProvider)element;
        }
        if (element instanceof IAdaptable && (adapter = (IAdaptable)element).getAdapter(ILinkProvider.class) != null) {
            return (ILinkProvider)adapter.getAdapter(ILinkProvider.class);
        }
        return null;
    }

    public void dispose() {
        this.fTitlePart.dispose();
        this.fResources.dispose();
        super.dispose();
    }

    private Form getForm(IManagedForm managedForm) {
        Form form;
        ScrolledForm scrolledForm;
        if (managedForm != null && (scrolledForm = managedForm.getForm()) != null && !scrolledForm.isDisposed() && (form = scrolledForm.getForm()) != null && !form.isDisposed()) {
            return form;
        }
        return null;
    }
}

