/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.SectionPart;

public class TeamCentralResizer {
    static boolean resize(SectionPart[] sections, SectionPart sectionToResize, int heightDiff, boolean withModKeyHold) {
        SectionPart previousExpandedSection;
        boolean requiresLayout = false;
        SectionPart nextSection = TeamCentralResizer.getNextSection(sections, sectionToResize);
        int curSectionHeight = TeamCentralResizer.getSectionHeight(sectionToResize);
        int nextSectionHeight = TeamCentralResizer.getSectionHeight(nextSection);
        if (heightDiff < 0 && withModKeyHold) {
            SectionPart lastExpandedSection = TeamCentralResizer.getLastExpandedSection(sections, sectionToResize);
            if (lastExpandedSection != null) {
                requiresLayout = true;
                int lastExpandedSectionHeight = TeamCentralResizer.getSectionHeight(lastExpandedSection);
                int oldLastExpandedSectionHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(lastExpandedSection);
                boolean accepted = lastExpandedSection.setSectionHeight(lastExpandedSectionHeight + heightDiff);
                if (!accepted) {
                    lastExpandedSection.setSectionExpanded(false, false, false);
                    int collapseImpact = oldLastExpandedSectionHeightBeforeCollapse - lastExpandedSection.computeHeaderHeight();
                    sectionToResize.setSectionHeight(curSectionHeight + collapseImpact);
                }
                if (lastExpandedSection.isExpanded()) {
                    if (!sectionToResize.isExpanded()) {
                        sectionToResize.setSectionExpanded(true, false, false);
                    }
                    sectionToResize.setSectionHeight(curSectionHeight - heightDiff);
                }
            }
        } else if (heightDiff < 0 && nextSection.isExpanded()) {
            requiresLayout = true;
            int oldNextSectionHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(nextSection);
            boolean accepted = nextSection.setSectionHeight(nextSectionHeight + heightDiff);
            if (!accepted) {
                nextSection.setSectionExpanded(false, false, false);
                int collapseImpact = oldNextSectionHeightBeforeCollapse - nextSection.computeHeaderHeight();
                sectionToResize.setSectionHeight(curSectionHeight + collapseImpact);
            }
            if (nextSection.isExpanded()) {
                if (!sectionToResize.isExpanded()) {
                    sectionToResize.setSectionExpanded(true, false, false);
                }
                sectionToResize.setSectionHeight(curSectionHeight - heightDiff);
            }
        } else if (heightDiff < 0 && !nextSection.isExpanded()) {
            SectionPart nextExpandedSection = TeamCentralResizer.getNextExpandedSection(sections, sectionToResize);
            if (nextExpandedSection != null) {
                requiresLayout = true;
                int nextExpandedSectionHeight = TeamCentralResizer.getSectionHeight(nextExpandedSection);
                int oldNextExpandedSectionHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(nextExpandedSection);
                boolean accepted = nextExpandedSection.setSectionHeight(nextExpandedSectionHeight + heightDiff);
                if (!accepted) {
                    nextExpandedSection.setSectionExpanded(false, false, false);
                    int collapseImpact = oldNextExpandedSectionHeightBeforeCollapse - nextExpandedSection.computeHeaderHeight();
                    sectionToResize.setSectionHeight(curSectionHeight + collapseImpact);
                }
                if (nextExpandedSection.isExpanded()) {
                    if (!sectionToResize.isExpanded()) {
                        sectionToResize.setSectionExpanded(true, false, false);
                    }
                    sectionToResize.setSectionHeight(curSectionHeight - heightDiff);
                }
            }
        } else if (heightDiff > 0 && withModKeyHold) {
            SectionPart lastExpandedSection;
            SectionPart firstExpandedSection = TeamCentralResizer.getFirstExpandedSection(sections, sectionToResize);
            if (firstExpandedSection != null) {
                requiresLayout = true;
                int previousExpandedSectionHeight = TeamCentralResizer.getSectionHeight(firstExpandedSection);
                int oldPreviousExpandedSectionToResizeHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(firstExpandedSection);
                boolean accepted = firstExpandedSection.setSectionHeight(previousExpandedSectionHeight - heightDiff);
                if (!accepted) {
                    firstExpandedSection.setSectionExpanded(false, false, false);
                    int collapseImpact = oldPreviousExpandedSectionToResizeHeightBeforeCollapse - firstExpandedSection.computeHeaderHeight();
                    nextSection.setSectionHeight(nextSectionHeight + collapseImpact);
                }
                if (firstExpandedSection.isExpanded()) {
                    if (!nextSection.isExpanded()) {
                        nextSection.setSectionExpanded(true, false, false);
                    }
                    nextSection.setSectionHeight(nextSectionHeight + heightDiff);
                }
            } else if (sectionToResize != null && sectionToResize.isExpanded() && sectionToResize == sections[0] && (lastExpandedSection = TeamCentralResizer.getLastExpandedSection(sections, sectionToResize)) != null) {
                requiresLayout = true;
                int lastExpandedSectionHeight = TeamCentralResizer.getSectionHeight(lastExpandedSection);
                int oldLastExpandedSectionHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(lastExpandedSection);
                boolean accepted = lastExpandedSection.setSectionHeight(lastExpandedSectionHeight + heightDiff);
                if (!accepted) {
                    lastExpandedSection.setSectionExpanded(false, false, false);
                    int collapseImpact = oldLastExpandedSectionHeightBeforeCollapse - lastExpandedSection.computeHeaderHeight();
                    sectionToResize.setSectionHeight(curSectionHeight + collapseImpact);
                }
                if (lastExpandedSection.isExpanded()) {
                    if (!sectionToResize.isExpanded()) {
                        sectionToResize.setSectionExpanded(true, false, false);
                    }
                    sectionToResize.setSectionHeight(curSectionHeight - heightDiff);
                }
            }
        } else if (heightDiff > 0 && sectionToResize.isExpanded()) {
            requiresLayout = true;
            int oldSectionToResizeHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(sectionToResize);
            boolean accepted = sectionToResize.setSectionHeight(curSectionHeight - heightDiff);
            if (!accepted) {
                sectionToResize.setSectionExpanded(false, false, false);
                int collapseImpact = oldSectionToResizeHeightBeforeCollapse - sectionToResize.computeHeaderHeight();
                nextSection.setSectionHeight(nextSectionHeight + collapseImpact);
            }
            if (sectionToResize.isExpanded()) {
                if (!nextSection.isExpanded()) {
                    nextSection.setSectionExpanded(true, false, false);
                }
                nextSection.setSectionHeight(nextSectionHeight + heightDiff);
            }
        } else if (heightDiff > 0 && !sectionToResize.isExpanded() && (previousExpandedSection = TeamCentralResizer.getPreviousExpandedSection(sections, sectionToResize)) != null) {
            requiresLayout = true;
            int previousExpandedSectionHeight = TeamCentralResizer.getSectionHeight(previousExpandedSection);
            int oldPreviousExpandedSectionToResizeHeightBeforeCollapse = TeamCentralResizer.getSectionHeight(previousExpandedSection);
            boolean accepted = previousExpandedSection.setSectionHeight(previousExpandedSectionHeight - heightDiff);
            if (!accepted) {
                previousExpandedSection.setSectionExpanded(false, false, false);
                int collapseImpact = oldPreviousExpandedSectionToResizeHeightBeforeCollapse - previousExpandedSection.computeHeaderHeight();
                nextSection.setSectionHeight(nextSectionHeight + collapseImpact);
            }
            if (previousExpandedSection.isExpanded()) {
                if (!nextSection.isExpanded()) {
                    nextSection.setSectionExpanded(true, false, false);
                }
                nextSection.setSectionHeight(nextSectionHeight + heightDiff);
            }
        }
        return requiresLayout;
    }

    private static int getSectionHeight(SectionPart part) {
        return part.getSize().y;
    }

    private static SectionPart getPreviousExpandedSection(SectionPart[] sections, SectionPart section) {
        int indexOfSection = TeamCentralResizer.indexOf(sections, section);
        int i = indexOfSection - 1;
        while (i >= 0) {
            SectionPart sectionPart = sections[i];
            if (sectionPart.isExpanded()) {
                return sectionPart;
            }
            --i;
        }
        return null;
    }

    private static SectionPart getFirstExpandedSection(SectionPart[] sections, SectionPart section) {
        int i = 0;
        while (i < sections.length) {
            SectionPart sectionPart = sections[i];
            if (sectionPart == section) break;
            if (sectionPart.isExpanded()) {
                return sectionPart;
            }
            ++i;
        }
        return null;
    }

    private static SectionPart getNextSection(SectionPart[] sections, SectionPart section) {
        int i = 0;
        while (i < sections.length) {
            SectionPart sectionPart = sections[i];
            if (sectionPart == section && i < sections.length - 1) {
                return sections[i + 1];
            }
            ++i;
        }
        return null;
    }

    private static SectionPart getNextExpandedSection(SectionPart[] sections, SectionPart section) {
        int indexOfSection = TeamCentralResizer.indexOf(sections, section);
        int i = indexOfSection + 1;
        while (i < sections.length) {
            SectionPart sectionPart = sections[i];
            if (sectionPart.isExpanded()) {
                return sectionPart;
            }
            ++i;
        }
        return null;
    }

    private static SectionPart getLastExpandedSection(SectionPart[] sections, SectionPart section) {
        int i = sections.length - 1;
        while (i > 0) {
            SectionPart sectionPart = sections[i];
            if (sectionPart == section) break;
            if (sectionPart.isExpanded()) {
                return sectionPart;
            }
            --i;
        }
        return null;
    }

    private static int indexOf(SectionPart[] sections, SectionPart section) {
        int i = 0;
        while (i < sections.length) {
            SectionPart sectionPart = sections[i];
            if (sectionPart == section) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

