/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.ISectionSiteProgressService;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.dashboard.ColorRegistry;
import com.ibm.team.jface.internal.dashboard.ErrorSection;
import com.ibm.team.jface.internal.dashboard.SectionTwistie;
import com.ibm.team.jface.internal.dashboard.views.Messages;
import com.ibm.team.jface.internal.dashboard.views.MultiTrackingSelectionProvider;
import com.ibm.team.jface.internal.dashboard.views.PerspectiveSectionSlot;
import com.ibm.team.jface.internal.dashboard.views.SectionDNDImpl;
import com.ibm.team.jface.internal.dashboard.views.SectionDescriptor;
import com.ibm.team.jface.internal.dashboard.views.SectionResizeMouseListener;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SectionPart
extends Composite {
    private static final boolean SHOW_LINK_ICON_IN_SECTION = true;
    public static final boolean SHOW_ICONS_IN_SECTIONS = false;
    public static final boolean ENABLE_CHEVRON = false;
    public static final boolean ENABLE_TWISTIE = true;
    private final DropTargetAdapter fgExpandingDropListener = new DropTargetAdapter(){
        private static final int EXPAND_HYSTERESIS = 500;
        private long fExpandBeginTime = 0L;

        public void dragOver(DropTargetEvent event) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    if (fExpandBeginTime == 0L) {
                        fExpandBeginTime = System.currentTimeMillis() + 500L;
                    } else if (System.currentTimeMillis() > fExpandBeginTime && !SectionPart.this.isExpanded()) {
                        SectionPart.this.setSectionExpanded(true, false, true);
                    }
                }
            });
            event.detail = 0;
        }

        public void dragEnter(DropTargetEvent event) {
            this.fExpandBeginTime = 0L;
        }

        public void dragLeave(DropTargetEvent event) {
            this.fExpandBeginTime = 0L;
        }
    };
    private static final int CHEVRON_HEIGHT = 12;
    public static final String EXTENSION_POINT_ID = "com.ibm.team.jface.expandableSection";
    public static final String SECTION_REQUIRED_INSTANCE = "requiredInstance";
    static final int OFFSCREEN = -200;
    int borderBottom = 0;
    int borderLeft = 0;
    int borderRight = 0;
    int borderTop = 0;
    Control fContent;
    Control fHeader;
    int highlight;
    private ResourceManager fResourceManager;
    private Image fChevronDownImage;
    private Image fChevronUpImage;
    private Label fChevron;
    private Composite fContentContainer;
    private Composite fContentContainerMargin;
    private Display fDisplay;
    private SectionDNDImpl fDndImpl;
    private Color fHeadBackground;
    private Color fHeaderGradientStart;
    private Color fHeaderGradientEnd;
    private Color fHeaderInnerBorder;
    private Color fHeaderOuterBorderTop;
    private Color fHeaderOuterBorderBottom;
    private Color fHeaderSeparator;
    private Composite fHeaderContainer;
    private SectionLabel fHeaderLabel;
    private Font fHeaderTeaseFont;
    private Font fHeaderBusyFont;
    private Font fHeaderBusyTeaseFont;
    private String fId;
    private boolean fIsErrorLoading = false;
    private boolean fIsExpanded;
    private boolean fIsOpenable;
    private boolean fIsDeletable;
    private boolean fIsCloneable;
    private boolean fIsTrimmed;
    private boolean fGrabExcassVerticalSpace;
    private MultiTrackingSelectionProvider fMultiTracker;
    private SectionDescriptor fSectionDescriptor;
    private int fSectionHeight = -1;
    private Image fSectionIcon;
    private ISection fSectionImpl;
    private Menu fSectionMenu;
    private SectionSite fSectionSite;
    private ToolBar fSectionToolBar;
    private TeamCentralView fTeamCentralView;
    private Composite fTeaser;
    private String fTitle;
    private SectionTwistie fTwistie;
    private boolean fTease;
    private boolean fBusy;
    private ISectionSiteProgressService fProgressService;
    public int horizontalSpacing = 1;
    public int marginHeight = 0;
    public int marginWidth = 0;
    Point oldSize;
    int separator = -1;
    boolean showBorder = false;
    private int fCachedHeaderHeight;
    public int verticalSpacing = 0;
    private SectionHeaderPainter fSectionHeaderPainter;

    public SectionPart(TeamCentralView view, Composite parent, MultiTrackingSelectionProvider multiTracker, SectionDescriptor sectionDescriptor, int style) {
        super(parent, SectionPart.checkStyle(style));
        super.setLayout((Layout)new SectionPartLayout());
        this.fTeamCentralView = view;
        this.fDisplay = parent.getDisplay();
        this.fMultiTracker = multiTracker;
        this.fSectionDescriptor = sectionDescriptor;
        this.fId = this.fSectionDescriptor.getId();
        this.fHeadBackground = parent.getBackground();
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        ColorDescriptor gradStart = ColorRegistry.getDefault().getColorDescriptor("SECTION_HEADER_GRADIENT_START");
        this.fHeaderGradientStart = this.fResourceManager.createColor(gradStart);
        ColorDescriptor gradEnd = ColorRegistry.getDefault().getColorDescriptor("SECTION_HEADER_GRADIENT_END");
        this.fHeaderGradientEnd = this.fResourceManager.createColor(gradEnd);
        ColorDescriptor headerInnerBorder = ColorRegistry.getDefault().getColorDescriptor("SECTION_HEADER_INNER_BORDER");
        this.fHeaderInnerBorder = this.fResourceManager.createColor(headerInnerBorder);
        ColorDescriptor headerOuterBorderTop = ColorRegistry.getDefault().getColorDescriptor("SECTION_HEADER_OUTER_BORDER_TOP");
        this.fHeaderOuterBorderTop = this.fResourceManager.createColor(headerOuterBorderTop);
        ColorDescriptor headerOuterBorderBottom = ColorRegistry.getDefault().getColorDescriptor("SECTION_HEADER_OUTER_BORDER_BOTTOM");
        this.fHeaderOuterBorderBottom = this.fResourceManager.createColor(headerOuterBorderBottom);
        ColorDescriptor headerSeparator = ColorRegistry.getDefault().getColorDescriptor("SECTION_HEADER_SEPARATOR");
        this.fHeaderSeparator = this.fResourceManager.createColor(headerSeparator);
        this.setBorderVisible((style & 0x800) != 0);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        SectionPart.this.onDispose();
                    }
                }
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 11: {
                        SectionPart.this.onResize();
                    }
                }
            }
        });
        this.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                SectionPart.this.getDisplay().timerExec(100, new Runnable(){

                    public void run() {
                        if (!SectionPart.this.isDisposed()) {
                            SectionPart.this.fTeamCentralView.firePageChanged(new PageChangedEvent((IPageChangeProvider)SectionPart.this.fTeamCentralView, (Object)SectionPart.this));
                        }
                    }
                });
            }
        });
        this.initData();
        this.fSectionSite = new SectionSite();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                JFacePlugin.getDefault().log(Messages.SectionPart_INIT_SECTION, e);
            }

            public void run() throws Exception {
                SectionPart.this.fSectionImpl.init(SectionPart.this.fSectionSite, SectionPart.this.fSectionDescriptor.getSavedUserSettings());
            }
        });
        this.fProgressService = new SectionSiteProgressService();
        this.fChevronDownImage = JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.CHEVRON_DN);
        this.fChevronUpImage = JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.CHEVRON_UP);
        Font defaultFont = JFaceResources.getDefaultFont();
        this.fHeaderTeaseFont = this.createFontVariant(defaultFont, 1);
        this.fHeaderBusyFont = this.createFontVariant(defaultFont, 2);
        this.fHeaderBusyTeaseFont = this.createFontVariant(defaultFont, 3);
        this.initComponents();
        if (this.fIsExpanded) {
            this.setSectionExpanded(true, false, false);
        }
    }

    public Point computeHeaderSize() {
        return this.fHeader.computeSize(-1, -1);
    }

    public int computeMinimalHeight(int wHint) {
        if (this.fIsExpanded) {
            // empty if block
        }
        return this.fHeader.computeSize((int)wHint, (int)-1).y + this.getBorderWidth() * 2;
    }

    public Point computePreferredSize(int wHint, int hHint) {
        Point headerSize = this.fHeader.computeSize(wHint, hHint);
        Point preferredContentSize = this.fSectionImpl.getPreferredContentSize(wHint, hHint);
        return new Point(headerSize.x + preferredContentSize.x, headerSize.y + preferredContentSize.y);
    }

    public Point computeSize(int wHint, int hHint) {
        Point size = super.computeSize(wHint, hHint);
        if (this.fSectionHeight != -1 && this.fIsExpanded) {
            size.y = this.fSectionHeight;
        }
        return size;
    }

    public int computeHeaderHeight() {
        if (this.fCachedHeaderHeight == 0) {
            this.fCachedHeaderHeight = this.fHeader.computeSize((int)-1, (int)-1).y;
        }
        return this.fCachedHeaderHeight;
    }

    public int computeHeight(int wHint, int hHint) {
        if (this.fSectionHeight != -1 && this.fIsExpanded) {
            return this.fSectionHeight;
        }
        return super.computeSize((int)wHint, (int)hHint).y;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (this.fSectionHeight != -1 && this.fIsExpanded) {
            size.y = this.fSectionHeight;
        }
        return size;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.borderLeft - this.highlight;
        int trimY = y - this.borderTop - this.highlight;
        int trimWidth = width + this.borderLeft + this.borderRight + 2 * this.highlight;
        int trimHeight = height + this.borderTop + this.borderBottom + 2 * this.highlight;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    private void fireExpandableSectionEvent(boolean gotExpanded) {
        if (this.fSectionImpl == null) {
            return;
        }
        if (gotExpanded) {
            this.fHeaderLabel.setCursor(null);
            this.fSectionSite.fireExpand();
            if (!this.fTeamCentralView.isMaximizeSupport() && !this.fTeamCentralView.isOpenViewSupport()) {
                this.fHeaderLabel.setCursor(this.fDisplay.getSystemCursor(0));
            }
        } else {
            this.fSectionSite.fireCollapse();
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle clientArea = super.getClientArea();
        clientArea.x += this.borderLeft;
        clientArea.y += this.borderTop;
        clientArea.width -= this.borderLeft + this.borderRight;
        clientArea.height -= this.borderTop + this.borderBottom;
        return clientArea;
    }

    private MouseAdapter getHeaderMouseAdapter() {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                SectionPart.this.setHeaderTeasing(false);
                if (e.button == 1 && !SectionPart.this.fTeamCentralView.isMaximizeSupport() && !SectionPart.this.fTeamCentralView.isOpenViewSupport()) {
                    SectionPart.this.setSectionExpanded(!SectionPart.this.fIsExpanded, true, true);
                } else if (e.button == 1) {
                    Control focusControl = SectionPart.this.fDisplay.getFocusControl();
                    SectionPart.this.fSectionImpl.setFocus();
                    if (focusControl == SectionPart.this.fDisplay.getFocusControl() && focusControl != SectionPart.this.fTwistie) {
                        SectionPart.this.fTwistie.setFocus();
                    }
                }
            }
        };
    }

    public String getId() {
        return this.fId;
    }

    public SectionDescriptor getSectionDescriptor() {
        return this.fSectionDescriptor;
    }

    public int getSectionHeight() {
        return this.fSectionHeight;
    }

    public ISection getSectionImpl() {
        return this.fSectionImpl;
    }

    SectionSite getSectionSite() {
        return this.fSectionSite;
    }

    private void initComponents() {
        Control child;
        Control[] children;
        this.setBackground(this.fHeadBackground);
        int cols = 2;
        GridLayout headerLayout = new GridLayout(++cols, false);
        headerLayout.marginHeight = 4;
        headerLayout.marginLeft = 2;
        headerLayout.marginWidth = 3;
        headerLayout.horizontalSpacing = 0;
        this.fHeaderContainer = new Composite((Composite)this, 0);
        this.fHeaderContainer.setLayout((Layout)headerLayout);
        this.fHeaderContainer.setCursor(this.fDisplay.getSystemCursor(0));
        this.fHeaderContainer.setBackgroundMode(2);
        this.fSectionHeaderPainter = new SectionHeaderPainter();
        this.fSectionHeaderPainter.updateTeaserBackgroundImage();
        this.fDndImpl = new SectionDNDImpl(this.fTeamCentralView, this);
        this.fHeaderContainer.addMouseListener((MouseListener)this.fDndImpl);
        this.fHeaderContainer.addMouseMoveListener((MouseMoveListener)this.fDndImpl);
        SectionResizeMouseListener sectionResizeListener = new SectionResizeMouseListener(this, this.fDndImpl);
        this.fHeaderContainer.addListener(5, (Listener)sectionResizeListener);
        this.fHeaderContainer.addListener(3, (Listener)sectionResizeListener);
        this.fHeaderContainer.addListener(4, (Listener)sectionResizeListener);
        this.fHeaderContainer.addListener(7, (Listener)sectionResizeListener);
        GridLayout topLeftLayout = new GridLayout(2, false);
        topLeftLayout.marginWidth = 0;
        topLeftLayout.marginHeight = 0;
        topLeftLayout.horizontalSpacing = 3;
        Composite topleftContainer = new Composite(this.fHeaderContainer, 0);
        topleftContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        topleftContainer.setLayout((Layout)topLeftLayout);
        topleftContainer.setCursor(this.fDisplay.getSystemCursor(0));
        topleftContainer.addMouseListener((MouseListener)this.getHeaderMouseAdapter());
        this.fTwistie = new SectionTwistie(topleftContainer, 0);
        this.fTwistie.setBackground(topleftContainer.getBackground());
        this.fTwistie.setLayoutData(new GridData(1, 0x1000000, false, true));
        ((GridData)this.fTwistie.getLayoutData()).exclude = false;
        this.fTwistie.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                SectionPart.this.setHeaderTeasing(false);
                SectionPart.this.setSectionExpanded(!SectionPart.this.fIsExpanded, true, true);
            }
        });
        this.fTwistie.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                SectionPart.this.fTwistie.setDrawHighlighted(true);
                SectionPart.this.fTwistie.redraw();
            }

            public void mouseExit(MouseEvent e) {
                SectionPart.this.fTwistie.setDrawHighlighted(false);
                SectionPart.this.fTwistie.redraw();
            }
        });
        this.fHeaderLabel = new SectionLabel(topleftContainer, 0);
        this.fHeaderLabel.setText(this.fTitle);
        this.fHeaderLabel.addMouseListener((MouseListener)this.getHeaderMouseAdapter());
        this.fHeaderLabel.setLayoutData(new GridData(4, 0x1000000, true, true));
        if (!this.fTeamCentralView.isMaximizeSupport() && !this.fTeamCentralView.isOpenViewSupport()) {
            this.fHeaderLabel.setCursor(this.fDisplay.getSystemCursor(0));
        }
        MouseAdapter doubleClickListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SectionPart.this.fTeamCentralView.isMaximizeSupport() && !SectionPart.this.fTeamCentralView.isOpenViewSupport()) {
                    SectionPart.this.fTeamCentralView.getSectionsManager().maximizeSection(SectionPart.this);
                } else if (SectionPart.this.fTeamCentralView.isOpenViewSupport() && SectionPart.this.fSectionImpl instanceof ISectionListener) {
                    ((ISectionListener)((Object)SectionPart.this.fSectionImpl)).sectionOpened();
                }
            }
        };
        this.fHeaderLabel.addMouseListener((MouseListener)doubleClickListener);
        this.fHeaderLabel.addMouseListener(this.fDndImpl);
        this.fHeaderLabel.addMouseMoveListener(this.fDndImpl);
        this.fTeaser = new Composite(this.fHeaderContainer, 0);
        this.fTeaser.setCursor(this.fDisplay.getSystemCursor(0));
        this.fTeaser.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fTeaser.addMouseListener((MouseListener)this.getHeaderMouseAdapter());
        this.fTeaser.addMouseListener((MouseListener)doubleClickListener);
        if (!this.fTeamCentralView.isMaximizeSupport() && !this.fTeamCentralView.isOpenViewSupport()) {
            this.fTeaser.setCursor(this.fDisplay.getSystemCursor(0));
        }
        this.fTeaser.addMouseListener((MouseListener)this.fDndImpl);
        this.fTeaser.addMouseMoveListener((MouseMoveListener)this.fDndImpl);
        this.fSectionToolBar = new ToolBar(this.fHeaderContainer, 0x800000);
        this.fSectionToolBar.setCursor(this.fDisplay.getSystemCursor(0));
        this.fSectionMenu = new Menu((Control)this.fSectionToolBar);
        this.fSectionToolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SectionPart.this.fSectionMenu.dispose();
            }
        });
        final ToolItem sectionToolBarDropDownItem = new ToolItem(this.fSectionToolBar, 8);
        sectionToolBarDropDownItem.setToolTipText(Messages.SectionPart_MENU);
        sectionToolBarDropDownItem.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.DROP_DOWN));
        sectionToolBarDropDownItem.setDisabledImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.DROP_DOWN_DISABLED));
        sectionToolBarDropDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = sectionToolBarDropDownItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = SectionPart.this.fSectionToolBar.toDisplay(pt);
                SectionPart.this.fSectionMenu.setLocation(pt.x, pt.y);
                SectionPart.this.fSectionMenu.setVisible(true);
            }
        });
        ToolItem openViewItem = new ToolItem(this.fSectionToolBar, 8);
        openViewItem.setToolTipText(NLS.bind((String)Messages.SectionPart_OPEN_SECTION, (Object)this.fSectionSite.getName()));
        openViewItem.setEnabled(this.fSectionDescriptor != null && this.fSectionDescriptor.isOpenable());
        openViewItem.setImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.LNCH_VIEW));
        openViewItem.setDisabledImage(JazzResources.getImageWithDefault(this.fResourceManager, ImagePool.LNCH_VIEW_DISABLED));
        openViewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SectionPart.this.fSectionImpl != null) {
                    SectionPart.this.setHeaderTeasing(false);
                    SectionPart.this.fSectionSite.fireOpen();
                }
            }
        });
        GridLayout noMarginsGrid = new GridLayout(1, false);
        noMarginsGrid.marginWidth = 0;
        noMarginsGrid.marginHeight = 0;
        this.fTeaser.setLayout((Layout)noMarginsGrid);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                JFacePlugin.getDefault().log(Messages.SectionPart_CREATING_TEASER, e);
            }

            public void run() throws Exception {
                SectionPart.this.fSectionImpl.createTeaser(SectionPart.this.fTeaser);
            }
        });
        Control[] controlArray = children = this.fTeaser.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            this.hookListeners(child, (MouseListener)doubleClickListener);
            ++n2;
        }
        controlArray = children = this.fHeaderContainer.getChildren();
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            this.hookMenu(child);
            ++n2;
        }
        controlArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            this.hookDropTarget(child);
            ++n2;
        }
        this.setHeader((Control)this.fHeaderContainer);
    }

    private void hookDropTarget(Control c) {
        DropTarget target = new DropTarget(c, 23);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)this.fgExpandingDropListener);
    }

    private void hookMenu(Control c) {
        c.setMenu(this.fTeamCentralView.getSectionsManager().getSectionMenu(c, this));
        if (c instanceof Composite) {
            Control[] childs;
            Control[] controlArray = childs = ((Composite)c).getChildren();
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookMenu(child);
                ++n2;
            }
        }
    }

    private void hookListeners(Control c, MouseListener listener) {
        if (c instanceof SectionLabel || c instanceof Label) {
            c.addMouseListener(listener);
            c.addMouseListener((MouseListener)this.getHeaderMouseAdapter());
            c.addMouseListener((MouseListener)this.fDndImpl);
            c.addMouseMoveListener((MouseMoveListener)this.fDndImpl);
        } else if (c instanceof Composite) {
            Control[] childs;
            Control[] controlArray = childs = ((Composite)c).getChildren();
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookListeners(child, listener);
                ++n2;
            }
        }
    }

    private void initData() {
        this.fTitle = this.fSectionDescriptor.getName();
        if (this.fSectionDescriptor.createSection()) {
            this.fSectionImpl = this.fSectionDescriptor.getSection();
        } else {
            this.fSectionImpl = new ErrorSection(this.fTeamCentralView.getSectionsManager(), this.fSectionDescriptor);
            this.fIsErrorLoading = true;
        }
        PerspectiveSectionSlot secContainer = this.fTeamCentralView.getPerspectivesManager().getSectionSlot(this.fId);
        String imgPath = this.fSectionDescriptor.getSectionIconPath();
        if (imgPath != null && imgPath.length() > 0 && this.fSectionDescriptor.getNamespace() != null) {
            this.fSectionIcon = JazzResources.getImageWithDefault(this.fResourceManager, AbstractUIPlugin.imageDescriptorFromPlugin((String)this.fSectionDescriptor.getNamespace(), (String)imgPath));
        }
        this.fIsExpanded = secContainer.isExpanded();
        this.fGrabExcassVerticalSpace = secContainer.isGrabExcessVerticalSpace();
        this.fSectionHeight = secContainer.getHeight();
        this.fIsOpenable = this.fSectionDescriptor.isOpenable();
        this.fIsDeletable = this.fSectionDescriptor.isDeletable();
        this.fIsCloneable = this.fSectionDescriptor.isCloneable();
        if (this.fIsErrorLoading) {
            this.fSectionHeight = -1;
        }
    }

    public boolean isErrorLoading() {
        return this.fIsErrorLoading;
    }

    public boolean isExpanded() {
        return this.fIsExpanded;
    }

    boolean isOpenable() {
        return this.fIsOpenable;
    }

    boolean isCloneable() {
        return this.fIsCloneable;
    }

    boolean isDeletable() {
        return this.fIsDeletable;
    }

    public boolean isTrimmed() {
        return this.fIsTrimmed;
    }

    public boolean isGrabExcessVerticalSpace() {
        return this.fGrabExcassVerticalSpace;
    }

    public void notifyResize() {
        if (this.fSectionImpl != null) {
            this.fSectionSite.fireResize();
        }
    }

    void onDispose() {
        this.fHeader = null;
        this.fTeaser = null;
        this.fContent = null;
        this.oldSize = null;
        if (this.fSectionImpl != null) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    JFacePlugin.getDefault().log(Messages.SectionPart_DISPOSING_SECTION, e);
                }

                public void run() throws Exception {
                    SectionPart.this.fSectionImpl.dispose();
                }
            });
        }
        if (this.fHeaderContainer != null) {
            this.fHeaderContainer.dispose();
        }
        if (this.fContentContainer != null) {
            this.fContentContainer.dispose();
        }
        if (this.fHeadBackground != null && this.fHeadBackground != this.getDisplay().getSystemColor(1)) {
            this.fHeadBackground.dispose();
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    void onResize() {
        Point size = this.getSize();
        if (this.oldSize == null || this.oldSize.x == 0 || this.oldSize.y == 0) {
            this.redraw();
        } else {
            int width = 0;
            if (this.oldSize.x < size.x) {
                width = size.x - this.oldSize.x + this.borderRight + this.highlight;
            } else if (this.oldSize.x > size.x) {
                width = this.borderRight + this.highlight;
            }
            this.redraw(size.x - width, 0, width, size.y, false);
            int height = 0;
            if (this.oldSize.y < size.y) {
                height = size.y - this.oldSize.y + this.borderBottom + this.highlight;
            }
            if (this.oldSize.y > size.y) {
                height = this.borderBottom + this.highlight;
            }
            this.redraw(0, size.y - height, size.x, height, false);
        }
        this.oldSize = size;
    }

    private void registerFocusHandler() {
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SectionPart.this.setHeaderTeasing(false);
                if (!SectionPart.this.fIsTrimmed && SectionPart.this.fTeamCentralView.getSectionsManager().getLastSelectedSection() != SectionPart.this) {
                    SectionPart.this.fTeamCentralView.getSectionsManager().setLastSelectedSection(SectionPart.this);
                    SectionPart.this.fTeamCentralView.layoutAnimated();
                }
            }
        };
        this.registerFocusHandler((Control)this.fContentContainer, focusAdapter);
    }

    private void registerFocusHandler(Control control, FocusAdapter focusAdapter) {
        control.addFocusListener((FocusListener)focusAdapter);
        if (control instanceof Composite) {
            Control[] children = ((Composite)control).getChildren();
            int a = 0;
            while (a < children.length) {
                this.registerFocusHandler(children[a], focusAdapter);
                ++a;
            }
        }
    }

    private void registerHoverHandler() {
        MouseTrackAdapter mouseTrackAdapter = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                if (!SectionPart.this.fTeamCentralView.isRestoreSectionOnHoverAndFocus()) {
                    return;
                }
                SectionPart.this.setHeaderTeasing(false);
                if (SectionPart.this.fIsTrimmed && SectionPart.this.fTeamCentralView.getSectionsManager().getLastSelectedSection() != SectionPart.this) {
                    SectionPart.this.fTeamCentralView.getSectionsManager().setLastSelectedSection(SectionPart.this);
                    SectionPart.this.fTeamCentralView.layoutAnimated();
                }
            }
        };
        this.registerHoverHandler((Control)this.fContentContainer, mouseTrackAdapter);
    }

    private void registerHoverHandler(Control control, MouseTrackAdapter hoverAdapter) {
        control.addMouseTrackListener((MouseTrackListener)hoverAdapter);
        if (control instanceof Composite) {
            int a = 0;
            while (a < ((Composite)control).getChildren().length) {
                this.registerHoverHandler(((Composite)control).getChildren()[a], hoverAdapter);
                ++a;
            }
        }
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.showBorder == show) {
            return;
        }
        this.showBorder = show;
        if (this.showBorder) {
            this.borderBottom = 1;
            if ((this.getStyle() & 0x800000) == 0) {
                this.highlight = 2;
            }
        } else {
            this.borderRight = 0;
            this.borderLeft = 0;
            this.borderTop = 0;
            this.borderBottom = 0;
            this.highlight = 0;
        }
        this.layout(false);
        this.redraw();
    }

    public void setChevronVisible(boolean visible) {
        if (this.fChevron != null && this.fChevron.isVisible() != visible) {
            this.fChevron.setVisible(visible);
            this.fChevron.redraw();
        }
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (content != null && content.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.fContent != null && !this.fContent.isDisposed()) {
            this.fContent.setBounds(-200, -200, 0, 0);
        }
        this.fContent = content;
        this.layout(false);
    }

    public void setHeadBackground(Color headBackground) {
        this.fHeadBackground = headBackground;
    }

    public void setHeader(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.fHeader != null && !this.fHeader.isDisposed()) {
            Point size = this.fHeader.getSize();
            this.fHeader.setLocation(-200 - size.x, -200 - size.y);
        }
        this.fHeader = c;
        this.layout(false);
    }

    private void setHeaderTeasing(boolean tease) {
        this.fTease = tease;
        if (this.fHeaderLabel.isDisposed()) {
            return;
        }
        this.updateFont();
        this.fHeaderContainer.layout(true, true);
    }

    private void updateFont() {
        if (this.fHeaderLabel == null || this.fHeaderLabel.isDisposed()) {
            return;
        }
        Font font = this.fHeaderLabel.getFont() != this.fHeaderTeaseFont && this.fTease && !this.fBusy ? this.fHeaderTeaseFont : (this.fHeaderLabel.getFont() != this.fHeaderTeaseFont && !this.fTease && this.fBusy ? this.fHeaderBusyFont : (this.fHeaderLabel.getFont() != this.fHeaderTeaseFont && this.fTease && this.fBusy ? this.fHeaderBusyTeaseFont : JFaceResources.getFontRegistry().get("")));
        if (this.fHeaderLabel.getFont() != font) {
            this.fHeaderLabel.setFont(font);
        }
    }

    public void setIsTrimmed(boolean isTrimmed) {
        this.fIsTrimmed = isTrimmed;
        this.setChevronDirection(this.fChevronDownImage);
    }

    private void setChevronDirection(Image direction) {
        if (this.fChevron != null && this.fChevron.getImage() != direction) {
            this.fChevron.setImage(direction);
            if (direction == this.fChevronDownImage) {
                this.fChevron.setToolTipText(Messages.SectionPart_SHOW_MORE);
            }
            if (direction == this.fChevronUpImage) {
                this.fChevron.setToolTipText(Messages.SectionPart_SHOW_LESS);
            }
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setSectionExpanded(boolean expanded, boolean giveTwistieFocus, boolean layout) {
        this.fireExpandableSectionEvent(expanded);
        this.fTwistie.setExpanded(expanded);
        if (giveTwistieFocus && !this.fTwistie.isFocusControl()) {
            this.fTwistie.setFocus();
        }
        Point headerSize = this.computeHeaderSize();
        int minExpandedSize = headerSize.y * 3;
        if (expanded && this.fContentContainer == null) {
            GridLayout contentMarginGrid = new GridLayout(2, false);
            contentMarginGrid.marginHeight = 0;
            contentMarginGrid.marginWidth = 0;
            contentMarginGrid.horizontalSpacing = 0;
            contentMarginGrid.verticalSpacing = 0;
            this.fContentContainerMargin = new Composite((Composite)this, 0);
            this.fContentContainerMargin.setLayout((Layout)contentMarginGrid);
            this.fContentContainerMargin.setBackground(this.getBackground());
            GridLayout chevronGrid = new GridLayout(1, false);
            chevronGrid.marginHeight = 0;
            chevronGrid.marginWidth = 0;
            chevronGrid.marginLeft = 2;
            chevronGrid.marginRight = 3;
            chevronGrid.marginBottom = 3;
            Composite chevronContainer = new Composite(this.fContentContainerMargin, 0);
            chevronContainer.setBackground(this.getBackground());
            chevronContainer.setLayout((Layout)chevronGrid);
            chevronContainer.setLayoutData((Object)new GridData(1, 0x1000008, false, true));
            this.fChevron = new Label(chevronContainer, 0);
            this.fChevron.setBackground(this.getBackground());
            this.fChevron.setLayoutData((Object)new GridData(1, 0x1000008, false, true));
            this.fChevron.setCursor(this.fDisplay.getSystemCursor(21));
            this.setChevronDirection(this.fChevronDownImage);
            this.fChevron.setVisible(false);
            this.fChevron.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    SectionPart.this.setHeaderTeasing(false);
                    SectionPart lastSelectedSection = null;
                    if (SectionPart.this.fTeamCentralView.getSectionsManager().getLastSelectedSection() != SectionPart.this) {
                        lastSelectedSection = SectionPart.this.fTeamCentralView.getSectionsManager().getLastSelectedSection();
                    }
                    if (SectionPart.this.fChevron.getImage().equals((Object)SectionPart.this.fChevronDownImage)) {
                        int tmpSectionHeight = SectionPart.this.fSectionHeight;
                        int preferredContentHeight = ((SectionPart)SectionPart.this).fSectionImpl.getPreferredContentSize((int)-1, (int)-1).y;
                        int preferredSectionHeight = SectionPart.this.fHeader.computeSize((int)-1, (int)-1).y + preferredContentHeight;
                        SectionPart.this.fTeamCentralView.getSectionsManager().setLastSelectedSection(SectionPart.this);
                        SectionPart.this.fSectionHeight = preferredSectionHeight;
                        SectionPart.this.fTeamCentralView.layoutAnimated();
                        SectionPart.this.fSectionSite.fireMaximize(SectionPart.this.getBounds().height < preferredSectionHeight);
                        SectionPart.this.setChevronDirection(SectionPart.this.fChevronUpImage);
                        SectionPart.this.fSectionHeight = tmpSectionHeight;
                        SectionPart.this.setChevronVisible(true);
                    } else if (SectionPart.this.fChevron.getImage().equals((Object)SectionPart.this.fChevronUpImage)) {
                        SectionPart.this.fTeamCentralView.getSectionsManager().setLastSelectedSection(lastSelectedSection);
                        SectionPart.this.setChevronDirection(SectionPart.this.fChevronDownImage);
                        SectionPart.this.fTeamCentralView.layoutAnimated();
                    }
                }
            });
            ((GridLayout)this.fContentContainerMargin.getLayout()).marginWidth = 0;
            chevronContainer.setVisible(false);
            ((GridData)chevronContainer.getLayoutData()).exclude = true;
            this.fContentContainer = new Composite(this.fContentContainerMargin, 0);
            this.fContentContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fContentContainer.setBackground(this.getBackground());
            this.fContentContainer.setLayout((Layout)new DefaultContentLayout(this.fSectionImpl));
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    JFacePlugin.getDefault().log(Messages.SectionPart_CREATING_CONTENT, e);
                }

                public void run() throws Exception {
                    SectionPart.this.fSectionImpl.createContent(SectionPart.this.fContentContainer);
                }
            });
            this.registerFocusHandler();
            this.registerHoverHandler();
            this.setContent((Control)this.fContentContainerMargin);
            if (this.fSectionHeight == -1) {
                Point contentSize = this.fSectionImpl.getDefaultContentSize();
                if (contentSize.y == -1) {
                    contentSize.y = this.fContentContainer.computeSize((int)-1, (int)-1).y;
                }
                this.fSectionHeight = headerSize.y + contentSize.y;
            } else if (this.fSectionHeight < minExpandedSize) {
                this.fSectionHeight = minExpandedSize;
            }
        } else if (expanded && this.fSectionHeight < minExpandedSize) {
            this.fSectionHeight = minExpandedSize;
        }
        if (this.fContent == null) {
            this.setContent((Control)this.fContentContainerMargin);
        }
        this.fIsExpanded = expanded;
        PerspectiveSectionSlot secContainer = this.fTeamCentralView.getPerspectivesManager().getSectionSlot(this.fId);
        secContainer.setExpanded(this.fIsExpanded);
        secContainer.setGrabExcessVerticalSpace(this.fGrabExcassVerticalSpace);
        this.fTeamCentralView.getSectionsManager().setLastSelectedSection(this);
        if (this.fIsExpanded) {
            this.fContentContainerMargin.setVisible(true);
        }
        if (layout) {
            this.fTeamCentralView.layoutAnimated();
        }
        this.fSectionHeaderPainter.updateTeaserBackgroundImage();
        if (!this.fIsExpanded && this.fContentContainerMargin != null) {
            this.fContentContainerMargin.setVisible(false);
        }
        if (expanded && giveTwistieFocus) {
            this.fTeamCentralView.getSectionsManager().updateContext(this);
        }
    }

    public void setGrabExcessVerticalSpace(boolean grabExcessVerticalSpace, boolean layout) {
        if (grabExcessVerticalSpace != this.fGrabExcassVerticalSpace) {
            this.fGrabExcassVerticalSpace = grabExcessVerticalSpace;
            if (layout) {
                this.fTeamCentralView.layoutAnimated();
            }
        }
    }

    public boolean setSectionHeight(int sectionHeight) {
        if (sectionHeight >= this.computeMinimalHeight(-1) || sectionHeight == -1) {
            this.fSectionHeight = sectionHeight;
            this.fTeamCentralView.getPerspectivesManager().getSectionSlot(this.fId).setHeight(this.fSectionHeight);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.fTitle;
    }

    public void updateGradient() {
        if (this.fContentContainerMargin != null) {
            this.fContentContainerMargin.redraw();
        }
    }

    static int checkStyle(int style) {
        int mask = 0x6800000;
        return style & mask | 0x100000;
    }

    void redrawTeaser() {
        if (this.fSectionHeaderPainter != null && this.fHeaderContainer != null && !this.fHeaderContainer.isDisposed()) {
            this.fSectionHeaderPainter.updateTeaserBackgroundImage();
        }
    }

    private Font createFontVariant(Font font, int style) {
        FontData[] fontData = font.getFontData();
        int a = 0;
        while (a < fontData.length) {
            fontData[a].setStyle(style);
            ++a;
        }
        FontDescriptor descriptor = FontDescriptor.createFrom((FontData[])fontData);
        return JazzResources.getFont(this.fResourceManager, descriptor, font);
    }

    static class DefaultContentLayout
    extends Layout {
        private ISection fSection;

        public DefaultContentLayout(ISection iSection) {
            this.fSection = iSection;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point parentSize = composite.getSize();
            Point defaultContentSize = this.fSection.getDefaultContentSize();
            if (defaultContentSize.x == -1) {
                defaultContentSize.x = parentSize.x;
            }
            if (defaultContentSize.y == -1) {
                defaultContentSize.y = parentSize.y;
            }
            return defaultContentSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Point parentSize = composite.getSize();
            Point minimalContentSize = this.fSection.getMinimalContentSize();
            Point childrenSize = new Point(-1, -1);
            childrenSize.x = minimalContentSize.x == -1 ? parentSize.x : (parentSize.x > minimalContentSize.x ? parentSize.x : minimalContentSize.x);
            childrenSize.y = minimalContentSize.y == -1 ? parentSize.y : (parentSize.y > minimalContentSize.y ? parentSize.y : minimalContentSize.y);
            if (composite.getChildren().length != 0) {
                composite.getChildren()[0].setSize(childrenSize.x, childrenSize.y);
            }
        }
    }

    private class SectionHeaderPainter {
        public SectionHeaderPainter() {
            SectionPart.this.fHeaderContainer.setBackgroundMode(1);
            SectionPart.this.fHeaderContainer.setBackground(SectionPart.this.fHeaderGradientStart);
            this.updateTeaserBackgroundImage();
            SectionPart.this.fHeaderContainer.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    SectionHeaderPainter.this.updateTeaserBackgroundImage();
                }
            });
            SectionPart.this.fHeaderContainer.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    Image backgroundImage = SectionPart.this.fHeaderContainer.getBackgroundImage();
                    if (backgroundImage != null && !backgroundImage.isDisposed()) {
                        backgroundImage.dispose();
                    }
                }
            });
        }

        void updateTeaserBackgroundImage() {
            Rectangle rect = SectionPart.this.fHeaderContainer.getClientArea();
            Point location = SectionPart.this.getLocation();
            if (!rect.isEmpty()) {
                int height = Math.max(1, rect.height);
                Image newImage = new Image((Device)SectionPart.this.fHeaderContainer.getDisplay(), 1, height);
                GC gc = new GC((Drawable)newImage);
                gc.setForeground(SectionPart.this.fHeaderGradientStart);
                gc.setBackground(SectionPart.this.fHeaderGradientEnd);
                gc.fillGradientRectangle(rect.x, rect.y, 1, height, true);
                if (SectionPart.this.isExpanded()) {
                    gc.setForeground(location.y == 0 ? SectionPart.this.fHeaderGradientStart : SectionPart.this.fHeaderOuterBorderTop);
                    gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                    gc.setForeground(SectionPart.this.fHeaderOuterBorderBottom);
                    gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
                    gc.setForeground(location.y == 0 ? SectionPart.this.fHeaderGradientStart : SectionPart.this.fHeaderInnerBorder);
                    gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
                    gc.setForeground(SectionPart.this.fHeaderInnerBorder);
                    gc.drawLine(rect.x, rect.y + rect.height - 2, rect.x + rect.width, rect.y + rect.height - 2);
                } else {
                    gc.setForeground(location.y == 0 ? SectionPart.this.fHeaderGradientStart : SectionPart.this.fHeaderOuterBorderTop);
                    gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                    gc.setForeground(SectionPart.this.fHeaderOuterBorderBottom);
                    gc.drawLine(rect.x, rect.y + rect.height - 2, rect.x + rect.width, rect.y + rect.height - 2);
                    gc.setForeground(location.y == 0 ? SectionPart.this.fHeaderGradientStart : SectionPart.this.fHeaderInnerBorder);
                    gc.drawLine(rect.x, rect.y + 1, rect.x + rect.width, rect.y + 1);
                    gc.setForeground(SectionPart.this.fHeaderInnerBorder);
                    gc.drawLine(rect.x, rect.y + rect.height - 3, rect.x + rect.width, rect.y + rect.height - 3);
                    gc.setForeground(SectionPart.this.fHeaderSeparator);
                    gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
                }
                gc.dispose();
                Image oldImage = SectionPart.this.fHeaderContainer.getBackgroundImage();
                SectionPart.this.fHeaderContainer.setBackgroundImage(newImage);
                if (oldImage != null && !oldImage.isDisposed()) {
                    oldImage.dispose();
                }
            }
        }
    }

    static class SectionPartLayout
    extends Layout {
        SectionPartLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            SectionPart section = (SectionPart)composite;
            Control left = section.fHeader;
            Object right = null;
            Control content = section.fContent;
            Point leftSize = new Point(0, 0);
            if (left != null) {
                leftSize = left.computeSize(-1, -1, flushCache);
            }
            Point rightSize = new Point(0, 0);
            if (right != null) {
                rightSize = right.computeSize(-1, -1, flushCache);
            }
            Point size = new Point(0, 0);
            if (wHint != -1 && leftSize.x + rightSize.x > wHint) {
                size.x = leftSize.x + rightSize.x;
                if (leftSize.x > 0 && rightSize.x > 0) {
                    size.x += section.horizontalSpacing;
                }
                size.y = Math.max(leftSize.y, rightSize.y);
            } else {
                size.x = leftSize.x + rightSize.x;
                int count = -1;
                if (leftSize.x > 0) {
                    ++count;
                }
                if (rightSize.x > 0) {
                    ++count;
                }
                if (count > 0) {
                    size.x += count * section.horizontalSpacing;
                }
                size.y = Math.max(leftSize.y, rightSize.y);
            }
            if (content != null && section.isExpanded()) {
                Point contentSize = new Point(0, 0);
                contentSize = content.computeSize(-1, -1, flushCache);
                size.x = Math.max(size.x, contentSize.x);
                size.y += contentSize.y;
                if (size.y > contentSize.y) {
                    size.y += section.verticalSpacing;
                }
            }
            size.x += 2 * section.marginWidth;
            size.y += 2 * section.marginHeight;
            if (wHint != -1) {
                size.x = wHint;
            }
            if (hHint != -1) {
                size.y = hHint;
            }
            return size;
        }

        int computeTrim(Control c) {
            if (c instanceof Scrollable) {
                Rectangle rect = ((Scrollable)c).computeTrim(0, 0, 0, 0);
                return rect.width;
            }
            return c.getBorderWidth() * 2;
        }

        protected boolean flushCache(Control control) {
            return true;
        }

        protected void layout(Composite composite, boolean flushCache) {
            int topHeight;
            SectionPart section = (SectionPart)composite;
            Control left = section.fHeader;
            Object right = null;
            Control content = section.fContent;
            Rectangle rect = composite.getClientArea();
            Point leftSize = new Point(0, 0);
            if (left != null && !left.isDisposed()) {
                leftSize = left.computeSize(-1, -1, flushCache);
            }
            Point rightSize = new Point(0, 0);
            if (right != null && !right.isDisposed()) {
                rightSize = right.computeSize(-1, -1, flushCache);
            }
            int minTopWidth = leftSize.x + rightSize.x + 2 * section.marginWidth + 2 * section.highlight;
            int count = -1;
            if (leftSize.x > 0) {
                ++count;
            }
            if (rightSize.x > 0) {
                ++count;
            }
            if (count > 0) {
                minTopWidth += count * section.horizontalSpacing;
            }
            int x = rect.x + rect.width - section.marginWidth - section.highlight;
            int y = rect.y + section.marginHeight + section.highlight;
            boolean top = false;
            if (minTopWidth > rect.width) {
                topHeight = Math.max(rightSize.y, leftSize.y);
                if (right != null && !right.isDisposed()) {
                    top = true;
                    right.setBounds(x -= rightSize.x, y, rightSize.x, topHeight);
                    x -= section.horizontalSpacing;
                }
                if (left != null && !left.isDisposed()) {
                    top = true;
                    int trim = this.computeTrim(left);
                    int leftW = x - rect.x - section.marginWidth - section.highlight - trim;
                    leftSize = left.computeSize(leftW, -1, false);
                    left.setBounds(rect.x + section.marginWidth + section.highlight, y, leftSize.x, topHeight);
                }
                if (top) {
                    y += topHeight + section.verticalSpacing;
                }
            } else {
                topHeight = Math.max(rightSize.y, leftSize.y);
                if (right != null && !right.isDisposed()) {
                    top = true;
                    right.setBounds(x -= rightSize.x, y, rightSize.x, topHeight);
                    x -= section.horizontalSpacing;
                }
                if (left != null && !left.isDisposed()) {
                    top = true;
                    Rectangle trim = left instanceof Composite ? ((Composite)left).computeTrim(0, 0, 0, 0) : new Rectangle(0, 0, 0, 0);
                    int w = x - rect.x - section.marginWidth - section.highlight - trim.width;
                    int h = topHeight - trim.height;
                    leftSize = left.computeSize(w, h, false);
                    left.setBounds(rect.x + section.marginWidth + section.highlight, y, leftSize.x, topHeight);
                }
                if (top) {
                    y += topHeight + section.verticalSpacing;
                }
            }
            int oldSeperator = section.separator;
            section.separator = -1;
            if (content != null && !content.isDisposed() && section.isExpanded()) {
                if (left != null || right != null) {
                    section.separator = y;
                }
                content.setBounds(rect.x + section.marginWidth + section.highlight, y, rect.width - 2 * section.marginWidth - 2 * section.highlight, rect.y + rect.height - y - section.marginHeight - section.highlight);
            }
            if (oldSeperator != -1 && section.separator != -1) {
                int t = Math.min(section.separator, oldSeperator);
                int b = Math.max(section.separator, oldSeperator);
                section.redraw(section.borderLeft, t, section.getSize().x - section.borderLeft - section.borderRight, b - t, false);
            }
        }
    }

    public class SectionSite
    implements ISectionSite {
        private String fContext;
        private ArrayList<ISectionListener> fSectionListener = new ArrayList();

        public String getId() {
            return SectionPart.this.fId;
        }

        public void addSectionListener(ISectionListener sectionListener) {
            if (!this.fSectionListener.contains(sectionListener)) {
                this.fSectionListener.add(sectionListener);
            }
        }

        public void addSelectionProvider(ISelectionProvider provider) {
            SectionPart.this.fMultiTracker.registerControl(provider);
        }

        void fireCollapse() {
            ISectionListener[] listeners = this.fSectionListener.toArray(new ISectionListener[this.fSectionListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].sectionCollapsed();
                ++i;
            }
        }

        void fireExpand() {
            ISectionListener[] listeners = this.fSectionListener.toArray(new ISectionListener[this.fSectionListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].sectionExpanded();
                ++i;
            }
        }

        void fireMaximize(boolean isContentClipped) {
            ISectionListener[] listeners = this.fSectionListener.toArray(new ISectionListener[this.fSectionListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].sectionMaximized(isContentClipped);
                ++i;
            }
        }

        void fireOpen() {
            ISectionListener[] listeners = this.fSectionListener.toArray(new ISectionListener[this.fSectionListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].sectionOpened();
                ++i;
            }
        }

        void fireResize() {
            ISectionListener[] listeners = this.fSectionListener.toArray(new ISectionListener[this.fSectionListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].sectionResized();
                ++i;
            }
        }

        public String getName() {
            return SectionPart.this.fSectionDescriptor.getName();
        }

        public Menu getSectionMenu() {
            return SectionPart.this.fSectionMenu;
        }

        public IViewSite getViewSite() {
            return SectionPart.this.fTeamCentralView.getViewSite();
        }

        public boolean isTeamCentralVisible() {
            return this.getViewSite().getPage().isPartVisible(this.getViewSite().getPart());
        }

        public void layoutTeaser() {
            if (SectionPart.this.fHeaderContainer.isDisposed()) {
                return;
            }
            SectionPart.this.fHeaderContainer.layout(true, true);
        }

        public void onContentChange() {
            Rectangle sectionBounds = SectionPart.this.getBounds();
            Point preferredSize = SectionPart.this.computePreferredSize(sectionBounds.width, -1);
            if (SectionPart.this.fChevron.getImage().equals((Object)SectionPart.this.fChevronUpImage) && SectionPart.this.getBounds().height < preferredSize.y) {
                this.fireMaximize(true);
            }
        }

        public void removeSectionListener(ISectionListener sectionListener) {
            this.fSectionListener.remove(sectionListener);
        }

        public void setName(String name) {
            SectionPart.this.fSectionDescriptor.setName(name);
            SectionPart.this.fTitle = name;
            if (SectionPart.this.fHeaderLabel != null) {
                SectionPart.this.fHeaderLabel.setText(name);
            }
        }

        public void hideAlert() {
            SectionPart.this.setHeaderTeasing(false);
        }

        public void showAlert(boolean showUntilViewOpened, boolean overlayIcon, boolean teaseSection) {
            this.showAlert(showUntilViewOpened, teaseSection);
        }

        public void showAlert(boolean showUntilViewOpened, boolean teaseSection) {
            if (teaseSection) {
                SectionPart.this.setHeaderTeasing(true);
            }
            SectionPart.this.fTeamCentralView.showAlert(showUntilViewOpened);
        }

        public String getParameter(String parameterName) {
            return SectionPart.this.fSectionDescriptor.getParameter(parameterName);
        }

        public String getParameterValue(String parameterName) {
            return SectionPart.this.fSectionDescriptor.getParameterValue(parameterName);
        }

        public Object createExecutableParameter(String parameterName) throws CoreException {
            return SectionPart.this.fSectionDescriptor.createExecutableParameter(parameterName);
        }

        public boolean hasParameter(String parameterName) {
            return SectionPart.this.fSectionDescriptor.hasParameter(parameterName);
        }

        public ISectionSiteProgressService getProgressService() {
            return SectionPart.this.fProgressService;
        }

        public String getContext() {
            return this.fContext;
        }

        public void setContext(String context) {
            this.fContext = context;
            if (SectionPart.this.fTeamCentralView.getSectionsManager().getLastSelectedSection() == SectionPart.this) {
                SectionPart.this.fTeamCentralView.getSectionsManager().setLastSelectedSection(SectionPart.this);
            }
        }

        public void setBusy(boolean busy) {
            if (SectionPart.this.fBusy == busy) {
                return;
            }
            SectionPart.this.fBusy = busy;
            if (SectionPart.this.fHeaderLabel.isDisposed()) {
                return;
            }
            SectionPart.this.fHeaderLabel.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (SectionPart.this.fHeaderLabel.isDisposed()) {
                        return;
                    }
                    SectionPart.this.updateFont();
                    SectionPart.this.fHeaderContainer.layout(true, true);
                }
            });
        }
    }

    class SectionSiteProgressService
    implements ISectionSiteProgressService {
        private HashSet<Job> nBusyJobs = new HashSet();
        private HashSet<Job> nHalfBusyJobs = new HashSet();
        private HashSet<Job> fRunningBusyJobs = new HashSet();
        private HashSet<Job> fRunningHalfBusyJobs = new HashSet();
        private Object fMutex = new Object();
        private IJobChangeListener fJobLister = new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = SectionSiteProgressService.this.fMutex;
                synchronized (object) {
                    Job job = event.getJob();
                    if (SectionSiteProgressService.this.fRunningBusyJobs.remove(job)) {
                        SectionSiteProgressService.this.nBusyJobs.remove(job);
                    }
                    if (SectionSiteProgressService.this.fRunningHalfBusyJobs.remove(job)) {
                        SectionSiteProgressService.this.nHalfBusyJobs.remove(job);
                    }
                }
                SectionSiteProgressService.this.updateBusyIndication();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void running(IJobChangeEvent event) {
                Object object = SectionSiteProgressService.this.fMutex;
                synchronized (object) {
                    Job job = event.getJob();
                    if (SectionSiteProgressService.this.nBusyJobs.contains(job)) {
                        SectionSiteProgressService.this.fRunningBusyJobs.add(job);
                    } else if (SectionSiteProgressService.this.nHalfBusyJobs.contains(job)) {
                        SectionSiteProgressService.this.fRunningHalfBusyJobs.add(job);
                    }
                }
                SectionSiteProgressService.this.updateBusyIndication();
            }
        };

        SectionSiteProgressService() {
        }

        public void schedule(Job job) {
            this.schedule(job, false);
        }

        public void schedule(Job job, long delay) {
            this.schedule(job, delay, false);
        }

        public void schedule(Job job, boolean useHalfBusyCursor) {
            this.schedule(job, 0L, useHalfBusyCursor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Job job, long delay, boolean useHalfBusyCursor) {
            job.addJobChangeListener(this.fJobLister);
            job.schedule(delay);
            Object object = this.fMutex;
            synchronized (object) {
                if (!useHalfBusyCursor) {
                    this.nBusyJobs.add(job);
                } else {
                    this.nHalfBusyJobs.add(job);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBusyIndication() {
            if (SectionPart.this.fHeaderLabel != null || !SectionPart.this.fHeaderLabel.isDisposed()) {
                Object object = this.fMutex;
                synchronized (object) {
                    SectionPart.this.fBusy = this.fRunningBusyJobs.size() > 0;
                }
                if (SectionPart.this.fHeaderLabel.isDisposed()) {
                    return;
                }
                SectionPart.this.fHeaderLabel.getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        if (SectionPart.this.fHeaderLabel.isDisposed()) {
                            return;
                        }
                        SectionPart.this.updateFont();
                        SectionPart.this.fHeaderContainer.layout(true, true);
                        Object object = SectionSiteProgressService.this.fMutex;
                        synchronized (object) {
                            Cursor cursor = SectionSiteProgressService.this.fRunningHalfBusyJobs.size() > 0 ? SectionPart.this.getDisplay().getSystemCursor(3) : null;
                            SectionPart.this.setCursor(cursor);
                        }
                    }
                });
            }
        }
    }
}

