/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.internal.dashboard.views.TeamCentralView;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.internal.DragCursors;

public class SectionDNDImpl
implements MouseListener,
MouseMoveListener {
    private static final int OFFSCREEN = -200;
    private static final int TRACKER_STIPPLE_SIZE = "carbon".equals(SWT.getPlatform()) ? 1 : 3;
    private boolean fBlockDND = false;
    private Display fDisplay;
    private boolean fIsMouseDown;
    private SectionPart fSection;
    private TeamCentralView fTeamCentralView;
    private Tracker fTracker;
    private Point fAnchor = new Point(0, 0);
    private boolean fInDnDMode;

    public SectionDNDImpl(TeamCentralView teamCentralView, SectionPart section) {
        this.fTeamCentralView = teamCentralView;
        this.fSection = section;
        this.fDisplay = this.fSection.getDisplay();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.fInDnDMode = false;
        if (e.button == 1 && !this.fBlockDND) {
            this.fIsMouseDown = true;
            this.fAnchor.x = e.x;
            this.fAnchor.y = e.y;
        }
    }

    public void mouseMove(MouseEvent e) {
        int dy;
        int dx;
        if (!this.fInDnDMode && this.fIsMouseDown && Math.sqrt((dx = Math.abs(e.x - this.fAnchor.x)) * dx + (dy = Math.abs(e.y - this.fAnchor.y)) * dy) > 4.0) {
            this.fInDnDMode = true;
        }
        if (this.fInDnDMode && this.fIsMouseDown && this.fTracker == null && !this.fBlockDND) {
            final Rectangle sourceBounds = this.fSection.getBounds();
            int sectionIndex = this.fTeamCentralView.indexOf(this.fSection);
            int trackerStyle = 1152;
            if (sectionIndex == 0) {
                trackerStyle = 1024;
            } else if (sectionIndex == this.fTeamCentralView.getPerspectivesManager().getCurrentVisibleSectionsCount() - 1) {
                trackerStyle = 128;
            }
            this.fTracker = new Tracker(this.fSection.getParent(), trackerStyle);
            this.fTracker.addControlListener((ControlListener)new ControlAdapter(){

                public void controlMoved(ControlEvent e) {
                    SectionPart hoverSection = SectionDNDImpl.getSection(SectionDNDImpl.this.fDisplay.getCursorControl());
                    if (hoverSection != SectionDNDImpl.this.fSection && hoverSection != null) {
                        Rectangle hoverBounds = hoverSection.getBounds();
                        SectionDNDImpl.this.fTracker.setCursor(SectionDNDImpl.this.fDisplay.getSystemCursor(0));
                        SectionDNDImpl.this.fTracker.setStippled(true);
                        if (hoverBounds.y < sourceBounds.y) {
                            Object[] existingTracker;
                            boolean updateTracker;
                            Rectangle feedback = new Rectangle(hoverBounds.x - 3, hoverBounds.y, hoverBounds.width + 6, 0);
                            SectionDNDImpl.this.fTracker.setCursor(DragCursors.getCursor((int)3));
                            if (feedback.y < ((SectionDNDImpl)SectionDNDImpl.this).fSection.getParent().getBounds().y) {
                                feedback.y = 0;
                            }
                            boolean bl = updateTracker = (existingTracker = SectionDNDImpl.this.fTracker.getRectangles()) == null || !Arrays.equals(existingTracker, new Rectangle[]{feedback});
                            if (updateTracker) {
                                SectionDNDImpl.this.fTracker.setRectangles(new Rectangle[]{feedback});
                            }
                        } else {
                            Object[] existingTracker;
                            boolean updateTracker;
                            Rectangle feedback = new Rectangle(hoverBounds.x - 3, hoverBounds.y + hoverBounds.height + 3, hoverBounds.width + 6, 0);
                            SectionDNDImpl.this.fTracker.setCursor(DragCursors.getCursor((int)4));
                            if (feedback.y > ((SectionDNDImpl)SectionDNDImpl.this).fSection.getParent().getBounds().y + ((SectionDNDImpl)SectionDNDImpl.this).fSection.getParent().getBounds().height) {
                                feedback.y = ((SectionDNDImpl)SectionDNDImpl.this).fSection.getParent().getBounds().y + ((SectionDNDImpl)SectionDNDImpl.this).fSection.getParent().getBounds().height - TRACKER_STIPPLE_SIZE;
                            }
                            boolean bl = updateTracker = (existingTracker = SectionDNDImpl.this.fTracker.getRectangles()) == null || !Arrays.equals(existingTracker, new Rectangle[]{feedback});
                            if (updateTracker) {
                                SectionDNDImpl.this.fTracker.setRectangles(new Rectangle[]{feedback});
                            }
                        }
                    } else {
                        SectionDNDImpl.this.fTracker.setCursor(DragCursors.getCursor((int)0));
                        SectionDNDImpl.this.fTracker.setRectangles(new Rectangle[]{new Rectangle(-200, -200, 0, 0)});
                        SectionDNDImpl.this.fTracker.setStippled(false);
                    }
                }
            });
            this.fTracker.open();
            this.fIsMouseDown = false;
            this.fInDnDMode = false;
            this.fTracker = null;
            this.fTeamCentralView.getSectionsManager().moveSection(this.fSection, SectionDNDImpl.getSection(this.fDisplay.getCursorControl()));
        }
    }

    public void mouseUp(MouseEvent e) {
        this.fIsMouseDown = false;
        this.fInDnDMode = false;
    }

    private static SectionPart getSection(Control control) {
        while (control != null && !(control instanceof SectionPart)) {
            control = control.getParent();
        }
        if (control != null && control instanceof SectionPart) {
            return (SectionPart)control;
        }
        return null;
    }

    public void setBlockDND(boolean blockDND) {
        this.fBlockDND = blockDND;
    }
}

