/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.alerts;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.internal.alerts.InfoPop;
import com.ibm.team.jface.internal.alerts.InfoPopManager;
import com.ibm.team.jface.internal.alerts.Messages;
import com.ibm.team.jface.internal.util.LoggingUIJob;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

class InfoPopAnimator {
    private static final int ANIMATION_TIME = 750;
    private static final int FPS = 20;
    private static final int FRAME_TIMEGAP = 50;
    private static final int STEPS = 15;
    private static final int INFOPOP_GAP = 3;
    private boolean fAnimationIsRunning;
    private boolean fAnimate;
    private List fPopupQueue;
    private boolean fDisposed;

    InfoPopAnimator(ArrayList popups, boolean animate) {
        this.fPopupQueue = popups;
        this.fAnimate = animate;
    }

    private Point getBottomRight() {
        Rectangle clientArea = this.getActiveWorkbenchMonitor().getClientArea();
        return new Point(clientArea.width + clientArea.x, clientArea.height + clientArea.y);
    }

    private Monitor getActiveWorkbenchMonitor() {
        IWorkbenchWindow activeWorkbenchWindow;
        Display display = PlatformUI.getWorkbench().getDisplay();
        Monitor[] monitors = display.getMonitors();
        if (monitors.length > 1 && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            Rectangle activeWorkbenchBounds = activeWorkbenchWindow.getShell().getBounds();
            Monitor eclipseMonitor = null;
            int maxArea = 0;
            int i = 0;
            while (i < monitors.length) {
                Monitor monitor = monitors[i];
                Rectangle monitorBounds = monitor.getBounds();
                Rectangle intersection = monitorBounds.intersection(activeWorkbenchBounds);
                int area = intersection.width * intersection.height;
                if (area >= maxArea) {
                    eclipseMonitor = monitor;
                    maxArea = area;
                }
                ++i;
            }
            return eclipseMonitor;
        }
        return display.getPrimaryMonitor();
    }

    private boolean isMultiMonitor() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        return display.getMonitors().length > 1;
    }

    boolean animationIsRunning() {
        return this.fAnimationIsRunning;
    }

    void closeGap(final InfoPop infoPop) {
        FoundationJob job = new FoundationJob(Messages.InfoPopAnimator_INFO_ANIMATOR_CLOSE_GAP){

            public boolean belongsTo(Object family) {
                return InfoPopManager.INFOPOP_JOB_FAMILY.equals(family);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(IProgressMonitor monitor) {
                final int index = InfoPopAnimator.this.fPopupQueue.indexOf(infoPop);
                final int gap = infoPop.getCachedSize().y + 3;
                if (InfoPopAnimator.this.fAnimate) {
                    if (InfoPopAnimator.this.fPopupQueue.get(InfoPopAnimator.this.fPopupQueue.size() - 1) != infoPop) {
                        int a = 1;
                        while (a <= 15) {
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            final int yd = gap * a / 15 - gap * (a - 1) / 15;
                            UIJob2 uiJob = new UIJob2(InfoPopAnimator.this){

                                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                                    if (yd > 0) {
                                        int i = index + 1;
                                        while (i < InfoPopAnimator.this.fPopupQueue.size()) {
                                            if (monitor.isCanceled()) {
                                                return Status.OK_STATUS;
                                            }
                                            InfoPop curInfoPop = (InfoPop)InfoPopAnimator.this.fPopupQueue.get(i);
                                            if (curInfoPop.getState() != 0) {
                                                Shell curShell = curInfoPop.getShell();
                                                if (!curInfoPop.getParent().isDisposed() && !curShell.isDisposed()) {
                                                    Point curShellLocation = curShell.getLocation();
                                                    curShell.setLocation(curShellLocation.x, curShellLocation.y + yd);
                                                    curInfoPop.getParent().update();
                                                }
                                            }
                                            ++i;
                                        }
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            InfoPopAnimator.this.syncRun(uiJob, 50);
                            ++a;
                        }
                    }
                } else if (InfoPopAnimator.this.fPopupQueue.get(InfoPopAnimator.this.fPopupQueue.size() - 1) != infoPop) {
                    UIJob2 uiJob = new UIJob2(InfoPopAnimator.this){

                        public IStatus runProtectedInUI(IProgressMonitor monitor) {
                            int i = index + 1;
                            while (i < InfoPopAnimator.this.fPopupQueue.size()) {
                                if (monitor.isCanceled()) {
                                    return Status.OK_STATUS;
                                }
                                InfoPop curInfoPop = (InfoPop)InfoPopAnimator.this.fPopupQueue.get(i);
                                if (curInfoPop.getState() != 0 && !curInfoPop.getShell().isDisposed()) {
                                    Shell curShell = curInfoPop.getShell();
                                    Point curShellLocation = curShell.getLocation();
                                    curShell.setLocation(curShellLocation.x, curShellLocation.y += gap);
                                    if (!curInfoPop.getParent().isDisposed()) {
                                        curInfoPop.getParent().update();
                                    }
                                }
                                ++i;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    InfoPopAnimator.this.syncRun(uiJob, 0);
                }
                List list = InfoPopAnimator.this.fPopupQueue;
                synchronized (list) {
                    InfoPopAnimator.this.fPopupQueue.remove(index);
                }
                InfoPopAnimator.this.fAnimationIsRunning = false;
                return Status.OK_STATUS;
            }
        };
        this.fAnimationIsRunning = true;
        job.setSystem(true);
        job.schedule();
    }

    void fadeIn(final InfoPop infoPop) {
        Fader job = new Fader(){

            public boolean belongsTo(Object family) {
                return InfoPopManager.INFOPOP_JOB_FAMILY.equals(family);
            }

            public IStatus runProtected(IProgressMonitor monitor) {
                if (infoPop.getParent() == null || infoPop.getParent().isDisposed()) {
                    return Status.OK_STATUS;
                }
                UIJob2 uiJob = new UIJob2(InfoPopAnimator.this){

                    public IStatus runProtectedInUI(IProgressMonitor monitor) {
                        if (!infoPop.getParent().isDisposed() && !monitor.isCanceled()) {
                            infoPop.create();
                            infoPopShell = infoPop.getShell();
                            infoPopSize = infoPopShell.getSize();
                            posY = ((InfoPopAnimator)(this).InfoPopAnimator.this).getBottomRight().y - infoPop.getHeight() - 3;
                            int x = ((InfoPopAnimator)(this).InfoPopAnimator.this).getBottomRight().x;
                            if (InfoPopAnimator.this.isMultiMonitor()) {
                                infoPopShell.setBounds(x, posY, 0, infoPopSize.y);
                            } else {
                                infoPopShell.setLocation(x, posY);
                            }
                            infoPopShell.setVisible(true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                InfoPopAnimator.this.syncRun(uiJob, 0);
                if (InfoPopAnimator.this.fAnimate) {
                    int i = 0;
                    while (i < 15) {
                        final int a = this.infoPopSize.x * (i + 1) / 15;
                        UIJob2 uiJob2 = new UIJob2(InfoPopAnimator.this){

                            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                                if (!infoPopShell.isDisposed()) {
                                    int x = ((InfoPopAnimator)(this).InfoPopAnimator.this).getBottomRight().x - a - 3;
                                    if (InfoPopAnimator.this.isMultiMonitor()) {
                                        infoPopShell.setBounds(x, posY, a, infoPopSize.y);
                                    } else {
                                        infoPopShell.setLocation(x, posY);
                                    }
                                    infoPopShell.update();
                                    Shell parent = infoPop.getParent();
                                    if (!parent.isDisposed()) {
                                        parent.update();
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        InfoPopAnimator.this.syncRun(uiJob2, 50);
                        ++i;
                    }
                } else {
                    UIJob2 uiJob3 = new UIJob2(InfoPopAnimator.this){

                        public IStatus runProtectedInUI(IProgressMonitor monitor) {
                            if (!infoPopShell.isDisposed() && !monitor.isCanceled()) {
                                infoPopShell.setLocation(((InfoPopAnimator)(this).InfoPopAnimator.this).getBottomRight().x - infoPopSize.x, posY);
                                infoPopShell.update();
                                if (!infoPop.getParent().isDisposed()) {
                                    infoPop.getParent().update();
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    InfoPopAnimator.this.syncRun(uiJob3, 0);
                }
                InfoPopAnimator.this.fAnimationIsRunning = false;
                return Status.OK_STATUS;
            }
        };
        this.fAnimationIsRunning = true;
        job.setSystem(true);
        job.schedule();
    }

    void fadeOut(final InfoPop infoPop) {
        Fader job = new Fader(){

            public boolean belongsTo(Object family) {
                return InfoPopManager.INFOPOP_JOB_FAMILY.equals(family);
            }

            public IStatus runProtected(IProgressMonitor monitor) {
                if (infoPop.getParent() == null || infoPop.getParent().isDisposed()) {
                    return Status.OK_STATUS;
                }
                if (InfoPopAnimator.this.fAnimate) {
                    this.infoPopSize = infoPop.getCachedSize();
                    int i = 0;
                    while (i < 15) {
                        final int a = this.infoPopSize.x * (i + 1) / 15;
                        UIJob2 uiJob = new UIJob2(InfoPopAnimator.this){

                            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                                infoPopShell = infoPop.getShell();
                                if (!infoPopShell.isDisposed() && !monitor.isCanceled()) {
                                    int width = infoPopSize.x - a;
                                    if (width > 0) {
                                        posY = infoPopShell.getShell().getLocation().y;
                                        int x = ((InfoPopAnimator)(this).InfoPopAnimator.this).getBottomRight().x - width;
                                        if (InfoPopAnimator.this.isMultiMonitor()) {
                                            infoPopShell.setBounds(x, posY, width, infoPopSize.y);
                                        } else {
                                            infoPopShell.setLocation(x, posY);
                                        }
                                        if (!infoPop.getParent().isDisposed()) {
                                            infoPop.getParent().update();
                                        }
                                    } else {
                                        infoPop.close();
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        InfoPopAnimator.this.syncRun(uiJob, 50);
                        ++i;
                    }
                } else {
                    UIJob2 uiJob = new UIJob2(InfoPopAnimator.this){

                        public IStatus runProtectedInUI(IProgressMonitor monitor) {
                            if (!infoPop.getParent().isDisposed() && !monitor.isCanceled()) {
                                infoPop.close();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    InfoPopAnimator.this.syncRun(uiJob, 0);
                }
                InfoPopAnimator.this.fAnimationIsRunning = false;
                return Status.OK_STATUS;
            }
        };
        this.fAnimationIsRunning = true;
        job.setSystem(true);
        job.schedule();
    }

    private void syncRun(UIJob uiJob, int sleep) {
        if (this.fDisposed) {
            return;
        }
        long start = 0L;
        if (sleep > 0) {
            start = System.currentTimeMillis();
        }
        uiJob.setSystem(true);
        uiJob.schedule();
        try {
            uiJob.join();
        }
        catch (InterruptedException interruptedException) {}
        if (sleep > 0) {
            long duration = System.currentTimeMillis() - start;
            if ((sleep = (int)((long)sleep - duration)) < 1) {
                sleep = 1;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private int getInfoPopPosY(InfoPop infoPop) {
        int posY = this.getBottomRight().y;
        Object[] obj = this.fPopupQueue.toArray();
        int i = 0;
        while (i < obj.length) {
            InfoPop curInfoPop = (InfoPop)obj[i];
            posY -= curInfoPop.getHeight();
            posY -= 3;
            if (curInfoPop == infoPop) break;
            ++i;
        }
        return posY;
    }

    public void dispose() {
        this.fDisposed = true;
    }

    abstract class Fader
    extends FoundationJob {
        protected Shell infoPopShell;
        protected Point infoPopSize;
        protected int posY;

        protected Fader() {
            super(Messages.InfoPopAnimator_INFO_ANIMATOR);
        }
    }

    abstract class UIJob2
    extends LoggingUIJob {
        public UIJob2() {
            super(Messages.InfoPopAnimator_INFO_ANIMATOR);
            this.setSystem(true);
        }

        public final boolean belongsTo(Object family) {
            return InfoPopManager.INFOPOP_JOB_FAMILY.equals(family);
        }
    }
}

