/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.alerts;

import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.foundation.rcp.core.notification.Notifier;
import com.ibm.team.jface.internal.JFacePlugin;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class GrowlNotifier
extends Notifier {
    public static final String ID = "com.ibm.team.jface.GrowlNotifier";
    private static final String APPLICATION_NAME = "Jazz";
    private static boolean fgLoggedException = false;

    public void notify(String eventCategoryId, String eventTypeId, String triggerId, NotificationInfo notification) {
        block9: {
            if (notification.isTriggeredByUser()) {
                return;
            }
            String title = notification.getTitle();
            String message = notification.getMessage();
            try {
                ArrayList<String> args = new ArrayList<String>();
                args.add("/usr/local/bin/growlnotify");
                args.add("--name");
                args.add(APPLICATION_NAME);
                if (title != null) {
                    args.add("-t");
                    args.add(title);
                }
                try {
                    URL url = new URL(notification.getImageUrl());
                    String imagePath = url.getFile();
                    if (imagePath != null) {
                        args.add("--image");
                        args.add(imagePath);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
                if (message != null) {
                    args.add("-m");
                    args.add(message);
                }
                Process p = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
                OutputStream outputStream = p.getOutputStream();
                if (message != null) {
                    outputStream.write(message.getBytes());
                }
                outputStream.close();
                p.waitFor();
            }
            catch (Exception e) {
                if (fgLoggedException) break block9;
                JFacePlugin.log(e);
                fgLoggedException = true;
            }
        }
    }
}

