/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.charts;

import com.ibm.team.jface.charts.HoverEvent;
import com.ibm.team.jface.charts.IChartElementProvider;
import com.ibm.team.jface.charts.IHoverListener;
import com.ibm.team.jface.charts.IProgressChartElementProvider;
import com.ibm.team.jface.charts.Messages;
import com.ibm.team.jface.tooltip.TooltipSupport;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class BarViewer
extends Viewer {
    protected static final String EXTENT_LABEL = "Fog";
    protected static final int VERTICAL_TEXT_GAP = 3;
    protected IChartElementProvider fChartElementProvider;
    protected String fChartName;
    protected Composite fComposite;
    protected IStructuredContentProvider fContentProvider;
    private EventHandler fEventHandler;
    protected Object fFocussedBar;
    private TooltipSupport fHoverSupport;
    private Object fInput;
    protected Object fSelectedBar;
    protected boolean fUseGradients;
    private ListenerList openListeners;
    private ListenerList hoverListeners;

    public BarViewer(Composite composite, String chartName, boolean useGradients) {
        this.fComposite = composite;
        this.fChartName = chartName;
        this.fUseGradients = useGradients;
        this.openListeners = new ListenerList(1);
        this.hoverListeners = new ListenerList(1);
        this.fEventHandler = new EventHandler();
        this.fComposite.addMouseListener((MouseListener)this.fEventHandler);
        this.fComposite.addMouseMoveListener((MouseMoveListener)this.fEventHandler);
        this.fComposite.addMouseTrackListener((MouseTrackListener)this.fEventHandler);
        this.fComposite.addTraverseListener((TraverseListener)this.fEventHandler);
        this.fComposite.addKeyListener((KeyListener)this.fEventHandler);
        this.fComposite.getAccessible().addAccessibleListener((AccessibleListener)this.fEventHandler);
        this.fComposite.addFocusListener((FocusListener)this.fEventHandler);
        this.fComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BarViewer.this.dispose();
            }
        });
        this.fHoverSupport = new TooltipSupport((Control)this.fComposite, true, true){

            public Rectangle getElementBounds(Control control, int x, int y) {
                return BarViewer.this.getElementBounds(new Point(x, y));
            }

            protected String getMarkup(Object element, boolean isFocus) {
                if (BarViewer.this.fChartElementProvider instanceof IProgressChartElementProvider) {
                    return this.getProgressMarkup(isFocus);
                }
                String markup = BarViewer.this.getHoverMarkup(element, isFocus);
                if (markup != null) {
                    return markup;
                }
                StructuredSelection selection = new StructuredSelection(element);
                BarViewer.this.fireHover(new HoverEvent(BarViewer.this, (ISelection)selection));
                return super.getMarkup(element, isFocus);
            }

            public boolean isBlockHoverEvent() {
                return BarViewer.this.isBusyLoading();
            }

            protected Object mapElement(int x, int y) {
                return BarViewer.this.getElement(new Point(x, y));
            }

            protected void openRequested(final Object element) {
                StructuredSelection selection = new StructuredSelection(){

                    public Object getFirstElement() {
                        return element;
                    }
                };
                BarViewer.this.fireOpen(new OpenEvent((Viewer)BarViewer.this, (ISelection)selection));
            }

            private String getProgressMarkup(boolean isFocus) {
                Object[] elements = BarViewer.this.fContentProvider.getElements(null);
                IProgressChartElementProvider progressProvider = (IProgressChartElementProvider)BarViewer.this.fChartElementProvider;
                return progressProvider.getHoverMarkup(elements, isFocus);
            }
        };
    }

    public TooltipSupport getHoverSupport() {
        return this.fHoverSupport;
    }

    protected String getHoverMarkup(Object element, boolean isFocus) {
        return null;
    }

    public void addHoverListener(IHoverListener listener) {
        this.hoverListeners.add((Object)listener);
    }

    public void addOpenListener(IOpenListener listener) {
        this.openListeners.add((Object)listener);
    }

    public void dispose() {
        if (this.fChartElementProvider != null) {
            this.fChartElementProvider.dispose();
        }
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        if (!this.fComposite.isDisposed()) {
            this.fComposite.removeMouseListener((MouseListener)this.fEventHandler);
            this.fComposite.removeMouseMoveListener((MouseMoveListener)this.fEventHandler);
            this.fComposite.removeMouseTrackListener((MouseTrackListener)this.fEventHandler);
            this.fComposite.removeTraverseListener((TraverseListener)this.fEventHandler);
            this.fComposite.removeKeyListener((KeyListener)this.fEventHandler);
            this.fComposite.removeFocusListener((FocusListener)this.fEventHandler);
            if (!"gtk".equals(SWT.getPlatform())) {
                this.fComposite.getAccessible().removeAccessibleListener((AccessibleListener)this.fEventHandler);
            }
        }
    }

    protected void fireOpen(final OpenEvent event) {
        Object[] listeners = this.openListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IOpenListener l = (IOpenListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.open(event);
                }
            });
            ++i;
        }
    }

    protected void fireHover(final HoverEvent event) {
        Object[] listeners = this.hoverListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IHoverListener l = (IHoverListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.hover(event);
                }
            });
            ++i;
        }
    }

    protected Rectangle getChartBounds() {
        return this.fComposite.getClientArea();
    }

    public Control getControl() {
        return this.fComposite;
    }

    public abstract Object getElement(Point var1);

    public abstract Rectangle getElementBounds(Point var1);

    public Object getInput() {
        return this.fInput;
    }

    private int getMaxValue() {
        Object[] elements = this.fContentProvider.getElements(null);
        if (elements.length == 0) {
            return -1;
        }
        int max = this.fChartElementProvider.getValue(elements[0]);
        int a = 0;
        while (a < elements.length - 1) {
            max = Math.max(max, this.fChartElementProvider.getValue(elements[++a]));
        }
        return max;
    }

    public abstract Point getMinimalSize();

    public abstract Point getPreferredSize();

    protected float[] getRelatives() {
        Object[] elements = this.fContentProvider.getElements(null);
        float sum = this.getValueSum();
        float[] relatives = new float[elements.length];
        int a = 0;
        while (a < elements.length) {
            relatives[a] = sum != 0.0f ? (float)this.fChartElementProvider.getValue(elements[a]) / sum : 1.0f / (float)elements.length;
            ++a;
        }
        return relatives;
    }

    protected float[] getRelativesToMax() {
        Object[] elements = this.fContentProvider.getElements(null);
        float max = this.getMaxValue();
        float[] relativesToMax = new float[elements.length];
        int a = 0;
        while (a < elements.length) {
            relativesToMax[a] = max != 0.0f ? (float)this.fChartElementProvider.getValue(elements[a]) / max : 0.0f;
            ++a;
        }
        return relativesToMax;
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    private int getValueSum() {
        Object[] elements = this.fContentProvider.getElements(null);
        int sum = 0;
        int a = 0;
        while (a < elements.length) {
            sum += this.fChartElementProvider.getValue(elements[a]);
            ++a;
        }
        return sum;
    }

    public boolean isBlockHoverEvent() {
        return this.fHoverSupport.isBlockHoverEvent();
    }

    protected boolean isBusyLoading() {
        Object[] elements = this.fContentProvider.getElements(null);
        if (elements.length == 0) {
            return true;
        }
        int a = 0;
        while (a < elements.length) {
            if (this.fChartElementProvider.isBusyLoading(elements[a])) {
                return true;
            }
            ++a;
        }
        return false;
    }

    protected abstract void onPaint(GC var1);

    public void paintControl(PaintEvent e) {
        if (!this.isBusyLoading()) {
            this.onPaint(e.gc);
        }
    }

    public void refresh() {
        this.fFocussedBar = null;
        this.fEventHandler.fLastFocusElement = null;
        if (!this.fComposite.isDisposed()) {
            this.fComposite.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BarViewer.this.fComposite.isDisposed()) {
                        BarViewer.this.fComposite.redraw();
                    }
                }
            });
        }
    }

    public void removeOpenListener(IOpenListener listener) {
        this.openListeners.remove((Object)listener);
    }

    public void removeHoverListener(IHoverListener listener) {
        this.hoverListeners.remove((Object)listener);
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.fContentProvider = contentProvider;
    }

    public void setInput(Object input) {
        this.fInput = input;
        if (this.fContentProvider != null) {
            this.fContentProvider.inputChanged((Viewer)this, null, input);
        }
    }

    public void setLabelProvider(IChartElementProvider chartElementProvider) {
        this.fChartElementProvider = chartElementProvider;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setEnabled(final boolean enabled) {
        if (!this.fComposite.isDisposed()) {
            this.fComposite.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!BarViewer.this.fComposite.isDisposed()) {
                        BarViewer.this.fComposite.setEnabled(enabled);
                        BarViewer.this.fComposite.redraw();
                    }
                }
            });
        }
    }

    public boolean isEnabled() {
        if (!this.fComposite.isDisposed()) {
            return this.fComposite.isEnabled();
        }
        return false;
    }

    private class EventHandler
    extends AccessibleAdapter
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener,
    TraverseListener,
    FocusListener,
    KeyListener {
        private Object fLastFocusElement;

        private EventHandler() {
        }

        public void focusGained(FocusEvent e) {
            Object[] elements = BarViewer.this.fContentProvider.getElements(null);
            if (elements.length == 0) {
                return;
            }
            BarViewer.this.fFocussedBar = this.fLastFocusElement != null ? this.fLastFocusElement : elements[0];
            BarViewer.this.fComposite.redraw();
        }

        public void focusLost(FocusEvent e) {
            if (BarViewer.this.fFocussedBar != null) {
                BarViewer.this.fFocussedBar = null;
                BarViewer.this.fComposite.redraw();
            }
        }

        public void keyTraversed(TraverseEvent e) {
            Object[] elements = BarViewer.this.fContentProvider.getElements(null);
            if (elements.length == 0) {
                return;
            }
            switch (e.detail) {
                case 4: {
                    if (BarViewer.this.fFocussedBar == null) break;
                    BarViewer.this.fireOpen(new OpenEvent((Viewer)BarViewer.this, (ISelection)new StructuredSelection(new Object[]{BarViewer.this.fFocussedBar})));
                    BarViewer.this.fFocussedBar = null;
                    BarViewer.this.fComposite.redraw();
                    break;
                }
                case 16: {
                    if (BarViewer.this.fFocussedBar == null) {
                        this.fLastFocusElement = BarViewer.this.fFocussedBar = elements[0];
                        BarViewer.this.fComposite.redraw();
                        break;
                    }
                    if (BarViewer.this.fFocussedBar == elements[elements.length - 1]) {
                        BarViewer.this.fFocussedBar = null;
                        BarViewer.this.fComposite.redraw();
                        e.doit = true;
                        break;
                    }
                    if (BarViewer.this.fFocussedBar == null) break;
                    int index = 0;
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i] == BarViewer.this.fFocussedBar) {
                            index = i;
                        }
                        ++i;
                    }
                    if (++index < elements.length) {
                        this.fLastFocusElement = BarViewer.this.fFocussedBar = elements[index];
                        BarViewer.this.fComposite.redraw();
                        e.doit = false;
                        break;
                    }
                    e.doit = true;
                    break;
                }
                case 8: {
                    if (BarViewer.this.fFocussedBar == null) {
                        this.fLastFocusElement = BarViewer.this.fFocussedBar = elements[elements.length - 1];
                        BarViewer.this.fComposite.redraw();
                        break;
                    }
                    if (BarViewer.this.fFocussedBar == elements[0]) {
                        BarViewer.this.fFocussedBar = null;
                        BarViewer.this.fComposite.redraw();
                        e.doit = true;
                        break;
                    }
                    if (BarViewer.this.fFocussedBar == null) break;
                    int index = 0;
                    int i = 0;
                    while (i < elements.length) {
                        if (elements[i] == BarViewer.this.fFocussedBar) {
                            index = i;
                        }
                        ++i;
                    }
                    if (--index >= 0) {
                        this.fLastFocusElement = BarViewer.this.fFocussedBar = elements[index];
                        BarViewer.this.fComposite.redraw();
                        e.doit = false;
                        break;
                    }
                    e.doit = true;
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.fLastFocusElement = BarViewer.this.fFocussedBar = BarViewer.this.getElement(new Point(e.x, e.y));
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            if (BarViewer.this.fSelectedBar != null) {
                BarViewer.this.fSelectedBar = null;
                BarViewer.this.fComposite.redraw();
            }
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            Object element = BarViewer.this.getElement(new Point(e.x, e.y));
            if (BarViewer.this.fSelectedBar != element) {
                BarViewer.this.fSelectedBar = element;
                BarViewer.this.fComposite.redraw();
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button != 1 || e.stateMask == 0x400000) {
                return;
            }
            StructuredSelection selection = new StructuredSelection(new Object[]{BarViewer.this.getElement(new Point(e.x, e.y))});
            BarViewer.this.fireOpen(new OpenEvent((Viewer)BarViewer.this, (ISelection)selection));
        }

        public void getName(AccessibleEvent e) {
            Point cursorLocation = BarViewer.this.fComposite.getDisplay().getCursorLocation();
            Object element = BarViewer.this.getElement(cursorLocation);
            if (element != null && BarViewer.this.fChartElementProvider != null) {
                String text = BarViewer.this.fChartElementProvider.getText(element);
                String value = BarViewer.this.fChartElementProvider.getValueAsString(element);
                e.result = MessageFormat.format(Messages.BarViewer_TEXT_VALUE, text, value);
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

