/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.service.managers.clearquest.common;

import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.interop.service.managers.clearquest.common.XMLControlEscaper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InteropDocument {
    protected static final String MAP_TAG = "map";
    protected static final String MAP_ENTRY_TAG = "mapEntry";
    protected static final String NAME_TAG = "name";
    protected static final String ENTRY_TAG = "entry";
    protected static final String VALUE_TAG = "value";

    InteropDocument() {
    }

    protected Map<String, ?> deSerializeMap(Node mapNode) throws InteropException {
        if (mapNode.getFirstChild() == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Node child = mapNode.getFirstChild();
        while (child != null) {
            String nodeName = child.getNodeName();
            if (nodeName.equals(ENTRY_TAG)) {
                Node firstChild = child.getFirstChild();
                Node secondChild = firstChild.getNextSibling();
                String firstChildTag = firstChild.getNodeName();
                String secondChildTag = secondChild.getNodeName();
                String firstChildText = this.getTextContent(firstChild, true);
                String secondChildText = this.getTextContent(secondChild, false);
                if (firstChildTag.equals(NAME_TAG) && secondChildTag.equals(VALUE_TAG)) {
                    result.put(firstChildText, secondChildText);
                } else {
                    this.unexpectedNodeError(NAME_TAG, firstChild);
                }
            } else {
                this.unexpectedNodeError(ENTRY_TAG, child);
            }
            child = child.getNextSibling();
        }
        return result;
    }

    private void serializeMapEntry(Document doc, Node root, Object key, Map<String, ?> map) {
        Element name = doc.createElement(NAME_TAG);
        root.appendChild(name);
        this.addTextContent(doc, name, (String)key);
        Element value = doc.createElement(VALUE_TAG);
        root.appendChild(value);
        this.addTextContent(doc, value, (String)map.get(key));
    }

    protected void serializeMap(Document doc, Node root, Map<String, ?> map) {
        Set<String> keySet;
        Element child = doc.createElement(MAP_TAG);
        root.appendChild(child);
        if (map != null && (keySet = map.keySet()) != null) {
            for (String key : keySet) {
                Element entry = doc.createElement(ENTRY_TAG);
                child.appendChild(entry);
                this.serializeMapEntry(doc, entry, key, map);
            }
        }
    }

    protected String getTextContent(Node node, boolean errorIfNone) throws InteropException {
        Node child = node.getFirstChild();
        if (child == null || child.getNodeValue() == null || child.getNodeValue().length() == 0) {
            if (errorIfNone) {
                throw new InteropException("The \"" + node.getNodeName() + "\" cannot be empty");
            }
            return null;
        }
        return XMLControlEscaper.decodeControlChars(child.getNodeValue());
    }

    protected void unexpectedNodeError(String expectedTagName, Node actualNode) throws InteropException {
        StringBuilder msgBuf = new StringBuilder();
        msgBuf.append("unexpected node \"");
        msgBuf.append(actualNode.getNodeName());
        msgBuf.append("\"");
        if (expectedTagName != null) {
            msgBuf.append("; expected \"");
            msgBuf.append(expectedTagName);
            msgBuf.append("\"");
        }
        throw new InteropException("Error in  interop operation: " + msgBuf);
    }

    protected void addTextContent(Document doc, Node node, String content) {
        if (content != null) {
            node.appendChild(doc.createTextNode(XMLControlEscaper.encodeControlChars(content)));
        }
    }
}

