<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:saxon="http://icl.com/saxon" 
	xmlns:xt="http://www.jclark.com/xt" 
	extension-element-prefixes="saxon xt">


<!--
##### STYLESHEET IMPORTS #####
the main dita to xhtml converter 
-->
<xsl:import href="idit2htm.xsl"/>

<!-- Turn off all the task label headings -->
<xsl:param name="GENERATE-TASK-LABELS" select="'NO'"/>

<!-- 
##### XHTML OUTPUT HEADER INFO #####
Output XHTML with Saxon:xhtml syntax; use UFT-8 encoding="UTF-8"; transitional XHTML.  
Prevent indenting to conserve space on output.
20080709:JA changed method="saxon:xhtml" to method="xml" for Saxon 9/IDWB 4.0
-->
<xsl:output method="xml"
            encoding="UTF-8"
            indent="no"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
/>


<!-- 
##### SHOWME: RELATED LINK OVERRIDE ##### 
overriding relinfo-links to ignore showme links that are listed in the related links area
-->
<xsl:template name="relinfo-links">
     <!--other info- - not currently sorting by role, since already mixing any number of types in here-->
     <!--if there are links not covered by any of the other routines - ie, not in a linklist, not a child or descendant, not a concept/task/reference, not ancestor/next/previous, not prerequisite - create a section for them and create the links -->
     <xsl:if test="descendant::*
[contains(@class, ' topic/link ')]
[not(ancestor::*[contains(@class,' topic/linklist ')])]
          [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous' or @type='concept' or @type='task' or @type='reference' or @type='showme')]
          [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]">
          <div>
          <strong>
             <xsl:call-template name="getString">
                  <xsl:with-param name="stringName" select="'Related information'"/>
               </xsl:call-template>
          </strong>
       <!--once section is created, create the links, using the same rules as above plus a uniqueness check-->
       <xsl:for-each select="descendant::*
          [not(ancestor::*[contains(@class,' topic/linklist ')])]
          [generate-id(.)=generate-id(key('link',concat(ancestor::*[contains(@class, ' topic/related-links ')]/parent::*[contains(@class, ' topic/topic ')]/@id, ' ', @href,@type,@role,@platform,@audience,@importance,@outputclass,@keyref,@scope,@format,@otherrole,@product,@otherprops,@rev,@class,child::*))[1])]
[contains(@class, ' topic/link ')]
          [not(@role='child' or @role='descendant' or @role='ancestor' or @role='parent' or @role='next' or @role='previous' or @type='concept' or @type='task' or @type='reference' or @type='showme')]
          [not(@importance='required' and (not(@role) or @role='sibling' or @role='friend' or @role='cousin'))]">
          <xsl:apply-templates select="."/>
       </xsl:for-each>

          </div>
     </xsl:if>
</xsl:template>

  <!-- 
  ##### SHOWME: SHORTDESC OVERRIDE #####
  Overrides shortdesc template to place code showme viewlet above the shortdesc tag.  This is how showme's get to the top of the page.
  Styles and images are called from collapse.js; movie image is in the Tutorials Gallery common files
  -->
  <xsl:template match="*[contains(@class,' topic/shortdesc ')]" mode="outofline">
    <div>
      <xsl:for-each select="following-sibling::*[contains(@class,' topic/related-links ')]/descendant::*[contains(@class,' topic/link ')][@format='viewlet'][@type='showme']">
      <div class="showme">
      <div class="collapseheadshowme">
        <a href="javascript:void(0)"
           class="collapsehead"
           onclick="collapse(this)">
           <!-- <img src="../../com.ibm.help.doc/images/camera2.gif" border="none" align="middle" alt=""></img> -->
           <xsl:value-of select="." /></a>
      </div>
      <div class="collapsecontent">
        <div class="section">
          <xsl:element name="object">
            <xsl:attribute name="id">11</xsl:attribute>
            <xsl:attribute name="codebase">http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab</xsl:attribute>
            <xsl:attribute name="type">application/x-shockwave-flash</xsl:attribute>
            <xsl:attribute name="classid">clsid:D27CDB6E-AE6D-11cf-96B8-444553540000</xsl:attribute>
            <xsl:attribute name="data">../swf/<xsl:value-of select="@href" />.swf</xsl:attribute>
            <xsl:attribute name="width">800</xsl:attribute>
            <xsl:attribute name="height">600</xsl:attribute>
            <xsl:element name="param">
              <xsl:attribute name="name">movie</xsl:attribute>
              <xsl:attribute name="value">../swf/<xsl:value-of select="@href" />.swf</xsl:attribute>
            </xsl:element>
            <xsl:element name="param">
              <xsl:attribute name="name">pluginspace</xsl:attribute>
              <xsl:attribute name="value">http://www.macromedia.com/go/getflashplayer</xsl:attribute>
            </xsl:element>
            <xsl:element name="embed">
              <xsl:attribute name="name">11</xsl:attribute>
              <xsl:attribute name="width">800</xsl:attribute>
              <xsl:attribute name="height">600</xsl:attribute>
              <xsl:attribute name="type">application/x-shockwave-flash</xsl:attribute>
              <xsl:attribute name="pluginspace">http://www.macromedia.com/go/getflashplayer</xsl:attribute>
              <xsl:attribute name="src">../swf/<xsl:value-of select="@href" />.swf</xsl:attribute>
            </xsl:element>
          </xsl:element>
        </div>
      </div>
      </div>
       </xsl:for-each>
      <xsl:apply-templates/>
    </div>
  </xsl:template>


<!-- 
##### IMAGES: OVERRIDES FOR IMAGE RESIZE ##### 
these are based on IDWB 3.8.3 templates 
additions or changes noted by ****** 
updated 06/14/2006 jta                                 
-->
<xsl:variable name="jscriptonload">javascript:resizeAtPageLoad();</xsl:variable> <!-- jta added 06/14/2006 ****** -->
<xsl:variable name="jscriptresize">javascript:resizeAllImages();</xsl:variable>  <!-- jta added 06/14/2006 ****** -->

<!-- 
##### IMAGES: NEEDED FOR IMAGE RESIZING #####
can go away if not resizing images in docs
-->

<xsl:template name="chapterBody">
    <body>
      <!-- Already put xml:lang on <html>; do not copy to body with commonattributes -->
      <xsl:call-template name="setonresize"/> <!-- ****** -->
      <xsl:call-template name="setidaname"/>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="start-revflag"/>
      <xsl:call-template name="generateBreadcrumbs"/>
      <xsl:call-template name="gen-user-header"/>  <!-- include user's XSL running header here -->
      <xsl:call-template name="processHDR"/>
      <!-- Include a user's XSL call here to generate a toc based on what's a child of topic -->
      <xsl:call-template name="gen-user-sidetoc"/>
      <xsl:apply-templates/> <!-- this will include all things within topic; therefore, -->
      <!-- title content will appear here by fall-through -->
      <!-- followed by prolog (but no fall-through is permitted for it) -->
      <!-- followed by body content, again by fall-through in document order -->
      <!-- followed by related links -->
      <!-- followed by child topics by fall-through -->
      
      <xsl:call-template name="gen-endnotes"/>    <!-- include footnote-endnotes -->
      <xsl:call-template name="gen-user-footer"/> <!-- include user's XSL running footer here -->
      <xsl:call-template name="processFTR"/>      <!-- Include XHTML footer, if specified -->
      <xsl:call-template name="end-revflag"/>
    </body>
    <xsl:value-of select="$newline"/>
  </xsl:template>

<!-- ****** -->
<xsl:template name="setonresize">
 <!-- jta added below 06/14/2006 -->
 <xsl:attribute name="onload">
   <xsl:value-of select="$jscriptonload"/>
 </xsl:attribute>
 <xsl:attribute name="onresize">
   <!-- jta removed 06/14/2006 <xsl:value-of select="$jscriptreload"/> -->
   <xsl:value-of select="$jscriptresize"/>
 </xsl:attribute>
</xsl:template>


<!--
##### FIXES FOR ECLIPSE EXTENSIONS #####
-->

<!-- Locates elements that have an outputclass attribute that contains
  'include' and replaces it with an include element. -->
  <!-- Amended to avoid avoid duplicate rule matches with the topic.p template.
       dwh 21.Aug.2006 -->
  <xsl:template match="//*[not(contains(@class,' topic/p ')) and contains(@outputclass, 'include')]">
    <xsl:element name="include">
      <xsl:attribute name="path"><xsl:value-of select="substring-after(@outputclass, 'include_')" /></xsl:attribute>
    </xsl:element>
    <xsl:apply-templates />
  </xsl:template>


  <!-- Locates elements that have an outputclass attribute that contains
  'anchor' and replaces it with an anchor element. -->
  <!-- Amended to avoid avoid duplicate rule matches with the topic.p template.
       dwh 21.Aug.2006 -->
  <xsl:template match="//*[not(contains(@class,' topic/p ')) and contains(@outputclass, 'anchor_')]">
    <xsl:element name="anchor">
      <xsl:attribute name="id"><xsl:value-of select="substring-after(@outputclass, 'anchor_')" /></xsl:attribute>
    </xsl:element>
    <xsl:apply-templates />
  </xsl:template>


  <!-- Locates outputclass attributes that contain product filters
  and replaces them with filter attributes that point to products. -->
  <xsl:template match="//@outputclass[contains(., 'filter_product')]">
    <xsl:attribute name="filter">product=<xsl:value-of select="substring-after(., 'filter_product_')" /></xsl:attribute>
  </xsl:template>

  <!-- Locates outputclass attributes that contain os filters
  and replaces them with filter attributes that point to the
  appropriate operating system. -->
  <xsl:template match="//@outputclass[contains(., 'filter_os')]">
    <xsl:choose>
      <xsl:when test="contains(., '_not_')">
        <xsl:attribute name="filter">os!=<xsl:value-of select="substring-after(., 'filter_os_not_')" /></xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="filter">os=<xsl:value-of select="substring-after(., 'filter_os_')" /></xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- Locates outputclass attributes that contain plugin filters
  and replaces them with filter attributes that point to the presence of
  the corresponding plug-in. -->
  <xsl:template match="//@outputclass[contains(., 'filter_plugin')]">
    <xsl:choose>
      <xsl:when test="contains(., '_not_')">
        <xsl:attribute name="filter">plugin!=<xsl:value-of select="substring-after(., 'filter_plugin_not_')" /></xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="filter">plugin=<xsl:value-of select="substring-after(., 'filter_plugin_')" /></xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- Replaces outputclass attributes that contain ids
  and replaces them with id attributes. -->
  <xsl:template match="//@outputclass[contains(., 'id_')]">
    <xsl:attribute name="id"><xsl:value-of select="substring-after(., 'id_')" /></xsl:attribute>
  </xsl:template>
<!--
##### End of fixes for Eclipse extensions #####
-->

<!-- 
##### OVERRIDE FOR "GET READY" TWISTIES #####
added 07/21/2006 jta 
these are based on IDWB 3.8.6 templates 
additions or changes noted by ******                   
-->

<xsl:template match="*[contains(@class,' topic/note ')][@outputclass='getready'][@type='other']" name="topic.note.getready">
	<xsl:if test="ancestor::*[contains(@class,' task/prereq ')]">
	  <xsl:call-template name="spec-title"/>
	  <div class="getready">
	  	<div class="collapseheadgetready">
	    	<a href="javascript:void(0)" class="collapsehead" onclick="collapse(this)">
	        	<xsl:value-of select="@othertype" />
			</a>
		</div>
	    <div class="collapsecontent">
	    	<xsl:apply-templates />
		</div>
	  </div>
	  <div class="learnmorebase">
	  	<xsl:text> </xsl:text>
	  </div>
	  <xsl:value-of select="$newline"/>
	</xsl:if>
</xsl:template>

<!-- 
##### RSS AND WEB FEEDS #####
Creates a link to Web feeds specified by writers in note elements
that have outputclass attibutes with the value 'webfeed'.
dwh :: 17.May.2007 
-->

  <xsl:template match="*[contains(@class,' topic/note ')][@outputclass='webfeed']" name="topic.note.webfeed">
      <xsl:call-template name="spec-title"/>
      <xsl:value-of select="$newline"/>
      <div class="webfeed">
        <span class="notetitle">
          <xsl:element name="a">
            <xsl:attribute name="class">webfeed-link</xsl:attribute>
            <xsl:attribute name="title">Afficher les articles en
anglais</xsl:attribute>
            <xsl:attribute name="href">javascript:void(0)</xsl:attribute>
            <xsl:attribute name="onClick">getWebFeed('<xsl:value-of select="xref/@href" />',this);</xsl:attribute>
            <xsl:value-of select="xref" />
          </xsl:element>
        </span>
       </div>
  </xsl:template>
  
<!-- 
################################
# TUTORIAL SPECIFIC TEMPLATES  #
################################
-->

  <!-- ##### Override Tutorial breadcrumbs #### --> 
  <xsl:template name="tutbreadcrumb">  
  	<!--<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>-->
  	<xsl:text disable-output-escaping="yes">&lt;!-- --&gt;</xsl:text>
  </xsl:template>
  
  <!-- #### Tutorial 'Learn More' notes #### -->
  <xsl:template match="/*[contains(@class, ' tutorialLesson/tutorialLesson ') or contains(@class, ' tutorialSummary/tutorialSummary ') or contains(@class, ' tutorialModule/tutorialModule ') or contains(@class, ' tutorial/tutorial ') or contains(@class, ' tutorialIntro/tutorialIntro ') or contains(@class,' authorInfo/authorInfo ')]//*[contains(@class,' topic/note ')][@outputclass='learnmore']" name="topic.tutorial.note">
    <xsl:call-template name="spec-title"/>
      <xsl:if test="@type='other'">
        <xsl:value-of select="$newline"/>
        <div class="learnmore">
          <xsl:call-template name="commonattributes"/>
          <xsl:call-template name="setidaname"/>
          <div class="collapseheadlearnmore">
            <a href="javascript:void(0)" class="collapsehead" onclick="collapse(this)">
            <xsl:value-of select="@othertype" />
            </a>
          </div>
          <div class="collapsecontent">
            <!-- <xsl:value-of select="." /> -->
            <xsl:apply-templates />
          </div>
         </div>
       <div class="learnmorebase"><xsl:text> </xsl:text></div>
     </xsl:if>
  </xsl:template>

  <!-- #### Tutorial 'Show Me' xrefs #### -->
  <xsl:template match="/*[contains(@class, ' tutorialLesson/tutorialLesson ') or contains(@class, ' tutorialSummary/tutorialSummary ') or contains(@class, ' tutorialModule/tutorialModule ') or contains(@class, ' tutorial/tutorial ') or contains(@class, ' tutorialIntro/tutorialIntro ') or contains(@class,' authorInfo/authorInfo ')]//*[contains(@class,' topic/xref ')][@outputclass='showme']" name="topic.tutorial.xref">
    <xsl:value-of select="$newline"/>
    <div class="showme">
      <div class="collapseheadshowme">
        <a href="javascript:void(0)" class="collapsehead" onclick="collapse(this)"><xsl:value-of select="." /></a>
      </div>
      <div class="collapsecontent">
        <div class="section">
          <xsl:choose>
            <!-- Parse values of 'otherprops' attribute. -->
            <xsl:when test="boolean(@otherprops)">
              <xsl:variable name="width">
                <xsl:value-of select="substring-before(@otherprops, 'x')" />
              </xsl:variable>
              <xsl:variable name="height">
                <xsl:value-of select="substring-after(@otherprops, 'x')" />
              </xsl:variable>
              <xsl:element name="object">
                <xsl:attribute name="id">11</xsl:attribute>
                <xsl:attribute name="codebase">http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab                    </xsl:attribute>
                <xsl:attribute name="type">application/x-shockwave-flash</xsl:attribute>
                <xsl:attribute name="classid">clsid:D27CDB6E-AE6D-11cf-96B8-444553540000</xsl:attribute>
                <xsl:attribute name="data"><xsl:value-of select="@href" /></xsl:attribute>
                <xsl:attribute name="width"><xsl:value-of select="$width" /></xsl:attribute>
                <xsl:attribute name="height"><xsl:value-of select="$height" /></xsl:attribute>
                <xsl:element name="param">
                  <xsl:attribute name="name">movie</xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="@href" /></xsl:attribute>
                </xsl:element>
                <xsl:element name="param">
                  <xsl:attribute name="name">pluginspace</xsl:attribute>
                  <xsl:attribute name="value">http://www.macromedia.com/go/getflashplayer</xsl:attribute>
                </xsl:element>
                <xsl:element name="embed">
                  <xsl:attribute name="name">11</xsl:attribute>
                  <xsl:attribute name="width"><xsl:value-of select="$width" /></xsl:attribute>
                  <xsl:attribute name="height"><xsl:value-of select="$height" /></xsl:attribute>
                  <xsl:attribute name="type">application/x-shockwave-flash</xsl:attribute>
                  <xsl:attribute name="pluginspace">http://www.macromedia.com/go/getflashplayer</xsl:attribute>
                  <xsl:attribute name="src"><xsl:value-of select="@href" /></xsl:attribute>
                </xsl:element>
              </xsl:element>
            </xsl:when>
            <!-- Default values for width and height attributes. -->
            <xsl:otherwise>
              <xsl:element name="object">
                <xsl:attribute name="id">11</xsl:attribute>
                <xsl:attribute name="codebase">http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab                    </xsl:attribute>
                <xsl:attribute name="type">application/x-shockwave-flash</xsl:attribute>
                <xsl:attribute name="classid">clsid:D27CDB6E-AE6D-11cf-96B8-444553540000</xsl:attribute>
                <xsl:attribute name="data"><xsl:value-of select="@href" /></xsl:attribute>
                <xsl:attribute name="width">800</xsl:attribute>
                <xsl:attribute name="height">600</xsl:attribute>
                <xsl:element name="param">
                  <xsl:attribute name="name">movie</xsl:attribute>
                  <xsl:attribute name="value"><xsl:value-of select="@href" /></xsl:attribute>
                </xsl:element>
                <xsl:element name="param">
                  <xsl:attribute name="name">pluginspace</xsl:attribute>
                  <xsl:attribute name="value">http://www.macromedia.com/go/getflashplayer</xsl:attribute>
                </xsl:element>
                <xsl:element name="embed">
                  <xsl:attribute name="name">11</xsl:attribute>
                  <xsl:attribute name="width">800</xsl:attribute>
                  <xsl:attribute name="height">600</xsl:attribute>
                  <xsl:attribute name="type">application/x-shockwave-flash</xsl:attribute>
                  <xsl:attribute name="pluginspace">http://www.macromedia.com/go/getflashplayer</xsl:attribute>
                  <xsl:attribute name="src"><xsl:value-of select="@href" /></xsl:attribute>
                </xsl:element>
              </xsl:element>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </div>
    </div>
    <div class="showmebase"><xsl:text> </xsl:text></div>
  </xsl:template>

<!-- 

	# THIS IS OVERRIDING THE tutorialBody TEMPLATE FROM tutorialspeclink.xsl
    #
    # ONE LINE CHANGE FOR A WEIRD PROBLEM WITH EHS
    # CONVERTING EMPTY DIVS TO SELF-CLOSING DIVS
    # AND THE CSS THEN GOING WONKY FOR ENTIRE PAGE
    # 
    # Also moving the Prev/Next links inside the header and before the footer
    # 
    # smp :: 2008:04:18

-->      
  <xsl:template name="tutorialBody">
    <body>
      <xsl:call-template name="setidaname"/>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="start-revflag"/>

      <!-- TutSpec :: breadcrumb -->
      <xsl:choose>
        <xsl:when test="boolean(//*[contains(@class,' topic/link ')][@role='tutbreadcrumb'])">
          <div class="breadcrumb">
            <xsl:call-template name="tutbreadcrumb" />
          </div>
        </xsl:when>
        <xsl:otherwise>
          <!-- smp: THIS IS THE CHANGED LINE --> 
          <!--<div class="breadcrumb"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>-->
          <div class="breadcrumb"><xsl:text disable-output-escaping="yes">&lt;!-- no breadcrumb entries --&gt;</xsl:text></div>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:call-template name="gen-user-header"/>  <!-- include user's XSL running header here -->
      <xsl:call-template name="processHDR"/>
      <!-- Include a user's XSL call here to generate a toc based on what's a child of topic -->
      <xsl:call-template name="gen-user-sidetoc"/>

      <!-- smp: MOVED TO AFTER HEADERS -->
      <!-- Insert previous-next links at the top of each topic. -->
      <xsl:call-template name="tutprevnext" />

      <xsl:apply-templates/> <!-- this will include all things within topic; therefore, -->
       <!-- title content will appear here by fall-through -->
       <!-- followed by prolog (but no fall-through is permitted for it) -->
       <!-- followed by body content, again by fall-through in document order -->
       <!-- followed by related links -->
       <!-- followed by child topics by fall-through -->

      <!-- smp: MOVED TO BEFORE FOOTERS -->
      <!-- Insert previous-home-next links at the bottom of each topic. -->
      <xsl:call-template name="tutprevnext" />

      <xsl:call-template name="gen-endnotes"/>    <!-- include footnote-endnotes -->
      <xsl:call-template name="gen-user-footer"/> <!-- include user's XSL running footer here -->
      <xsl:call-template name="processFTR"/>      <!-- Include XHTML footer, if specified -->
      <xsl:call-template name="end-revflag"/>

    </body>
    <xsl:value-of select="$newline"/>

  </xsl:template>




<!-- 
####################################
# END TUTORIAL SPECIFIC TEMPLATES  #
####################################
-->
  
<!-- 
###############################
# SAMPLES SPECIFIC TEMPLATES  #
###############################
-->
  <!-- JavaScript variables -->
  <xsl:variable name="jscriptImport" select="'javaScript:importPISample'" />
  <xsl:variable name="jscriptTutorial" select="'javaScript:linkTutorial'" />
  
  <!-- Match sample and call modified page setup. -->
  <xsl:template match="/*[contains(@class, ' sample/sample ')]" priority="1" name="sample_element">
    <xsl:call-template name="sample-setup"/>
  </xsl:template>

  <!-- Match sampleSetup and sampleDetails and call standard page
  setup -->
  <xsl:template match="/*[contains(@class, ' sampleSetup/sampleSetup ') or contains(@class, ' sampleDetails/sampleDetails ')]" priority="1" name="sampleSetup_element">
    <xsl:call-template name="sampleOther-setup"/>
  </xsl:template>

  <!-- Modified default page layout for sample. -->
  <xsl:template name="sample-setup">
    <html>
      <xsl:call-template name="setTopicLanguage"/>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="chapterHead"/>
      <xsl:call-template name="sampleBody"/>
    </html>
  </xsl:template>

  <xsl:template name="sampleBody">
    <body>
      <xsl:call-template name="setidaname"/>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="start-revflag"/>

      <xsl:call-template name="gen-user-header"/>  <!-- include user's XSL running header here -->
      <xsl:call-template name="processHDR"/>
      <!-- Include a user's XSL call here to generate a toc based on what's a child of topic -->
      <xsl:call-template name="gen-user-sidetoc"/>

      <!-- Calling individual templates to modify processing order
      for samples topics -->
      <xsl:apply-templates select="*[contains(@class,' topic/title ')][parent::*[contains(@class,' sample/sample ')]]" />

      <xsl:apply-templates select="*[contains(@class,' topic/shortdesc ')][parent::*[contains(@class,' sample/sample ')]]" mode="outofline" />

      <xsl:apply-templates select="*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' topic/section sample/timeRequired ')]" />
       <xsl:apply-templates select="*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' topic/section sample/samplePrereq ')]" />

      <xsl:apply-templates select="*[contains(@class,' sample/sampleRelatedLinks ')]" />

      <xsl:apply-templates select="*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleDesc ')]" />

      <xsl:apply-templates select="*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleGraphics ')]" />

      <xsl:call-template name="gen-endnotes"/>    <!-- include footnote-endnotes -->
      <xsl:call-template name="gen-user-footer"/> <!-- include user's XSL running footer here -->
      <xsl:call-template name="processFTR"/>      <!-- Include XHTML footer, if specified -->
      <xsl:call-template name="end-revflag"/>

    </body>
    <xsl:value-of select="$newline"/>

  </xsl:template>

  <!-- Modifiying standard page layout for sampleSetp and
  sampleDetails. -->
  <xsl:template name="sampleOther-setup">
    <html>
      <xsl:call-template name="setTopicLanguage"/>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="chapterHead"/>
      <xsl:call-template name="sampleSetupBody"/>
    </html>
  </xsl:template>

  <xsl:template name="sampleSetupBody">
    <body>
      <!-- Already put xml:lang on <html>; do not copy to body-->
      <xsl:call-template name="setidaname"/>
      <xsl:value-of select="$newline"/>
      <xsl:call-template name="flagit"/>
      <xsl:call-template name="start-revflag"/>
      <xsl:call-template name="generateBreadcrumbs"/>
      <xsl:call-template name="gen-user-header"/>  <!-- include user's XSL running header here -->
      <xsl:call-template name="processHDR"/>
      <!-- Include a user's XSL call here to generate a toc based on what's a child of topic -->
      <xsl:call-template name="gen-user-sidetoc"/>

      <!-- Link to parent from sampleDetails and sampleSetup -->
      <xsl:if test="self::*[contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]">
        <div class="breadcrumbs">
          <xsl:call-template name="sampparent" />
        </div>
      </xsl:if>

      <xsl:apply-templates/> <!-- this will include all things within topic; therefore, -->
                             <!-- title content will appear here by fall-through -->
                             <!-- followed by prolog (but no fall-through is permitted for it) -->
                             <!-- followed by body content, again by fall-through in document order -->
                             <!-- followed by related links -->
                             <!-- followed by child topics by fall-through -->

      <xsl:call-template name="gen-endnotes"/>
      <xsl:call-template name="gen-user-footer"/> <!-- include user's XSL running footer here -->
      <xsl:call-template name="processFTR"/>      <!-- Include XHTML footer, if specified -->
      <xsl:call-template name="end-revflag"/>
    </body>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- Sample title override -->
  <xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' topic/title ')]" name="topic.sampleTitle">
    <xsl:param name="headinglevel">
      <xsl:choose>
          <xsl:when test="count(ancestor::*[contains(@class,' topic/topic ')]) > 6">6</xsl:when>
          <xsl:otherwise><xsl:value-of select="count(ancestor::*[contains(@class,' topic/topic ')])"/></xsl:otherwise>
      </xsl:choose>
    </xsl:param>
    <xsl:if test="$headinglevel=1" >
      <div class="title">
        <xsl:element name="h{$headinglevel}">
          <xsl:call-template name="commonattributes"/>
          <xsl:apply-templates/>
        </xsl:element>
      </div>
    </xsl:if>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- sampleDesc -->
  <!-- 20080709:JA per RA, changed from xsl:template match="*[contains(@class,' topic/section sample/sampleDesc ')]" name="topic.sample.sampleDesc" -->
  <xsl:template match="*[contains(@class,' sample/sampleDesc ')]" name="topic.sample.sampleDesc">
    <div class="desc">
      <xsl:call-template name="commonattributes"/>
      <xsl:call-template name="gen-toc-id"/>
      <xsl:call-template name="setidaname"/>
      <xsl:call-template name="flagit"/>
      <xsl:variable name="revtest">
        <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
          <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
            <xsl:with-param name="allrevs" select="@rev"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
          <div class="{@rev}">
            <xsl:apply-templates select="."  mode="section-fmt" />
          </div>
        </xsl:when>
        <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
          <xsl:apply-templates select="."  mode="section-fmt" />
        </xsl:otherwise>
      </xsl:choose>
    </div><xsl:value-of select="$newline"/>
  </xsl:template>

  <!--sampleGraphics  -->
<!-- 20080709:JA per Robert Anderson, changed from xsl:template match="*[contains(@class,' topic/section sample/sampleGraphics ')]" name="topic.sample.sampleGraphics" -->
  <xsl:template match="*[contains(@class,' sample/sampleGraphics ')]" name="topic.sample.sampleGraphics">
    <div class="graphics">
      <!--  p class="graphicsText">Click on images to expand view</p>-->
      <xsl:call-template name="commonattributes"/>
      <xsl:call-template name="gen-toc-id"/>
      <xsl:call-template name="setidaname"/>
      <xsl:call-template name="flagit"/>
      <xsl:variable name="revtest">
        <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
          <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
            <xsl:with-param name="allrevs" select="@rev"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
          <div class="{@rev}">
            <xsl:apply-templates select="."  mode="section-fmt" />
          </div>
        </xsl:when>
        <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
          <xsl:apply-templates />
        </xsl:otherwise>
      </xsl:choose>
    </div><xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- Process only sampleGraphics elements. -->
 <!--
  <xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' topic/body sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleGraphics ')]">
    <div class="gdesc"><xsl:apply-templates /></div>
  </xsl:template>
-->
  <!-- Process only sampleGraphics/p elements.
  <xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' topic/body sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleGraphics ')]/*[contains(@class,' topic/p ')]">
       <div class="gdesc"><xsl:apply-templates /></div>
  </xsl:template>
  -->

  <!-- Process only sampleGraphics/p/image elements. -->
  <!-- 20080709: JA per RA, changed from xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' topic/body sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleGraphics ')]/*[contains(@class,' topic/p ')]/*[contains(@class, ' topic/image ')]" -->
  <xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' sample/sampleGraphics ')]/*[contains(@class,' topic/p ')]/*[contains(@class, ' topic/image ')]">
  
      <div class="gimage">
      <script type="text/javascript"><xsl:text>displayImage("</xsl:text><xsl:value-of select="@href" /><xsl:text>","</xsl:text><xsl:value-of select="*[contains(@class, ' topic/alt ')]" /><xsl:text>")</xsl:text></script>
    </div>
   
    <!-- Use mode set to text-only because base transforms don't handle alt text -->

  </xsl:template>

  <!-- Process only sampleGraphics/image elements. -->
  <!-- 20080709:JA per RA, changed from xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' topic/body sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleGraphics ')]/*[contains(@class, ' topic/image ')]" -->
  <xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' sample/sampleGraphics ')]/*[contains(@class, ' topic/image ')]">

      <div class="gimage">
      <script type="text/javascript"><xsl:text>displayImage("</xsl:text><xsl:value-of select="@href" /><xsl:text>","</xsl:text><xsl:value-of select="normalize-space(*[contains(@class, ' topic/alt ')])" /><xsl:text>")</xsl:text></script>
    </div>
  
  </xsl:template>

  <!-- Process only sampleGraphics/p/b elements. -->
  <!-- 20080709:JA per RA, changed from xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' topic/body sample/sampleBody ')]/*[contains(@class,' topic/section sample/sampleGraphics ')]/*[contains(@class,' topic/p ')]/*[contains(@class, ' topic/ph hi-d/b ')]" -->
  <xsl:template match="/*[contains(@class, ' sample/sample ') or contains(@class, ' sampleDetails/sampleDetails ') or contains(@class, ' sampleSetup/sampleSetup ')]/*[contains(@class,' sample/sampleBody ')]/*[contains(@class,' sample/sampleGraphics ')]/*[contains(@class,' topic/p ')]/*[contains(@class, ' topic/ph hi-d/b ')]">
    <strong><xsl:value-of select="." /></strong>
  </xsl:template>



  <!-- timeRequired -->
  <!-- 20080709:JA per RA, changed from xsl:template match="*[contains(@class,' topic/section sample/timeRequired ')]" name="topic.sample.timeRequired" -->
  <xsl:template match="*[contains(@class,' sample/timeRequired ')]" name="topic.sample.timeRequired">
    <div class="sampleTimeRequired">
      <xsl:call-template name="commonattributes"/>
      <xsl:call-template name="gen-toc-id"/>
      <xsl:call-template name="setidaname"/>
      <xsl:call-template name="flagit"/>
      <xsl:variable name="revtest">
        <xsl:if test="@rev and not($FILTERFILE='') and ($DRAFT='yes')"> <!-- revision? -->
          <xsl:call-template name="find-active-rev-flag">               <!-- active? (revtest will be 1 when active)-->
            <xsl:with-param name="allrevs" select="@rev"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$revtest=1">   <!-- Rev is active - add the DIV -->
          <div class="{@rev}"><xsl:apply-templates select="."  mode="section-fmt" /></div>
        </xsl:when>
        <xsl:otherwise>  <!-- Rev wasn't active - process normally -->
          <xsl:apply-templates select="."  mode="section-fmt" />
        </xsl:otherwise>
      </xsl:choose>
    </div><xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- sampleRelatedLinks -->
  <xsl:template match="*[contains(@class,' sample/sampleRelatedLinks ')]" name="topic.sample.sampleRelatedLinks">
    <div class="sampleLinks">
      <div class="impLinks">
        <!-- Process first seeSetup element only -->
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-setup'][1]" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-import']" />
        <!-- Process remaining seeSetup elements -->
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-setup'][not(position()=1)]" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-configure']" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-details'][1]" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-demo']" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-build']" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-how']" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-tutorial']" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-details'][not(position()=1)]" />
        <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-help']" />
             <xsl:apply-templates select="*[contains(@class,' topic/link ')][@outputclass='link-sample']" />
      </div>
    </div>
    <xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- link -->
  <xsl:template match="*[contains(@class,' topic/link ')][parent::*[contains(@class,' sample/sample ')]]" name="topic.sample.link">
    <div class="detailsLink">
      <xsl:call-template name="makeseesamplink" />
    </div><xsl:value-of select="$newline"/>
  </xsl:template>

  <!-- Make link -->
  <xsl:template name="makeseesamplink">
    <xsl:call-template name="linkdupinfo"/>
    <xsl:call-template name="flagit"/>
    <xsl:call-template name="start-revflag"/>
    <xsl:element name="a">
      <xsl:if test="boolean(@outputclass)">
        <!-- Apply common attributes, including outputclass, when
        the outputclass attribute exists. -->
        <xsl:call-template name="commonattributes"/>
      </xsl:if>
      <xsl:attribute name="href">
        <xsl:call-template name="href"/>
      </xsl:attribute>
      <xsl:if test="@scope='external' or @type='external' or ((@format='PDF' or @format='pdf') and not(@scope='local'))">
        <xsl:attribute name="target">_blank</xsl:attribute>
      </xsl:if>
      <!--create hover help if desc exists-->
      <xsl:if test="*[contains(@class, ' topic/desc ')]">
        <xsl:variable name="hoverhelp">
          <xsl:apply-templates select="*[contains(@class, ' topic/desc ')]" mode="text-only"/>
        </xsl:variable>
        <xsl:attribute name="title">
          <xsl:value-of select="normalize-space($hoverhelp)"/>
        </xsl:attribute>
      </xsl:if>
      <!--use linktext as linktext if it exists, otherwise use href as linktext-->
      <xsl:choose>
        <xsl:when test="*[contains(@class, ' topic/linktext ')]">
          <xsl:apply-templates select="*[contains(@class, ' topic/linktext ')]"/>
        </xsl:when>
        <xsl:otherwise>
          <!--use href-->
          <xsl:call-template name="href"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
    <xsl:call-template name="end-revflag"/>
  </xsl:template>

  <xsl:template name="sampparent">
    <xsl:for-each select="//*[contains(@class,' topic/link ')][@role='sampparent']">
      <xsl:element name="a">
        <xsl:attribute name="href">
          <xsl:value-of select="substring-before(@href, '.dita')"/>
          <xsl:text>.</xsl:text>
          <xsl:value-of select="$OUTEXT"/>
        </xsl:attribute>
        <xsl:value-of select="linktext" />
      </xsl:element>
    </xsl:for-each>
  </xsl:template>



<!-- 
###################################
# END SAMPLES SPECIFIC TEMPLATES  #
###################################
-->
   <!-- override for Syntax diagrams using idwb 4.0 patch 01 -->
    <xsl:character-map name="cm1">
    <xsl:output-character character="&lt;" string="&amp;lt;"/>  
    <xsl:output-character character="&amp;" string="&amp;amp;"/>
  </xsl:character-map>

<xsl:template match="*[contains(@class, ' pr-d/syntaxdiagram ')]" mode="process-after-doc">
  <xsl:variable name="synfilename">
    <xsl:value-of select="substring-before($FILENAME,'.dita')"/>
    <xsl:text>_syn</xsl:text>
    <xsl:number level="any"/>
    <xsl:text>.syn</xsl:text>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="ancestor::*[contains(@class,' topic/draft-comment ') or contains(@class,' topic/required-cleanup ')] and
                    $DRAFT='no'">
    </xsl:when>
    <xsl:otherwise>
      <xsl:result-document href="{$FILEREF}{$WORKDIR}{$synfilename}" method="text" use-character-maps="cm1">
        <xsl:call-template name="output-railroad-syntax-diagram"/>
      </xsl:result-document>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
  
</xsl:stylesheet>
