/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.viewer;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.account.CollaborationAccountInfo;
import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.CollaborationMeetingEvent;
import com.ibm.team.collaboration.core.meeting.DataTransferRequest;
import com.ibm.team.collaboration.core.meeting.ICollaborationMeetingListener;
import com.ibm.team.collaboration.core.meeting.MeetingHistoryStanza;
import com.ibm.team.collaboration.core.meeting.MeetingInvitationRequest;
import com.ibm.team.collaboration.core.meeting.ReceiveDataRequest;
import com.ibm.team.collaboration.core.meeting.SendDataRequest;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresence;
import com.ibm.team.collaboration.core.session.CollaborationPresenceEvent;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationSession;
import com.ibm.team.collaboration.core.session.CollaborationSessionEvent;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.core.session.CollaborationUserEvent;
import com.ibm.team.collaboration.core.session.ICollaborationPresenceListener;
import com.ibm.team.collaboration.core.session.ICollaborationSessionListener;
import com.ibm.team.collaboration.core.session.ICollaborationUserListener;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.chat.ui.action.ResumeChatAction;
import com.ibm.team.collaboration.internal.chat.ui.action.SendFileAction;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingAttributePart;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingSite;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingStanza;
import com.ibm.team.collaboration.internal.chat.ui.viewer.ChatMeetingTranscriptModel;
import com.ibm.team.collaboration.internal.core.service.DefaultCollaborationService;
import com.ibm.team.collaboration.internal.ui.action.AbstractContactActionDelegate;
import com.ibm.team.collaboration.internal.ui.viewer.CollaborationViewerUIProxy;
import com.ibm.team.collaboration.internal.ui.viewer.CollaborationViewerUIRegistry;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.collaboration.ui.text.CollaborationPresenceTextDecorator;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerMenuListener;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.core.notification.Notification;
import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormPartSite;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CommandNotMappedException;
import org.eclipse.ui.actions.ContributedAction;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChatMeetingViewer {
    private static final String KEY_WARN_MISSING_AVAILABILITY = "com.ibm.team.collaboration.chat.warn.of.availability";
    private static final int MESSAGE_COMPOSING_TIMEOUT = 2000;
    final CollaborationMeeting fChatMeeting;
    private final ICollaborationMeetingListener fChatMeetingListener = new ChatMeetingListener();
    ChatMeetingAttributePart fChatMeetingPart;
    private final ICollaborationPresenceListener fChatPresenceListener = new ChatPresenceListener();
    private final ICollaborationSessionListener fChatSessionListener = new ChatSessionListener();
    private final ICollaborationUserListener fChatUserListener = new ChatUserListener();
    private final Map<String, CommandAction> fCommandActions = new HashMap<String, CommandAction>(6);
    IStyledDocument fComposeDocument;
    private final ComposeViewerKeyListener fComposeKeyListener = new ComposeViewerKeyListener();
    final Map<URI, CollaborationData> fComposeRequests = Collections.synchronizedMap(new HashMap(2));
    StyledTextViewerSupport fComposeSupport;
    Job fComposeTimer;
    final CollaborationServiceJobQueue fJobQueue = new CollaborationServiceJobQueue();
    final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    boolean fResumeComposeSent = false;
    private final LineBackgroundListener fTranscriptHistoryPainter = new ChatTranscriptHistoryPainter();
    ChatMeetingTranscriptModel fTranscriptModel;
    StyledTextViewerSupport fTranscriptSupport;
    private boolean fViewerSealed = false;
    ChatMeetingSite fViewerSite;

    static String createReferenceLink(URIReference reference) {
        Assert.isNotNull((Object)reference);
        return "<a href=\"" + reference.getURI().toASCIIString() + "\" title=\"" + reference.getDetails() + "\">" + reference.getName() + "</a>";
    }

    static ChatMeetingStanza createStanza(CollaborationUser user, CollaborationData data, boolean history) {
        Assert.isNotNull((Object)data);
        return new ChatMeetingStanza(data.getId(), user, data.getMessage(), data.getMessageType(), data.getTimeStamp(), history);
    }

    static String createUserLink(CollaborationUser user, String pattern, IProgressMonitor monitor) {
        Assert.isNotNull((Object)user);
        Assert.isNotNull((Object)monitor);
        try {
            URIReference reference;
            monitor.beginTask(ChatMessages.ChatMeetingViewer_18, 200);
            String label = null;
            IContributorHandle handle = user.getContributor();
            if (handle != null && (reference = Hyperlinks.create((Object)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))) != null) {
                label = ChatMeetingViewer.createReferenceLink(reference);
            }
            if (label == null) {
                label = user.getUserName((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
            }
            String string = MessageFormat.format(pattern, label);
            return string;
        }
        finally {
            monitor.done();
        }
    }

    static StyledTextViewerSupport createViewerSupport() {
        StyledTextViewerSupport support = new StyledTextViewerSupport();
        support.getTextViewerDecorators().add(0, new CollaborationPresenceTextDecorator());
        support.setContextMenuListener((IMenuListener)new StyledTextViewerMenuListener(support));
        return support;
    }

    static boolean isCurrentIdentity(CollaborationUser user) {
        Assert.isNotNull((Object)user);
        ITeamRepository[] iTeamRepositoryArray = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = iTeamRepositoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            IContributor contributor = repository.loggedInContributor();
            if (contributor != null && contributor.getItemId().equals((Object)user.getUUID())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    ChatMeetingViewer(CollaborationMeeting meeting) {
        Assert.isNotNull((Object)meeting);
        this.fChatMeeting = meeting;
        this.addListeners();
        new Thread(ChatMessages.ChatMeetingViewer_19){

            public void run() {
                while (!ChatMeetingViewer.this.fJobQueue.isDisposed()) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable throwable) {
                            CollaborationChatPlugin.getInstance().log(throwable);
                        }

                        public void run() throws Exception {
                            IStatus status;
                            CollaborationServiceJob first = (this).ChatMeetingViewer.this.fJobQueue.dequeue();
                            if (first != null && !(status = first.run((IProgressMonitor)new NullProgressMonitor())).isOK()) {
                                CollaborationChatPlugin.getInstance().log(status);
                            }
                        }
                    });
                }
            }
        }.start();
    }

    void addListeners() {
        this.fChatMeeting.getSession().addSessionListener(this.fChatSessionListener);
        this.fChatMeeting.addMeetingListener(this.fChatMeetingListener);
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.addUserListener(this.fChatUserListener);
        service.addPresenceListener(this.fChatPresenceListener);
    }

    void appendComposeRequest(CollaborationData data) {
        Assert.isNotNull((Object)data);
        try {
            ReferencePosition[] positions;
            String message = data.getMessage();
            int length = this.fComposeDocument.getLength();
            if ("text/html".equals(data.getMessageType())) {
                this.fComposeDocument.replaceHTML(length, 0, XMLString.createFromXMLText((String)message));
            } else {
                this.fComposeDocument.replace(length, 0, message);
            }
            ReferencePosition[] referencePositionArray = positions = this.fComposeDocument.getReferencePositions(length, 1, false);
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                ReferencePosition position = referencePositionArray[n2];
                this.fComposeRequests.put(position.getReference(), data);
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        SourceViewer viewer = this.fComposeSupport.getSourceViewer();
        viewer.getSelectionProvider().setSelection((ISelection)new TextSelection((IDocument)this.fComposeDocument, this.fComposeDocument.getLength(), 0));
        if (!this.isVisible()) {
            this.fViewerSite.setUnread(true);
        } else {
            StyledText widget = viewer.getTextWidget();
            if (widget != null && !widget.isDisposed()) {
                widget.setFocus();
            }
        }
    }

    void asyncExec(final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!ChatMeetingViewer.this.fViewerSite.getWidget().isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    IStatus composeMail(Collection<CollaborationUser> users, Collection<? extends CollaborationData> data, IProgressMonitor monitor) {
        Assert.isNotNull(users);
        Assert.isNotNull(data);
        try {
            MultiStatus result;
            monitor.beginTask(ChatMessages.ChatMeetingViewer_64, 100 * data.size());
            if (data.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            ArrayList<CollaborationData> messages = new ArrayList<CollaborationData>(data.size());
            ArrayList<DataTransferRequest> requests = new ArrayList<DataTransferRequest>(data.size());
            for (CollaborationData collaborationData : data) {
                if (collaborationData instanceof DataTransferRequest) {
                    DataTransferRequest request = (DataTransferRequest)collaborationData;
                    requests.add(request);
                    continue;
                }
                messages.add(collaborationData);
            }
            ArrayList<IStatus> arrayList = new ArrayList<IStatus>(data.size());
            Set topics = Collections.emptySet();
            if (!messages.isEmpty()) {
                for (CollaborationData message : messages) {
                    arrayList.add(AbstractContactActionDelegate.composeMail(users, topics, (CollaborationData)message, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
                }
            }
            if (!requests.isEmpty()) {
                for (DataTransferRequest request : requests) {
                    Object object = request.getData();
                    if (object == null) continue;
                    arrayList.add(AbstractContactActionDelegate.composeMail((Collection)request.getUsers(), topics, (CollaborationData)request, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
                }
            }
            if ((result = new MultiStatus("com.ibm.team.collaboration.chat.rcp.ui", 0, arrayList.toArray(new IStatus[arrayList.size()]), ChatMessages.ChatMeetingViewer_65, null)).isOK()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            MultiStatus multiStatus = result;
            return multiStatus;
        }
        finally {
            monitor.done();
        }
    }

    void createComposeViewer(ITeamFormPartSite site, SashForm parent) {
        Assert.isNotNull((Object)site);
        Assert.isNotNull((Object)parent);
        this.fComposeSupport = ChatMeetingViewer.createViewerSupport();
        this.fComposeSupport.init(site);
        this.fComposeSupport.createContent((Composite)parent);
        DropTarget target = this.fComposeSupport.getDropTarget();
        Transfer[] transfers = target.getTransfer();
        boolean needsFileTransfer = true;
        Transfer[] transferArray = transfers;
        int n = transfers.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer transfer = transferArray[n2];
            if (FileTransfer.getInstance() == transfer) {
                needsFileTransfer = false;
            }
            ++n2;
        }
        if (needsFileTransfer) {
            Transfer[] temp = new Transfer[transfers.length + 1];
            temp[0] = FileTransfer.getInstance();
            System.arraycopy(transfers, 0, temp, 1, transfers.length);
            transfers = temp;
        }
        target.setTransfer(transfers);
        this.fComposeSupport.getDropAdapter().addDropTargetListener(new TransferDropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                StyledText widget;
                this.validateDrop(event);
                SourceViewer viewer = ChatMeetingViewer.this.fComposeSupport.getSourceViewer();
                if (viewer != null && (widget = viewer.getTextWidget()) != null && !widget.isDisposed() && !widget.isFocusControl()) {
                    widget.setFocus();
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void drop(DropTargetEvent event) {
                this.performDrop(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.validateDrop(event);
            }

            void dropFile(File file) {
                Assert.isNotNull((Object)file);
                SendDataRequest data = new SendDataRequest(ChatMeetingViewer.this.fChatMeeting.getInvitees(), file);
                ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob((CollaborationData)data){
                    private final /* synthetic */ CollaborationData val$data;
                    {
                        this.val$data = collaborationData;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        Assert.isNotNull((Object)monitor);
                        if ((this).ChatMeetingViewer.this.fChatMeeting.hasJoined()) {
                            return (this).ChatMeetingViewer.this.fChatMeeting.send(this.val$data, monitor);
                        }
                        return Status.OK_STATUS;
                    }
                });
            }

            public Transfer getTransfer() {
                return FileTransfer.getInstance();
            }

            public boolean isEnabled(DropTargetEvent event) {
                return LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) || FileTransfer.getInstance().isSupportedType(event.currentDataType);
            }

            void performDrop(DropTargetEvent event) {
                block7: {
                    block6: {
                        Object[] elements;
                        IStructuredSelection structured;
                        Assert.isNotNull((Object)event);
                        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) break block6;
                        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                        if (!(selection instanceof IStructuredSelection) || (structured = (IStructuredSelection)selection).isEmpty()) break block7;
                        Object[] objectArray = elements = structured.toArray();
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAdaptable adaptable;
                            File file;
                            Object element = objectArray[n2];
                            if (element instanceof File) {
                                this.dropFile((File)element);
                            } else if (element instanceof IAdaptable && (file = (File)(adaptable = (IAdaptable)element).getAdapter(File.class)) != null) {
                                this.dropFile(file);
                            }
                            ++n2;
                        }
                        break block7;
                    }
                    if (FileTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof String[]) {
                        String[] names;
                        String[] stringArray = names = (String[])event.data;
                        int n = names.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String name = stringArray[n3];
                            File file = new File(name);
                            this.dropFile(file);
                            ++n3;
                        }
                    }
                }
            }

            void validateDrop(DropTargetEvent event) {
                IStructuredSelection structured;
                ISelection selection;
                Assert.isNotNull((Object)event);
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && !FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                    return;
                }
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection && !(structured = (IStructuredSelection)selection).isEmpty()) {
                    Object[] elements = structured.toArray();
                    boolean incompatible = false;
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAdaptable adaptable;
                        File file;
                        Object element = objectArray[n2];
                        if (!(element instanceof File || element instanceof IAdaptable && (file = (File)(adaptable = (IAdaptable)element).getAdapter(File.class)) != null)) {
                            incompatible = true;
                        }
                        ++n2;
                    }
                    if (incompatible) {
                        event.detail = 0;
                        return;
                    }
                }
                if ((event.operations & 4) != 0) {
                    event.detail = 4;
                    return;
                }
                event.detail = 0;
            }
        });
        SourceViewer viewer = this.fComposeSupport.getSourceViewer();
        this.fComposeDocument = new StyledDocument();
        viewer.setDocument((IDocument)this.fComposeDocument, (IAnnotationModel)new AnnotationModel());
        StyledText widget = viewer.getTextWidget();
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = widget.getLineHeight() * 2;
        widget.setLayoutData((Object)gridData);
        viewer.prependVerifyKeyListener((VerifyKeyListener)this.fComposeKeyListener);
        this.createContextMenu(this.fViewerSite.getView().getSite(), this.fComposeSupport);
        this.fComposeDocument.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
                Assert.isNotNull((Object)event);
            }

            public void documentChanged(DocumentEvent event) {
                boolean empty;
                Assert.isNotNull((Object)event);
                boolean bl = empty = event.getDocument().getLength() == 0;
                if (!empty) {
                    if (!ChatMeetingViewer.this.fResumeComposeSent) {
                        ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                            public IStatus run(IProgressMonitor monitor) {
                                Assert.isNotNull((Object)monitor);
                                return (this).ChatMeetingViewer.this.fChatMeeting.resumeComposing(monitor);
                            }
                        });
                        ChatMeetingViewer.this.fResumeComposeSent = true;
                    }
                    if (ChatMeetingViewer.this.fComposeTimer != null) {
                        ChatMeetingViewer.this.fComposeTimer.cancel();
                    }
                    ChatMeetingViewer.this.fComposeTimer = new FoundationJob(ChatMessages.ChatMeetingViewer_25){

                        protected IStatus runProtected(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            IStatus status = (this).ChatMeetingViewer.this.fChatMeeting.cancelComposing(monitor);
                            ChatMeetingViewer.this.syncExec(new Runnable(){

                                public void run() {
                                    ((this).this).ChatMeetingViewer.this.fComposeTimer = null;
                                    ((this).this).ChatMeetingViewer.this.fResumeComposeSent = false;
                                }
                            });
                            return status;
                        }
                    };
                    ChatMeetingViewer.this.fComposeTimer.setPriority(20);
                    ChatMeetingViewer.this.fComposeTimer.setSystem(true);
                    ChatMeetingViewer.this.fComposeTimer.schedule(2000L);
                } else if (ChatMeetingViewer.this.fResumeComposeSent) {
                    if (ChatMeetingViewer.this.fComposeTimer != null) {
                        ChatMeetingViewer.this.fComposeTimer.cancel();
                    }
                    ChatMeetingViewer.this.fComposeTimer = null;
                    ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            return (this).ChatMeetingViewer.this.fChatMeeting.cancelComposing(monitor);
                        }
                    });
                    ChatMeetingViewer.this.fResumeComposeSent = false;
                }
            }
        });
    }

    void createContextMenu(IWorkbenchPartSite site, StyledTextViewerSupport support) {
        Assert.isNotNull((Object)site);
        Assert.isNotNull((Object)support);
        SourceViewer viewer = support.getSourceViewer();
        MenuManager manager = new MenuManager(null, "#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new ChatMenuListener(site, viewer));
        StyledText widget = viewer.getTextWidget();
        widget.setMenu(manager.createContextMenu((Control)widget));
        site.registerContextMenu(site.getId(), manager, (ISelectionProvider)support.getStructuredSelectionProvider());
    }

    public void createControl(final Composite parent, ChatMeetingViewer predecessor) {
        Composite container;
        SashForm sash;
        Assert.isNotNull((Object)parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 3;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (this.fChatMeeting.isMultiMeeting()) {
            sash = new SashForm(parent, 256);
            sash.setLayoutData((Object)new GridData(4, 4, true, true));
            container = sash;
        } else {
            container = parent;
            sash = null;
        }
        final SashForm chatSash = new SashForm(container, 512);
        TeamFormPartSite partSite = new TeamFormPartSite((IWorkbenchPart)this.fViewerSite.getView());
        this.fTranscriptModel = predecessor != null ? predecessor.getTranscriptModel() : new ChatMeetingTranscriptModel(parent.getShell());
        this.fTranscriptModel.setHistory(true);
        this.createTranscriptViewer((ITeamFormPartSite)partSite, (Composite)chatSash);
        this.createComposeViewer((ITeamFormPartSite)partSite, chatSash);
        this.fTranscriptSupport.getSourceViewer().appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (Character.getType(event.character) != 15) {
                    SourceViewer viewer = ChatMeetingViewer.this.fComposeSupport.getSourceViewer();
                    String value = viewer.getDocument().get();
                    value = String.valueOf(value) + String.valueOf(event.character);
                    StyledText widget = viewer.getTextWidget();
                    viewer.getDocument().set(value);
                    widget.setFocus();
                    widget.setCaretOffset(widget.getCharCount());
                }
            }
        });
        chatSash.setLayoutData((Object)new GridData(4, 4, true, true));
        chatSash.setWeights(new int[]{80, 20});
        if (this.fChatMeeting.isMultiMeeting()) {
            this.fChatMeetingPart = new ChatMeetingAttributePart((Composite)sash, this.fChatMeeting);
            this.fChatMeetingPart.addTopicListener(new ChatMeetingAttributePart.IChatMeetingTopicListener(){

                public void topicAdded(URIReference topic) {
                    Assert.isNotNull((Object)topic);
                    ChatMeetingViewer.this.processTopicProposal(topic);
                }

                public void topicRemoved(URIReference topic) {
                    Assert.isNotNull((Object)topic);
                }
            });
            sash.setWeights(new int[]{70, 30});
            sash.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                    Assert.isNotNull((Object)event);
                }

                public void controlResized(ControlEvent event) {
                    boolean horizontal;
                    Assert.isNotNull((Object)event);
                    Point size = parent.getSize();
                    if (size.x != 0 && size.y != 0 && (horizontal = size.x > size.y) != (sash.getOrientation() == 256)) {
                        if (horizontal) {
                            sash.setOrientation(256);
                            chatSash.moveAbove(ChatMeetingViewer.this.fChatMeetingPart.getControl());
                        } else {
                            sash.setOrientation(512);
                            chatSash.moveBelow(ChatMeetingViewer.this.fChatMeetingPart.getControl());
                        }
                    }
                }
            });
        }
        FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_26){

            protected IStatus runProtected(IProgressMonitor monitor) {
                ChatMeetingViewer.this.refreshLabel(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    void createTranscriptViewer(ITeamFormPartSite partSite, Composite parent) {
        Assert.isNotNull((Object)partSite);
        Assert.isNotNull((Object)parent);
        IWorkbenchPartSite viewSite = this.fViewerSite.getView().getSite();
        StandardContextProvider provider = new StandardContextProvider(null);
        provider.setUIContext((Object)viewSite.getPage());
        this.fTranscriptSupport = ChatMeetingViewer.createViewerSupport();
        this.fTranscriptSupport.init(partSite);
        this.fTranscriptSupport.setEnableSpellChecking(false);
        this.fTranscriptSupport.createContent(parent);
        SourceViewer viewer = this.fTranscriptSupport.getSourceViewer();
        viewer.setEditable(false);
        StyledText widget = viewer.getTextWidget();
        widget.addLineBackgroundListener(this.fTranscriptHistoryPainter);
        widget.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContextMenu(viewSite, this.fTranscriptSupport);
        viewer.setDocument((IDocument)this.fTranscriptModel.getTranscript(), (IAnnotationModel)new AnnotationModel());
        new Thread(ChatMessages.ChatMeetingViewer_27){

            public void run() {
                final Iterator iterator = ChatMeetingViewer.this.fChatMeeting.getQueuedData();
                while (iterator.hasNext()) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable throwable) {
                            CollaborationChatPlugin.getInstance().log(throwable);
                        }

                        public void run() {
                            final CollaborationData data = (CollaborationData)iterator.next();
                            if (data != null) {
                                if (data.isCompose() || data.isSend()) {
                                    String message = data.getMessage();
                                    if (message != null && !"".equals(message)) {
                                        ChatMeetingViewer.this.asyncExec(new Runnable(){

                                            public void run() {
                                                ChatMeetingViewer.this.appendComposeRequest(data);
                                            }
                                        });
                                    }
                                } else if (data.isReceive() && data instanceof ReceiveDataRequest) {
                                    ReceiveDataRequest request = (ReceiveDataRequest)data;
                                    ChatMeetingViewer.this.processDataReceive(request);
                                } else if (data.isHistory() && data instanceof MeetingHistoryStanza) {
                                    final MeetingHistoryStanza extended = (MeetingHistoryStanza)data;
                                    final CollaborationUser user = extended.getUser();
                                    if ((this).ChatMeetingViewer.this.fChatMeeting.isMultiMeeting() && extended.isLast()) {
                                        ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                                            public IStatus run(IProgressMonitor monitor) {
                                                Assert.isNotNull((Object)monitor);
                                                try {
                                                    monitor.beginTask(ChatMessages.ChatMeetingViewer_28, 100);
                                                    final ChatMeetingStanza message = ChatMeetingViewer.createStanza(user, data, false);
                                                    String link = ChatMeetingViewer.createUserLink(user, ChatMessages.ChatMeetingViewer_29, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                                    final ChatMeetingStanza invitation = new ChatMeetingStanza(link, "text/html", message.getTimeStamp() - 1L);
                                                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                                                        public void run() {
                                                            (((this).this).this).ChatMeetingViewer.this.fTranscriptModel.addStanza(invitation);
                                                            ChatMeetingViewer.this.processStanza(user, message, true, false);
                                                        }
                                                    });
                                                    IStatus iStatus = Status.OK_STATUS;
                                                    return iStatus;
                                                }
                                                finally {
                                                    monitor.done();
                                                }
                                            }
                                        });
                                    } else {
                                        ChatMeetingViewer.this.asyncExec(new Runnable(){

                                            public void run() {
                                                ChatMeetingViewer.this.processStanza(user, ChatMeetingViewer.createStanza(user, data, !extended.isLast()), true, false);
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    });
                }
            }
        }.start();
    }

    public void dispose() {
        this.fResourceManager.dispose();
        for (CommandAction action : this.fCommandActions.values()) {
            action.dispose();
        }
        this.removeListeners();
        if (this.fChatMeeting.hasJoined()) {
            this.scheduleJob(new CollaborationServiceJob(){

                public IStatus run(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    ChatMeetingViewer.this.fJobQueue.dispose();
                    if (ChatMeetingViewer.this.fChatMeeting.hasJoined()) {
                        return ChatMeetingViewer.this.fChatMeeting.leave(monitor);
                    }
                    return Status.OK_STATUS;
                }
            });
        } else {
            this.fJobQueue.dispose();
        }
        if (this.fTranscriptSupport != null) {
            StyledText widget = this.fTranscriptSupport.getSourceViewer().getTextWidget();
            if (widget != null) {
                widget.removeLineBackgroundListener(this.fTranscriptHistoryPainter);
            }
            this.fTranscriptSupport.dispose();
            this.fTranscriptSupport = null;
        }
        if (this.fComposeSupport != null) {
            this.fComposeSupport.getSourceViewer().removeVerifyKeyListener((VerifyKeyListener)this.fComposeKeyListener);
            this.fComposeSupport.dispose();
            this.fComposeSupport = null;
        }
    }

    CommandAction getCommandAction(IServiceLocator locator, String commandId) {
        Assert.isNotNull((Object)locator);
        Assert.isNotNull((Object)commandId);
        CommandAction result = this.fCommandActions.get(commandId);
        if (result == null) {
            result = new CommandAction(locator, commandId);
        }
        return result;
    }

    public ITextViewer getComposeViewer() {
        return this.fComposeSupport.getSourceViewer();
    }

    public String getId() {
        return this.fChatMeeting.getId();
    }

    public String getLabel() {
        String label = this.fViewerSite.getLabel();
        if (this.fViewerSealed) {
            String decoration = ChatMessages.ChatMeetingViewer_30;
            label.replace(decoration, "");
            label = label.trim();
        }
        return label;
    }

    public CollaborationMeeting getMeeting() {
        return this.fChatMeeting;
    }

    public ChatMeetingTranscriptModel getTranscriptModel() {
        return this.fTranscriptModel;
    }

    public ITextViewer getTranscriptViewer() {
        return this.fTranscriptSupport.getSourceViewer();
    }

    public void init(ChatMeetingSite site) {
        Assert.isNotNull((Object)site);
        this.fViewerSite = site;
    }

    public boolean isSealed() {
        return this.fViewerSealed;
    }

    public boolean isVisible() {
        StyledText widget = this.fTranscriptSupport.getSourceViewer().getTextWidget();
        if (widget != null && !widget.isDisposed()) {
            return widget.isVisible() && !widget.getShell().getMinimized();
        }
        return false;
    }

    void processComposingNotification(CollaborationUser user, String name, boolean composing) {
        boolean show;
        Assert.isNotNull((Object)user);
        boolean bl = show = !ChatMeetingViewer.isCurrentIdentity(user);
        if (composing && show) {
            this.fViewerSite.setComposing(name);
        } else {
            this.fViewerSite.setComposing(null);
        }
        if (show) {
            this.fViewerSite.setBusy(composing && !this.isVisible());
            IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.fViewerSite.getView().getSite().getAdapter(IWorkbenchSiteProgressService.class);
            if (service != null) {
                if (composing) {
                    service.incrementBusy();
                } else {
                    try {
                        service.decrementBusy();
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        }
    }

    void processDataReceive(final ReceiveDataRequest request) {
        Assert.isNotNull((Object)request);
        this.scheduleJob(new CollaborationServiceJob(){

            public IStatus run(IProgressMonitor monitor) {
                Assert.isNotNull((Object)monitor);
                final CollaborationUser user = request.getUser();
                final String name = user.getUserName(monitor);
                final String text = ChatMeetingViewer.createUserLink(user, ChatMessages.ChatMeetingViewer_0, monitor);
                ChatMeetingViewer.this.asyncExec(new Runnable(){

                    public void run() {
                        ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(text, "text/html"), true, false);
                        StyledText widget = (this).ChatMeetingViewer.this.fTranscriptSupport.getSourceViewer().getTextWidget();
                        if (widget != null && !widget.isDisposed() && MessageDialog.openQuestion((Shell)widget.getShell(), (String)ChatMessages.ChatMeetingViewer_1, (String)MessageFormat.format(ChatMessages.ChatMeetingViewer_2, name, request.getDescription()))) {
                            FileDialog dialog = new FileDialog(widget.getShell(), 8192);
                            dialog.setFilterPath(System.getProperty("user.home", null));
                            dialog.setText(ChatMessages.ChatMeetingViewer_3);
                            dialog.setFileName(request.getName());
                            final String path = dialog.open();
                            if (path != null && !"".equals(path)) {
                                ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_4, "text/plain"), false, false);
                                FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_5){

                                    /*
                                     * Loose catch block
                                     */
                                    protected IStatus runProtected(IProgressMonitor progress) {
                                        IStatus iStatus;
                                        OutputStream stream;
                                        block11: {
                                            stream = null;
                                            stream = new BufferedOutputStream(new FileOutputStream(new File(path)));
                                            final IStatus status = request.accept(stream, progress);
                                            ChatMeetingViewer.this.asyncExec(new Runnable(){

                                                public void run() {
                                                    if (status.isOK()) {
                                                        try {
                                                            String link = new File(path).toURI().toString();
                                                            ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(MessageFormat.format(ChatMessages.ChatMeetingViewer_6, link), "text/html"), false, false);
                                                        }
                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                            ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_31, "text/plain"), false, false);
                                                        }
                                                    } else if (status.matches(8)) {
                                                        ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_7, "text/plain"), false, false);
                                                    } else {
                                                        ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_8, "text/plain"), false, false);
                                                    }
                                                }
                                            });
                                            iStatus = status;
                                            if (stream == null) break block11;
                                            try {
                                                stream.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        return iStatus;
                                        catch (IOException iOException) {
                                            IStatus iStatus2;
                                            block12: {
                                                try {
                                                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                                                        public void run() {
                                                            ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_9, "text/plain"), false, false);
                                                        }
                                                    });
                                                    iStatus2 = Status.OK_STATUS;
                                                    if (stream == null) break block12;
                                                }
                                                catch (Throwable throwable) {
                                                    if (stream != null) {
                                                        try {
                                                            stream.close();
                                                        }
                                                        catch (IOException iOException2) {}
                                                    }
                                                    throw throwable;
                                                }
                                                try {
                                                    stream.close();
                                                }
                                                catch (IOException iOException3) {}
                                            }
                                            return iStatus2;
                                        }
                                    }
                                };
                                job.setPriority(30);
                                job.setSystem(false);
                                job.schedule();
                                return;
                            }
                        }
                        ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_10, "text/plain"), true, false);
                        request.decline();
                    }
                });
                return Status.OK_STATUS;
            }
        });
    }

    void processStanza(ChatMeetingStanza stanza) {
        Assert.isNotNull((Object)stanza);
        this.fTranscriptModel.addStanza(stanza);
        this.revealTranscriptTail();
    }

    void processStanza(final CollaborationUser user, final ChatMeetingStanza stanza, boolean allow, boolean force) {
        Assert.isNotNull((Object)user);
        Assert.isNotNull((Object)stanza);
        this.processStanza(stanza);
        if (allow && (force || !this.isVisible())) {
            FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_33){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    ChatMeetingViewer.this.sendTeamNotification(user, stanza, "com.ibm.team.collaboration.incoming.message", monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }
    }

    void processTopicChange(URIReference topic, boolean add) {
        Assert.isNotNull((Object)topic);
        String link = ChatMeetingViewer.createReferenceLink(topic);
        String pattern = add ? ChatMessages.ChatMeetingViewer_34 : ChatMessages.ChatMeetingViewer_35;
        this.fTranscriptModel.addStanza(new ChatMeetingStanza(MessageFormat.format(pattern, link), "text/html"));
        this.revealTranscriptTail();
    }

    void processTopicProposal(URIReference topic) {
        Assert.isNotNull((Object)topic);
        try {
            this.fComposeDocument.replaceHTML(this.fComposeDocument.getLength(), 0, XMLString.createFromXMLText((String)MessageFormat.format(ChatMessages.ChatMeetingViewer_36, ChatMeetingViewer.createReferenceLink(topic))));
        }
        catch (BadLocationException badLocationException) {}
        this.fComposeSupport.getSourceViewer().getSelectionProvider().setSelection((ISelection)new TextSelection((IDocument)this.fComposeDocument, 0, this.fComposeDocument.getLength()));
        if (!this.isVisible()) {
            this.fViewerSite.setUnread(true);
        }
    }

    void processUserChange(final CollaborationUser user, String link) {
        Assert.isNotNull((Object)user);
        Assert.isNotNull((Object)link);
        final ChatMeetingStanza stanza = new ChatMeetingStanza(link, "text/html");
        this.fTranscriptModel.addStanza(stanza);
        this.revealTranscriptTail();
        if (!this.isVisible()) {
            FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_32){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    ChatMeetingViewer.this.sendTeamNotification(user, stanza, "com.ibm.team.collaboration.user", monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }
    }

    void processUserDeclined(final CollaborationUser user, String link) {
        Assert.isNotNull((Object)user);
        Assert.isNotNull((Object)link);
        final ChatMeetingStanza stanza = new ChatMeetingStanza(link, "text/html");
        this.fTranscriptModel.addStanza(stanza);
        this.revealTranscriptTail();
        if (!this.isVisible()) {
            FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_37){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    ChatMeetingViewer.this.sendTeamNotification(user, stanza, "com.ibm.team.collaboration.user", monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setSystem(true);
            job.schedule();
        }
    }

    void processUsersInvited(Collection<String> links) {
        Assert.isNotNull(links);
        String text = null;
        int size = links.size();
        Iterator<String> iterator = links.iterator();
        if (size == 1) {
            text = MessageFormat.format(ChatMessages.ChatMeetingViewer_38, iterator.next());
        } else if (size == 2) {
            text = MessageFormat.format(ChatMessages.ChatMeetingViewer_39, iterator.next(), iterator.next());
        } else if (size > 2) {
            Object[] elements = links.toArray();
            StringBuilder builder = new StringBuilder(256);
            int index = 0;
            while (index < elements.length) {
                if (index > 0) {
                    if (index == elements.length - 1) {
                        builder.append(ChatMessages.ChatMeetingViewer_40);
                    } else {
                        builder.append(ChatMessages.ChatMeetingViewer_41);
                    }
                }
                builder.append(elements[index]);
                ++index;
            }
            text = MessageFormat.format(ChatMessages.ChatMeetingViewer_42, builder.toString());
        }
        if (text != null) {
            this.fTranscriptModel.addStanza(new ChatMeetingStanza(text, "text/html"));
            this.revealTranscriptTail();
        }
    }

    public void refreshLabel(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        try {
            String tooltip;
            String label;
            URIReference scope;
            monitor.beginTask(ChatMessages.ChatMeetingViewer_43, 100);
            String description = "";
            CollaborationSession session = this.fChatMeeting.getSession();
            DefaultCollaborationService service = DefaultCollaborationService.getInstance();
            CollaborationAccountInfo info = service.getAccountManager().getAccount(session.getAccountId());
            if (info != null) {
                String server = info.getServer().toString();
                if ("localhost".equals(server)) {
                    server = ChatMessages.ChatMeetingViewer_44;
                }
                description = MessageFormat.format(ChatMessages.ChatMeetingViewer_45, server);
            }
            if ((scope = this.fChatMeeting.getScope()) != null) {
                label = scope.getName();
                tooltip = MessageFormat.format(ChatMessages.ChatMeetingViewer_46, label, description);
            } else {
                Collection invitees = this.fChatMeeting.getInvitees();
                int size = invitees.size();
                if (size > 1 || this.fChatMeeting.isMultiMeeting()) {
                    String count = String.valueOf(size);
                    label = MessageFormat.format(ChatMessages.ChatMeetingViewer_49, count);
                    tooltip = MessageFormat.format(ChatMessages.ChatMeetingViewer_50, count, description);
                } else {
                    CollaborationUser user = size == 1 ? (CollaborationUser)invitees.iterator().next() : session.getUser();
                    label = user.getUserName((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                    tooltip = MessageFormat.format(ChatMessages.ChatMeetingViewer_47, label, service.getPresenceStatus(user).getLabel(), description);
                }
            }
            this.asyncExec(new Runnable(){

                public void run() {
                    Widget widget = ChatMeetingViewer.this.fViewerSite.getWidget();
                    if (!widget.isDisposed()) {
                        ChatMeetingViewer.this.refreshViewerLabel(label, tooltip);
                    }
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    void refreshViewerLabel(String label, String tooltip) {
        Assert.isNotNull((Object)label);
        Assert.isNotNull((Object)tooltip);
        String text = label;
        if (this.fViewerSealed) {
            text = MessageFormat.format(ChatMessages.ChatMeetingViewer_52, text);
        }
        this.fViewerSite.setLabel(text);
        text = tooltip;
        if (this.fViewerSealed) {
            text = MessageFormat.format(ChatMessages.ChatMeetingViewer_53, text);
        }
        this.fViewerSite.setToolTip(text);
        this.fViewerSite.getView().updateContentDescription();
    }

    void removeListeners() {
        ICollaborationService service = CollaborationCore.getCollaborationService();
        service.removeUserListener(this.fChatUserListener);
        service.removePresenceListener(this.fChatPresenceListener);
        this.fChatMeeting.removeMeetingListener(this.fChatMeetingListener);
        this.fChatMeeting.getSession().removeSessionListener(this.fChatSessionListener);
    }

    void revealTranscriptTail() {
        SourceViewer viewer = this.fTranscriptSupport.getSourceViewer();
        int length = viewer.getDocument().getLength();
        viewer.setSelectedRange(length, 0);
        viewer.revealRange(length, 0);
        if (!viewer.getTextWidget().isVisible()) {
            this.fViewerSite.setUnread(true);
        }
    }

    void scheduleJob(CollaborationServiceJob job) {
        Assert.isNotNull((Object)job);
        this.fJobQueue.enqueue(job);
    }

    void sealViewer() {
        if (!this.fViewerSealed) {
            try {
                this.removeListeners();
                StyledText widget = this.fTranscriptSupport.getSourceViewer().getTextWidget();
                if (widget != null && !widget.isDisposed()) {
                    widget.setEditable(false);
                }
                if ((widget = this.fComposeSupport.getSourceViewer().getTextWidget()) != null) {
                    widget.setText("");
                    widget.setEditable(false);
                    widget.setEnabled(false);
                }
            }
            finally {
                this.fViewerSealed = true;
                Widget widget = this.fViewerSite.getWidget();
                if (!widget.isDisposed()) {
                    this.refreshViewerLabel(this.fViewerSite.getLabel(), this.fViewerSite.getToolTip());
                }
                if (this.fChatMeetingPart != null) {
                    this.fChatMeetingPart.sealPart();
                }
            }
        }
    }

    void sendTeamNotification(CollaborationUser user, ChatMeetingStanza stanza, String eventType, IProgressMonitor monitor) {
        Assert.isNotNull((Object)user);
        Assert.isNotNull((Object)stanza);
        Assert.isNotNull((Object)eventType);
        Assert.isNotNull((Object)monitor);
        String text = null;
        text = "text/html".equals(stanza.getTextType()) ? XMLString.createFromXMLText((String)stanza.getText()).getPlainText() : stanza.getText();
        if (text.length() > 100) {
            text = MessageFormat.format("{0}...", text.substring(0, 97));
        }
        try {
            ImageDescriptor descriptor;
            monitor.beginTask(ChatMessages.ChatMeetingViewer_55, 200);
            NotificationInfo info = new NotificationInfo(user.getUserName((IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)), text){

                public boolean isSameTo(NotificationInfo other) {
                    Assert.isNotNull((Object)other);
                    return this.getDetail().equals(other.getDetail());
                }
            };
            IContributorHandle handle = user.getContributor();
            if (handle != null && (descriptor = CollaborationUI.getImageDescriptor((IContributorHandle)handle, (int)48, (int)48, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2))) != null) {
                info.setImageUrl(JazzResources.getConformingURL((URL)JazzResources.createURL((ImageDescriptor)descriptor)));
            }
            info.setDetail((Object)user.getUUID());
            info.setRunnable(new Runnable(){

                public void run() {
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            Widget widget = (this).ChatMeetingViewer.this.fViewerSite.getWidget();
                            if (!widget.isDisposed()) {
                                (this).ChatMeetingViewer.this.fViewerSite.getView().setActiveViewer((this).ChatMeetingViewer.this.fViewerSite.getViewer().getId(), true);
                            }
                        }
                    });
                }
            });
            Notification.send((String)eventType, (NotificationInfo)info);
        }
        finally {
            monitor.done();
        }
    }

    public void setFocus() {
        StyledText widget = this.fComposeSupport.getSourceViewer().getTextWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.setFocus();
            this.fViewerSite.setUnread(false);
        }
    }

    boolean showAvailabilityWarning(CollaborationPresence presence, String operation, String data, IProgressMonitor monitor) {
        Assert.isNotNull((Object)presence);
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)monitor);
        final IPreferenceStore store = CollaborationChatPlugin.getInstance().getPreferenceStore();
        store.setDefault(KEY_WARN_MISSING_AVAILABILITY, true);
        final boolean warn = store.getBoolean(KEY_WARN_MISSING_AVAILABILITY);
        final boolean active = presence.isActive();
        if (warn || !active) {
            final String caption = presence.getText(monitor);
            final String message = active ? MessageFormat.format(ChatMessages.ChatMeetingViewer_61, caption, operation, data) : MessageFormat.format(ChatMessages.ChatMeetingViewer_63, caption, operation);
            final int[] result = new int[]{2};
            this.syncExec(new Runnable(){

                public void run() {
                    Shell shell = ChatMeetingViewer.this.fViewerSite.getView().getSite().getShell();
                    if (active) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)caption, (String)message, (String)ChatMessages.ChatMeetingViewer_62, (!warn ? 1 : 0) != 0, null, null);
                        result[0] = dialog.getReturnCode();
                        store.setValue(ChatMeetingViewer.KEY_WARN_MISSING_AVAILABILITY, !dialog.getToggleState());
                    } else if (!MessageDialog.openQuestion((Shell)shell, (String)caption, (String)message)) {
                        result[0] = 3;
                    }
                }
            });
            return result[0] == 2;
        }
        return true;
    }

    void syncExec(final Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    Widget widget = ChatMeetingViewer.this.fViewerSite.getWidget();
                    if (widget != null && !widget.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private final class ChatMeetingListener
    implements ICollaborationMeetingListener {
        ChatMeetingListener() {
        }

        public void meetingNotification(final CollaborationMeetingEvent event) {
            Assert.isNotNull((Object)event);
            if (!ChatMeetingViewer.this.fChatMeeting.equals((Object)event.getMeeting())) {
                return;
            }
            switch (event.getType()) {
                case 3: {
                    final CollaborationUser user = event.getUser();
                    ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            final String name = user.getUserName(monitor);
                            ChatMeetingViewer.this.asyncExec(new Runnable(){

                                public void run() {
                                    ChatMeetingViewer.this.processComposingNotification(user, name, true);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    });
                    break;
                }
                case 4: {
                    final CollaborationUser user = event.getUser();
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processComposingNotification(user, null, false);
                        }
                    });
                    break;
                }
                case 8: {
                    final CollaborationUser user = event.getUser();
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processComposingNotification(user, null, false);
                        }
                    });
                    final CollaborationData data = event.getData();
                    if (data instanceof ReceiveDataRequest) {
                        ChatMeetingViewer.this.processDataReceive((ReceiveDataRequest)data);
                        break;
                    }
                    if (data.getMessage() == null) break;
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processStanza(user, ChatMeetingViewer.createStanza(user, data, false), true, false);
                        }
                    });
                    break;
                }
                case 5: {
                    String message;
                    final CollaborationData data = event.getData();
                    if (data == null || data.isTransfer() || data.isSend() || data.isCompose() || (message = data.getMessage()) == null || ChatMeetingViewer.this.fChatMeeting.isMultiMeeting() || ChatMeetingViewer.this.fChatMeeting.getParticipants().size() == 1) break;
                    final CollaborationUser user = ChatMeetingViewer.this.fChatMeeting.getSession().getUser();
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processStanza(user, ChatMeetingViewer.createStanza(user, data, false), false, false);
                        }
                    });
                    break;
                }
                case 0: {
                    final CollaborationUser user = event.getUser();
                    if (!ChatMeetingViewer.this.fChatMeeting.isMultiMeeting() || ChatMeetingViewer.this.fChatMeeting.getSession().getUser().equals((Object)user)) break;
                    ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            final String link = ChatMeetingViewer.createUserLink(user, ChatMessages.ChatMeetingViewer_11, monitor);
                            ChatMeetingViewer.this.asyncExec(new Runnable(){

                                public void run() {
                                    ChatMeetingViewer.this.processUserChange(user, link);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    });
                    break;
                }
                case 1: {
                    final CollaborationUser user = event.getUser();
                    if (!ChatMeetingViewer.this.fChatMeeting.isMultiMeeting() || ChatMeetingViewer.this.fChatMeeting.getSession().getUser().equals((Object)user)) break;
                    final CollaborationData data = event.getData();
                    if (data != null && data.isRejection()) {
                        ChatMeetingViewer.this.asyncExec(new Runnable(){

                            public void run() {
                                ChatMeetingViewer.this.processStanza(ChatMeetingViewer.createStanza(null, data, false));
                            }
                        });
                        break;
                    }
                    ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            final String link = ChatMeetingViewer.createUserLink(user, ChatMessages.ChatMeetingViewer_12, monitor);
                            ChatMeetingViewer.this.asyncExec(new Runnable(){

                                public void run() {
                                    ChatMeetingViewer.this.processUserChange(user, link);
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    });
                    break;
                }
                case 6: {
                    if (!ChatMeetingViewer.this.fChatMeeting.isMultiMeeting()) break;
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processTopicChange(event.getTopic(), true);
                        }
                    });
                    break;
                }
                case 7: {
                    if (!ChatMeetingViewer.this.fChatMeeting.isMultiMeeting()) break;
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processTopicChange(event.getTopic(), false);
                        }
                    });
                    break;
                }
                case 2: {
                    CollaborationData data = event.getData();
                    if (!ChatMeetingViewer.this.fChatMeeting.isMultiMeeting() || !(data instanceof MeetingInvitationRequest)) break;
                    MeetingInvitationRequest extended = (MeetingInvitationRequest)data;
                    final Collection users = extended.getUsers();
                    ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            try {
                                int size = users.size();
                                monitor.beginTask(ChatMessages.ChatMeetingViewer_13, size * 100);
                                final ArrayList<String> links = new ArrayList<String>(size);
                                for (CollaborationUser user : users) {
                                    links.add(ChatMeetingViewer.createUserLink(user, ChatMessages.ChatMeetingViewer_14, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2)));
                                }
                                ChatMeetingViewer.this.asyncExec(new Runnable(){

                                    public void run() {
                                        ChatMeetingViewer.this.processUsersInvited(links);
                                    }
                                });
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                    break;
                }
                case 10: {
                    final CollaborationData data = event.getData();
                    if (!ChatMeetingViewer.this.fChatMeeting.isMultiMeeting()) break;
                    final CollaborationUser user = event.getUser();
                    ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                        public IStatus run(IProgressMonitor monitor) {
                            Assert.isNotNull((Object)monitor);
                            try {
                                String message;
                                monitor.beginTask(ChatMessages.ChatMeetingViewer_15, 100);
                                if (data != null && (message = data.getMessage()) != null) {
                                    final ChatMeetingStanza reason = ChatMeetingViewer.createStanza(user, data, false);
                                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                                        public void run() {
                                            ChatMeetingViewer.this.processStanza(user, reason, true, false);
                                        }
                                    });
                                }
                                final String link = ChatMeetingViewer.createUserLink(user, ChatMessages.ChatMeetingViewer_16, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                                ChatMeetingViewer.this.asyncExec(new Runnable(){

                                    public void run() {
                                        ChatMeetingViewer.this.processUserDeclined(user, link);
                                    }
                                });
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
            }
            ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                public IStatus run(IProgressMonitor monitor) {
                    Assert.isNotNull((Object)monitor);
                    ChatMeetingViewer.this.refreshLabel(monitor);
                    return Status.OK_STATUS;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChatMenuListener
    implements IMenuListener {
        private static final String ATTRIBUTE_ICON = "icon";
        private static final String ATTRIBUTE_TARGET_ID = "targetID";
        private static final String CONTRIBUTION_KIND = "action";
        private static final String CONTRIBUTION_TYPE = "viewerContribution";
        private static final String EXTENSION_POINT_POPUP_MENUES = "popupMenus";
        private ResumeChatAction fResumeChatAction = null;
        private SendFileAction fSendFileAction = null;
        private final IWorkbenchPartSite fSite;
        private final SourceViewer fViewer;

        ChatMenuListener(IWorkbenchPartSite site, SourceViewer viewer) {
            Assert.isNotNull((Object)site);
            Assert.isNotNull((Object)viewer);
            this.fSite = site;
            this.fViewer = viewer;
        }

        private Collection<IAction> getContributedActions() {
            CollaborationViewerUIProxy proxy;
            ArrayList<IAction> actions = new ArrayList<IAction>(4);
            if (ChatMeetingViewer.this.fChatMeeting != null && (proxy = CollaborationViewerUIRegistry.getInstance().getViewerUI(ChatMeetingViewer.this.fChatMeeting.getSession().getProvider().getId())) != null) {
                IConfigurationElement[] elements;
                String targetId = proxy.getId();
                ArrayList<IConfigurationElement> contributions = new ArrayList<IConfigurationElement>(4);
                IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", EXTENSION_POINT_POPUP_MENUES);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (CONTRIBUTION_TYPE.equals(element.getName()) && targetId.equals(element.getAttribute(ATTRIBUTE_TARGET_ID))) {
                        IConfigurationElement[] children;
                        IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren(CONTRIBUTION_KIND);
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement child = iConfigurationElementArray2[n4];
                            contributions.add(child);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                for (IConfigurationElement contribution : contributions) {
                    try {
                        ImageDescriptor descriptor;
                        ContributedAction action = new ContributedAction((IServiceLocator)ChatMeetingViewer.this.fViewerSite.getView().getSite(), contribution);
                        String icon = contribution.getAttribute(ATTRIBUTE_ICON);
                        if (icon != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)contribution.getContributor().getName(), (String)icon)) != null) {
                            action.setImageDescriptor(descriptor);
                        }
                        actions.add((IAction)action);
                    }
                    catch (CommandNotMappedException commandNotMappedException) {}
                }
            }
            return actions;
        }

        public void menuAboutToShow(IMenuManager manager) {
            Assert.isNotNull((Object)manager);
            boolean editable = this.fViewer.isEditable();
            manager.add((IContributionItem)new Separator("group.undo"));
            if (editable) {
                manager.appendToGroup("group.undo", (IAction)ChatMeetingViewer.this.getCommandAction((IServiceLocator)this.fSite, "org.eclipse.ui.edit.undo"));
            }
            manager.add((IContributionItem)new Separator("group.chat"));
            if (ChatMeetingViewer.this.isSealed() && !ChatMeetingViewer.this.fChatMeeting.getInvitees().isEmpty()) {
                if (this.fResumeChatAction == null) {
                    this.fResumeChatAction = new ResumeChatAction(ChatMeetingViewer.this.fChatMeeting);
                }
                manager.appendToGroup("group.chat", (IAction)this.fResumeChatAction);
            }
            if (!editable) {
                for (IAction action : this.getContributedActions()) {
                    manager.appendToGroup("group.chat", action);
                }
            }
            if (!ChatMeetingViewer.this.isSealed() && (ChatMeetingViewer.this.fChatMeeting.getCapabilities() & 4) != 0) {
                if (this.fSendFileAction == null) {
                    this.fSendFileAction = new SendFileAction(ChatMeetingViewer.this.fChatMeeting);
                }
                manager.add((IAction)this.fSendFileAction);
            }
            manager.add((IContributionItem)new Separator("group.style"));
            if (editable) {
                manager.appendToGroup("group.style", (IAction)ChatMeetingViewer.this.getCommandAction((IServiceLocator)this.fSite, "com.ibm.magnolia.edit.text.bold"));
                manager.appendToGroup("group.style", (IAction)ChatMeetingViewer.this.getCommandAction((IServiceLocator)this.fSite, "com.ibm.magnolia.edit.text.italic"));
            }
            manager.add((IContributionItem)new Separator("group.edit"));
            if (editable) {
                manager.appendToGroup("group.edit", (IAction)ChatMeetingViewer.this.getCommandAction((IServiceLocator)this.fSite, "org.eclipse.ui.edit.cut"));
            }
            manager.appendToGroup("group.edit", (IAction)ChatMeetingViewer.this.getCommandAction((IServiceLocator)this.fSite, "org.eclipse.ui.edit.copy"));
            if (editable) {
                manager.appendToGroup("group.edit", (IAction)ChatMeetingViewer.this.getCommandAction((IServiceLocator)this.fSite, "org.eclipse.ui.edit.paste"));
            }
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    private final class ChatPresenceListener
    implements ICollaborationPresenceListener {
        ChatPresenceListener() {
        }

        public void presenceNotification(CollaborationPresenceEvent event) {
            Assert.isNotNull((Object)event);
            if (ChatMeetingViewer.this.fChatMeeting.getParticipants().contains(event.getUser())) {
                FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingView_21){

                    protected IStatus runProtected(IProgressMonitor monitor) {
                        ChatMeetingViewer.this.refreshLabel(monitor);
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    private final class ChatSessionListener
    implements ICollaborationSessionListener {
        ChatSessionListener() {
        }

        public void sessionNotification(CollaborationSessionEvent event) {
            Assert.isNotNull((Object)event);
            switch (event.getType()) {
                case 2: {
                    final CollaborationData data = event.getData();
                    String message = data.getMessage();
                    if (message == null || !ChatMeetingViewer.this.fChatMeeting.equals((Object)event.getMeeting())) break;
                    final CollaborationUser user = event.getUser();
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.processStanza(user, ChatMeetingViewer.createStanza(user, data, false), true, true);
                        }
                    });
                    break;
                }
                case 4: {
                    if (!ChatMeetingViewer.this.fChatMeeting.equals((Object)event.getMeeting())) break;
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.sealViewer();
                        }
                    });
                    break;
                }
                case 1: {
                    if (!ChatMeetingViewer.this.fChatMeeting.getSession().equals((Object)event.getSession())) break;
                    ChatMeetingViewer.this.asyncExec(new Runnable(){

                        public void run() {
                            ChatMeetingViewer.this.sealViewer();
                        }
                    });
                }
            }
        }
    }

    private final class ChatTranscriptHistoryPainter
    implements LineBackgroundListener {
        ChatTranscriptHistoryPainter() {
        }

        public void lineGetBackground(LineBackgroundEvent event) {
            int offset;
            Assert.isNotNull((Object)event);
            SourceViewer viewer = ChatMeetingViewer.this.fTranscriptSupport.getSourceViewer();
            StyledText widget = viewer.getTextWidget();
            if (widget != null && (offset = viewer.widgetOffset2ModelOffset(event.lineOffset)) >= 0) {
                try {
                    ChatMeetingStanza stanza;
                    int line = viewer.getDocument().getLineOfOffset(offset);
                    if (line >= 0 && (stanza = ChatMeetingViewer.this.fTranscriptModel.getStanza(line)) != null && stanza.isHistory()) {
                        Display display = widget.getDisplay();
                        Color background = display.getSystemColor(25);
                        Color foreground = display.getSystemColor(17);
                        RGB blended = ColorUtils.blend((RGB)background.getRGB(), (RGB)foreground.getRGB(), (int)75);
                        event.lineBackground = ChatMeetingViewer.this.fResourceManager.createColor(blended);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    private final class ChatUserListener
    implements ICollaborationUserListener {
        ChatUserListener() {
        }

        public void userNotification(CollaborationUserEvent event) {
            Assert.isNotNull((Object)event);
            int type = event.getType();
            if (type == 0 && ChatMeetingViewer.this.fChatMeeting.getParticipants().contains(event.getUser())) {
                ChatMeetingViewer.this.scheduleJob(new CollaborationServiceJob(){

                    public IStatus run(IProgressMonitor monitor) {
                        Assert.isNotNull((Object)monitor);
                        ChatMeetingViewer.this.refreshLabel(monitor);
                        return Status.OK_STATUS;
                    }
                });
            }
        }
    }

    private static final class CollaborationServiceJobQueue {
        private boolean fDisposed = false;
        private final LinkedList<CollaborationServiceJob> fQueue = new LinkedList();

        CollaborationServiceJobQueue() {
        }

        public synchronized CollaborationServiceJob dequeue() throws InterruptedException {
            while (this.fQueue.isEmpty()) {
                this.wait();
                if (!this.fDisposed) continue;
                return null;
            }
            return this.fQueue.removeFirst();
        }

        public synchronized void dispose() {
            this.fDisposed = true;
            this.notifyAll();
        }

        public synchronized void enqueue(CollaborationServiceJob job) {
            Assert.isNotNull((Object)job);
            this.fQueue.addLast(job);
            this.notifyAll();
        }

        public synchronized boolean isDisposed() {
            return this.fDisposed;
        }
    }

    private final class ComposeViewerKeyListener
    implements VerifyKeyListener {
        ComposeViewerKeyListener() {
        }

        public void verifyKey(VerifyEvent event) {
            Assert.isNotNull((Object)event);
            if (event.stateMask == 0 && event.character == '\r') {
                if (ChatMeetingViewer.this.fComposeDocument.getLength() != 0) {
                    String originalMessage = ChatMeetingViewer.this.fComposeDocument.getHTML().getXMLText();
                    ReferencePosition[] positions = ChatMeetingViewer.this.fComposeDocument.getReferencePositions(false);
                    final LinkedHashMap<ReferencePosition, DataTransferRequest> requestMap = new LinkedHashMap<ReferencePosition, DataTransferRequest>(positions.length);
                    ReferencePosition[] referencePositionArray = positions;
                    int n = positions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ReferencePosition position = referencePositionArray[n2];
                        CollaborationData request = ChatMeetingViewer.this.fComposeRequests.get(position.getReference());
                        if (request instanceof SendDataRequest) {
                            SendDataRequest extended = (SendDataRequest)request;
                            requestMap.put(position, new DataTransferRequest(extended));
                        }
                        ++n2;
                    }
                    if (!requestMap.isEmpty()) {
                        Document plainDocument = new Document(ChatMeetingViewer.this.fComposeDocument.get());
                        StyledDocument messageDocument = new StyledDocument(ChatMeetingViewer.this.fComposeDocument.getHTML());
                        for (ReferencePosition position : requestMap.keySet()) {
                            try {
                                ReferencePosition[] toRemove;
                                ReferencePosition[] referencePositionArray2 = toRemove = messageDocument.getReferencePositions(position.getOffset(), position.getLength(), false);
                                int n3 = toRemove.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ReferencePosition remove = referencePositionArray2[n4];
                                    messageDocument.removeReferencePosition(remove);
                                    plainDocument.replace(remove.getOffset(), remove.getLength(), "");
                                    ++n4;
                                }
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                        originalMessage = "".equals(plainDocument.get().trim()) ? null : messageDocument.getHTML().getXMLText();
                        final Collection requests = requestMap.values();
                        final CollaborationUser user = ChatMeetingViewer.this.fChatMeeting.getSession().getUser();
                        ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_20, "text/plain"), false, false);
                        FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_21){

                            protected IStatus runProtected(IProgressMonitor monitor) {
                                Assert.isNotNull((Object)monitor);
                                try {
                                    CollaborationPresenceStatus status;
                                    monitor.beginTask(ChatMessages.ChatMeetingViewer_22, 200 + requestMap.size() * 100);
                                    if (((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.isPeerMeeting()) {
                                        Collection invitees = ((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.getInvitees();
                                        if (invitees.size() == 1) {
                                            CollaborationPresence presence = ((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.getSession().getPresence((CollaborationUser)invitees.iterator().next(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                            if (presence != null) {
                                                status = presence.getStatus();
                                                if (!status.isAvailable()) {
                                                    if (monitor.isCanceled()) {
                                                        IStatus iStatus = Status.CANCEL_STATUS;
                                                        return iStatus;
                                                    }
                                                    if (!ChatMeetingViewer.this.showAvailabilityWarning(presence, ChatMessages.ChatMeetingViewer_56, ChatMessages.ChatMeetingViewer_59, (IProgressMonitor)new SubProgressMonitor(monitor, 50))) {
                                                        ChatMeetingViewer.this.asyncExec(new Runnable(){

                                                            public void run() {
                                                                ChatMeetingViewer.this.processStanza(user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_9, "text/plain"), false, false);
                                                            }
                                                        });
                                                        IStatus iStatus = Status.OK_STATUS;
                                                        return iStatus;
                                                    }
                                                    if (monitor.isCanceled()) {
                                                        IStatus iStatus = Status.CANCEL_STATUS;
                                                        return iStatus;
                                                    }
                                                    if (!status.isActive()) {
                                                        IStatus iStatus = ChatMeetingViewer.this.composeMail(invitees, requests, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                                        return iStatus;
                                                    }
                                                    monitor.worked(100);
                                                } else {
                                                    monitor.worked(150);
                                                }
                                            } else {
                                                monitor.worked(150);
                                            }
                                        } else {
                                            monitor.worked(200);
                                        }
                                    } else {
                                        monitor.worked(200);
                                    }
                                    for (DataTransferRequest request : requests) {
                                        if (monitor.isCanceled()) {
                                            IStatus iStatus = Status.CANCEL_STATUS;
                                            return iStatus;
                                        }
                                        status = ((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.send((CollaborationData)request, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                        ChatMeetingViewer.this.asyncExec(new Runnable((IStatus)status, user){
                                            private final /* synthetic */ IStatus val$status;
                                            private final /* synthetic */ CollaborationUser val$user;
                                            {
                                                this.val$status = iStatus;
                                                this.val$user = collaborationUser;
                                            }

                                            public void run() {
                                                if (this.val$status.matches(8)) {
                                                    ChatMeetingViewer.this.processStanza(this.val$user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_7, "text/plain"), false, false);
                                                } else if (!this.val$status.isOK()) {
                                                    IStatus[] children;
                                                    IStatus[] iStatusArray = children = this.val$status.getChildren();
                                                    int n = children.length;
                                                    int n2 = 0;
                                                    while (n2 < n) {
                                                        IStatus child = iStatusArray[n2];
                                                        if (!child.isOK()) {
                                                            ChatMeetingViewer.this.processStanza(this.val$user, new ChatMeetingStanza(child.getMessage(), "text/plain"), false, false);
                                                        }
                                                        ++n2;
                                                    }
                                                } else {
                                                    ChatMeetingViewer.this.processStanza(this.val$user, new ChatMeetingStanza(ChatMessages.ChatMeetingViewer_23, "text/plain"), false, false);
                                                }
                                            }
                                        });
                                    }
                                    IStatus iStatus = Status.OK_STATUS;
                                    return iStatus;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        job.setPriority(10);
                        job.schedule();
                    }
                    if (originalMessage != null && !"".equals(originalMessage)) {
                        final CollaborationData data = new CollaborationData(CollaborationData.generateId(), originalMessage, "text/html", null);
                        FoundationJob job = new FoundationJob(ChatMessages.ChatMeetingViewer_24){

                            protected IStatus runProtected(IProgressMonitor monitor) {
                                Assert.isNotNull((Object)monitor);
                                try {
                                    monitor.beginTask(ChatMessages.ChatMeetingViewer_57, 200);
                                    if (((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.isPeerMeeting()) {
                                        Collection invitees = ((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.getInvitees();
                                        if (invitees.size() == 1) {
                                            CollaborationPresence presence = ((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.getSession().getPresence((CollaborationUser)invitees.iterator().next(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                            if (presence != null) {
                                                CollaborationPresenceStatus status = presence.getStatus();
                                                if (!status.isAvailable()) {
                                                    if (monitor.isCanceled()) {
                                                        IStatus iStatus = Status.CANCEL_STATUS;
                                                        return iStatus;
                                                    }
                                                    if (!ChatMeetingViewer.this.showAvailabilityWarning(presence, ChatMessages.ChatMeetingViewer_58, ChatMessages.ChatMeetingViewer_60, (IProgressMonitor)new SubProgressMonitor(monitor, 50))) {
                                                        IStatus iStatus = Status.OK_STATUS;
                                                        return iStatus;
                                                    }
                                                    if (monitor.isCanceled()) {
                                                        IStatus iStatus = Status.CANCEL_STATUS;
                                                        return iStatus;
                                                    }
                                                    if (!status.isActive()) {
                                                        IStatus iStatus = ChatMeetingViewer.this.composeMail(invitees, Collections.singleton(data), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                                        return iStatus;
                                                    }
                                                } else {
                                                    monitor.worked(150);
                                                }
                                            } else {
                                                monitor.worked(150);
                                            }
                                        } else {
                                            monitor.worked(200);
                                        }
                                    } else {
                                        monitor.worked(200);
                                    }
                                    IStatus iStatus = ((ComposeViewerKeyListener)ComposeViewerKeyListener.this).ChatMeetingViewer.this.fChatMeeting.send(data, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                    return iStatus;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        job.setPriority(10);
                        job.schedule();
                    }
                    ChatMeetingViewer.this.fComposeDocument.set("");
                    ChatMeetingViewer.this.fComposeRequests.clear();
                    if (ChatMeetingViewer.this.fComposeTimer != null) {
                        ChatMeetingViewer.this.fComposeTimer.cancel();
                        ChatMeetingViewer.this.fComposeTimer = null;
                        ChatMeetingViewer.this.fResumeComposeSent = false;
                    }
                }
                event.doit = false;
            }
        }
    }
}

