/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.action;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.meeting.CollaborationData;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.collaboration.ui.context.ICollaborationContextProvider;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class StartChatAction
extends Action {
    public StartChatAction() {
        super(ChatMessages.StartChatAction_0, CollaborationChatPlugin.getImageDescriptor("$nl$/icons/full/elcl16/chat.gif"));
        this.setId("com.ibm.team.collaboration.ui.start.chat");
        this.setDescription(ChatMessages.StartChatAction_1);
        this.setToolTipText(ChatMessages.StartChatAction_2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.collaboration.ui.start_chat");
    }

    public void run() {
        Shell shell;
        ITeamRepository repository;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (repository = CollaborationChatPlugin.selectTeamRepository(shell = window.getShell())) != null) {
            IContributorHandle[] handles;
            TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(shell, repository, Collections.emptyList(), true);
            dialog.setTitle(ChatMessages.StartChatAction_3);
            dialog.setSeparatorLabel(ChatMessages.StartChatAction_5);
            dialog.create();
            dialog.setMessage(ChatMessages.StartChatAction_4);
            dialog.getShell().setText(ChatMessages.StartChatAction_7);
            if (dialog.open() == 0 && (handles = dialog.getContributorResult()).length > 0) {
                CollaborationCore.getCollaborationService().scheduleJob(new CollaborationServiceJob(){

                    public String getName() {
                        return ChatMessages.StartChatAction_6;
                    }

                    public boolean isSystem() {
                        return false;
                    }

                    public boolean isUser() {
                        return true;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        return CollaborationExceptionHandler.handleErrorStatus((IStatus)CollaborationUI.contactContributors((IWorkbenchPart)part, Arrays.asList(handles), (ICollaborationContextProvider)new ICollaborationContextProvider(){

                            public CollaborationData getContext(Collection<CollaborationUser> users, IProgressMonitor progress) {
                                Assert.isNotNull(users);
                                return null;
                            }

                            public Collection<URIReference> getTopics(Collection<CollaborationUser> users, IProgressMonitor progress) {
                                Assert.isNotNull(users);
                                return Collections.emptyList();
                            }
                        }, (IProgressMonitor)monitor));
                    }
                });
            }
        }
    }
}

