/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.toolkit.unit;

import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import com.ibm.team.build.internal.toolkit.unit.UnitParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public abstract class UnitLogParser {
    private File fLogFile;
    private String fName;
    private UnitParser unitParser;

    public UnitLogParser(File logFile) {
        this.fLogFile = logFile;
        this.fName = this.fLogFile.getName();
        this.unitParser = this.createUnitParser();
    }

    public UnitParser getUnitParser() {
        return this.unitParser;
    }

    public String getFileName() {
        return this.fName;
    }

    public final void parse() throws IOException, SAXException {
        this.parse(new FileInputStream(this.fLogFile));
    }

    public void parse(InputStream inputStream) throws IOException, SAXException {
        this.unitParser.parse(inputStream);
    }

    public JUnitParserTestSuiteData[] getTestSuites() {
        return this.unitParser.getTestSuites();
    }

    public String[] getParseErrors() {
        return this.unitParser.getParseErrors();
    }

    protected abstract UnitParser createUnitParser();
}

