/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.toolkit.nunit;

import com.ibm.team.build.internal.parser.data.JUnitParserFailureData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import com.ibm.team.build.internal.toolkit.unit.UnitParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NUnitParser
extends UnitParser {
    private static final String TESTSUITE_QNAME = "test-suite";
    private static final String TESTCLASS_QNAME = "test-case";
    private static final String MESSAGE_QNAME = "message";
    private static final String STACKTRACE_QNAME = "stack-trace";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TIME_ATTRIBUTE_NAME = "time";
    private static final String EXECUTED_ATTRIBUTE_NAME = "executed";
    private List<JUnitParserTestSuiteData> fTestSuites = new ArrayList<JUnitParserTestSuiteData>();
    private List<JUnitParserTestCaseData> fTestCases = new ArrayList<JUnitParserTestCaseData>();
    private boolean fFlagged = false;
    private String fCurrentTestSuite;
    private long fCurrentTestSuiteTime;
    private Stack<String> fRecord = new Stack();
    private JUnitParserTestCaseData fCurrentTest;
    private StringBuilder fBuilder;

    public void parse(InputStream inputStream) throws IOException, SAXException {
        this.fFlagged = false;
        this.fTestSuites.clear();
        this.fRecord.clear();
        this.fTestCases.clear();
        super.parse(inputStream);
    }

    public JUnitParserTestSuiteData[] getTestSuites() {
        return this.fTestSuites.toArray(new JUnitParserTestSuiteData[this.fTestSuites.size()]);
    }

    private String getName(String name) {
        int backIndex = name.lastIndexOf(92);
        int forwardIndex = name.lastIndexOf(47);
        if (backIndex == -1) {
            if (forwardIndex == -1) {
                return name;
            }
            return name.substring(forwardIndex + 1);
        }
        if (forwardIndex == -1) {
            return name.substring(backIndex + 1);
        }
        if (backIndex > forwardIndex) {
            return name.substring(backIndex + 1);
        }
        return name.substring(forwardIndex + 1);
    }

    private static long getTime(Attributes attributes, String qName) {
        String value = attributes.getValue(qName);
        if (value == null) {
            return 0L;
        }
        try {
            return (long)(Double.parseDouble(value) * 1000.0);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static long getTime(Attributes attributes) {
        return NUnitParser.getTime(attributes, TIME_ATTRIBUTE_NAME);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(TESTSUITE_QNAME)) {
            String name = attributes.getValue(NAME_ATTRIBUTE_NAME);
            if (name.length() > 0) {
                if (!this.fFlagged) {
                    this.fCurrentTestSuite = this.getName(name);
                    this.fCurrentTestSuiteTime = NUnitParser.getTime(attributes);
                    this.fFlagged = true;
                } else {
                    this.fRecord.push(name);
                }
            }
        } else if (qName.equals(TESTCLASS_QNAME)) {
            if (!Boolean.parseBoolean(attributes.getValue(EXECUTED_ATTRIBUTE_NAME))) {
                return;
            }
            String name = attributes.getValue(NAME_ATTRIBUTE_NAME);
            int index = name.lastIndexOf(46);
            long time = NUnitParser.getTime(attributes);
            this.fCurrentTest = new JUnitParserTestCaseData(name.substring(index + 1), name.substring(0, index), time);
        } else if (qName.equals(MESSAGE_QNAME)) {
            this.fBuilder = new StringBuilder();
        } else if (qName.equals(STACKTRACE_QNAME)) {
            this.fBuilder = new StringBuilder();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String string;
        if (this.fBuilder != null && (string = new String(ch, start, length)).trim().length() > 0) {
            this.fBuilder.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(TESTSUITE_QNAME)) {
            if (this.fRecord.isEmpty()) {
                if (this.fFlagged) {
                    int failures = 0;
                    for (JUnitParserTestCaseData testCase : this.fTestCases) {
                        if (!testCase.isFailure()) continue;
                        ++failures;
                    }
                    JUnitParserTestSuiteData data = new JUnitParserTestSuiteData(this.fCurrentTestSuite, this.fTestCases.size(), failures, 0, this.fCurrentTestSuiteTime);
                    for (JUnitParserTestCaseData testCase : this.fTestCases) {
                        data.addTestCase(testCase);
                    }
                    this.fTestSuites.add(data);
                    this.fTestCases.clear();
                    this.fFlagged = false;
                }
            } else {
                this.fRecord.pop();
            }
        } else if (qName.equals(TESTCLASS_QNAME)) {
            if (this.fCurrentTest != null) {
                this.fTestCases.add(this.fCurrentTest);
            }
            this.fCurrentTest = null;
        } else if (qName.equals(MESSAGE_QNAME)) {
            if (this.fCurrentTest != null) {
                this.fCurrentTest.setFailureData(new JUnitParserFailureData(this.fBuilder.toString(), null));
            }
            this.fBuilder = null;
        } else if (qName.equals(STACKTRACE_QNAME)) {
            if (this.fCurrentTest != null) {
                this.fCurrentTest.getFailureData().setStackTrace(this.fBuilder.toString());
            }
            this.fBuilder = null;
        }
    }
}

