/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.toolkit.cppunit;

import com.ibm.team.build.internal.parser.data.JUnitParserErrorData;
import com.ibm.team.build.internal.parser.data.JUnitParserFailureData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import com.ibm.team.build.internal.toolkit.unit.UnitParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CppUnitParser
extends UnitParser {
    private static final String FAILEDTEST_QNAME = "FailedTest";
    private static final String TEST_QNAME = "Test";
    private static final String NAME_QNAME = "Name";
    private static final String TESTS_QNAME = "Tests";
    private static final String ERRORS_QNAME = "Errors";
    private static final String FAILURES_QNAME = "Failures";
    private static final String FILE_QNAME = "File";
    private static final String LINE_QNAME = "Line";
    private static final String MESSAGE_QNAME = "Message";
    private static final String FAILURETYPE_QNAME = "FailureType";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String ASSERTION_FAILURE_VALUE = "Assertion";
    private Map<Integer, JUnitParserTestCaseData> testCases = new HashMap<Integer, JUnitParserTestCaseData>();
    private JUnitParserTestSuiteData[] testSuites;
    private String fTestSuiteName;
    private int testCount;
    private int failureCount;
    private int errorCount;
    private StringBuilder builder = new StringBuilder();
    private String message;
    private String location;
    private boolean isFailure = false;
    private boolean inName = false;
    private String name;
    private boolean inTests = false;
    private boolean inErrors = false;
    private boolean inFailures = false;
    private boolean inMessage = false;
    private boolean inFailureType = false;
    private boolean inFile = false;
    private boolean inLine = false;
    private int id;

    public void setTestSuiteName(String testSuiteName) {
        this.fTestSuiteName = testSuiteName;
    }

    public JUnitParserTestSuiteData[] getTestSuites() {
        return this.testSuites;
    }

    public void parse(InputStream inputStream) throws IOException, SAXException {
        this.testCases.clear();
        this.testSuites = new JUnitParserTestSuiteData[0];
        super.parse(inputStream);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(FAILEDTEST_QNAME) || qName.equals(TEST_QNAME)) {
            this.id = Integer.parseInt(attributes.getValue(ID_ATTRIBUTE_NAME));
        }
        this.inName = qName.equals(NAME_QNAME);
        this.inTests = qName.equals(TESTS_QNAME);
        this.inErrors = qName.equals(ERRORS_QNAME);
        this.inFailures = qName.equals(FAILURES_QNAME);
        this.inMessage = qName.equals(MESSAGE_QNAME);
        this.inFailureType = qName.equals(FAILURETYPE_QNAME);
        this.inFile = qName.equals(FILE_QNAME);
        this.inLine = qName.equals(LINE_QNAME);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inName) {
            String string = new String(ch, start, length);
            if ((string = string.trim()).length() > 1) {
                this.name = string;
            }
        } else if (this.inFile) {
            this.builder.append(ch, start, length);
            this.inFile = false;
        } else if (this.inLine) {
            this.builder.append(ch, start, length);
            this.inLine = false;
        } else if (this.inMessage) {
            this.builder.append(ch, start, length);
        } else if (this.inTests) {
            String string = new String(ch, start, length);
            string = string.trim();
            this.testCount = Integer.parseInt(string);
            this.inTests = false;
        } else if (this.inFailures) {
            String string = new String(ch, start, length);
            string = string.trim();
            this.failureCount = Integer.parseInt(string);
            this.inFailures = false;
        } else if (this.inErrors) {
            String string = new String(ch, start, length);
            string = string.trim();
            this.errorCount = Integer.parseInt(string);
            this.inErrors = false;
        } else if (this.inFailureType) {
            String string = new String(ch, start, length);
            string = string.trim();
            this.isFailure = string.equals(ASSERTION_FAILURE_VALUE);
            this.inFailureType = false;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(FILE_QNAME)) {
            this.location = this.builder.toString();
            this.builder.delete(0, this.builder.length());
        } else if (qName.equals(LINE_QNAME)) {
            this.builder.insert(0, ':');
            this.builder.insert(0, this.location);
            this.location = this.builder.toString();
            this.builder.delete(0, this.builder.length());
        } else if (qName.equals(MESSAGE_QNAME)) {
            this.message = this.builder.toString().trim();
            this.builder.delete(0, this.builder.length());
            this.inMessage = false;
        } else if (qName.equals(FAILEDTEST_QNAME) || qName.equals(TEST_QNAME)) {
            int index = this.name.lastIndexOf("::");
            String methodName = this.name.substring(index + 2);
            this.name = this.name.substring(0, index);
            JUnitParserTestCaseData testCaseData = new JUnitParserTestCaseData(methodName, this.name, 0L);
            if (qName.equals(FAILEDTEST_QNAME) && this.message.length() != 0) {
                if (this.isFailure) {
                    JUnitParserFailureData data = new JUnitParserFailureData(this.message, null);
                    data.setStackTrace(this.location);
                    testCaseData.setFailureData(data);
                } else {
                    JUnitParserErrorData data = new JUnitParserErrorData(this.message, null);
                    data.setStackTrace(this.location);
                    testCaseData.setErrorData(data);
                }
            }
            this.testCases.put(this.id, testCaseData);
        }
    }

    public void endDocument() throws SAXException {
        this.testSuites = new JUnitParserTestSuiteData[]{new JUnitParserTestSuiteData(this.fTestSuiteName, this.testCount, this.failureCount, this.errorCount, 0L)};
        Object[] array = this.testCases.entrySet().toArray();
        Arrays.sort(array, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                return ((Integer)e1.getKey()).compareTo((Integer)e2.getKey());
            }
        });
        int i = 0;
        while (i < array.length) {
            Map.Entry entry = (Map.Entry)array[i];
            this.testSuites[0].addTestCase((JUnitParserTestCaseData)entry.getValue());
            ++i;
        }
    }
}

