/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.publishing;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;

public abstract class AbstractContributionPublisher {
    private final String fExtendedContributionTypeId;
    private final String fLabel;
    private String fComponentName;

    public AbstractContributionPublisher(String extendedContributionTypeId, String label) {
        ValidationHelper.validateNotNull((String)"extendedContributionTypeId", (Object)extendedContributionTypeId);
        ValidationHelper.validateNotEmpty((String)"extendedContributionTypeId", (String)extendedContributionTypeId);
        ValidationHelper.validateNotNull((String)"label", (Object)label);
        this.fExtendedContributionTypeId = extendedContributionTypeId;
        this.fLabel = label;
    }

    protected abstract void initializeContribution(IBuildResultContribution var1, ITeamRepository var2) throws TeamRepositoryException;

    public void setComponentName(String componentName) {
        ValidationHelper.validateNotEmpty((String)"componentName", (String)componentName);
        this.fComponentName = componentName;
    }

    public String getComponentName() {
        return this.fComponentName;
    }

    public final IBuildResultContribution publish(IBuildResultHandle buildResultHandle, BuildStatus contributionStatus, ITeamRepository teamRepository) throws TeamRepositoryException {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setLabel(this.fLabel);
        contribution.setImpactsPrimaryResult(true);
        contribution.setStatus(contributionStatus);
        contribution.setExtendedContributionTypeId(this.fExtendedContributionTypeId);
        if (this.fComponentName != null) {
            contribution.setComponentName(this.fComponentName);
        }
        this.initializeContribution(contribution, teamRepository);
        ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).addBuildResultContribution(buildResultHandle, contribution, null);
        return contribution;
    }

    public String getExtendedContributionTypeId() {
        return this.fExtendedContributionTypeId;
    }
}

