/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser.data;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.data.JdtParserSourceData;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtParserCompileData {
    private Hashtable<String, List<JdtParserSourceData>> fSources = new Hashtable();
    private long fCompileTime;
    private int fLinesCompiled;
    private int fNumberOfClassfiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(JdtParserSourceData source) {
        ValidationHelper.validateNotNull((String)"source", (Object)source);
        Hashtable<String, List<JdtParserSourceData>> hashtable = this.fSources;
        synchronized (hashtable) {
            if (this.fSources.get(source.getPackageName()) == null) {
                this.fSources.put(source.getPackageName(), new LinkedList());
            }
        }
        this.fSources.get(source.getPackageName()).add(source);
    }

    public int getSourceFileCount() {
        int numSources = 0;
        for (String packageName : this.fSources.keySet()) {
            List<JdtParserSourceData> sources = this.fSources.get(packageName);
            numSources += sources.size();
        }
        return numSources;
    }

    protected Hashtable getSources() {
        return this.fSources;
    }

    public Collection<String> getPackageNames() {
        return this.fSources.keySet();
    }

    public Collection<JdtParserSourceData> getSourcesInPackage(String packageName) {
        ValidationHelper.validateNotNull((String)"packageName", (Object)packageName);
        if (!this.fSources.containsKey(packageName)) {
            return Collections.emptyList();
        }
        return this.fSources.get(packageName);
    }

    public void setCompileTime(long compileTime) {
        this.fCompileTime = compileTime;
    }

    public long getCompileTime() {
        return this.fCompileTime;
    }

    public void setLinesCompiled(int lines) {
        this.fLinesCompiled = lines;
    }

    public int getLinesCompiled() {
        return this.fLinesCompiled;
    }

    public void setNumberOfClassfiles(int numberOfClassfiles) {
        this.fNumberOfClassfiles = numberOfClassfiles;
    }

    public int getNumberOfClassfiles() {
        return this.fNumberOfClassfiles;
    }

    public int getErrorCount() {
        int errorCount = 0;
        Enumeration<List<JdtParserSourceData>> elements = this.fSources.elements();
        while (elements.hasMoreElements()) {
            List<JdtParserSourceData> dataList = elements.nextElement();
            for (JdtParserSourceData sourceData : dataList) {
                errorCount += sourceData.getErrorCount();
            }
        }
        return errorCount;
    }

    public int getWarningCount() {
        int warningCount = 0;
        Enumeration<List<JdtParserSourceData>> elements = this.fSources.elements();
        while (elements.hasMoreElements()) {
            List<JdtParserSourceData> dataList = elements.nextElement();
            for (JdtParserSourceData sourceData : dataList) {
                warningCount += sourceData.getWarningCount();
            }
        }
        return warningCount;
    }

    public int getProblemCount() {
        int problemCount = 0;
        Enumeration<List<JdtParserSourceData>> elements = this.fSources.elements();
        while (elements.hasMoreElements()) {
            List<JdtParserSourceData> dataList = elements.nextElement();
            for (JdtParserSourceData sourceData : dataList) {
                problemCount += sourceData.getErrorCount();
                problemCount += sourceData.getWarningCount();
            }
        }
        return problemCount;
    }
}

