/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser.data;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import java.util.LinkedList;
import java.util.List;

public class JUnitParserTestClassData {
    private String fTestClassName;
    private int fTestCount = 0;
    private int fErrorCount = 0;
    private int fFailureCount = 0;
    private long fTimeTaken;
    private int fOrdinal;
    private List<JUnitParserTestCaseData> fTestCases = new LinkedList<JUnitParserTestCaseData>();

    public JUnitParserTestClassData(String className, int ordinal) {
        ValidationHelper.validateNotEmpty((String)"className", (String)className);
        this.fTestClassName = className;
        this.fOrdinal = ordinal;
    }

    public void addTestCase(JUnitParserTestCaseData testCase) {
        ValidationHelper.validateNotNull((String)"testCase", (Object)testCase);
        this.fTestCases.add(testCase);
        testCase.setOrdinal(this.fTestCases.size());
        ++this.fTestCount;
        if (testCase.isError()) {
            ++this.fErrorCount;
        }
        if (testCase.isFailure()) {
            ++this.fFailureCount;
        }
        this.fTimeTaken += testCase.getTimeTaken();
    }

    public String getTestClassName() {
        return this.fTestClassName;
    }

    public int getTestCount() {
        return this.fTestCount;
    }

    public int getFailureCount() {
        return this.fFailureCount;
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public long getTimeTaken() {
        return this.fTimeTaken;
    }

    public int getOrdinal() {
        return this.fOrdinal;
    }

    public JUnitParserTestCaseData[] getTestCases() {
        return this.fTestCases.toArray(new JUnitParserTestCaseData[this.fTestCases.size()]);
    }
}

