/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.parser.AbstractParserHandlerBase;
import com.ibm.team.build.internal.parser.SkipElementException;
import com.ibm.team.build.internal.parser.data.JUnitParserErrorData;
import com.ibm.team.build.internal.parser.data.JUnitParserFailureData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JUnitLogParser
extends AbstractParserHandlerBase {
    private List<JUnitParserTestSuiteData> fTestSuites = new ArrayList<JUnitParserTestSuiteData>();
    private JUnitParserTestSuiteData fCurrentTestSuite;
    private JUnitParserTestCaseData fCurrentTestCase;
    private JUnitParserFailureData fFailureData;
    private JUnitParserErrorData fErrorData;
    public static final String TAG_TESTSUITES = "testsuites";
    public static final String TAG_TESTSUITE = "testsuite";
    public static final String TAG_TESTCASE = "testcase";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_SYSTEM_OUT = "system-out";
    public static final String TAG_SYSTEM_ERR = "system-err";
    public static final String TAG_FAILURE = "failure";
    public static final String TAG_ERROR = "error";
    public static final String TAG_TYPE = "type";
    public static final String TAG_MESSAGE = "message";
    public static final String TAG_NAME = "name";
    public static final String TAG_CLASS_NAME = "classname";
    public static final String TAG_ERRORS = "errors";
    public static final String TAG_FAILURES = "failures";
    public static final String TAG_TESTS = "tests";
    public static final String TAG_TIME = "time";

    public JUnitLogParser(File logFile) {
        super(logFile);
    }

    public JUnitLogParser(String logString) {
        super(logString);
    }

    public JUnitParserTestSuiteData[] getTestSuites() {
        return this.fTestSuites.toArray(new JUnitParserTestSuiteData[this.fTestSuites.size()]);
    }

    protected AbstractParserHandlerBase.ContextType getContextForElement(String elementName) {
        if (elementName.equals(TAG_ERROR)) {
            return JUnitContextType.PARSING_ERROR;
        }
        if (elementName.equals(TAG_FAILURE)) {
            return JUnitContextType.PARSING_FAILURE;
        }
        if (elementName.equals(TAG_TESTCASE)) {
            return JUnitContextType.PARSING_TESTCASE;
        }
        if (elementName.equals(TAG_TESTSUITES)) {
            return JUnitContextType.PARSING_TESTSUITES;
        }
        if (elementName.equals(TAG_TESTSUITE)) {
            return JUnitContextType.PARSING_TESTSUITE;
        }
        if (elementName.equals(TAG_PROPERTIES)) {
            return JUnitContextType.PARSING_PROPERTIES;
        }
        if (elementName.equals(TAG_SYSTEM_OUT)) {
            return JUnitContextType.PARSING_SYSTEM_OUT;
        }
        if (elementName.equals(TAG_SYSTEM_ERR)) {
            return JUnitContextType.PARSING_SYSTEM_ERR;
        }
        return null;
    }

    protected AbstractParserHandlerBase.ContextType getValidChildElementContext(AbstractParserHandlerBase.ContextType childContext, AbstractParserHandlerBase.ContextType parentContext) {
        if (parentContext instanceof JUnitContextType) {
            switch ((JUnitContextType)parentContext) {
                case PARSING_TESTSUITES: {
                    if (childContext != JUnitContextType.PARSING_TESTSUITE) break;
                    return childContext;
                }
                case PARSING_TESTSUITE: {
                    switch ((JUnitContextType)childContext) {
                        case PARSING_TESTCASE: 
                        case PARSING_ERROR: {
                            return childContext;
                        }
                        case PARSING_PROPERTIES: 
                        case PARSING_SYSTEM_OUT: 
                        case PARSING_SYSTEM_ERR: {
                            return this.getIgnoreContext();
                        }
                    }
                    break;
                }
                case PARSING_TESTCASE: {
                    switch ((JUnitContextType)childContext) {
                        case PARSING_FAILURE: 
                        case PARSING_ERROR: {
                            return childContext;
                        }
                    }
                }
            }
        }
        return null;
    }

    protected AbstractParserHandlerBase.ContextType getValidRootElementContext(AbstractParserHandlerBase.ContextType rootContext) throws SAXParseException {
        if (rootContext == JUnitContextType.PARSING_TESTSUITES || rootContext == JUnitContextType.PARSING_TESTSUITE) {
            return rootContext;
        }
        return null;
    }

    protected void startChildElement(Attributes attributes) throws SAXException, SkipElementException {
        switch ((JUnitContextType)this.getCurrentContext()) {
            case PARSING_TESTSUITE: {
                this.handleStartTestSuite(attributes);
                break;
            }
            case PARSING_TESTCASE: {
                this.handleStartTestcase(attributes);
                break;
            }
            case PARSING_FAILURE: {
                this.handleStartFailure(attributes);
                break;
            }
            case PARSING_ERROR: {
                this.handleStartError(attributes);
            }
        }
    }

    private void handleStartTestSuite(Attributes attributes) throws SkipElementException {
        this.fCurrentTestSuite = null;
        String name = this.getRequiredAttribute(attributes, TAG_NAME, true);
        int errorCount = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_ERRORS, true, false, 0L);
        int failureCount = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_FAILURES, true, false, 0L);
        int testCount = (int)this.getRequiredWholeNumberAttribute(attributes, TAG_TESTS, true, false, 0L);
        long timeTaken = (long)(this.getRequiredNumericAttribute(attributes, TAG_TIME, true, false, 0.0f) * 1000.0f);
        this.fCurrentTestSuite = new JUnitParserTestSuiteData(name, testCount, failureCount, errorCount, timeTaken);
        this.fTestSuites.add(this.fCurrentTestSuite);
    }

    private void handleStartTestcase(Attributes attributes) throws SkipElementException {
        this.fCurrentTestCase = null;
        String testcaseName = this.getRequiredAttribute(attributes, TAG_NAME, true);
        String testcaseClassName = this.getRequiredAttribute(attributes, TAG_CLASS_NAME, true);
        long timeTaken = (long)(this.getRequiredNumericAttribute(attributes, TAG_TIME, true, false, 0.0f) * 1000.0f);
        this.fCurrentTestCase = new JUnitParserTestCaseData(testcaseName, testcaseClassName, timeTaken);
    }

    private void handleStartFailure(Attributes attributes) throws SkipElementException {
        this.fFailureData = null;
        String type = this.getRequiredAttribute(attributes, TAG_TYPE, true);
        String message = this.getOptionalAttribute(attributes, TAG_MESSAGE);
        this.fFailureData = new JUnitParserFailureData(type, message);
    }

    private void handleStartError(Attributes attributes) throws SkipElementException {
        this.fErrorData = null;
        String type = this.getRequiredAttribute(attributes, TAG_TYPE, true);
        String message = this.getOptionalAttribute(attributes, TAG_MESSAGE);
        this.fErrorData = new JUnitParserErrorData(type, message);
    }

    protected void endChildElement() {
        switch ((JUnitContextType)this.getCurrentContext()) {
            case PARSING_TESTSUITE: {
                if (this.fErrorData == null) break;
                this.fCurrentTestSuite.setErrorData(this.fErrorData);
                this.fErrorData = null;
                break;
            }
            case PARSING_TESTCASE: {
                if (this.fCurrentTestCase != null) {
                    if (this.fErrorData != null) {
                        this.fCurrentTestCase.setErrorData(this.fErrorData);
                    }
                    if (this.fFailureData != null) {
                        this.fCurrentTestCase.setFailureData(this.fFailureData);
                    }
                    this.fCurrentTestSuite.addTestCase(this.fCurrentTestCase);
                }
                this.fErrorData = null;
                this.fFailureData = null;
                break;
            }
            case PARSING_FAILURE: {
                if (this.getCurrentCharacterData().length() == 0) break;
                this.fFailureData.setStackTrace(this.getCurrentCharacterData().toString());
                break;
            }
            case PARSING_ERROR: {
                if (this.getCurrentCharacterData().length() == 0) break;
                this.fErrorData.setStackTrace(this.getCurrentCharacterData().toString());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum JUnitContextType implements AbstractParserHandlerBase.ContextType
    {
        PARSING_TESTSUITES,
        PARSING_TESTSUITE,
        PARSING_PROPERTIES,
        PARSING_TESTCASE,
        PARSING_FAILURE,
        PARSING_ERROR,
        PARSING_SYSTEM_OUT,
        PARSING_SYSTEM_ERR;

    }
}

