/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser;

import com.ibm.team.build.internal.parser.AbstractParserHandlerBase;
import com.ibm.team.build.internal.parser.ParserMessages;
import com.ibm.team.build.internal.parser.SkipElementException;
import java.io.File;
import java.util.Hashtable;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMapParser
extends AbstractParserHandlerBase {
    private String fCurrentComponentName = null;
    Hashtable<String, String> fPackageNameToComponentMappings = new Hashtable();
    Hashtable<String, String> fPackagePrefixToComponentMappings = new Hashtable();
    private String fDefaultComponentName = null;
    public static final String TAG_COMPONENT_MAPPING = "component_mapping";
    public static final String TAG_COMPONENT = "component";
    public static final String TAG_NAME = "name";
    public static final String TAG_INCLUDE_PACKAGE = "includePackage";

    public ComponentMapParser(File mappingFile) {
        super(mappingFile);
    }

    public String getDefaultComponentName() {
        return this.fDefaultComponentName;
    }

    public Hashtable<String, String> getPackageNameToComponentMappings() {
        return this.fPackageNameToComponentMappings;
    }

    public Hashtable<String, String> getPackagePrefixToComponentMappings() {
        return this.fPackagePrefixToComponentMappings;
    }

    @Override
    public void startChildElement(Attributes attributes) throws SAXException, SkipElementException {
        switch ((MappingContextType)this.getCurrentContext()) {
            case PARSING_COMPONENT: {
                this.fCurrentComponentName = this.getRequiredAttribute(attributes, TAG_NAME, true);
                break;
            }
            case PARSING_INCLUDE_PACKAGE: {
                this.addPackageMapping(this.getRequiredAttribute(attributes, TAG_NAME, true, true));
            }
        }
    }

    protected String getCurrentComponentName() {
        return this.fCurrentComponentName;
    }

    @Override
    protected AbstractParserHandlerBase.ContextType getValidChildElementContext(AbstractParserHandlerBase.ContextType childContext, AbstractParserHandlerBase.ContextType parentContext) {
        switch ((MappingContextType)parentContext) {
            case PARSING_COMPONENT_MAPPING: {
                if (childContext == MappingContextType.PARSING_COMPONENT) break;
                return null;
            }
            case PARSING_COMPONENT: {
                if (childContext == MappingContextType.PARSING_INCLUDE_PACKAGE) break;
                return null;
            }
            case PARSING_INCLUDE_PACKAGE: {
                return null;
            }
        }
        return childContext;
    }

    @Override
    protected AbstractParserHandlerBase.ContextType getValidRootElementContext(AbstractParserHandlerBase.ContextType rootContext) throws SAXParseException {
        if (rootContext != MappingContextType.PARSING_COMPONENT_MAPPING) {
            return null;
        }
        return rootContext;
    }

    @Override
    protected AbstractParserHandlerBase.ContextType getContextForElement(String elementName) {
        if (elementName.equals(TAG_COMPONENT)) {
            return MappingContextType.PARSING_COMPONENT;
        }
        if (elementName.equals(TAG_COMPONENT_MAPPING)) {
            return MappingContextType.PARSING_COMPONENT_MAPPING;
        }
        if (elementName.equals(TAG_INCLUDE_PACKAGE)) {
            return MappingContextType.PARSING_INCLUDE_PACKAGE;
        }
        return null;
    }

    protected void addPackageMapping(String packageName) throws SAXException {
        boolean prefix = false;
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            prefix = true;
        } else if (packageName.endsWith("*")) {
            if (packageName.length() == 1) {
                if (this.fDefaultComponentName != null && !this.getCurrentComponentName().equals(this.fDefaultComponentName)) {
                    throw new SAXException(NLS.bind((String)ParserMessages.ComponentMapRegistry_DUPLICATE_PACKAGE, (Object[])new String[]{packageName, this.fDefaultComponentName, this.getCurrentComponentName()}));
                }
                this.fDefaultComponentName = this.getCurrentComponentName();
                return;
            }
            packageName = packageName.substring(0, packageName.length() - 1);
            prefix = true;
        }
        if (prefix) {
            if (this.fPackagePrefixToComponentMappings.containsKey(packageName)) {
                if (!this.fPackagePrefixToComponentMappings.get(packageName).equals(this.getCurrentComponentName())) {
                    throw new SAXException(NLS.bind((String)ParserMessages.ComponentMapRegistry_DUPLICATE_PACKAGE, (Object[])new String[]{String.valueOf(packageName) + ".*", this.fPackagePrefixToComponentMappings.get(packageName), this.getCurrentComponentName()}));
                }
            } else {
                this.fPackagePrefixToComponentMappings.put(packageName, this.getCurrentComponentName());
            }
        } else if (this.fPackageNameToComponentMappings.containsKey(packageName)) {
            if (!this.fPackageNameToComponentMappings.get(packageName).equals(this.getCurrentComponentName())) {
                throw new SAXException(NLS.bind((String)ParserMessages.ComponentMapRegistry_DUPLICATE_PACKAGE, (Object[])new String[]{packageName, this.fPackageNameToComponentMappings.get(packageName), this.getCurrentComponentName()}));
            }
        } else {
            this.fPackageNameToComponentMappings.put(packageName, this.getCurrentComponentName());
        }
    }

    @Override
    public void endChildElement() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MappingContextType implements AbstractParserHandlerBase.ContextType
    {
        PARSING_COMPONENT_MAPPING,
        PARSING_COMPONENT,
        PARSING_INCLUDE_PACKAGE;

    }
}

