/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.l10n.Messages;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class ItemHelper {
    private static final int TRUNCATED_ATTRIBUTE_EXTENSION_LENGTH = Messages.getCommonString("ItemHelper.0").length() - "{0}".length();

    static {
        new ItemHelper();
    }

    private ItemHelper() {
    }

    public static String validateStringAttributeLength(String value, IType type, String propertyName) {
        if (value == null) {
            return value;
        }
        ValidationHelper.validateNotNull("type", type);
        ValidationHelper.validateNotEmpty("propertyName", propertyName);
        IStatus status = IItemValidator.INSTANCE.validateAttribute(type, propertyName, (Object)value);
        if (!status.isOK() && status instanceof IStringSizeConstraintErrorStatus) {
            int maxSize = (int)((IStringSizeConstraintErrorStatus)status).getMaxSize();
            if (value.length() > maxSize - TRUNCATED_ATTRIBUTE_EXTENSION_LENGTH) {
                String truncatedValue = value.substring(0, maxSize - TRUNCATED_ATTRIBUTE_EXTENSION_LENGTH);
                value = NLS.bind((String)Messages.getCommonString("ItemHelper.0"), (Object)truncatedValue);
            }
        }
        return value;
    }

    public static boolean removeHelper(List helperList, Helper toRemove) {
        ValidationHelper.validateNotNull("helperList", helperList);
        ValidationHelper.validateNotNull("toRemove", toRemove);
        Iterator i = helperList.iterator();
        while (i.hasNext()) {
            Helper helper;
            Object o = i.next();
            if (!(o instanceof Helper) || (helper = (Helper)o).getInternalId() == null || !helper.getInternalId().equals((Object)toRemove.getInternalId())) continue;
            i.remove();
            return true;
        }
        return false;
    }
}

