/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.structure.TeamMemberGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.OwnerElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GenericElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.Create"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.SecondaryLocationMarker"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.team.foundation.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var GenericElement				= com.ibm.team.apt.ui.structure.GenericElement;
var GroupProvider				= com.ibm.team.apt.ui.structure.GroupProvider;
var Create						= com.ibm.team.apt.ui.Create;

var SecondaryLocationMarker		= com.ibm.team.apt.ui.model.SecondaryLocationMarker;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.internal.ui.structure.TeamMemberGroupProvider", GroupProvider, { //$NON-NLS-1$

	constructor: function(funcGetPlan, options) {
	},
	
	// ---- api ------------------------------------------------------------------------------------------------------------
	
	getGroupAttributes: function() {
		return [ PlanItem.TEAM_MEMBER_AREA ];
	},
	
	getDefaultGroupIds: function() {
		return dojo.map(this._getPlan().getTeamMemberAreas(), this.__getAreaStack, this);
	},
	
	getGroupsIds: function(elementInfo) {
		var result= this.__getAreaStack(elementInfo.getValue(PlanItem.TEAM_MEMBER_AREA));
		if (result.length > 0)
			return [ result ];
		
		return [];
	},
	
	isPrimaryGroup: function(groupIdPath, elementInfo) {
		if (groupIdPath.length < 1)
			return false;
		
		if (!elementInfo.getValue(PlanItem.TEAM_MEMBER_AREA))
			return false;
		
		return groupIdPath[groupIdPath.length - 1] == elementInfo.getValue(PlanItem.TEAM_MEMBER_AREA).itemId;
	},
	
	getGroupElement: function(groupIdPath) {
		Assert.isTrue(groupIdPath.length >= 1);
		var teamArea= this._getPlan().getItem(groupIdPath[groupIdPath.length - 1]);
		var category= this._getPlan().getPrimaryCategoryFor(teamArea); 
		var unassignedCategory= this._getPlan().findAttribute(PlanItem.CATEGORY).getValueSet().nullValue;
		return new GenericElement(teamArea.itemId, teamArea.label, teamArea, {
			canAdopt: function (planItem) {
				return category != null && category.itemId != unassignedCategory.itemId;
			},
			adopt: function(planItem) {
				planItem.setAttributeValue(PlanItem.TEAM_MEMBER_AREA, teamArea);
				return true;
			},
			comperator: function(o1, o2) {
				return o1.getValue().compareTo(o2.getValue());
			}});
	},
	
	getElementsToExpandInitially: function(readAccessor) {
		var rootEntries= readAccessor.getChildren(readAccessor.getRootEntry());
	
		var result= [].concat(rootEntries);
		for (var i= 0; i < rootEntries.length; i++) {
			dojo.forEach(readAccessor.getChildren(rootEntries[i]), function(childEntry) {
				if (childEntry.getElement() instanceof GenericElement) {
					result.push(childEntry);
				}
			})
		}
		return result;
	},
	
	calculateLocationMarker: function(entry, elementInfo) {
		if (!entry.hasTag(PrimaryLocationTag) && elementInfo != null && elementInfo.getPlanElement() instanceof PlanItem) {
			return new SecondaryLocationMarker(bind(Messages['teamAreas_outplace'], [ elementInfo.getValue(PlanItem.TEAM_MEMBER_AREA).label ])); //$NON-NLS-1$
		}
		return null;
	},
	
	
	canCreate: function(request, readAccessor) {
		var n= readAccessor.getEntryNavigator(true);
		var groupEntry= n.parentEntryOfType(request.targetEntry, com.ibm.team.apt.ui.structure.GroupElement);

		if (groupEntry != null) {
			var teamArea= groupEntry.getElement().getValue();
			var category= this._getPlan().getPrimaryCategoryFor(teamArea); 
			var unassignedCategory= this._getPlan().findAttribute(PlanItem.CATEGORY).getValueSet().nullValue;
			if (category == null || category.equals(unassignedCategory) || !this._getPlan().canAddToCategory(request.workItemType, category)) {
				return Create.Response.DENY;
			}
		}
		
		return this.inherited(arguments);
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__getAreaStack: function(area) {
		var result= [];
		while (area != null) {
			result.unshift(area.itemId);
			area= area.getParent();
		}
		return result;
	},
	
	__sentinel: null // terminates this class definition
});

})();