/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.structure.TaskboardViewMode"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanModel"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.RowElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.ColumnElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GenericElement"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.PrimaryLocationTag"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.FieldTag"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.internal.ui.structure.TreeViewMode"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "ViewModeMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {
var Assert						= com.ibm.team.foundation.Assert;

var PlanElement					= com.ibm.team.apt.client.PlanElement;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var PlanModel					= com.ibm.team.apt.client.PlanModel;
var RowElement					= com.ibm.team.apt.ui.structure.RowElement;
var ColumnElement				= com.ibm.team.apt.ui.structure.ColumnElement;
var GroupElement				= com.ibm.team.apt.ui.structure.GroupElement;
var GenericElement				= com.ibm.team.apt.ui.structure.GenericElement;

var TreeViewMode				= com.ibm.team.apt.internal.ui.structure.TreeViewMode;
var PrimaryLocationTag 			= com.ibm.team.apt.ui.model.PrimaryLocationTag.INSTANCE;
var State						= com.ibm.team.apt.ui.model.FieldTag.STATE;
var Priority					= com.ibm.team.apt.ui.model.FieldTag.PRIORITY; 
var Progress					= com.ibm.team.apt.ui.model.FieldTag.PROGRESS; 
var Summary						= com.ibm.team.apt.ui.model.FieldTag.SUMMARY;
var Id							= com.ibm.team.apt.ui.model.FieldTag.ID;
var Actions						= com.ibm.team.apt.ui.model.FieldTag.ACTIONS;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "ViewModeMessages"); //$NON-NLS-1$ //$NON-NLS-2$

var OTHER_WORKFLOW_GROUP_ID		= "other.workflows.group"; //$NON-NLS-1$

dojo.declare("com.ibm.team.apt.internal.ui.structure.TaskboardViewMode", TreeViewMode, { //$NON-NLS-1$
	
	__groupTaskboardCache: null,
	__workflowId: null,

	constructor: function(funcGetPlan, groupProvider, options) {
		this.__workflowId= options.parameters["TASKBOARD_WORKFLOW_ID"] || null; //$NON-NLS-1$
	},

	// ---- TaskboardViewMode implementation ------------------------------------------------------------------------------------

	getViewAttributes: function() {
		return this.inherited(arguments).concat( [ PlanItem.STATE, PlanItem.WORKFLOW_ACTION, PlanItem.DRAFT_ITEM ]);
	},

	onBeginRebuild: function() {
		this.inherited(arguments);
		this.__groupTaskboardCache= {};
	},

	getEntryComparator: function() {
		var defaultComparator= this.inherited(arguments);
		
		var categoryFn= function(e) {
			if (e instanceof PlanItem)
				return 0;
			if (e instanceof RowElement)
				return 1;
			if (e instanceof ColumnElement)
				return 2;
			if (e instanceof GenericElement) {
				if (e.getId() == OTHER_WORKFLOW_GROUP_ID)
					return 5;
				
				return 4;
			}
			return 3;
		};
		
		return function(e1, e2, forceResort, readAccessor) {
			var element1= e1.getElement();
			var element2= e2.getElement();
			
			var c1=categoryFn(element1);
			var c2=categoryFn(element2);
			
			if (c1 == c2) {
				if (c1 == 1 || c1 == 2 || c1 == 4) {
					return element1.compareTo(element2);
				}
			} else {
				return c1 - c2;
			}
			
			return defaultComparator(e1, e2, forceResort, readAccessor);
		};
	},

	processPlanChanged: function(delta, updateAccessor) {
		return true;
	},

	processElementAdded: function(delta, updateAccessor) {
		var elementInfoPath= this._getElementInfoPath(delta, true);
				
		this.__doAddElement(elementInfoPath, updateAccessor, delta);
		
		if (elementInfoPath.length == 1) {
			var children= elementInfoPath[elementInfoPath.length - 1].getChildren();
			for ( var j = 0; j < children.length; j++) {
				var childInfo= this.__elementInfos[children[j]];
				if (delta) {
					var childDelta= this.__getDelta(delta, children[j]);
					if (childDelta != null) {
						childInfo= childInfo.update(childDelta, true);
					}
				}
			
				var infos= [];
				infos.push(elementInfoPath[elementInfoPath.length - 1]);
				infos.push(childInfo);
				this.__doAddElement(infos, updateAccessor, delta);
			}
		}
		
		return true;
	},

	processElementMoved: function(removeDelta, addDelta, updateAccessor) {
		this.processElementAdded(addDelta, updateAccessor);
		this.processElementRemoved(removeDelta, updateAccessor);
		return true;
	},

	processElementRemoved: function(delta, updateAccessor) {
		var elementInfoPath= this._getElementInfoPath(delta, false);
		
		this.__doRemoveElement(elementInfoPath, updateAccessor);
		
		if (elementInfoPath.length == 1) {
			var children= elementInfoPath[elementInfoPath.length - 1].getChildren();
			for ( var j = 0; j < children.length; j++) {
				var child= children[j];
				
				var childInfo= this.__elementInfos[child];
				this.__doRemoveElement([elementInfoPath[elementInfoPath.length - 1], childInfo], updateAccessor);
			}
		}
		
		return true;
	},
	
	canCreate: function(request, readAccessor) {
		if (this.__workflowId) {
			var workflow= request.workItemType.getWorkflow();
			var id= workflow.getId(); 
			if (id != this.__workflowId)
				return com.ibm.team.apt.ui.Create.Response.DENY;
		}
		
		return this.inherited(arguments);
	},
	
	// ---- Implementation: Taskboard support  ----------------------------------------------------------------------------------

	_calculatePath: function(groupPath, groupIdPath, elementInfoPath){
		var result= [];
		result.push.apply(result, groupPath);
		
		try {
			var elementInfo= elementInfoPath[elementInfoPath.length - 1];
			var parentInfo= elementInfoPath.length > 1 ? elementInfoPath[elementInfoPath.length - 2] : null;
			
			groupIdPath.push(parentInfo == null ? "DaE" : parentInfo.getPlanElement().getUuid()); //$NON-NLS-1$
			var row= this._getRowGroupElement(groupIdPath, parentInfo, groupPath);
			result.push(row);
			
			var stateGroupId= this._getStateGroup(elementInfo, elementInfo.getPlanElement().getWorkflowInfo());
			groupIdPath.push(stateGroupId);
			var column= this._getColumnGroupElement(groupIdPath, row, stateGroupId);
			result.push(column);
			
			return result;
		} finally {
			groupIdPath.pop();
			groupIdPath.pop();
		}
	},
	
	_getRowGroupElement: function(groupIdPath, parentElementInfo, groupPath) {		
		var groupId= groupIdPath.join("/"); //$NON-NLS-1$
		
		var result= this.__groupTaskboardCache[groupId];
		Assert.isLegal(result);
		return result;
	},
	
	_getStateGroup: function(elementInfo, workflowInfo) {
		var workflowAction= elementInfo.getValue(PlanItem.WORKFLOW_ACTION);
		
		var state;
		if (workflowAction != null) {
			state= workflowInfo.getActionResultState(workflowAction.getId());
		} else {
			var stateIdentifier= elementInfo.getValue(PlanItem.STATE);
			if (stateIdentifier) {
				state= stateIdentifier.getId();
			} else {
				state= null;
			}
		}
		
		if (state == null) {
			if (this.__workflowId){
				return workflowInfo.getStartStateId();
			} else {
				return "1"; //$NON-NLS-1$
			}
		}
		
		if (!this.__workflowId) {
			return workflowInfo.getStateGroup(state);
		} else {
			return state;
		}
	},
	
	_getColumnGroupElement: function(groupIdPath, row, stateGroupId) {
		var groupId= groupIdPath.join("/"); //$NON-NLS-1$
		
		var result= this.__groupTaskboardCache[groupId];
		Assert.isLegal(result);
		return result;
	},
		
	_addRow: function(groupIdPath, parentElementInfo, groupPath, elementInfoPath, updateAccessor) {
		var parentItem= parentElementInfo == null ? null : parentElementInfo.getPlanElement();
		
		groupIdPath.push(parentItem == null ? "DaE" : parentItem.getUuid()); //$NON-NLS-1$
		try {
			var row= this.__groupTaskboardCache[groupIdPath.join("/")];  //$NON-NLS-1$
			if (row != null) {
				updateAccessor.addEntry(groupPath, row);
			} else {
				row= new RowElement(parentItem, this._getPlan(), groupPath, false);
				this.__groupTaskboardCache[groupIdPath.join("/")]= row; //$NON-NLS-1$
				
				updateAccessor.addEntry(groupPath, row);
			}
			
			groupPath.push(row);
			try {
				var parentColumn= this.__createColumns(row, groupIdPath, groupPath, updateAccessor);
							
				if (parentItem != null) {
					groupPath.push(parentColumn);
					try {
						this._addPlanItem(groupPath, parentItem, [groupIdPath[0]], [parentElementInfo], updateAccessor);
					} finally {
						groupPath.pop();
					}
				}
				
				return row;
			} finally {
				groupPath.pop();
			}
		} finally {
			groupIdPath.pop();
		}
	},
	
	__removeRow: function(row, updateAccessor) {
		var n= updateAccessor.getEntryNavigator(false);
		var columns= n.childEntries(row);
		var parents= n.childEntries(columns[0]);
		for ( var k = 0; k < parents.length; k++) {
			updateAccessor.removeEntry(parents[k]);
		}
		for ( var j = 0; j < columns.length; j++) {
			updateAccessor.removeEntry(columns[j]);	
		}
		updateAccessor.removeEntry(row);
	},
	
	__addHeader: function(groupIdPath, groupPath, updateAccessor) {
		groupIdPath.push("HEADER"); //$NON-NLS-1$
		try {
			var groupId= groupIdPath.join("/"); //$NON-NLS-1$
			var row= this.__groupTaskboardCache[groupId];
			if (row == null) {
				row= new RowElement(null, this._getPlan(), groupPath, true);
				this.__groupTaskboardCache[groupId]= row;
				updateAccessor.addEntry(groupPath, row);
			} else {
				updateAccessor.addEntry(groupPath, row);
			}
	
			groupPath.push(row);
			try {
				this.__createColumns(row, groupIdPath, groupPath, updateAccessor);
			} finally {
				groupPath.pop();
			}
		} finally {
			groupIdPath.pop();
		}
	},
	
	__createColumns: function(row, groupIdPath, groupPath, updateAccessor) {
		var groupId= groupIdPath.join("/"); //$NON-NLS-1$
		
		var parentColumn= this.__groupTaskboardCache[groupId + "/column.parent"]; //$NON-NLS-1$
		if (!parentColumn) {
			parentColumn= new ColumnElement(row, 0, this.__workflowId, "column.parent");  //$NON-NLS-1$
			this.__groupTaskboardCache[groupId + "/column.parent"]= parentColumn; //$NON-NLS-1$
		}
		var newEntry= updateAccessor.addEntry(groupPath, parentColumn);
		this.__setColumns(newEntry, updateAccessor);

		var columnIds= this.__getColumnIds();
		for ( var i = 0; i < columnIds.length; i++) {
			var id= columnIds[i];
			
			var column= this.__groupTaskboardCache[groupId + "/" + id]; //$NON-NLS-1$
			if (!column) {
				column= new ColumnElement(row, i + 1, this.__workflowId, id); 
				this.__groupTaskboardCache[groupId + "/" + id]= column; //$NON-NLS-1$
			}
			newEntry= updateAccessor.addEntry(groupPath, column);
			this.__setColumns(newEntry, updateAccessor);
		}
		
		return parentColumn;
	},
	
	__setColumns: function(entry, updateAccessor) {
		var fields= this.getColumns();
		for ( var i = 0; i < fields.length; i++) {
			fields[i].setIndex(i);
		}
		
		dojo.forEach(fields, function(tag){
			updateAccessor.setTag(entry, tag);
		}, this);
	},
	
	__getColumnIds: function() {
		if (!this.__workflowId) {
			return ["1", "4", "2"]; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} else {
			var plan= this._getPlan();
			var workflowInfo= plan.getWorkflowInfo(this.__workflowId);
			Assert.isLegal(workflowInfo != null);
			return workflowInfo.getStateIds();
		}
	},
	
	__removeHeader: function(headerRow, updateAccessor) {
		var n= updateAccessor.getEntryNavigator(false);
		var headerColumns= n.childEntries(headerRow);
		for ( var l = 0; l < headerColumns.length; l++) {
			updateAccessor.removeEntry(headerColumns[l]);
		}
		updateAccessor.removeEntry(headerRow);
	},
	
	_addPlanItem: function(path, planItem, groupIdPath, elementInfoPath, updateAccessor) {
		var newEntry= updateAccessor.addEntry(path, planItem);
		
		dojo.forEach(this._doCalculateTags(groupIdPath, elementInfoPath), function(tag){
			// tag the entries
			updateAccessor.setTag(newEntry, tag);
		}, this);
		
		var n= updateAccessor.getEntryNavigator(false);
		var candidateParent= n.parentEntryOfType(newEntry, GroupElement);
		while (candidateParent != null && !candidateParent.isRootEntry()) {
			// make sure the parent group gets a chance to update the count
			updateAccessor.update(candidateParent, null);
			candidateParent= n.parentEntry(candidateParent);
		}
	},
	
	__removePlanItem: function(entry, elementInfoPath, groupIdPath, updateAccessor) {
//		dojo.forEach(this._doCalculateTags(groupIdPath, elementInfoPath), function(tag) {
//			updateAccessor.clearTag(entry, tag);
//		}, this);
		
		updateAccessor.removeEntry(entry);
		
		var n= updateAccessor.getEntryNavigator(false);
		var candidateParent= n.parentEntryOfType(entry, GroupElement);
		while (candidateParent != null && !candidateParent.isRootEntry()) {
			// make sure the parent group gets a chance to update the count
			updateAccessor.update(candidateParent, null);
			candidateParent= n.parentEntry(candidateParent);
		}
	},
	
	__doAddElement: function(elementInfoPath, updateAccessor, delta) {
		Assert.isLegal(elementInfoPath.length >= 1);
		var n= updateAccessor.getEntryNavigator(false);
		
		var element= elementInfoPath[elementInfoPath.length - 1].getPlanElement();

		dojo.forEach(this._getGroups(elementInfoPath), function(groupIdPath) {
			if (this.__isOtherGroupCandidate(elementInfoPath[elementInfoPath.length - 1])) {
				this.__addOtherWorkflowItem(elementInfoPath, groupIdPath, updateAccessor);
				return;
			}
			
			var groupPath= this._convertToGroupElementPath(groupIdPath);
			
			this.__addHeader(groupIdPath, groupPath, updateAccessor);
			
			var parentInfo= elementInfoPath.length == 1 ? null : elementInfoPath[elementInfoPath.length - 2];				
			this._addRow(groupIdPath, parentInfo, groupPath, elementInfoPath, updateAccessor);
			
			var path= this._calculatePath(groupPath, groupIdPath, elementInfoPath);
			this._addPlanItem(path, element, groupIdPath, elementInfoPath, updateAccessor);
		}, this);
	},
	
	__isOtherGroupCandidate: function(elementInfo) {
		var planItem= elementInfo.getPlanElement();
		if (planItem.getWorkflowInfo() == null)
			return true;
		
		if (this.__workflowId && this.__workflowId != planItem.getWorkflowInfo().getId())
			return true; //item with other workflow
		
		var state= elementInfo.getValue(PlanItem.STATE);
		if (state == null) {
			return !elementInfo.getValue(PlanItem.DRAFT_ITEM);
		}
		
		if (!this.__hasState(state.getId(), planItem.getWorkflowInfo()))
			return true; //state was removed from process
		
		if (!this.__workflowId) {
			var stateGroup= this._getStateGroup(elementInfo, planItem.getWorkflowInfo());
			if (stateGroup === 0)
				return true;
		}
		
		return false;
	},
	
	__hasState: function(stateId, workflowInfo) {
		var workflowStateIds= workflowInfo.getStateIds();
		for ( var i = 0; i < workflowStateIds.length; i++) {
			if (stateId == workflowStateIds[i])
				return true;
		}
		
		return false;
	},
	
	__addOtherWorkflowItem: function(elementInfoPath, originalGroupIdPath, updateAccessor) {
		var planItem= elementInfoPath[elementInfoPath.length - 1].getPlanElement();
		var workflowInfo= planItem.getWorkflowInfo();
		
		var groupIdPath= [];
		groupIdPath.push(OTHER_WORKFLOW_GROUP_ID); //$NON-NLS-1$
		var group= this.__groupTaskboardCache[groupIdPath.join("/")];  //$NON-NLS-1$
		if (!group) {
			var text;
			if (!this.__workflowId) {
				text= Messages['taskboard_groupInvalid']; //$NON-NLS-1$
			} else {
				text= Messages['taskboard_groupOther']; //$NON-NLS-1$
			}
			group= new GenericElement(OTHER_WORKFLOW_GROUP_ID, text, workflowInfo, { //$NON-NLS-1$
				adopt : function(planItem) {
					return false;
				},
				comperator : function(o1, o2) {
					if (o1 instanceof GenericElement && o2 instanceof GenericElement) {
						return 0;
					} else if (o1 instanceof GenericElement) {
						return 1;
					} else if (o2 instanceof GenericElement) {
						return -1;
					} else {
						return 0;
					}
				}}
			);
			this.__groupTaskboardCache[groupIdPath.join("/")]= group; //$NON-NLS-1$
		}
		
		groupIdPath.push("other.workflows.row"); //$NON-NLS-1$
		var row= this.__groupTaskboardCache[groupIdPath.join("/")];  //$NON-NLS-1$
		if (!row) {
			row= new RowElement(null, this._getPlan(), [group], false);
			this.__groupTaskboardCache[groupIdPath.join("/")]= row; //$NON-NLS-1$
		}
		
		groupIdPath.push("other.workflows.column"); //$NON-NLS-1$
		var column= this.__groupTaskboardCache[groupIdPath.join("/")];  //$NON-NLS-1$
		if (!column) {
			column= new ColumnElement(row, 0, null, "other.workflows.column"); //$NON-NLS-1$
			this.__groupTaskboardCache[groupIdPath.join("/")]= column; //$NON-NLS-1$
		}
		
		this._addPlanItem([group, row, column], planItem, originalGroupIdPath, elementInfoPath, updateAccessor);
	},
	
	__getDelta: function(delta, uuid) {
		var element= delta.getPlanElement();
		if (element instanceof PlanModel)
			return null;
		
		if (element instanceof PlanItem && element.getUuid() == uuid)
			return delta;
		
		return this.__getDelta(delta.getParentDelta(), uuid);
	},

	__doRemoveElement: function(elementInfoPath, updateAccessor) {
		Assert.isLegal(elementInfoPath.length >= 1);
		
		var n= updateAccessor.getEntryNavigator(false);
		var element= elementInfoPath[elementInfoPath.length - 1].getPlanElement();
		
		if (this.__isOtherGroupCandidate(elementInfoPath[elementInfoPath.length - 1])) {
			var candidateEntries= updateAccessor.getElementEntries(element);
			for (var j = 0; j < candidateEntries.length; j++) {
				var candidateEntry= candidateEntries[j];
				var parentEntry= n.parentEntry(candidateEntry);
				if (parentEntry.getElement().getId() == OTHER_WORKFLOW_GROUP_ID) { //$NON-NLS-1$
					this.__removePlanItem(candidateEntry, elementInfoPath, null, updateAccessor);
				}
			}
			return;
		}

		dojo.forEach(this._getGroups(elementInfoPath), function(groupIdPath) {
			var groupPath= this._convertToGroupElementPath(groupIdPath);
			var path= this._calculatePath(groupPath, groupIdPath, elementInfoPath);

			candidateEntries= updateAccessor.getElementEntries(element);
			for (var i = 0; i < candidateEntries.length; i++) {
				candidateEntry= candidateEntries[i];

				var pathEqual= true;
				var chainEntry= n.parentEntry(candidateEntry);
				var level= path.length - 1;
				while (pathEqual && level >= 0 && chainEntry != null) {
					pathEqual= pathEqual && (path[level--].equals(chainEntry.getElement()));
					chainEntry= n.parentEntry(chainEntry);
				}

				if (pathEqual == true && level == -1 && n.parentEntry(chainEntry) == null) {
					var candidateParent= n.parentEntryOfType(candidateEntry, GroupElement);
					if (candidateParent != null && !candidateParent.isRootEntry()) {
						// make sure the parent group gets a chance to update the count
						updateAccessor.update(candidateParent, null);
					}

					dojo.forEach(this._doCalculateTags(groupIdPath, elementInfoPath), function(tag){
						// tag the entries
						updateAccessor.clearTag(candidateEntry, tag);
					}, this);
					
					var column= n.parentEntry(candidateEntry);
					var row= n.parentEntry(column);
					this.__removeRow(row, updateAccessor);
					
					var groupEntry= n.parentEntry(row);
					var headerRow= n.childEntries(groupEntry)[0];
					this.__removeHeader(headerRow, updateAccessor);

					this.__removePlanItem(candidateEntry, elementInfoPath, groupIdPath, updateAccessor);
					break;
				}
			}
		}, this);
	},
	
	__sentinel: null // terminates this class definition
});

})();