/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.structure.NoGroupProvider"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.OwnerElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupProvider"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.MessageElement"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert						= com.ibm.team.foundation.Assert;
var PlanItem					= com.ibm.team.apt.client.PlanItem;
var GroupProvider				= com.ibm.team.apt.ui.structure.GroupProvider;
var MessageElement				= com.ibm.team.apt.ui.structure.MessageElement;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "GroupProviderMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.internal.ui.structure.NoGroupProvider", GroupProvider, { //$NON-NLS-1$

	__createWorkItemHint: null,
	__messageRunnableToken: null,

	constructor: function(funcGetPlan, options) {
		this.__createWorkItemHint= new MessageElement(Messages['none_createHint'], MessageElement.CREATE_LINK); //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	inputChanged: function(model, newInput) {
		var oldModel= this._getViewModel();
		if (oldModel && this.__messageRunnableToken !== null) {
			oldModel.removePostUpdateRunnable(this.__messageRunnableToken);
			this.__messageRunnableToken= null;
		}
		
		this.inherited(arguments);
		
		if (model) {
			this.__messageRunnableToken= model.addPostUpdateRunnable(dojo.hitch(this, this.__updateHint), false);
		}
	},

	
	getGroupsIds: function(elementInfo) {
		return [[""]]; //$NON-NLS-1$
	},
	
	getGroupElement: function(groupIdPath) {
		return null;
	},
	
	isPrimaryGroup: function(groupIdPath, elementInfo) {
		return true;
	},

	getElementsToExpandInitially: function(readAccessor) {
		return [];
	},

	__updateHint: function(updateAccessor) {
		var n= updateAccessor.getEntryNavigator(true);
		
		var childEntries= n.childEntries(updateAccessor.getRootEntry());
		var messageEntries= updateAccessor.getElementEntries(this.__createWorkItemHint);
		
		if (childEntries.length == 0 && messageEntries.length == 0) {
			updateAccessor.addEntry([], this.__createWorkItemHint);
		} else if (childEntries.length > 0 && messageEntries.length > 0) {
			Assert.isTrue(messageEntries.length == 1);
			updateAccessor.removeEntry(messageEntries[0]);
		}
	},

	__sentinel: null // terminates this class definition
});

})();