/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.sortmode.CustomPersistedSorter"); //$NON-NLS-1$

dojo.require("com.ibm.team.foundation.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.structure.GroupElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.EntrySorter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var Assert							= com.ibm.team.foundation.Assert;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var GroupElement					= com.ibm.team.apt.ui.structure.GroupElement;

dojo.declare("com.ibm.team.apt.internal.ui.sortmode.CustomPersistedSorter", com.ibm.team.apt.ui.model.EntrySorter, { //$NON-NLS-1$

	__optionsStore: null,
	__sortIndices: null,
	
	constructor: function(options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isSorterProperty: function(property) {
		return false;
	},
	
	loadOptions: function(optionsStore) {
		this.__optionsStore= optionsStore;
		var contents= optionsStore.load();
		this.__sortIndices= contents.sortIndices || {};
	},
	
	storeOptions: function(readAccessor) {
		var n= readAccessor.getEntryNavigator(false);

		var sortIndices= {};
		var index= 1;
		
		readAccessor.accept(function(entry) {
			var element= entry.getElement();
			if (element instanceof PlanItem) {
				var itemInfo= sortIndices[element.getUuid()] || {};
				itemInfo[n.parentEntryOfType(entry, GroupElement).getElement().getId()]= index++;
				sortIndices[element.getUuid()]= itemInfo;
			}
			return true;
		}, null, this);
		
		this.__sortIndices= sortIndices;
		this.__optionsStore.store({
			sortIndices: this.__sortIndices
		});
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	_compare: function(e1, e2, forceResort, readAccessor) {
		var i1= e1.getElement();
		var i2= e2.getElement();
		if (forceResort && i1 instanceof PlanItem && i2 instanceof PlanItem) {
			var n= readAccessor.getEntryNavigator(false);
			var group= n.parentEntryOfType(e1, GroupElement);
			Assert.isTrue(group === n.parentEntryOfType(e2, GroupElement));
			var groupId= group.getElement().getId();
	
			var s1= this.__getSortIndex(i1.getUuid(), groupId);
			var s2= this.__getSortIndex(i2.getUuid(), groupId);
			
			if (s1 < s2)
				return -1;
			if (s1 > s2)
				return 1;
			
			return i2.getId() - i1.getId();
		}
		return this.inherited(arguments);
	},
	
	__getSortIndex: function(itemId, groupId) {
		var itemInfo= this.__sortIndices[itemId];
		return itemInfo && itemInfo[groupId] || Number.MAX_VALUE;
	},
	
	__sentinel: null // terminates this class definition
});

})();
