/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.progress.StoryPointProgressLabelProvider"); //$NON-NLS-1$

dojo.require("dojo.number"); //$NON-NLS-1$
dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.internal.ui", "ProgressMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.internal.ui", "ProgressMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.internal.ui.progress.StoryPointProgressLabelProvider", com.ibm.team.apt.internal.ui.progress.ProgressLabelProvider, { //$NON-NLS-1$
	
	__complexityUnit: null,
	__complexityLabel: null,
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	constructor: function(options){
		if(options && options.parameters){
			var param= options.parameters;
			this.__complexityLabel= param.complexityLabel;		
			this.__complexityUnit= param.complexityUnit;
		}
	},
	
	__isComplexityAttrDefined: function() {
		return this.__complexityUnit && this.__complexityLabel;
	},
	
	getMessage: function(element){
		if(this.__isComplexityAttrDefined())
			return this.inherited(arguments);
		return Messages['complexity_attributeNotDefined']; //$NON-NLS-1$
	},
	
	getProgressText: function(element){
		var result= bind(Messages['complexity_progress'], [ element.getStepsDone(), element.getSteps(),  this.__complexityUnit || "" ]); //$NON-NLS-1$ //$NON-NLS-2$

		if(this._showLabels) {
			result= bind(Messages['complexity_progressLabel'], [ result ]); //$NON-NLS-1$
		}

		return result;
	},
	
	getTooltipText: function(element){
		var lines= new Array();
		
		if(this.__isComplexityAttrDefined()){
			
			var complexityLabel= this.__complexityLabel || ""; //$NON-NLS-1$
			var complexityUnit= this.__complexityUnit || ""; //$NON-NLS-1$
			
			lines.push("<span class=\"header\">" + Messages['complexity_tooltipTitle'] + "</span>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			lines.push(bind(Messages['complexity_tooltipDone'], [ complexityLabel, this._toHours(element.getStepsDone()), this._toHours(element.getSteps()) ])); //$NON-NLS-1$

			if (element.isRealTimeSpecified() && !element.isAllWorkDone()) {

				var dir= this.getDeltaDirection(element);
				
				var deltaMessage= dir > 0 ? 'complexity_tooltipAhead' : (dir < 0 ? 'complexity_tooltipBehind' : 'complexity_tooltipOnTrack' ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				var delta= bind(Messages[deltaMessage], [ this._absString(this._toHours(element.getStepsDoneDelta(), 2)), complexityUnit ]);

				lines.push(bind(Messages['complexity_tooltipExpectedDone'], [ complexityLabel, Math.round(element.getStepsDoneExpected()), delta ])); //$NON-NLS-1$
			}

			if (!element.isAllWorkDone()) {
				lines.push(""); //$NON-NLS-1$
				lines.push(bind(Messages['complexity_tooltipItemsEstimatedLabel'], [ bind(Messages['complexity_tooltipItemsEstimatedPercentage'], [ Math.round(element.getQualityOfPlanning() * 100) ]) ])); //$NON-NLS-1$ //$NON-NLS-2$
				lines.push(bind(Messages['complexity_tooltipItemsCompletedLabel'], [ bind(Messages['complexity_tooltipItemsCompleted'], [ element.getCloseCount(), element.getCount(), Math.round(element.getClosedRatio() * 100) ]) ])); //$NON-NLS-1$ //$NON-NLS-2$
			} else {
				lines.push(bind(Messages['complexity_tooltipItemsCompletedLabel'], [ Messages['complexity_tooltipItemsCompletedAll'] ] )); //$NON-NLS-1$ //$NON-NLS-2$
			}

			
		} else {
			lines.push("<span class=\"header\">" + Messages['complexity_tooltipNotConfiguredTitle'] + "</span>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			lines.push(Messages['complexity_tooltipNotConfiguredMessage']); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		return lines.join("<br />"); //$NON-NLS-1$
	},
	
	_toHours: function(value, n) {
		return  dojo.number.format(value, n ? {places: n} : undefined);
	},
	
	__sentinel: null // terminates this class definition
});

})();
