/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.filter.SubTeamFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.ui.model.EntryFilter.FilterType;

dojo.declare("com.ibm.team.apt.internal.ui.filter.SubTeamFilter", com.ibm.team.apt.ui.model.EntryFilter, { //$NON-NLS-1$

	constructor: function(getPlanFn, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

    isFilterProperty: function(entry, property) {
		return PlanItem.CATEGORY.getId() === property;
    },

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		if (!(element instanceof PlanItem))
			return true;
		var plan= element.getPlanModel();
		return plan.isPrimaryCategory(element.getAttributeValue(PlanItem.CATEGORY));
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
