/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.filter.NullValueFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanElement						= com.ibm.team.apt.client.PlanElement;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.ui.model.EntryFilter.FilterType;

var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;

dojo.declare("com.ibm.team.apt.internal.ui.filter.NullValueFilter", com.ibm.team.apt.ui.model.EntryFilter, { //$NON-NLS-1$

	constructor: function(getPlanFn, options) {
		this.__attributeId= new PlanningAttributeIdentifier(options.parameters["attribute"]); //$NON-NLS-1$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isFilterType: function(filterType) {
		return filterType === FilterType.Regular;
	},

    isFilterProperty: function(entry, property) {
		return this.__attributeId === property;
    },

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		
		if (!(element instanceof PlanItem))
			return true;

		var attribute= this._getPlan().findAttribute(this.__attributeId);
		if (!attribute)
			return true;
		
		var nullValue= attribute.getValueSet().nullValue;
		var attributeValue= element.getAttributeValue(PlanItem.OWNER);
		
		if (nullValue === undefined)
			return attributeValue !== undefined;

		if (nullValue === null)
			return attributeValue !== null;

		if (nullValue.equals)
			return nullValue.equals(attributeValue);
		
		return nullValue != attributeValue;
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
