/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.internal.ui.filter.NoEstimateFilter"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.ui.model.EntryFilter"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var FilterType						= com.ibm.team.apt.ui.model.EntryFilter.FilterType;

dojo.declare("com.ibm.team.apt.internal.ui.filter.NoEstimateFilter", com.ibm.team.apt.ui.model.EntryFilter, { //$NON-NLS-1$

	constructor: function(getPlanFn, options) {
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	isFilterType: function(filterType) {
		return filterType == FilterType.Regular;
	},

    isFilterProperty: function(entry, property) {
		return PlanItem.ESTIMATE.getId() === property;
    },

	select: function(entry, readAccessor) {
		var element= entry.getElement();
		return !(element instanceof PlanItem) || !element.getAttributeValue(PlanItem.ESTIMATE).specified; 
    },

	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
