/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.ui.Move"); //$NON-NLS-1$

(function() {

dojo.declare("com.ibm.team.apt.ui.Move.Request", null, { //$NON-NLS-1$

	constructor: function(sourceElement, sourceEntry, targetEntry, location) {
		this.sourceElement= sourceElement;
		this.sourceEntry= sourceEntry;
		this.targetEntry= targetEntry;
		this.location= location;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	sourceElement: null,
	sourceEntry: null,
	
	targetEntry: null,

	location: 0, 
	
	__sentinel: null // terminates this class definition
});

dojo.declare("com.ibm.team.apt.ui.Move.Response", null, { //$NON-NLS-1$

	constructor: function(targetEntry, location, info, options) {
		this.targetEntry= targetEntry;
		this.location= location;
		this.info= info;
		this.options= options;
	},

	canMove: function() {
		return this.location != com.ibm.team.apt.ui.Move.None;
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------

	targetEntry: null,
	location: 0,
	info: null,
	options: 0, 

	__sentinel: null // terminates this class definition
});

com.ibm.team.apt.ui.Move.Response.DENY= new com.ibm.team.apt.ui.Move.Response(null, 0, 0);

// ---- locations ----------------------------------------------------------------------------------------------------------

com.ibm.team.apt.ui.Move.None= 0;
com.ibm.team.apt.ui.Move.After= 1;
com.ibm.team.apt.ui.Move.Before= 2;
com.ibm.team.apt.ui.Move.Child= 3;
com.ibm.team.apt.ui.Move.Demote= 4;
com.ibm.team.apt.ui.Move.Promote= 5;

// ---- options ------------------------------------------------------------------------------------------------------------

com.ibm.team.apt.ui.Move.UnderlayChildren= 1; //$NON-NLS-1$

})();
