/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.client.RankingAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.SequenceValue"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var SequenceValue					= com.ibm.team.apt.client.SequenceValue;
var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet		= com.ibm.team.apt.client.PlanningAttributeValueSet;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;

var SEQUENCE_ATTRIBUTE_ID_SUFFIX= "_pm7NmRYUEd6L1tNIGdz5qQ"; //$NON-NLS-1$
var SEQUENCE_ATTRIBUTE_LEGACYSCOPE= "__tpZgxeHEd6ry8lWYPBHvQ"; //$NON-NLS-1$

function compare(a, b, direction) {
	if (a == null || b == null)
		return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
	return a.compareTo(b) * direction;
}

function calculateSeq(predecessorSeq, successorSeq) {
	if (predecessorSeq != null) {
			if (successorSeq != null) {
				return SequenceValue.FACTORY.between(predecessorSeq, successorSeq);
			} else {
				return SequenceValue.FACTORY.successor(predecessorSeq);
			}
	} else if (successorSeq != null) {
		return SequenceValue.FACTORY.predecessor(successorSeq);
	} else {
		return SequenceValue.INITIAL;
	}		
}

dojo.declare("com.ibm.team.apt.client.RankingAttribute", com.ibm.team.apt.client.ScriptableAttribute, { //$NON-NLS-1$
	
	__options: null,

	__sequenceAttribute: null,
	__enumerationAttribute: null,
	
	__attributeCache: null, 
	
	constructor: function(descriptor) {
		this.__thisAttributeId= new PlanningAttributeIdentifier(descriptor.id);
		this.__options= descriptor.parameters;
		this.__attributeCache= {};
		
		this.__direction= "true" == String(descriptor.parameters["reverse"] || "true").toLowerCase() ? -1 : 1; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	initialize: function(plan) {
		var attribute= this.__options["attribute"]; //$NON-NLS-1$
		
		var enumerationAttributeId= new PlanningAttributeIdentifier(attribute);
		this.__enumerationAttribute= plan.findAttribute(enumerationAttributeId);
		
		var sequenceAttributeId= new PlanningAttributeIdentifier(attribute + "." + SEQUENCE_ATTRIBUTE_ID_SUFFIX); //$NON-NLS-1$
		this.__sequenceAttribute= plan.findAttribute(sequenceAttributeId);
	},

	
	getDependantAttributes: function() {
		return [ this.__enumerationAttribute, this.__sequenceAttribute ];
	},

	getUnranked: function(source) {
		return this.__createRank(source.getEnumerationValue(), SequenceValue.NEW);
	},
	
	calculateRank: function(predecessor, successor, source) {
		var sourceEnum= source.getEnumerationValue();
		
		if (!predecessor && !successor) 
			return this.__createRank(sourceEnum, SequenceValue.INITIAL);

		var predecessorEnum= predecessor && predecessor.getEnumerationValue();
		var predecessorSeq= predecessor && predecessor.getSequenceValue();
		var successorEnum= successor && successor.getEnumerationValue();
		var successorSeq= successor && successor.getSequenceValue();

		if (predecessorSeq != null && predecessorSeq.isNew())
			predecessorSeq= null;
		if (successorSeq != null && successorSeq.isNew())
			successorSeq= null;

		var targetEnum, targetSeq;
		if (predecessor && !successor) {
			targetEnum= compare(sourceEnum, predecessorEnum, this.__direction) < 0 ? predecessorEnum : sourceEnum;
			targetSeq= calculateSeq(predecessorSeq, null);
		} else if (!predecessor && successor) {
			targetEnum= compare(sourceEnum, successorEnum, this.__direction) < 0 ? sourceEnum : successorEnum;
			targetSeq= calculateSeq(null, successorSeq);
		} else {
			if (predecessorEnum.equals(successorEnum)) {
				targetEnum= predecessorEnum;
				targetSeq= calculateSeq(predecessorSeq, successorSeq);
			} else if (predecessorEnum.equals(sourceEnum)) {
				targetEnum= predecessorEnum;
				targetSeq= calculateSeq(predecessorSeq, null);
			} else if (successorEnum.equals(sourceEnum)) {
				targetEnum= successorEnum;
				targetSeq= calculateSeq(null, successorSeq);
			} else {
				var predecessorToSource= compare(predecessorEnum, sourceEnum, this.__direction);
				var successorToSource= compare(successorEnum, sourceEnum, this.__direction);
				var predecessorToSuccessor= compare(predecessorEnum, successorEnum, this.__direction);
				
				if (predecessorToSource < 0 && successorToSource < 0) {
					if (predecessorToSuccessor < 0) {
						targetEnum= predecessorEnum;
						targetSeq= calculateSeq(predecessorSeq, null);
					} else {
						targetEnum= predecessorEnum;
						targetSeq= calculateSeq(null, successorSeq);
					}
				} else if (predecessorToSource > 0 && successorToSource > 0) {
					if (predecessorToSuccessor > 0) {
						targetEnum= predecessorEnum;
						targetSeq= calculateSeq(predecessorSeq, null);
					} else {
						targetEnum= predecessorEnum;
						targetSeq= calculateSeq(null, successorSeq);
					}
				}
			}
		}

		if (!targetEnum || !targetSeq)
			return source;

		return this.__createRank(targetEnum, targetSeq);
	},
	
	changed: function(planElementDelta, deltaBuilder) {
		var oldEnum, newEnum, oldSeq, newSeq;
		
		var enumDelta= planElementDelta.getAttributeDelta(this.__enumerationAttribute);
		if (enumDelta) {
			oldEnum= enumDelta.getOldValue();
			newEnum= enumDelta.getNewValue();
		} else {
			oldEnum= newEnum= planElementDelta.getPlanElement().getAttributeValue(this.__enumerationAttribute);
		}
		
		var seqDelta= planElementDelta.getAttributeDelta(this.__sequenceAttribute);
		if (seqDelta) {
			oldSeq= this.__fromNativeValue(seqDelta.getOldValue(), oldEnum);
			newSeq= this.__fromNativeValue(seqDelta.getNewValue(), newEnum);
		} else {
			var rawSeq= planElementDelta.getPlanElement().getAttributeValue(this.__sequenceAttribute);
			oldSeq= this.__fromNativeValue(rawSeq, oldEnum);
			newSeq= this.__fromNativeValue(rawSeq, newEnum);
		}
		
		var oldValue= this.__createRank(oldEnum, oldSeq);
		var newValue= this.__createRank(newEnum, newSeq);
				
		this.__toCache(planElementDelta.getPlanElement(), newValue);

		deltaBuilder.changed(planElementDelta.getPlanElement(), this.__thisAttributeId, oldValue, newValue);
	},

	attributeType: PlanningAttributeType.RANKING,
	
	getValueSet: function() {
		return PlanningAttributeValueSet.EMPTY;
	},

	getValue: function(receiver) {
		var result= undefined;
		if (receiver instanceof PlanItem) {
			result= this.__fromCache(receiver);
			if(result == null){
				var enumerationValue= receiver.getAttributeValue(this.__enumerationAttribute);
				var sequenceValue= this.__fromNativeValue(receiver.getAttributeValue(this.__sequenceAttribute), enumerationValue);
				result= this.__createRank(enumerationValue, sequenceValue);
				this.__toCache(receiver, result);
			}
		}

		return result;
	},

	setValue: function(receiver, value) {
		if (receiver instanceof PlanItem) {
			this.__toCache(receiver, null);
	
			var enumerationValue= value.getEnumerationValue();
			var sequenceValue= value.getSequenceValue();
	
			receiver.getPlanModel().compoundChange(function() {
				receiver.setAttributeValue(this.__enumerationAttribute, enumerationValue);
				receiver.setAttributeValue(this.__sequenceAttribute, this.__toNativeValue(sequenceValue, enumerationValue));
			}, this);
		}
	},
	
	__fromCache: function(planItem) {
		return this.__attributeCache[planItem.getUuid()];
	},
	
	__toCache: function(planItem, value) {
		this.__attributeCache[planItem.getUuid()]= value;
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------

	__fromNativeValue: function(value, enumValue) {
		if (!enumValue)
			return SequenceValue.INITIAL;
		
		var scope= enumValue.itemId;
		if (value != null && value.indexOf(SEQUENCE_ATTRIBUTE_LEGACYSCOPE) == 0)
			scope= SEQUENCE_ATTRIBUTE_LEGACYSCOPE;
		
		return SequenceValue.FACTORY.valueOf(value, scope);
	},

	__toNativeValue: function(value, enumValue) {
		return value.serializeSequenceValue(enumValue.itemId);
	},

	__createRank: function(enumValue, seqValue) {
		return new com.ibm.team.apt.client.RankingAttribute._Value(enumValue, seqValue, this.__direction);
	},

	__sentinel: null // terminates this class definition
});

com.ibm.team.apt.client.RankingAttribute.SEQUENCE_ATTRIBUTE_ID_SUFFIX= SEQUENCE_ATTRIBUTE_ID_SUFFIX;

dojo.declare("com.ibm.team.apt.client.RankingAttribute._Value", null, { //$NON-NLS-1$

	__enumerationValue: null,
	__sequenceValue: null,
	__direction: 1,
	
	constructor: function(enumerationValue, sequenceValue, direction) {
		this.__enumerationValue= enumerationValue;
		this.__sequenceValue= sequenceValue;
		this.__direction= direction;
	},

	// ---- API ------------------------------------------------------------------------------------------------------------

	canRank: function() {
		return this.__enumerationValue !== undefined;
	},
	
	isSpecified: function() {
		return this.__enumerationValue && this.__sequenceValue && !this.__sequenceValue.isNew();
	},
	
	getEnumerationValue: function() {
		return this.__enumerationValue;
	},

	compareEnumerationValueTo: function(other) {
		return compare(this.__enumerationValue, other.__enumerationValue, this.__direction);
	},

	getSequenceValue: function(scope) {
		return this.__sequenceValue;
	},
	// ---- Comparable implementation --------------------------------------------------------------------------------------

	compareTo: function(other) {
		if (!this.canRank() || !other.canRank()) {
			return (this.canRank() ? 0 : 1) - (other.canRank() ? 0 : 1);
		}
		
		var result= compare(this.__enumerationValue, other.__enumerationValue, this.__direction);

		if (result == 0)
			result= compare(this.__sequenceValue, other.__sequenceValue, 1);
		
		return result;
	},

	equals: function(other) {
		if (this === other)
			return true;

		if (this.declaredClass !== other.declaredClass)
			return false;

		return this.compareTo(other) == 0;
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------

	__sentinel: null // terminates this class definition
});

})();
