/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki.transformer;

import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symbol {
    public static final Symbol EOF = new Symbol(null, Token.EOF);
    private final int sizeOfLong = 63;
    private final int nLongs = Math.round((float)Token.values().length / 63.0f);
    private final long[] fValues = new long[this.nLongs];
    private final Object fData;

    public Symbol(Object data, Token ... tokens) {
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            int ordinal = token.ordinal();
            int index = ordinal / 63;
            int shift = ordinal % 63;
            int n3 = index;
            this.fValues[n3] = this.fValues[n3] | 1L << shift;
            ++n2;
        }
        this.fData = data;
    }

    public Symbol(Object data, List<Token> tokens) {
        for (Token token : tokens) {
            int ordinal = token.ordinal();
            int index = ordinal / 63;
            int shift = ordinal % 63;
            int n = index;
            this.fValues[n] = this.fValues[n] | 1L << shift;
        }
        this.fData = data;
    }

    public Object getData() {
        return this.fData;
    }

    public Token couldBe(Token ... tokens) {
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            int shift;
            Token token = tokenArray[n2];
            int ordinal = token.ordinal();
            int index = ordinal / 63;
            if ((this.fValues[index] & 1L << (shift = ordinal % 63)) != 0L) {
                return token;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        Token[] values;
        StringBuilder output = new StringBuilder();
        Token[] tokenArray = values = Token.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            if (this.couldBe(token) != null) {
                output.append(token.name()).append('@').append(token.ordinal());
            }
            ++n2;
        }
        return String.format("tokens=[%s], data=[%s]", output, this.fData);
    }
}

