/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.IFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node<E> {
    private E fElement;
    private Node<E> fParent;
    private List<Node<E>> fChildren;

    public Node(Node<E> parent, E element) {
        this.fParent = parent;
        this.fElement = element;
        this.fChildren = new ArrayList<Node<E>>(5);
    }

    public boolean isRoot() {
        return this.fParent == null;
    }

    public E getElement() {
        return this.fElement;
    }

    public Node<E> getParent() {
        return this.fParent;
    }

    public List<Node<E>> getChildren() {
        return this.fChildren;
    }

    public boolean isSibling(Node<E> node) {
        if (this.isRoot()) {
            return false;
        }
        return this.getParent().getChildren().contains(node);
    }

    public Node<E> nextSibling() {
        if (this.isRoot()) {
            return null;
        }
        List<Node<E>> siblings = this.getParent().getChildren();
        int index = siblings.indexOf(this);
        if (index + 1 >= siblings.size()) {
            return null;
        }
        return siblings.get(index + 1);
    }

    public Iterator<Node<E>> depthFirstIterator() {
        return this.depthFirstIterator(null);
    }

    public Iterator<Node<E>> depthFirstIterator(IFilter<E> filter) {
        return new DepthFirstIterator(this, filter);
    }

    public Iterator<Node<E>> breadthFirstIterator() {
        return this.breadthFirstIterator(null);
    }

    public Iterator<Node<E>> breadthFirstIterator(IFilter<E> filter) {
        return new BreadthFirstIterator(this, filter);
    }

    public boolean contains(Object element, Comparator<Object> comparator) {
        Iterator<Node<E>> iter = this.depthFirstIterator(null);
        while (iter.hasNext()) {
            Node<E> next = iter.next();
            if (!(comparator != null ? comparator.compare(next.getElement(), element) == 0 : next.getElement().equals(element))) continue;
            return true;
        }
        return false;
    }

    public Node<E> find(final Object element) {
        IFilter filter = new IFilter<E>(){

            @Override
            public boolean accept(E e) {
                return e == element || e != null && e.equals(element);
            }
        };
        Node<E> next = this.depthFirstIterator(filter).next();
        return next;
    }

    public int ordinal() {
        Node<E> parent = this.getParent();
        if (parent == null) {
            return -1;
        }
        List<Node<E>> children = parent.getChildren();
        int index = children.indexOf(this) + 1;
        Assert.isLegal((index > 0 ? 1 : 0) != 0);
        int tmp = parent.ordinal();
        if (tmp != -1) {
            index += tmp * this.fac(children.size());
        }
        return index;
    }

    private int fac(int n) {
        int count = 1;
        while (n > 0) {
            n /= 10;
            count *= 10;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreadthFirstIterator
    extends NodeIterator {
        public BreadthFirstIterator(Node<E> current, IFilter<E> filter) {
            super(current, filter);
        }

        @Override
        Node<E> primaryNext(Node<E> node) {
            if (node.isSibling(this.fRoot)) {
                return null;
            }
            return node.nextSibling();
        }

        @Override
        Node<E> secondaryNext(Node<E> node) {
            return this.secondaryNext(node, 0);
        }

        Node<E> secondaryNext(Node<E> node, int offset) {
            if (node == this.fRoot) {
                List children = node.getChildren();
                return children.isEmpty() ? null : children.get(0);
            }
            Node parent = node.getParent();
            List children = parent.getChildren();
            if (offset >= children.size()) {
                return null;
            }
            Iterator iter = children.subList(offset, children.size()).iterator();
            Node next = null;
            while (next == null && iter.hasNext()) {
                List nextRow = iter.next().getChildren();
                if (nextRow.isEmpty()) continue;
                next = nextRow.get(0);
            }
            if (next != null) {
                return next;
            }
            if (parent == this.fRoot) {
                return null;
            }
            if ((parent = parent.nextSibling()) != null) {
                return this.secondaryNext(parent, offset + 1);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DepthFirstIterator
    extends NodeIterator {
        public DepthFirstIterator(Node<E> current, IFilter<E> filter) {
            super(current, filter);
        }

        @Override
        Node<E> secondaryNext(Node<E> node) {
            if (node.isSibling(this.fRoot)) {
                return null;
            }
            Node parent = node.getParent();
            if (parent == null) {
                return null;
            }
            Node sibling = node.nextSibling();
            if (sibling == null) {
                return this.secondaryNext(parent);
            }
            return sibling;
        }

        @Override
        Node<E> primaryNext(Node<E> node) {
            List children = node.getChildren();
            if (!children.isEmpty()) {
                return children.get(0);
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.fCurrent.isRoot()) {
                throw new IllegalStateException();
            }
            Node node = this.fCurrent;
            this.fCurrent = this.secondaryNext(this.fCurrent);
            this.fAdvance = false;
            boolean b = node.getParent().getChildren().remove(node);
            if (!b) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NodeIterator
    implements Iterator<Node<E>> {
        protected IFilter<E> fFilter;
        protected Node<E> fCurrent;
        protected boolean fAdvance;
        protected Node<E> fRoot;

        public NodeIterator(Node<E> current, IFilter<E> filter) {
            this.fCurrent = current;
            this.fRoot = current;
            this.fFilter = filter;
            this.fAdvance = this.fFilter != null && !this.fFilter.accept(this.fCurrent.getElement());
        }

        private void computeNext() {
            if (!this.fAdvance) {
                return;
            }
            Node next = null;
            next = this.primaryNext(this.fCurrent);
            if (next == null) {
                next = this.secondaryNext(this.fCurrent);
            }
            this.fCurrent = next;
            if (this.fCurrent != null && this.fFilter != null && !this.fFilter.accept(this.fCurrent.getElement())) {
                this.fAdvance = true;
                this.computeNext();
            }
            this.fAdvance = false;
        }

        abstract Node<E> secondaryNext(Node<E> var1);

        abstract Node<E> primaryNext(Node<E> var1);

        @Override
        public boolean hasNext() {
            this.computeNext();
            return this.fCurrent != null;
        }

        @Override
        public Node<E> next() {
            this.computeNext();
            this.fAdvance = this.fCurrent != null;
            return this.fCurrent;
        }
    }
}

