/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.impl;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.ScriptException;
import com.ibm.team.apt.internal.common.scripting.annotation.Function;
import com.ibm.team.apt.internal.common.scripting.impl.ArgumentProvider;
import com.ibm.team.apt.internal.common.scripting.impl.JavaScriptTypes;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class ScriptTypeFunction
extends BaseFunction {
    private final String fName;
    private final Method fMethod;
    private final ArgumentProvider fArgumentProvider;
    private JavaScriptTypes fReturnType;

    public ScriptTypeFunction(Scriptable scope, Method method) {
        this.fMethod = method;
        this.fName = "".equals(method.getAnnotation(Function.class).value()) ? method.getName() : method.getAnnotation(Function.class).value();
        this.fArgumentProvider = ArgumentProvider.create(method.getParameterTypes());
        this.fReturnType = JavaScriptTypes.getType(this.fMethod.getReturnType());
    }

    public int getArity() {
        return this.fArgumentProvider.getArity();
    }

    public int getLength() {
        return this.fArgumentProvider.getArity();
    }

    public String getFunctionName() {
        return this.fName;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (Modifier.isStatic(this.fMethod.getModifiers())) {
            thisObj = null;
        } else if (!this.fMethod.getDeclaringClass().isInstance(thisObj)) {
            ScriptRuntime.typeError1((String)"msg.incompat.call", (String)this.fName);
        }
        try {
            return this.fReturnType.convertToScript(cx, scope, this.fMethod.invoke((Object)thisObj, this.fArgumentProvider.getArguments(cx, scope, args)), this.fMethod.getReturnType());
        }
        catch (InvocationTargetException e) {
            throw new ScriptException(e.getTargetException());
        }
        catch (Exception e) {
            APTCommonPlugin.log("Failed to call method", e);
            throw new ScriptException(e);
        }
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw new ScriptException(String.format("Function '%s' cannot be used as a constructor", this.fName));
    }
}

