/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.impl;

import com.ibm.team.apt.internal.common.scripting.impl.JavaScriptTypes;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

abstract class ArgumentProvider {
    private static final Class[] RAW_PARAMETER_TYPES = new Class[]{Context.class, Scriptable.class, Object[].class};

    ArgumentProvider() {
    }

    public static ArgumentProvider create(Class[] parameterTypes) {
        if (Arrays.equals(RAW_PARAMETER_TYPES, parameterTypes)) {
            return new RawArgumentProvider();
        }
        if (parameterTypes.length >= 2 && parameterTypes[0] == Context.class && parameterTypes[1] == Scriptable.class) {
            return new ContextArgumentProvider(parameterTypes);
        }
        return new DefaultArgumentProvider(parameterTypes);
    }

    public abstract Object[] getArguments(Context var1, Scriptable var2, Object[] var3);

    public abstract int getArity();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextArgumentProvider
    extends DefaultArgumentProvider {
        public ContextArgumentProvider(Class<?>[] parameterTypes) {
            super(parameterTypes, 2);
        }

        @Override
        public Object[] getArguments(Context cx, Scriptable scope, Object[] args) {
            Object[] result = this.getArguments(cx, scope, args, new Object[this.fTypes.length + 2], 2);
            result[0] = cx;
            result[1] = scope;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultArgumentProvider
    extends ArgumentProvider {
        final JavaScriptTypes[] fTypes;
        final Class[] fJavaTypes;

        public DefaultArgumentProvider(Class<?>[] parameterTypes) {
            this(parameterTypes, 0);
        }

        protected DefaultArgumentProvider(Class<?>[] parameterTypes, int start) {
            this.fTypes = new JavaScriptTypes[parameterTypes.length - start];
            this.fJavaTypes = new Class[parameterTypes.length - start];
            int i = start;
            while (i < parameterTypes.length) {
                this.fTypes[i - start] = JavaScriptTypes.getType(parameterTypes[i]);
                this.fJavaTypes[i - start] = parameterTypes[i];
                ++i;
            }
        }

        @Override
        public Object[] getArguments(Context cx, Scriptable scope, Object[] args) {
            return this.getArguments(cx, scope, args, args.length == this.fTypes.length ? args : new Object[this.fTypes.length], 0);
        }

        @Override
        public int getArity() {
            return this.fTypes.length;
        }

        protected Object[] getArguments(Context cx, Scriptable scope, Object[] args, Object[] target, int start) {
            int i = 0;
            while (i < this.fTypes.length) {
                target[i + start] = this.fTypes[i].convertToJava(cx, scope, i < args.length ? args[i] : Undefined.instance, this.fJavaTypes[i]);
                ++i;
            }
            return target;
        }
    }

    private static class RawArgumentProvider
    extends ArgumentProvider {
        private RawArgumentProvider() {
        }

        public Object[] getArguments(Context cx, Scriptable scope, Object[] args) {
            return new Object[]{cx, scope, args};
        }

        public int getArity() {
            return 1;
        }
    }
}

